/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.Edge;
import com.jme3.scene.plugins.blender.meshes.Face;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

class MirrorModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(MirrorModifier.class.getName());
    private static final int FLAG_MIRROR_X = 8;
    private static final int FLAG_MIRROR_Y = 16;
    private static final int FLAG_MIRROR_Z = 32;
    private static final int FLAG_MIRROR_U = 2;
    private static final int FLAG_MIRROR_V = 4;
    private static final int FLAG_MIRROR_VERTEX_GROUP = 64;
    private static final int FLAG_MIRROR_MERGE = 128;
    private boolean[] isMirrored;
    private boolean mirrorU;
    private boolean mirrorV;
    private boolean merge;
    private float tolerance;
    private Pointer pMirrorObject;
    private boolean mirrorVGroup;

    public MirrorModifier(Structure modifierStructure, BlenderContext blenderContext) {
        if (this.validate(modifierStructure, blenderContext)) {
            int flag = ((Number)modifierStructure.getFieldValue("flag")).intValue();
            this.isMirrored = new boolean[]{(flag & 8) != 0, (flag & 0x10) != 0, (flag & 0x20) != 0};
            if (blenderContext.getBlenderKey().isFixUpAxis()) {
                boolean temp = this.isMirrored[1];
                this.isMirrored[1] = this.isMirrored[2];
                this.isMirrored[2] = temp;
            }
            this.mirrorU = (flag & 2) != 0;
            this.mirrorV = (flag & 4) != 0;
            this.mirrorVGroup = (flag & 0x40) != 0;
            this.merge = (flag & 0x80) == 0;
            this.tolerance = ((Number)modifierStructure.getFieldValue("tolerance")).floatValue();
            this.pMirrorObject = (Pointer)modifierStructure.getFieldValue("mirror_ob");
            if (this.mirrorVGroup) {
                LOGGER.warning("Mirroring vertex groups is currently not supported.");
            }
        }
    }

    @Override
    public void apply(Node node, BlenderContext blenderContext) {
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Mirror modifier is invalid! Cannot be applied to: {0}", node.getName());
        } else {
            TemporalMesh temporalMesh = this.getTemporalMesh(node);
            if (temporalMesh != null) {
                LOGGER.log(Level.FINE, "Applying mirror modifier to: {0}", (Object)temporalMesh);
                Vector3f mirrorPlaneCenter = new Vector3f();
                if (this.pMirrorObject.isNotNull()) {
                    try {
                        Structure objectStructure = this.pMirrorObject.fetchData().get(0);
                        ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
                        Node object = (Node)objectHelper.toObject(objectStructure, blenderContext);
                        if (object != null) {
                            mirrorPlaneCenter = this.getWorldMatrix(node).invertLocal().mult(object.getWorldTranslation());
                        }
                    }
                    catch (BlenderFileException e) {
                        LOGGER.log(Level.SEVERE, "Cannot load mirror''s reference object. Cause: {0}", e.getLocalizedMessage());
                        LOGGER.log(Level.SEVERE, "Mirror modifier will not be applied to node named: {0}", node.getName());
                        return;
                    }
                }
                LOGGER.finest("Allocating temporal variables.");
                Vector3f mirrorPlaneNormal = new Vector3f();
                Vector3f shiftVector = new Vector3f();
                LOGGER.fine("Mirroring mesh.");
                for (int mirrorIndex = 0; mirrorIndex < 3; ++mirrorIndex) {
                    boolean mirrorAtPoint0;
                    if (!this.isMirrored[mirrorIndex]) continue;
                    boolean bl = mirrorAtPoint0 = mirrorPlaneCenter.get(mirrorIndex) == 0.0f;
                    if (!mirrorAtPoint0) {
                        mirrorPlaneNormal.set(0.0f, 0.0f, 0.0f).set(mirrorIndex, Math.signum(mirrorPlaneCenter.get(mirrorIndex)));
                    }
                    TemporalMesh mirror = temporalMesh.clone();
                    for (int i = 0; i < mirror.getVertexCount(); ++i) {
                        float d;
                        Vector3f vertex = mirror.getVertices().get(i);
                        Vector3f normal = mirror.getNormals().get(i);
                        if (mirrorAtPoint0) {
                            d = Math.abs(vertex.get(mirrorIndex));
                            shiftVector.set(0.0f, 0.0f, 0.0f).set(mirrorIndex, -vertex.get(mirrorIndex));
                        } else {
                            d = this.computeDistanceFromPlane(vertex, mirrorPlaneCenter, mirrorPlaneNormal);
                            mirrorPlaneNormal.mult(d, shiftVector);
                        }
                        if (this.merge && d <= this.tolerance) {
                            vertex.addLocal(shiftVector);
                            normal.set(mirrorIndex, 0.0f);
                            temporalMesh.getVertices().get(i).addLocal(shiftVector);
                            temporalMesh.getNormals().get(i).set(mirrorIndex, 0.0f);
                            continue;
                        }
                        vertex.addLocal(shiftVector.multLocal(2.0f));
                        normal.set(mirrorIndex, -normal.get(mirrorIndex));
                    }
                    for (Face face : mirror.getFaces()) {
                        face.flipIndexes();
                    }
                    for (Edge edge : mirror.getEdges()) {
                        edge.flipIndexes();
                    }
                    Collections.reverse(mirror.getPoints());
                    if (this.mirrorU || this.mirrorV) {
                        for (Face face : mirror.getFaces()) {
                            face.flipUV(this.mirrorU, this.mirrorV);
                        }
                    }
                    temporalMesh.append(mirror);
                }
            } else {
                LOGGER.log(Level.WARNING, "Cannot find temporal mesh for node: {0}. The modifier will NOT be applied!", node);
            }
        }
    }

    private Matrix4f getWorldMatrix(Node node) {
        Matrix4f result = new Matrix4f();
        result.setTranslation(node.getWorldTranslation());
        result.setRotationQuaternion(node.getWorldRotation());
        result.setScale(node.getWorldScale());
        return result;
    }

    private float computeDistanceFromPlane(Vector3f p, Vector3f c, Vector3f n) {
        return Math.abs(n.dot(p) - c.dot(n));
    }
}

