/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.animation.Bone;
import com.jme3.math.Transform;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.Set;

public abstract class ConstraintDefinition {
    protected ConstraintHelper constraintHelper;
    protected int flag;
    private Object owner;
    protected BlenderContext blenderContext;
    protected Long ownerOMA;
    protected Set<Long> alteredOmas;
    protected boolean trackToBeChanged = true;
    protected String constraintName;

    public ConstraintDefinition(Structure constraintData, Long ownerOMA, BlenderContext blenderContext) {
        Number flag;
        if (constraintData != null && (flag = (Number)constraintData.getFieldValue("flag")) != null) {
            this.flag = flag.intValue();
        }
        this.blenderContext = blenderContext;
        this.constraintHelper = blenderContext == null ? null : blenderContext.getHelper(ConstraintHelper.class);
        this.ownerOMA = ownerOMA;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public boolean isTrackToBeChanged() {
        return this.trackToBeChanged;
    }

    public abstract boolean isTargetRequired();

    protected Object getOwner() {
        if (this.ownerOMA != null && this.owner == null) {
            this.owner = this.blenderContext.getLoadedFeature(this.ownerOMA, BlenderContext.LoadedDataType.FEATURE);
            if (this.owner == null) {
                throw new IllegalStateException("Cannot load constraint's owner for constraint type: " + this.getClass().getName());
            }
        }
        return this.owner;
    }

    protected Transform getOwnerTransform(ConstraintHelper.Space ownerSpace) {
        if (this.getOwner() instanceof Bone) {
            BoneContext boneContext = this.blenderContext.getBoneContext(this.ownerOMA);
            return this.constraintHelper.getTransform(boneContext.getArmatureObjectOMA(), boneContext.getBone().getName(), ownerSpace);
        }
        return this.constraintHelper.getTransform(this.ownerOMA, null, ownerSpace);
    }

    protected void applyOwnerTransform(Transform ownerTransform, ConstraintHelper.Space ownerSpace) {
        if (this.getOwner() instanceof Bone) {
            BoneContext boneContext = this.blenderContext.getBoneContext(this.ownerOMA);
            this.constraintHelper.applyTransform(boneContext.getArmatureObjectOMA(), boneContext.getBone().getName(), ownerSpace, ownerTransform);
        } else {
            this.constraintHelper.applyTransform(this.ownerOMA, null, ownerSpace, ownerTransform);
        }
    }

    public boolean isImplemented() {
        return true;
    }

    public Set<Long> getAlteredOmas() {
        return this.alteredOmas;
    }

    public abstract String getConstraintTypeName();

    public abstract void bake(ConstraintHelper.Space var1, ConstraintHelper.Space var2, Transform var3, float var4);

    public String toString() {
        return this.getConstraintTypeName();
    }
}

