/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.EnabledComboBoxRenderer;
import rs.co.ast.aspen.gui.module.securityevents.IntervalListCellRenderer;
import rs.co.ast.aspen.gui.module.securityevents.IntervalModel;
import rs.co.ast.aspen.gui.module.securityevents.IntervalObject;
import rs.co.ast.aspen.gui.module.securityevents.LastNHoursModel;
import rs.co.ast.aspen.gui.module.securityevents.NextNHoursModel;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventsTopComponent;
import rs.co.ast.aspen.gui.module.securityevents.export.ExportContext;
import rs.co.ast.aspen.gui.module.securityevents.export.FileType;
import rs.co.ast.aspen.gui.module.securityevents.export.FileTypesComboBoxModel;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.CountSkippedEvent;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.ExportListeners;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.FileCreatedEvent;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.FileSkippedEvent;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.ProgressValueChangedEvent;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.WorkFinishedEvent;
import rs.co.ast.aspen.gui.module.securityevents.export.strategies.DefaultExportStrategy;
import rs.co.ast.aspen.gui.module.securityevents.export.strategies.ExportStrategy;
import rs.co.ast.aspen.gui.module.securityevents.export.strategies.JSONExportStrategy;
import rs.co.ast.aspen.gui.module.securityevents.export.strategies.XLSXExportStrategy;

public class DisplayOptionsPanel
extends JPanel
implements ExportListeners {
    private static final long MS_IN_AN_HOUR = 3600000L;
    private static final long MS_IN_A_DAY = 86400000L;
    private static final long MS_IN_A_MINUTE = 60000L;
    private static final Logger logger = Logger.getLogger(DisplayOptionsPanel.class.getName());
    private String query;
    private RequestProcessor req = null;
    private final DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());
    private DisplayOptions opts;
    private IntervalModel intervalModel;
    private ActionListener lastNHoursActionListener;
    private DisabledListener disabledNextNHoursActionListener = new DisabledListener();
    private EnabledListener enabledNextNHoursActionListener = new EnabledListener();
    private final FileTypesComboBoxModel fileTypesModel = new FileTypesComboBoxModel();
    private ExportStrategy strategy;
    private ExportContext exportContext;
    private ProgressHandle exportProgressHandle;
    private boolean messageShownOnSkippedCount = false;
    private boolean fired = false;
    private EnabledComboBoxRenderer enabledComboBoxRenderer = new EnabledComboBoxRenderer();
    private DefaultListSelectionModel model = new DefaultListSelectionModel();
    private JButton bExport;
    private JCheckBox cbDateRangeGraph;
    private JComboBox<FileType> cbFileType;
    private JComboBox cbInterval;
    private JComboBox cbLastNHours;
    private JComboBox<String> cbNextNHours;
    private JComboBox<String> cbNumberOfThreads;
    private JComboBox cbPageSize;
    private JCheckBox cbShowOverview;
    private JXDatePicker dtpTimeFinish;
    private JXDatePicker dtpTimeStart;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JLabel lHoursAfter;
    private JLabel lIndicesDates;
    private JLabel lWarningText;
    private JProgressBar pbCurrentJobProgress;
    private JRadioButton rbFinishTime;
    private JRadioButton rbLastNHours;
    private JRadioButton rbNextNHours;
    private JRadioButton rbStartTime;
    private JSpinner sAutoRefresh;
    private JSpinner sIndexSplit;
    private JToggleButton tbDescAsc;

    public DisplayOptionsPanel(final DisplayOptions opts) {
        this.opts = opts;
        this.intervalModel = new IntervalModel(opts.getIntervals());
        this.initComponents();
        this.lHoursAfter.setVisible(false);
        this.cbShowOverview.setSelected(this.opts.isShowOverview());
        this.toggleEnableOverview();
        this.sIndexSplit.addChangeListener(e -> opts.setIndexSplit((Long)this.sIndexSplit.getValue() * 60000L));
        this.dtpTimeStart.setFormats(new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"});
        this.dtpTimeStart.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeFinish.setFormats(new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"});
        this.dtpTimeFinish.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeStart.setTimeZone(TimeZone.getDefault());
        this.dtpTimeFinish.setTimeZone(TimeZone.getDefault());
        ActionListener dataPickerListener = e -> {
            if (this.isNextNHoursSelected() && this.rbStartTime.isSelected()) {
                this.lHoursAfter.setVisible(true);
                this.cbNextNHours.setSelectedIndex(3);
                this.cbNextNHours.repaint();
                this.setNextNHoursTime(this.dtpTimeStart.getDate().getTime());
            }
            if (this.isLastNHoursSelected()) {
                this.setLastNHoursTime();
            }
            this.setIndicesDates();
            opts.resetManualIntervalObj();
        };
        PropertyChangeListener datePickerPropertyListener = evt -> {
            this.setIndicesDates();
            this.autoEnableOverview();
        };
        this.dtpTimeStart.addPropertyChangeListener("date", datePickerPropertyListener);
        this.dtpTimeFinish.addPropertyChangeListener("date", datePickerPropertyListener);
        this.dtpTimeStart.addActionListener(dataPickerListener);
        this.dtpTimeFinish.addActionListener(dataPickerListener);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbStartTime);
        bg.add(this.rbLastNHours);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.rbNextNHours);
        bg2.add(this.rbFinishTime);
        this.rbLastNHours.addActionListener(e -> {
            int selectedIndex = this.cbLastNHours.getSelectedIndex();
            this.cbLastNHours.setEnabled(true);
            this.dtpTimeStart.setEnabled(false);
            this.cbLastNHours.setSelectedIndex(0);
            this.cbLastNHours.setSelectedIndex(selectedIndex);
            this.cbNextNHours.setSelectedIndex(0);
            this.cbNextNHours.repaint();
            this.disableNextNHoursComboBox();
        });
        this.rbStartTime.addActionListener(e -> {
            this.enableNextNHoursComboBox();
            this.cbLastNHours.setEnabled(false);
            this.dtpTimeStart.setEnabled(true);
        });
        this.rbNextNHours.addActionListener(e -> {
            this.cbNextNHours.setEnabled(true);
            this.dtpTimeFinish.setEnabled(false);
            this.dtpTimeFinish.setDate(new Date(System.currentTimeMillis()));
            if (this.isLastNHoursSelected()) {
                this.setLastNHoursTime();
            } else {
                this.setNextNHoursTime(this.dtpTimeStart.getDate().getTime());
            }
            this.setIndicesDates();
        });
        this.rbFinishTime.addActionListener(e -> {
            this.dtpTimeFinish.setEnabled(true);
            this.cbNextNHours.setEnabled(false);
        });
        this.cbInterval.setRenderer(new IntervalListCellRenderer());
        this.cbInterval.setModel(this.intervalModel);
        this.cbInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                opts.toggleFireEvents();
                opts.setIntervalObj(DisplayOptionsPanel.this.intervalModel.getSelectedItem());
                opts.setManualIntervalObj(true);
                opts.toggleFireEvents();
            }
        });
        this.cbNumberOfThreads.setSelectedIndex(opts.getWidgetThreads() - 1);
        this.cbNumberOfThreads.addActionListener(ActionListener2 -> {
            opts.toggleFireEvents();
            opts.setWidgetThreads(this.cbNumberOfThreads.getSelectedIndex() + 1);
            opts.toggleFireEvents();
        });
        this.cbLastNHours.setModel(new LastNHoursModel(opts.getLastNHourItems()));
        this.lastNHoursActionListener = e -> this.setLastNHoursTime();
        this.cbLastNHours.addActionListener(this.lastNHoursActionListener);
        this.cbNextNHours.setModel(new NextNHoursModel(opts.getNextNHoursItems()));
        this.cbNextNHours.setRenderer(this.enabledComboBoxRenderer);
        this.pbCurrentJobProgress.setVisible(false);
        this.cbFileType.setModel(this.fileTypesModel);
        this.cbFileType.setSelectedIndex(0);
        this.cbPageSize.addKeyListener(new KeyListener(){
            boolean altPressed = false;
            StringBuilder secret = new StringBuilder();

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.altPressed) {
                    this.secret.append(e.getKeyChar());
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 18) {
                    this.altPressed = true;
                    this.secret = new StringBuilder();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 18) {
                    this.altPressed = false;
                    try {
                        int pageSize = Integer.parseInt(this.secret.toString());
                        DisplayOptionsPanel.this.setPageSize(pageSize);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        this.setIndicesDates();
        this.tbDescAsc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DisplayOptionsPanel.this.tbDescAsc.isSelected()) {
                    DisplayOptionsPanel.this.tbDescAsc.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.desc"));
                    opts.setDescOrder(true);
                } else {
                    DisplayOptionsPanel.this.tbDescAsc.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.asc"));
                    opts.setDescOrder(false);
                }
            }
        });
    }

    public void enableNextNHoursComboBox() {
        this.cbNextNHours.removeActionListener(this.disabledNextNHoursActionListener);
        this.model.setSelectionInterval(0, this.cbNextNHours.getModel().getSize() - 1);
        this.enabledComboBoxRenderer.setEnabledItems(this.model);
        this.cbNextNHours.addActionListener(this.enabledNextNHoursActionListener);
    }

    public void disableNextNHoursComboBox() {
        this.lHoursAfter.setVisible(false);
        this.cbNextNHours.removeActionListener(this.enabledNextNHoursActionListener);
        this.model.setSelectionInterval(0, 0);
        this.enabledComboBoxRenderer.setEnabledItems(this.model);
        this.cbNextNHours.addActionListener(this.disabledNextNHoursActionListener);
    }

    public void setLastNHoursTime() {
        if (this.opts.isFireEvents()) {
            this.opts.resetManualIntervalObj();
        }
        long finish = this.rbNextNHours.isSelected() && this.cbNextNHours.getSelectedIndex() == 0 ? System.currentTimeMillis() : this.dtpTimeFinish.getDate().getTime();
        DateTime dtStart = new DateTime(finish);
        DateTime dtFinish = new DateTime(finish);
        int selectedIndex = this.cbLastNHours.getSelectedIndex();
        switch (selectedIndex) {
            case 0: {
                dtStart = dtStart.minusHours(1);
                break;
            }
            case 1: {
                dtStart = dtStart.minusHours(2);
                break;
            }
            case 2: {
                dtStart = dtStart.minusHours(4);
                break;
            }
            case 3: {
                dtStart = dtStart.minusHours(8);
                break;
            }
            case 4: {
                dtStart = dtStart.minusHours(12);
                break;
            }
            case 5: {
                dtStart = dtStart.minusDays(1);
                break;
            }
            case 6: {
                dtStart = dtStart.minusDays(2);
            }
        }
        this.dtpTimeStart.setDate(new Date(dtStart.getMillis()));
        this.dtpTimeFinish.setDate(new Date(dtFinish.getMillis()));
        long range = this.dtpTimeFinish.getDate().getTime() - this.dtpTimeStart.getDate().getTime();
        if (range < 86400000L) {
            this.setChartManuallyOpened(false);
        } else {
            this.setChartManuallyOpened(true);
        }
    }

    private void setNextNHoursTime(long time) {
        if (this.opts.isFireEvents()) {
            this.opts.resetManualIntervalObj();
        }
        DateTime dtStart = new DateTime(time);
        DateTime dtFinish = new DateTime(time);
        if (this.rbNextNHours.isSelected()) {
            int selectionIndex = this.cbNextNHours.getSelectedIndex();
            switch (selectionIndex) {
                case 0: {
                    dtFinish = DateTime.now();
                    break;
                }
                case 1: {
                    dtFinish = dtStart.plusHours(8);
                    break;
                }
                case 2: {
                    dtFinish = dtStart.plusHours(12);
                    break;
                }
                case 3: {
                    dtFinish = dtStart.plusHours(24);
                    break;
                }
                case 4: {
                    dtFinish = dtStart.plusHours(48);
                }
            }
        }
        this.dtpTimeStart.setDate(new Date(dtStart.getMillis()));
        this.dtpTimeFinish.setDate(new Date(dtFinish.getMillis()));
        long range = this.dtpTimeFinish.getDate().getTime() - this.dtpTimeStart.getDate().getTime();
        if (range < 86400000L) {
            this.setChartManuallyOpened(false);
        } else {
            this.setChartManuallyOpened(true);
        }
    }

    private void autoSelectInterval(DateTime dtStart, DateTime dtFinish) {
        if (!this.opts.isManualIntervalObj()) {
            ComboBoxModel model = this.cbInterval.getModel();
            long tmp = dtFinish.getMillis() - dtStart.getMillis();
            if (tmp <= 14400000L) {
                model.setSelectedItem(model.getElementAt(0));
            } else if (tmp > 14400000L && tmp < 43200000L) {
                model.setSelectedItem(model.getElementAt(1));
            } else if (tmp >= 43200000L && tmp <= 86400000L) {
                model.setSelectedItem(model.getElementAt(2));
            } else if (tmp > 86400000L && tmp <= 172800000L) {
                model.setSelectedItem(model.getElementAt(3));
            } else if (tmp > 172800000L && tmp <= 604800000L) {
                model.setSelectedItem(model.getElementAt(4));
            } else if (tmp > 604800000L && tmp <= 3888000000L) {
                model.setSelectedItem(model.getElementAt(5));
            } else {
                model.setSelectedItem(model.getElementAt(6));
            }
        }
    }

    private void setIndicesDates() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DateTime dtStart = new DateTime(DisplayOptionsPanel.this.dtpTimeStart.getDate().getTime());
                DateTime dtFinish = new DateTime(DisplayOptionsPanel.this.dtpTimeFinish.getDate().getTime());
                long remainder = dtFinish.getMillis() - dtStart.getMillis();
                StringBuilder sb = new StringBuilder();
                sb.append(NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.from"));
                sb.append(DisplayOptionsPanel.this.isoTimeFormat.print(dtStart.getMillis()));
                sb.append(NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.to"));
                sb.append(DisplayOptionsPanel.this.isoTimeFormat.print(dtFinish.getMillis()));
                if (remainder <= 0L) {
                    DisplayOptionsPanel.this.lWarningText.setText(NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.lWarningText.message"));
                } else {
                    DisplayOptionsPanel.this.lWarningText.setText("");
                }
                DisplayOptionsPanel.this.lIndicesDates.setText(sb.toString());
                DisplayOptionsPanel.this.autoSelectInterval(dtStart, dtFinish);
            }
        });
    }

    public boolean isLastNHoursSelected() {
        return this.rbLastNHours.isSelected();
    }

    public boolean isNextNHoursSelected() {
        return this.rbNextNHours.isSelected();
    }

    public boolean isNowSelected() {
        return this.rbNextNHours.isSelected() ? this.cbNextNHours.getSelectedIndex() == 0 : false;
    }

    public boolean isShowOverviewSelected() {
        return this.cbShowOverview.isSelected();
    }

    public boolean isChartManuallyOpened() {
        return this.cbDateRangeGraph.isSelected();
    }

    public int getLastNHours() {
        return (Integer)this.cbLastNHours.getModel().getSelectedItem();
    }

    public int getLastNHoursIndex() {
        return this.cbLastNHours.getSelectedIndex();
    }

    public void setShowOverview(boolean isSelected) {
        this.cbShowOverview.setSelected(isSelected);
        this.toggleEnableOverview();
    }

    public void setChartManuallyOpened(boolean isSelected) {
        this.cbDateRangeGraph.setSelected(isSelected);
    }

    public void setNowSelected(boolean isSelected) {
        this.rbNextNHours.setSelected(isSelected);
        this.cbNextNHours.setEnabled(isSelected);
        this.dtpTimeFinish.setEnabled(!isSelected);
        this.rbFinishTime.setSelected(!isSelected);
        if (!isSelected) {
            this.enableNextNHoursComboBox();
        } else {
            this.disableNextNHoursComboBox();
        }
        this.cbNextNHours.repaint();
    }

    public void setLastNHoursIndex(int index) {
        this.cbLastNHours.removeActionListener(this.lastNHoursActionListener);
        this.cbLastNHours.setSelectedIndex(index);
        this.cbLastNHours.addActionListener(this.lastNHoursActionListener);
    }

    public void setLastNHoursSelected(boolean isSelected) {
        this.cbLastNHours.setEnabled(isSelected);
        this.dtpTimeStart.setEnabled(!isSelected);
        this.rbLastNHours.setSelected(isSelected);
        this.rbStartTime.setSelected(!isSelected);
    }

    private void createAndWriteToFile(String fileName, byte[] file) throws IOException {
        File dfile = new File(this.strategy.getExportPath(), fileName);
        dfile.createNewFile();
        try (FileOutputStream fileOuputStream = new FileOutputStream(dfile);){
            fileOuputStream.write(file);
        }
    }

    private void showWorkDoneMessage(WorkFinishedEvent event) {
        int messageType = 1;
        if (!event.isSuccess()) {
            messageType = 0;
        }
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)event.getMessage(), messageType);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    private void toggleButtonAndProgressBars() {
        String export = NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.bExport.text");
        if (this.bExport.getText().equals(export)) {
            this.bExport.setText(NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.bExport.stop.text"));
        } else {
            this.bExport.setText(export);
        }
        this.pbCurrentJobProgress.setVisible(!this.pbCurrentJobProgress.isVisible());
        this.pbCurrentJobProgress.setMaximum(100);
        this.pbCurrentJobProgress.setValue(0);
        this.pbCurrentJobProgress.setStringPainted(true);
        this.pbCurrentJobProgress.setString(String.format("%d/%d [~%.1fs]", 0, 0, Float.valueOf(0.0f)));
    }

    private void initComponents() {
        this.jLabel7 = new JLabel();
        this.jLabel12 = new JLabel();
        this.lIndicesDates = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel3 = new JLabel();
        this.cbFileType = new JComboBox();
        this.sAutoRefresh = new JSpinner();
        this.bExport = new JButton();
        this.jLabel4 = new JLabel();
        this.pbCurrentJobProgress = new JProgressBar();
        this.jLabel5 = new JLabel();
        this.cbPageSize = new JComboBox();
        this.jLabel1 = new JLabel();
        this.cbInterval = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel6 = new JLabel();
        this.cbShowOverview = new JCheckBox();
        this.cbNumberOfThreads = new JComboBox();
        this.jLabel13 = new JLabel();
        this.lWarningText = new JLabel();
        this.sIndexSplit = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jPanel1 = new JPanel();
        this.rbLastNHours = new JRadioButton();
        this.cbLastNHours = new JComboBox();
        this.rbStartTime = new JRadioButton();
        this.jLabel14 = new JLabel();
        this.dtpTimeStart = new JXDatePicker();
        this.jLabel11 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel15 = new JLabel();
        this.rbFinishTime = new JRadioButton();
        this.rbNextNHours = new JRadioButton();
        this.dtpTimeFinish = new JXDatePicker();
        this.cbNextNHours = new JComboBox();
        this.lHoursAfter = new JLabel();
        this.cbDateRangeGraph = new JCheckBox();
        this.tbDescAsc = new JToggleButton();
        this.jLabel7.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel7.text"));
        this.jLabel12.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel12.text"));
        this.lIndicesDates.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lIndicesDates, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.lIndicesDates.text"));
        this.lIndicesDates.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel9.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel9.text"));
        this.jLabel3.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel3.text"));
        this.cbFileType.setFont(new Font("Dialog", 0, 12));
        this.sAutoRefresh.setFont(new Font("Dialog", 0, 12));
        this.sAutoRefresh.setModel(new SpinnerNumberModel(0, 0, 60, 1));
        this.bExport.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayOptionsPanel.this.bExportActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel4.text"));
        this.pbCurrentJobProgress.setFont(new Font("Dialog", 0, 12));
        this.jLabel5.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel5.text"));
        this.cbPageSize.setFont(new Font("Dialog", 0, 12));
        this.cbPageSize.setModel(new DefaultComboBoxModel<String>(new String[]{"10", "50", "100", "200", "500", "1000"}));
        this.cbPageSize.setSelectedIndex(2);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel1.text"));
        this.cbInterval.setFont(new Font("Dialog", 0, 12));
        this.cbInterval.setToolTipText(NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.cbInterval.toolTipText"));
        this.jLabel8.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel8.text"));
        this.jLabel6.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel6.text"));
        this.cbShowOverview.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowOverview, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.cbShowOverview.text"));
        this.cbShowOverview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayOptionsPanel.this.cbShowOverviewActionPerformed(evt);
            }
        });
        this.cbNumberOfThreads.setFont(new Font("Dialog", 0, 12));
        this.cbNumberOfThreads.setModel(new DefaultComboBoxModel<Object>(this.opts.getThreadsNumber().toArray()));
        this.cbNumberOfThreads.setToolTipText(NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.cbNumberOfThreads.toolTipText"));
        this.jLabel13.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel13.text"));
        this.lWarningText.setForeground(new Color(153, 0, 0));
        this.lWarningText.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lWarningText, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.lWarningText.text"));
        this.sIndexSplit.setFont(new Font("Dialog", 0, 12));
        this.sIndexSplit.setModel(new SpinnerNumberModel((Number)480L, Long.valueOf(1L), Long.valueOf(720L), (Number)1L));
        this.sIndexSplit.setToolTipText(NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.sIndexSplit.toolTipText"));
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel2.text"));
        this.jLabel10.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel10.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.rbLastNHours, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.rbLastNHours.text"));
        this.cbLastNHours.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "4", "8", "12", "24", "48"}));
        this.cbLastNHours.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.rbStartTime, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.rbStartTime.text"));
        this.jLabel14.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel14.text"));
        this.jLabel11.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel11.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.rbStartTime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dtpTimeStart, -2, 241, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel14).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.rbLastNHours).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbLastNHours, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11))).addGap(0, 0, 0)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel14).addGap(3, 3, 3).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbLastNHours).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbLastNHours, -2, -1, -2).addComponent(this.jLabel11))).addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dtpTimeStart, -2, -1, -2).addComponent(this.rbStartTime)).addGap(0, 0, 0)));
        this.jLabel15.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.jLabel15.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.rbFinishTime, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.rbFinishTime.text"));
        this.rbNextNHours.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.rbNextNHours, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.rbNextNHours.text"));
        this.lHoursAfter.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lHoursAfter, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.lHoursAfter.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.rbNextNHours, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.rbFinishTime, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dtpTimeFinish, -2, 242, -2).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.cbNextNHours, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lHoursAfter))))).addGap(0, 0, 0)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel15).addGap(4, 4, 4).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbNextNHours).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbNextNHours, -2, -1, -2).addComponent(this.lHoursAfter))).addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dtpTimeFinish, -2, -1, -2).addComponent(this.rbFinishTime)).addGap(0, 0, 0)));
        this.cbDateRangeGraph.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDateRangeGraph, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.cbDateRangeGraph.text"));
        this.tbDescAsc.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDescAsc, (String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.tbDescAsc.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sAutoRefresh, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(134, 134, 134)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sIndexSplit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10, -2, 84, -2).addGap(18, 18, 18).addComponent(this.cbDateRangeGraph)).addComponent(this.cbShowOverview, -2, 535, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -2, 475, -2).addGroup(layout.createSequentialGroup().addComponent(this.cbFileType, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bExport).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pbCurrentJobProgress, -2, 307, -2)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbInterval, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbNumberOfThreads, -2, 93, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPageSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -2, 370, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lIndicesDates, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lWarningText, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 471, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.tbDescAsc).addGap(17, 17, 17)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tbDescAsc, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, -2, 25, -2)).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel2, -2, -1, -2)).addGap(46, 46, 46)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lIndicesDates))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lWarningText, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.sAutoRefresh, -2, -1, -2).addComponent(this.jLabel4)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.cbPageSize, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowOverview).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.cbInterval, -2, -1, -2).addComponent(this.cbNumberOfThreads, -2, -1, -2).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.sIndexSplit, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.cbDateRangeGraph)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8).addComponent(this.jSeparator1, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pbCurrentJobProgress, GroupLayout.Alignment.TRAILING, -2, 25, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.cbFileType, -2, -1, -2).addComponent(this.bExport))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void bExportActionPerformed(ActionEvent evt) {
        block9: {
            if (this.bExport.getText().equals(NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.bExport.text"))) {
                logger.info(String.format("EXPORT STARTED [%s - %s]", new DateTime(this.getTimeStart()), new DateTime(this.getTimeStart())));
                try {
                    this.exportContext = new ExportContext();
                    this.strategy = new DefaultExportStrategy(this.query, "", this.getTimeStart(), this.getTimeFinish(), this.getIndexSplit());
                    this.strategy.getWorkFinishedSupport().addWorkFinishedListener(this);
                    this.toggleButtonAndProgressBars();
                    JFileChooser saveDialog = new JFileChooser();
                    saveDialog.setDialogTitle(NbBundle.getMessage(DisplayOptionsPanel.class, (String)"saving-report.dialog.title"));
                    saveDialog.setDialogType(1);
                    saveDialog.setFileSelectionMode(1);
                    int actionDialog = saveDialog.showSaveDialog(this);
                    if (actionDialog == 0) {
                        String exportPath = saveDialog.getSelectedFile().getPath();
                        switch (this.fileTypesModel.getElementAt(this.cbFileType.getSelectedIndex())) {
                            case XLS: {
                                this.strategy = new XLSXExportStrategy(this.query, exportPath, this.getTimeStart(), this.getTimeFinish(), this.getIndexSplit());
                                break;
                            }
                            case JSON: {
                                this.strategy = new JSONExportStrategy(this.query, exportPath, this.getTimeStart(), this.getTimeFinish(), this.getIndexSplit());
                            }
                        }
                        this.strategy.getWorkFinishedSupport().addWorkFinishedListener(this);
                        this.strategy.getFileCreatedSupport().addFileCreatedListener(this);
                        this.strategy.getProgressValueChangedSupport().addProgressValueChangeListener(this);
                        this.strategy.getFileSkippedSupport().addFileSkippedListener(this);
                        this.strategy.getCountSkippedSupport().addCountSkippedListener(this);
                        this.strategy.getCountTasksCompletedSupport().addCountTasksCompletedListener(this);
                        this.exportContext.setExportStrategy(this.strategy);
                        break block9;
                    }
                    this.strategy.getWorkFinishedSupport().fireWorkFinishedEvent(false, NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.export.canceled_task.message"));
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                logger.info(String.format("EXPORT CANCELED [%s - %s]", new DateTime(this.getTimeStart()), new DateTime(this.getTimeStart())));
                this.strategy.getWorkFinishedSupport().fireWorkFinishedEvent(false, NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.export.canceled_task.message"));
            }
        }
    }

    private void cbShowOverviewActionPerformed(ActionEvent evt) {
        this.opts.setShowOverview(this.cbShowOverview.isSelected());
        this.toggleEnableOverview();
    }

    private void toggleEnableOverview() {
        if (!this.cbShowOverview.isSelected()) {
            this.cbInterval.setEnabled(false);
            this.cbNumberOfThreads.setEnabled(false);
        } else {
            this.cbInterval.setEnabled(true);
            this.cbNumberOfThreads.setEnabled(true);
        }
    }

    private void autoEnableOverview() {
        if (this.dtpTimeFinish.getDate() != null && this.dtpTimeStart.getDate() != null) {
            long range = this.dtpTimeFinish.getDate().getTime() - this.dtpTimeStart.getDate().getTime();
            if (range > 604800000L) {
                this.enableOverview(false);
                this.setChartManuallyOpened(true);
            } else if (range > 172800000L) {
                this.cbShowOverview.setEnabled(true);
                this.cbShowOverview.setSelected(false);
                this.cbInterval.setEnabled(false);
                this.cbNumberOfThreads.setEnabled(false);
                this.setChartManuallyOpened(true);
            } else {
                this.setChartManuallyOpened(true);
                if (range < 86400000L) {
                    this.setChartManuallyOpened(false);
                }
                this.cbShowOverview.setEnabled(true);
                this.cbInterval.setEnabled(true);
                this.cbNumberOfThreads.setEnabled(true);
            }
            if (this.cbShowOverview.isSelected()) {
                this.cbShowOverview.setFont(new Font(this.cbShowOverview.getFont().getName(), 0, 10));
            } else {
                this.cbShowOverview.setFont(new Font(this.cbShowOverview.getFont().getName(), 1, 10));
            }
            this.opts.setShowOverview(this.cbShowOverview.isSelected());
        }
    }

    private void enableOverview(boolean enable) {
        this.cbShowOverview.setSelected(enable);
        this.cbInterval.setEnabled(enable);
        this.cbNumberOfThreads.setEnabled(enable);
    }

    public long getTimeStart() {
        return this.dtpTimeStart.getDate().getTime();
    }

    public long getTimeFinish() {
        return this.dtpTimeFinish.getDate().getTime();
    }

    public void setTimeStart(long time) {
        this.dtpTimeStart.setDate(new Date(time));
    }

    public void setTimeFinish(long time) {
        this.dtpTimeFinish.setDate(new Date(time));
    }

    public int getAutoRefresh() {
        return (Integer)this.sAutoRefresh.getValue();
    }

    public void setAutoRefresh(int autoRefresh) {
        this.sAutoRefresh.setValue(autoRefresh);
    }

    public long getIndexSplit() {
        return (Long)this.sIndexSplit.getValue() * 60000L;
    }

    public void setIndexSplit(long indexSplit) {
        this.sIndexSplit.setValue(indexSplit);
    }

    public int getPageSize() {
        return Integer.valueOf((String)this.cbPageSize.getSelectedItem());
    }

    public void setPageSize(int pageSize) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cbPageSize.getModel();
        if (model.getIndexOf(String.valueOf(pageSize)) == -1) {
            model.addElement(String.valueOf(pageSize));
        }
        this.cbPageSize.setSelectedItem(String.valueOf(pageSize));
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public IntervalObject getIntervalObject() {
        return (IntervalObject)this.cbInterval.getSelectedItem();
    }

    public void setIntervalObject(IntervalObject io) {
        this.cbInterval.setSelectedItem(io);
    }

    public boolean isDescSelected() {
        return this.tbDescAsc.isSelected();
    }

    public void setDescAsc(boolean isDescSelected) {
        if (isDescSelected) {
            this.tbDescAsc.setSelected(true);
            this.tbDescAsc.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.desc"));
        } else {
            this.tbDescAsc.setSelected(false);
            this.tbDescAsc.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.asc"));
        }
        this.tbDescAsc.repaint();
    }

    @Override
    public void progressChanged(final ProgressValueChangedEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DisplayOptionsPanel.this.pbCurrentJobProgress.setIndeterminate(false);
                DisplayOptionsPanel.this.pbCurrentJobProgress.setMaximum((int)event.getTotalHits());
                DisplayOptionsPanel.this.pbCurrentJobProgress.setValue(event.getProgress());
                DisplayOptionsPanel.this.pbCurrentJobProgress.setStringPainted(true);
                if (event.getPosition() == event.getTotalHits()) {
                    DisplayOptionsPanel.this.pbCurrentJobProgress.setIndeterminate(true);
                    DisplayOptionsPanel.this.pbCurrentJobProgress.setString(NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.export.preparing.file"));
                } else {
                    DisplayOptionsPanel.this.pbCurrentJobProgress.setString(String.format("%d/%d [~%.1fs]", event.getPosition(), event.getTotalHits(), Float.valueOf(event.getElapsed())));
                }
            }
        });
    }

    @Override
    public void fileCreated(final FileCreatedEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (event.isSuccess() && event.getFile() != null) {
                    try {
                        DisplayOptionsPanel.this.createAndWriteToFile(event.getFileName(), event.getFile());
                        int workUnits = DisplayOptionsPanel.this.strategy.countFilesDone() > DisplayOptionsPanel.this.strategy.getTotalFilesCount() ? DisplayOptionsPanel.this.strategy.getTotalFilesCount() : DisplayOptionsPanel.this.strategy.countFilesDone();
                        DisplayOptionsPanel.this.exportProgressHandle.progress(workUnits);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
    }

    @Override
    public void done(final WorkFinishedEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DisplayOptionsPanel.this.toggleButtonAndProgressBars();
                DisplayOptionsPanel.this.exportContext.shutdown();
                DisplayOptionsPanel.this.messageShownOnSkippedCount = false;
                DisplayOptionsPanel.this.fired = false;
                DisplayOptionsPanel.this.showWorkDoneMessage(event);
                logger.info(String.format("EXPORT FINISHED [%s]", event.isSuccess()));
                DisplayOptionsPanel.this.exportProgressHandle.finish();
            }
        });
    }

    @Override
    public void fileSkipped(FileSkippedEvent event) {
        logger.warning(String.format("FILE SKIPPED - %s", event.getFileName()));
        this.strategy.submitSkippedFetch(event);
    }

    @Override
    public void countSkipped(CountSkippedEvent event) {
        logger.warning(String.format("COUNT SKIPPED - %s - %s", new DateTime(event.getDateRange().getStartTimeStamp()), new DateTime(event.getDateRange().getFinishTimeStamp())));
        this.strategy.submitSkippedCount(event);
    }

    @Override
    public void countTasksCompleted(boolean success) {
        logger.info(String.format("countTasksCompleted success %s - messageShownOnSkippedCount %s ", success, this.messageShownOnSkippedCount));
        if (!this.fired) {
            if (!success && !this.messageShownOnSkippedCount) {
                this.messageShownOnSkippedCount = true;
                int ret = JOptionPane.showConfirmDialog(this, "Do you want to continue ?", "Title", 0, 3);
                if (ret == 1) {
                    this.exportContext.shutdown();
                    this.toggleButtonAndProgressBars();
                    return;
                }
            }
            this.exportContext.calcTotalFilesCount();
            this.exportProgressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.export.progress.title"), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    DisplayOptionsPanel.this.exportContext.shutdown();
                    DisplayOptionsPanel.this.strategy.getWorkFinishedSupport().fireWorkFinishedEvent(false, NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.export.canceled_task.message"));
                    return true;
                }
            });
            this.exportProgressHandle.start(this.strategy.getTotalFilesCount());
            this.exportProgressHandle.progress(0);
            this.exportContext.export();
            this.fired = true;
        }
    }

    public void setDescToggleButtonVisible(boolean isDescToggleButtonVisible) {
        this.tbDescAsc.setEnabled(isDescToggleButtonVisible);
        this.tbDescAsc.setVisible(isDescToggleButtonVisible);
    }

    private class EnabledListener
    implements ActionListener {
        private EnabledListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((JComboBox)e.getSource()).getSelectedIndex() != 0) {
                if (!DisplayOptionsPanel.this.lHoursAfter.isVisible()) {
                    DisplayOptionsPanel.this.lHoursAfter.setVisible(true);
                }
                DisplayOptionsPanel.this.setNextNHoursTime(DisplayOptionsPanel.this.dtpTimeStart.getDate().getTime());
            } else {
                if (DisplayOptionsPanel.this.lHoursAfter.isVisible()) {
                    DisplayOptionsPanel.this.lHoursAfter.setVisible(false);
                }
                DisplayOptionsPanel.this.setLastNHoursTime();
            }
        }
    }

    private class DisabledListener
    implements ActionListener {
        private DisabledListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((JComboBox)e.getSource()).getSelectedIndex() != 0) {
                if (!DisplayOptionsPanel.this.lHoursAfter.getText().isEmpty()) {
                    DisplayOptionsPanel.this.lHoursAfter.setVisible(false);
                }
                DisplayOptionsPanel.this.cbNextNHours.setSelectedIndex(0);
                System.out.println("Henlo frend");
            }
        }
    }
}

