/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.factory;

import org.ejml.alg.dense.decompose.chol.CholeskyDecompositionInner_CD64;
import org.ejml.alg.dense.decompose.lu.LUDecompositionAlt_CD64;
import org.ejml.alg.dense.decompose.qr.QRDecompositionHouseholderColumn_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.interfaces.decomposition.QRDecomposition;

public class CDecompositionFactory {
    public static LUDecomposition<CDenseMatrix64F> lu(int numRows, int numCols) {
        return new LUDecompositionAlt_CD64();
    }

    public static QRDecomposition<CDenseMatrix64F> qr(int numRows, int numCols) {
        return new QRDecompositionHouseholderColumn_CD64();
    }

    public static CholeskyDecomposition<CDenseMatrix64F> chol(int size, boolean lower) {
        return new CholeskyDecompositionInner_CD64(lower);
    }

    public static boolean decomposeSafe(DecompositionInterface<CDenseMatrix64F> decomposition, CDenseMatrix64F a) {
        if (decomposition.inputModified()) {
            a = a.copy();
        }
        return decomposition.decompose((Matrix)a);
    }
}

