/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization.properties;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTime;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.api.service.SecurityEventsSearchResults;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.visualization.VisualizationTopComponent;
import rs.co.ast.aspen.gui.module.visualization.properties.Producer;

public class HistoricalProducer
extends Producer {
    private static final Logger LOGGER = Logger.getLogger(HistoricalProducer.class.getName());

    public HistoricalProducer(BlockingQueue<List<Node>> queue) {
        super("HistoricalProducer", queue);
        this.page = 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.generateQuery();
            block9: while (!this.isInterrupted()) {
                Thread.sleep(1L);
                while (!this.idle || this.goToNextStep > 0) {
                    if (this.isInterrupted()) {
                        LOGGER.info("Producer stopped");
                        if (this.ph == null) continue block9;
                        this.ph.finish();
                        continue block9;
                    }
                    Thread.sleep(1L);
                    this.ph = ProgressHandleFactory.createHandle((String)this.progressHandleName);
                    this.ph.start();
                    LOGGER.info("START");
                    this.ph.switchToIndeterminate();
                    if (this.activeList == null) {
                        this.activeList = this.search(this.query, this.from, this.to);
                        LOGGER.info("ActiveList is fetched!");
                    }
                    if (this.future == null) {
                        this.future = this.executeSearch(this.query, this.from, this.to);
                        while (!this.future.isDone()) {
                            this.tempList = (List)this.future.get();
                            LOGGER.info("TempList is fetched!");
                        }
                    }
                    this.ph.finish();
                    LOGGER.info("FINISH Fetching");
                    while (!(this.activeList.isEmpty() || this.idle && this.goToNextStep <= 0)) {
                        if (this.isInterrupted()) {
                            LOGGER.info("Producer stopped");
                            if (this.ph != null) {
                                this.ph.finish();
                            }
                            this.idle = true;
                            break;
                        }
                        Thread.sleep(1L);
                        this.indexTo = this.indexFrom + this.eventsPerStep;
                        this.indexTo = this.indexTo > this.activeList.size() ? this.activeList.size() : this.indexTo;
                        LOGGER.info(String.format("activeList size: %d, tempList size: %d, indexFrom: %d, indexTo: %d", this.activeList.size(), this.tempList.size(), this.indexFrom, this.indexTo));
                        List subList = this.activeList.subList(this.indexFrom, this.indexTo);
                        try {
                            this.visManager.getConfig().getVisEngine().process(subList);
                        }
                        catch (Exception ex) {
                            StringBuilder skippedEventIds = new StringBuilder();
                            for (SecurityEvent event : subList) {
                                skippedEventIds.append(event.getId());
                                SecurityEvent se = (SecurityEvent)subList.get(subList.size() - 1);
                                if (event.getId().equals(se.getId())) continue;
                                skippedEventIds.append(",");
                            }
                            StringWriter sw = new StringWriter();
                            ex.printStackTrace(new PrintWriter(sw));
                            LOGGER.warning(String.format("Event skipped! %s because of: %s", skippedEventIds.toString(), sw.toString()));
                            this.activeList.removeAll(subList);
                            this.goToNextStep = 1;
                            continue;
                        }
                        if (this.goToNextStep <= 0) {
                            Thread.sleep(this.stepDelay);
                        }
                        List<Node> allNodesList = this.allNodesList();
                        this.queue.put(allNodesList);
                        this.activeList.removeAll(subList);
                        this.count += (long)this.eventsPerStep;
                        this.count = this.count > this.searchState.getTotalHits() ? this.searchState.getTotalHits() : this.count;
                        this.visPropTC.updateEventsDrawnLabel(String.format("%,8d%n / %,8d%n", this.count, this.searchState.getTotalHits()));
                        if (this.goToNextStep > 0) {
                            this.goToNextStep = this.goToNextStep - 1;
                        }
                        if (!this.activeList.isEmpty()) continue;
                        this.activeList = this.tempList;
                        this.future = null;
                        LOGGER.info("Switching lists and fetching TempList!");
                        break;
                    }
                    this.indexFrom = 0;
                    this.indexTo = 0;
                    if (!this.activeList.isEmpty() || this.activeList.size() >= this.page) continue;
                    if (this.searchState != null) {
                        if (this.searchState.getTotalHits() < 0L) {
                            LOGGER.info("Query failed!");
                            this.visPropTC.updateStatusLabel(NbBundle.getMessage(VisualizationTopComponent.class, (String)"Producer.status.query.failed.title"));
                        } else {
                            LOGGER.info("No more security events!");
                            this.visPropTC.updateStatusLabel(NbBundle.getMessage(HistoricalProducer.class, (String)"Producer.status.finished.title"));
                        }
                    } else {
                        LOGGER.info("No more security events!");
                        this.visPropTC.updateStatusLabel(NbBundle.getMessage(HistoricalProducer.class, (String)"Producer.status.finished.title"));
                    }
                    this.interrupt();
                    this.idle = true;
                    continue block9;
                }
            }
        }
        catch (RuntimeException | ExecutionException ex) {
            LOGGER.log(Level.SEVERE, "HistoricalProducer thread error", ex);
            this.mode = Producer.Mode.ERROR;
        }
        catch (InterruptedException | ApiServiceException_Exception ex) {
            LOGGER.log(Level.INFO, "HistoricalProducer thread interrupted", ex);
        }
        finally {
            LOGGER.info("Producer finished.");
            if (this.ph != null) {
                this.ph.finish();
            }
            this.executorService.shutdownNow();
        }
    }

    @Override
    protected List<SecurityEvent> search(String query, long from, long to) throws ApiServiceException_Exception {
        LOGGER.info(String.format("Searching security events by QUERY: %s, PAGE: %d [%d - %d], FROM: %s, TO: %s", query, this.page, this.searchState.getOffset(), this.searchState.getTotalHits(), new DateTime(from), new DateTime(to)));
        SecurityEventsSearchResults results = this.apiService.searchSecurityEventsAsc(query, this.searchState, this.page, from, to);
        this.searchState = results.getSearchState();
        this.searchState.setOffset(this.searchState.getOffset() + (long)this.page);
        this.visPropTC.updateEventsDrawnLabel(String.format("%,8d%n / %,8d%n", this.count, this.searchState.getTotalHits()));
        return results.getContainer().getSecurityEvents();
    }
}

