/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.simple.SimpleMatrix;

public class SimpleEVD<T extends SimpleMatrix> {
    private EigenDecomposition<DenseMatrix64F> eig;
    DenseMatrix64F mat;

    public SimpleEVD(DenseMatrix64F mat) {
        this.mat = mat;
        this.eig = DecompositionFactory.eig((int)mat.numCols, (boolean)true);
        if (!this.eig.decompose((Matrix)mat)) {
            throw new RuntimeException("Eigenvalue Decomposition failed");
        }
    }

    public int getNumberOfEigenvalues() {
        return this.eig.getNumberOfEigenvalues();
    }

    public Complex64F getEigenvalue(int index) {
        return this.eig.getEigenvalue(index);
    }

    public T getEigenVector(int index) {
        return (T)SimpleMatrix.wrap((DenseMatrix64F)this.eig.getEigenVector(index));
    }

    public double quality() {
        return DecompositionFactory.quality((DenseMatrix64F)this.mat, this.eig);
    }

    public EigenDecomposition getEVD() {
        return this.eig;
    }

    public int getIndexMax() {
        int indexMax = 0;
        double max = this.getEigenvalue(0).getMagnitude2();
        int N = this.getNumberOfEigenvalues();
        for (int i = 1; i < N; ++i) {
            double m = this.getEigenvalue(i).getMagnitude2();
            if (!(m > max)) continue;
            max = m;
            indexMax = i;
        }
        return indexMax;
    }

    public int getIndexMin() {
        int indexMin = 0;
        double min = this.getEigenvalue(0).getMagnitude2();
        int N = this.getNumberOfEigenvalues();
        for (int i = 1; i < N; ++i) {
            double m = this.getEigenvalue(i).getMagnitude2();
            if (!(m < min)) continue;
            min = m;
            indexMin = i;
        }
        return indexMin;
    }
}

