/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.export.strategies;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.api.service.RawLogsSearchResults;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.gui.rawlogs.export.strategies.ExportStrategy;

public class XMLExportStrategy
extends ExportStrategy {
    public XMLExportStrategy(String query, String exportPath, long startTime, long finishTime, long indexSplit) throws ApiServiceException_Exception {
        super(query, exportPath, startTime, finishTime, indexSplit, "xml");
    }

    @Override
    public SwingWorker<byte[], Void> search(final String fileName, final SearchState searchState, final DateRange dateRange) {
        return new SwingWorker<byte[], Void>(){

            @Override
            protected byte[] doInBackground() throws Exception {
                Object object;
                RawLogsSearchResults result = XMLExportStrategy.this.fetch(searchState, dateRange);
                ExportStrategy.logger.info(String.format("FETCH - s: %s - f: %s, o: %d, d: %d, t: %d", new DateTime(dateRange.getStartTimeStamp()), new DateTime(dateRange.getFinishTimeStamp()), result.getSearchState().getOffset(), result.getContainer().getRowLogs().size(), result.getSearchState().getTotalHits()));
                if (!result.getContainer().getErrors().isEmpty()) {
                    ExportStrategy.logger.warning(String.format("FETCH ERRORS - %s", result.getContainer().getErrors()));
                    XMLExportStrategy.this.fileSkippedSupport.fireFileSkippedEvent(fileName, dateRange, searchState);
                    return null;
                }
                ByteArrayOutputStream osFile = new ByteArrayOutputStream();
                try {
                    JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RawLog.class});
                    Marshaller m = ctx.createMarshaller();
                    m.setProperty("jaxb.formatted.output", (Object)true);
                    m.setProperty("jaxb.fragment", (Object)true);
                    StringBuilder sb = new StringBuilder();
                    sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    sb.append("<events>");
                    osFile.write(sb.toString().getBytes());
                    int progress = 0;
                    for (RawLog r : result.getContainer().getRowLogs()) {
                        try (ByteArrayOutputStream osRawLog = new ByteArrayOutputStream();){
                            JAXBElement je2 = new JAXBElement(new QName("rawlog"), RawLog.class, (Object)r);
                            m.marshal((Object)je2, (OutputStream)osRawLog);
                            osRawLog.writeTo(osFile);
                            XMLExportStrategy.this.progressValueChangedSupport.fireProgressValueChangedEvent(progress++, progress, result.getContainer().getRowLogs().size(), 0.0f);
                        }
                    }
                    osFile.write("</events>".getBytes());
                    object = osFile.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            osFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (JAXBException | IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return null;
                    }
                }
                osFile.close();
                return object;
            }

            @Override
            protected void done() {
                try {
                    byte[] file = (byte[])this.get();
                    if (file == null) {
                        return;
                    }
                    XMLExportStrategy.this.taskMonitor.completeFetch(fileName);
                    XMLExportStrategy.this.fileCreatedSupport.fireFileCreatedEvent(fileName, file, true);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
    }
}

