/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.eval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CorrelationContextTest {
    private static final long MS_IN_S = 1000L;
    private static final long MIN_EXPIRE_PERIOD = 1000L;
    private String id;
    private long threshold;
    private long lastUpdate;
    private long window;
    private List<String> references = new ArrayList<String>();
    private List<Trigger> triggers = new ArrayList<Trigger>();
    private Mode mode;
    private boolean fireOnExpire;
    private String language;
    private boolean dirty;
    private boolean alreadyFired;
    private boolean initialized;
    private String triggerModuleName;
    private long lastExpire;

    public void expireTriggers() {
        long now = System.currentTimeMillis();
        if (now - this.lastExpire > 1000L) {
            this.lastExpire = now;
            long cutoff = now - this.window * 1000L;
            Iterator<Trigger> it = this.triggers.iterator();
            ArrayList<Trigger> newTriggers = new ArrayList<Trigger>();
            while (it.hasNext()) {
                Trigger trigger = it.next();
                if (trigger.getTimestamp() < cutoff) continue;
                newTriggers.add(trigger);
            }
            if (newTriggers.size() != this.triggers.size()) {
                this.dirty = true;
                this.triggers = newTriggers;
            }
        }
    }

    public void addTrigger(String customData) {
        Trigger trigger = new Trigger(System.currentTimeMillis(), customData);
        this.triggers.add(trigger);
        this.dirty = true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public List<String> getReferences() {
        this.dirty = true;
        return this.references;
    }

    public void setReferences(List<String> references) {
        this.references = references;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.dirty = true;
        this.lastUpdate = lastUpdate;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    public long getWindow() {
        return this.window;
    }

    public void setWindow(long window) {
        this.window = window;
    }

    public boolean isFireOnExpire() {
        return this.fireOnExpire;
    }

    public void setFireOnExpire(boolean fireOnExpire) {
        this.fireOnExpire = fireOnExpire;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isAlreadyFired() {
        return this.alreadyFired;
    }

    public void setAlreadyFired(boolean alreadyFired) {
        this.alreadyFired = alreadyFired;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getTriggerModuleName() {
        return this.triggerModuleName;
    }

    public void setTriggerModuleName(String triggerModuleName) {
        this.triggerModuleName = triggerModuleName;
    }

    public Map<String, Long> getCustomData() {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (Trigger t : this.triggers) {
            if (t.getCustomData() == null) continue;
            Long l = (Long)ret.get(t.getCustomData());
            if (l == null) {
                l = 0L;
            }
            ret.put(t.getCustomData(), l + 1L);
        }
        return ret;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorrelationContextTest other = (CorrelationContextTest)obj;
        return Objects.equals(this.id, other.id);
    }

    public long getLastExpire() {
        return this.lastExpire;
    }

    public void setLastExpire(long lastExpire) {
        this.lastExpire = lastExpire;
    }

    public static class Trigger
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long timestamp;
        private String customData;

        public Trigger(long timestamp, String customData) {
            this.timestamp = timestamp;
            this.customData = customData;
        }

        public Trigger() {
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getCustomData() {
            return this.customData;
        }

        public void setCustomData(String customData) {
            this.customData = customData;
        }
    }

    public static enum Mode {
        FIXED_WINDOW,
        SLIDING_WINDOW;

    }
}

