/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventDetailsPanel;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventDetailsTableModel;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventSearchQueryUpdate;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventWrapper;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventsTopComponent;
import rs.co.ast.aspen.gui.module.alertevents.NeighborEventsOptionPanel;
import rs.co.ast.aspen.gui.module.alertevents.SecurityEventActionListener;
import rs.co.ast.aspen.gui.module.alertevents.query.QueryManager;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.SimpleCorrelatorPanel;

@TopComponent.Description(preferredID="AlertEventDetailsTopComponent", iconBase="alert_details.png", persistenceType=0)
public final class AlertEventDetailsTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(AlertEventDetailsTopComponent.class.getName());
    private final String NEIGHBOR_EVENTS = "neighborEvents";
    private final String NEW_SE_FIELD_QUERY = "newFieldSEQuery";
    private final String NEW_AL_FIELD_QUERY = "newFieldAlQuery";
    private final String INCLUDE_AND_IN_QUERY = "includeAndInQuery";
    private final String INCLUDE_OR_IN_QUERY = "includeOrInQuery";
    private final String EXCLUDE_FROM_QUERY = "excludeFromQuery";
    private Lookup.Result<AlertEventWrapper> lr = Utilities.actionsGlobalContext().lookupResult(AlertEventWrapper.class);
    private AlertEventDetailsPanel sedp = new AlertEventDetailsPanel();
    private AlertEventWrapper alertEventWrapper;
    private SecurityEventActionListener l;
    private InstanceContent instanceContent = new InstanceContent();
    private Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private Dialog dialog;
    private JTable sedpTable;
    private JButton bNeighborEvent;
    private JButton bReferences;
    private JButton bSimpleCorrelator;
    private JScrollPane spContainer;

    public AlertEventDetailsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(AlertEventDetailsTopComponent.class, (String)"CTL_AlertEventDetailsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(AlertEventDetailsTopComponent.class, (String)"HINT_AlertEventDetailsTopComponent"));
        this.sedpTable = this.sedp.getTable();
        this.associateLookup(this.lookup);
        this.spContainer.setViewportView(this.sedp);
        this.sedpTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                Collection instances = lr.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof AlertEventWrapper)) continue;
                    AlertEventDetailsTopComponent.this.alertEventWrapper = (AlertEventWrapper)o;
                    AlertEventDetailsTopComponent.this.setSecurityEvent(AlertEventDetailsTopComponent.this.alertEventWrapper);
                }
            }
        });
        this.sedp.addPropertyChangeListener(evt -> {
            AlertEventSearchQueryUpdate prevSearchQueryUpdate = null;
            if (evt.getPropertyName().equals("neighborEvents")) {
                String query = (String)evt.getNewValue();
                this.openNeighborEventsDialog(this.alertEventWrapper, query);
            } else if (evt.getPropertyName().equals("newFieldSEQuery")) {
                String query = (String)evt.getNewValue();
                SecurityEventActionListener sealNewFieldQuery = new SecurityEventActionListener(query, this.alertEventWrapper);
                sealNewFieldQuery.actionPerformed(new ActionEvent((Object)this, 1001, null));
            } else if (evt.getPropertyName().equals("newFieldAlQuery")) {
                String query = (String)evt.getNewValue();
                this.openNewAlertsWindow(query);
            } else if (evt.getPropertyName().equals("includeAndInQuery")) {
                this.addAdditionalParametersInQuery(prevSearchQueryUpdate, false, false);
            } else if (evt.getPropertyName().equals("includeOrInQuery")) {
                this.addAdditionalParametersInQuery(prevSearchQueryUpdate, false, true);
            } else if (evt.getPropertyName().equals("excludeFromQuery")) {
                this.addAdditionalParametersInQuery(prevSearchQueryUpdate, true, false);
            }
        });
    }

    private void addAdditionalParametersInQuery(AlertEventSearchQueryUpdate prevSearchQueryUpdate, boolean isNot, boolean isOr) {
        AlertEventDetailsTableModel.Item item = (AlertEventDetailsTableModel.Item)this.sedp.getTableModel().getValueAt(this.sedpTable.getSelectedRow(), 0);
        if (item != null && this.alertEventWrapper != null && item.getKey() != null && item.getValue() != null) {
            String query = QueryManager.makeSEDetailsQuery(item, this.alertEventWrapper, isNot, isOr, this.sedpTable.getSelectedColumn());
            AlertEventSearchQueryUpdate squ = new AlertEventSearchQueryUpdate(query, false, this.alertEventWrapper.getTag());
            this.instanceContent.add((Object)squ);
            prevSearchQueryUpdate = squ;
            this.instanceContent.remove((Object)squ);
            this.alertEventWrapper.setQuery(query);
        }
    }

    private void openNewAlertsWindow(String query) {
        AlertEventsTopComponent atc = new AlertEventsTopComponent();
        long start = this.alertEventWrapper.getOptions().getTimeStart();
        long finish = this.alertEventWrapper.getOptions().getTimeFinish();
        LOGGER.info(String.format("finish %d", finish));
        boolean lastNHours = this.alertEventWrapper.getOptions().isLastNHours();
        LOGGER.info(String.format("lastNHours %s", lastNHours));
        boolean now = this.alertEventWrapper.getOptions().isNow();
        LOGGER.info(String.format("now %s", now));
        int lastNHoursSelectedIndex = this.alertEventWrapper.getOptions().getLastNHoursSelectedIndex();
        LOGGER.info(String.format("lastNHoursSelectedIndex %d", lastNHoursSelectedIndex));
        boolean asc = false;
        LOGGER.info(String.format("ASC %s", asc));
        atc.getDisplayOptions().toggleFireEvents();
        atc.getDisplayOptions().setNow(now);
        atc.getDisplayOptions().setLastNHours(lastNHours);
        atc.getDisplayOptions().setLastNHoursSelectedIndex(lastNHoursSelectedIndex);
        atc.getDisplayOptions().setTimeStart(start);
        atc.getDisplayOptions().setTimeFinish(finish);
        atc.getDisplayOptions().toggleFireEvents();
        if (asc) {
            atc.setAsc();
        }
        atc.doSearch(query, start, finish);
        atc.open();
        atc.requestActive();
    }

    public synchronized void setSecurityEvent(final AlertEventWrapper event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (event != null) {
                    AlertEventDetailsTopComponent.this.sedp.getTableModel().setEvent(event.getEvent());
                    AlertEventDetailsTopComponent.this.alertEventWrapper = event;
                    AlertEventDetailsTopComponent.this.updateReferences(event);
                }
            }
        });
    }

    private void updateReferences(AlertEventWrapper event) {
        this.bReferences.setEnabled(false);
        this.bSimpleCorrelator.setEnabled(true);
        if (event != null) {
            if (event.getEvent().getExtra() != null) {
                List entries = event.getEvent().getExtra().getEntry();
                for (SecurityEvent.Extra.Entry e : entries) {
                    if (!e.getKey().equals("references")) continue;
                    String query = QueryManager.makeCorrelationIdsQuery(e.getValue());
                    if (this.l != null) {
                        this.bReferences.removeActionListener(this.l);
                    }
                    this.l = new SecurityEventActionListener(query, this.alertEventWrapper);
                    this.bReferences.addActionListener(this.l);
                    this.bReferences.setEnabled(true);
                    break;
                }
            }
            if (event.getEvent().getWhat() == null && event.getEvent().getWhen() == null) {
                this.bReferences.setEnabled(false);
                this.bSimpleCorrelator.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.spContainer = new JScrollPane();
        this.bReferences = new JButton();
        this.bSimpleCorrelator = new JButton();
        this.bNeighborEvent = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.bReferences, (String)NbBundle.getMessage(AlertEventDetailsTopComponent.class, (String)"AlertEventDetailsTopComponent.bReferences.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bSimpleCorrelator, (String)NbBundle.getMessage(AlertEventDetailsTopComponent.class, (String)"AlertEventDetailsTopComponent.bSimpleCorrelator.text"));
        this.bSimpleCorrelator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventDetailsTopComponent.this.bSimpleCorrelatorActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bNeighborEvent, (String)NbBundle.getMessage(AlertEventDetailsTopComponent.class, (String)"AlertEventDetailsTopComponent.bNeighborEvent.text"));
        this.bNeighborEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventDetailsTopComponent.this.bNeighborEventActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spContainer).addGroup(layout.createSequentialGroup().addComponent(this.bReferences).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bSimpleCorrelator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bNeighborEvent))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.spContainer, -1, 445, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bReferences).addComponent(this.bSimpleCorrelator).addComponent(this.bNeighborEvent)).addContainerGap()));
    }

    private void bSimpleCorrelatorActionPerformed(ActionEvent evt) {
        if (this.alertEventWrapper != null) {
            final SimpleCorrelatorPanel scp = new SimpleCorrelatorPanel(this.alertEventWrapper);
            final JButton save = new JButton("Save Script");
            DialogDescriptor des = new DialogDescriptor((Object)scp, NbBundle.getMessage(AlertEventDetailsTopComponent.class, (String)"SimpleCorrelatorPanel.title"), false, new Object[]{save, DialogDescriptor.CANCEL_OPTION}, (Object)save, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource().equals(save)) {
                        if (scp.isScriptValid() && !scp.getScriptText().isEmpty()) {
                            boolean success = false;
                            try {
                                AlertEventDetailsTopComponent.this.apiService.createScriptWithText(scp.getScriptName(), scp.getScriptText(), "javascript", "Script created with SimpleCorrelator", ScriptType.CORRELATION);
                                String scriptType = NbBundle.getMessage(AlertEventDetailsTopComponent.class, (String)("scrypt.type." + ScriptType.CORRELATION));
                                String savedText = NbBundle.getMessage(AlertEventDetailsTopComponent.class, (String)"AlertEventsTopComponent.simpleCorrelator.scriptSaved");
                                JOptionPane.showMessageDialog(scp, String.format(savedText, scp.getScriptName(), scriptType));
                                success = true;
                            }
                            catch (ApiServiceException_Exception ex) {
                                LOGGER.log(Level.INFO, "{0}", ex.getFaultInfo().getData());
                                JOptionPane.showMessageDialog(scp, ex.getFaultInfo().getData().get(0), "Save faild", 2);
                            }
                            if (success) {
                                AlertEventDetailsTopComponent.this.dialog.setVisible(false);
                                AlertEventDetailsTopComponent.this.dialog.dispose();
                            }
                        } else {
                            JOptionPane.showMessageDialog(scp, NbBundle.getMessage(AlertEventDetailsTopComponent.class, (String)"AlertEventsTopComponent.simpleCorrelator.scriptNotValid"));
                        }
                    }
                }
            });
            this.dialog = DialogDisplayer.getDefault().createDialog(des);
            this.dialog.setVisible(true);
        }
    }

    private void bNeighborEventActionPerformed(ActionEvent evt) {
        this.openNeighborEventsDialog(this.alertEventWrapper, null);
    }

    public void openNeighborEventsDialog(final AlertEventWrapper alertEventWrapper, String additionalQuery) throws MissingResourceException {
        if (alertEventWrapper != null) {
            StringBuilder sbQuery = new StringBuilder();
            sbQuery.append(alertEventWrapper.getQuery());
            if (additionalQuery != null) {
                sbQuery.append(" ");
                sbQuery.append("AND");
                sbQuery.append(" ");
                sbQuery.append(additionalQuery);
            }
            final NeighborEventsOptionPanel neighborPanel = new NeighborEventsOptionPanel(sbQuery.toString());
            final JButton ok = new JButton("OK");
            DialogDescriptor d = new DialogDescriptor((Object)neighborPanel, NbBundle.getMessage(AlertEventDetailsTopComponent.class, (String)"NeighborEventsOptionPanel.title"), false, new Object[]{ok, DialogDescriptor.CANCEL_OPTION}, (Object)ok, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource().equals(ok)) {
                        int seconds = neighborPanel.getSeconds();
                        AlertEventsTopComponent aetc = new AlertEventsTopComponent();
                        aetc.open();
                        aetc.requestActive();
                        Long timestamp = alertEventWrapper.getEvent().getTimestamp();
                        LOGGER.info(String.format("timeStart %d", alertEventWrapper.getEvent().getTimestamp()));
                        ZonedDateTime zdtStart = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).minusSeconds(seconds);
                        ZonedDateTime zdtFinish = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).plusSeconds(seconds);
                        long start = zdtStart.toInstant().toEpochMilli();
                        long finish = zdtFinish.toInstant().toEpochMilli();
                        LOGGER.info(String.format("timeStart %d", start));
                        LOGGER.info(String.format("timeFinish %d", finish));
                        int lastNHoursSelectedIndex = alertEventWrapper.getOptions().getLastNHoursSelectedIndex();
                        boolean asc = !alertEventWrapper.getOptions().isDescOrder();
                        LOGGER.info(String.format("ASC %s", asc));
                        aetc.getDisplayOptions().toggleFireEvents();
                        aetc.getDisplayOptions().setNow(false);
                        aetc.getDisplayOptions().setLastNHours(false);
                        aetc.getDisplayOptions().setLastNHoursSelectedIndex(lastNHoursSelectedIndex);
                        aetc.getDisplayOptions().setTimeStart(start);
                        aetc.getDisplayOptions().setTimeFinish(finish);
                        aetc.getDisplayOptions().toggleFireEvents();
                        if (asc) {
                            aetc.setAsc();
                        }
                        LOGGER.info(String.format("Query: %s", neighborPanel.getQuery()));
                        aetc.doSearch(neighborPanel.getQuery(), start, finish);
                        AlertEventDetailsTopComponent.this.dialog.setVisible(false);
                        AlertEventDetailsTopComponent.this.dialog.dispose();
                    }
                }
            });
            this.dialog = DialogDisplayer.getDefault().createDialog(d);
            this.dialog.setVisible(true);
        }
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("ted_col_count", String.valueOf(this.sedpTable.getColumnModel().getColumnCount()));
        for (int i = 0; i < this.sedpTable.getColumnModel().getColumnCount(); ++i) {
            TableColumn tc = this.sedpTable.getColumnModel().getColumn(i);
            p.setProperty(String.format("ted_col%d_width", i), String.valueOf(tc.getWidth()));
        }
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        String colCountString = p.getProperty("ted_col_count");
        LOGGER.fine(String.format("Version: %s, colCount: %s", version, colCountString));
        try {
            int colCount = colCountString != null ? Integer.valueOf(colCountString) : 0;
            for (int i = 0; i < colCount; ++i) {
                String s = p.getProperty("ted_col" + i + "_width");
                LOGGER.fine(String.format("ted_col_%d_width: %s", i, s));
                if (s == null) continue;
                this.sedpTable.getColumnModel().getColumn(i).setPreferredWidth(Integer.valueOf(s));
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.warning(String.format("Error converting to number: %s", ex.getMessage()));
        }
    }
}

