/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import rs.co.ast.aspen.api.service.ParsingRuleAssignment;
import rs.co.ast.aspen.api.service.ParsingRuleMetaRule;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.AssignmentPanel;
import rs.co.ast.aspen.gui.module.prseditor.JumpToDialog;
import rs.co.ast.aspen.gui.module.prseditor.MetaRulePanel;
import rs.co.ast.aspen.gui.module.prseditor.ParsingRulesetEditorTopComponent;
import rs.co.ast.aspen.gui.module.prseditor.RegExpDebuggerPanel;
import rs.co.ast.aspen.gui.module.prseditor.models.FocusGroupService;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RulesGroupNode;

public class RuleDetailsPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final FocusGroupService groupService = (FocusGroupService)Lookup.getDefault().lookup(FocusGroupService.class);
    private final Lookup.Result<ParsingRuleDTOWrapper> lr = Utilities.actionsGlobalContext().lookupResult(ParsingRuleDTOWrapper.class);
    private ParsingRuleDTOWrapper rule;
    private ParsingRulesGroupDTOWrapper group;
    private final ExplorerManager explorerManager = new ExplorerManager();
    private final InstanceContent instanceContentMetaRule = new InstanceContent();
    private final Lookup selectedMetaRule = new AbstractLookup((AbstractLookup.Content)this.instanceContentMetaRule);
    private final InstanceContent instanceContentAssignment = new InstanceContent();
    private final Lookup selectedAssignment = new AbstractLookup((AbstractLookup.Content)this.instanceContentAssignment);
    private int x;
    private int y;
    private JButton bAction;
    private JButton bAddAssignment;
    private JButton bAddMetaRule;
    private JButton bBuildRegexp;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JPanel pAssignments;
    private JPanel pMetaRules;
    private JPopupMenu pmAction;
    private JRadioButtonMenuItem rbContinueParsing;
    private JRadioButtonMenuItem rbJumpToGroup;
    private JRadioButtonMenuItem rbSilent;
    private JRadioButtonMenuItem rbStopParsing;
    private JTextArea taRegexp;

    public RuleDetailsPanel() {
        this.initComponents();
        this.addAncestorListener(new MyAncestorListener(this).getAncestorListener());
        this.setEditable(this.model.isEditMode());
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.rbStopParsing);
        btnGroup.add(this.rbSilent);
        btnGroup.add(this.rbContinueParsing);
        btnGroup.add(this.rbJumpToGroup);
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lookupResult = (Lookup.Result)ev.getSource();
                Collection instances = lookupResult.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof ParsingRuleDTOWrapper)) continue;
                    RuleDetailsPanel.this.rule = (ParsingRuleDTOWrapper)o;
                    System.out.println("LR INSTANCE RULE NAME: " + RuleDetailsPanel.this.rule.getDescription());
                    RuleDetailsPanel.this.updateDisplay(RuleDetailsPanel.this.rule);
                }
            }
        });
        this.taRegexp.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String text = RuleDetailsPanel.this.taRegexp.getText();
                String regex = RuleDetailsPanel.this.rule.getRegexp();
                if (regex == null) {
                    regex = "";
                }
                if (!regex.equals(text)) {
                    String tmp = RuleDetailsPanel.this.taRegexp.getText();
                    RuleDetailsPanel.this.model.setRuleRegexp(RuleDetailsPanel.this.rule, tmp);
                }
            }
        });
        this.rbStopParsing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleDetailsPanel.this.updateActionButton();
                RuleDetailsPanel.this.model.setRuleContinueParsing(RuleDetailsPanel.this.rule, false);
            }
        });
        this.rbSilent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleDetailsPanel.this.updateActionButton();
                RuleDetailsPanel.this.model.setRuleSilent(RuleDetailsPanel.this.rule, true);
            }
        });
        this.rbContinueParsing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleDetailsPanel.this.updateActionButton();
                RuleDetailsPanel.this.model.setRuleContinueParsing(RuleDetailsPanel.this.rule, true);
            }
        });
        this.rbJumpToGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JumpToDialog dialog = new JumpToDialog();
                dialog.setVisible(true);
                dialog.setFocusable(true);
                dialog.setFocusableWindowState(true);
                dialog.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                    }

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        dialog.setVisible(false);
                    }
                });
                dialog.addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                        Object selectedNode;
                        if (dialog.isOk() && (selectedNode = dialog.getSelectedNode()) instanceof RulesGroupNode) {
                            RulesGroupNode groupNode = (RulesGroupNode)selectedNode;
                            RuleDetailsPanel.this.group = groupNode.getGroup();
                            if (RuleDetailsPanel.this.rule != null && RuleDetailsPanel.this.group != null) {
                                RuleDetailsPanel.this.model.setRuleJumpTo(RuleDetailsPanel.this.rule, RuleDetailsPanel.this.group.getId());
                            }
                            RuleDetailsPanel.this.updateActionButton();
                        }
                    }
                });
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RuleDetailsPanel.this.x = e.getX();
                RuleDetailsPanel.this.y = e.getY();
            }
        });
    }

    public Lookup getSelectedMetaRuleLookup() {
        return this.selectedMetaRule;
    }

    public Lookup getSelectedAssignmentLookup() {
        return this.selectedAssignment;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("ancestor")) {
            switch (evt.getPropertyName()) {
                case "ruleChanged": {
                    this.firePropertyChange("ruleChanged", "", this.rule);
                    break;
                }
                case "editModeChanged": {
                    this.setEditable(this.model.isEditMode());
                    break;
                }
                case "ruleRuleRemoved": {
                    this.firePropertyChange("ruleChanged", "", this.rule);
                    this.updateDisplay((ParsingRuleDTOWrapper)evt.getNewValue());
                }
            }
        }
    }

    private void setEditable(boolean edit) {
        this.taRegexp.setEditable(edit);
        this.bAddMetaRule.setEnabled(edit);
        this.bAddAssignment.setEnabled(edit);
    }

    public void updateDisplay(ParsingRuleDTOWrapper rule) {
        if (rule != null) {
            this.taRegexp.setText(rule.getRegexp());
            this.taRegexp.select(0, 0);
            this.updateActionButton();
            this.pMetaRules.removeAll();
            rule.getMetaRules().forEach(m -> this.pMetaRules.add(new MetaRulePanel((ParsingRuleMetaRule)m)));
            this.pMetaRules.validate();
            this.pMetaRules.repaint();
            this.pMetaRules.getParent().validate();
            this.pMetaRules.getParent().repaint();
            this.pAssignments.removeAll();
            rule.getAssignments().forEach(a -> this.pAssignments.add(new AssignmentPanel((ParsingRuleAssignment)a)));
            this.pAssignments.validate();
            this.pAssignments.repaint();
            this.pAssignments.getParent().validate();
            this.pAssignments.getParent().repaint();
        } else {
            this.taRegexp.setText("");
            this.bAction.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RuleJumpTo.none"));
            this.pMetaRules.removeAll();
            this.pAssignments.removeAll();
        }
    }

    private void updateActionButton() {
        boolean continueParsing = this.rule.isContinueParsing() == null ? false : this.rule.isContinueParsing();
        boolean silent = this.rule.isSilent() == null ? false : this.rule.isSilent();
        System.out.println("MATHCED GROUP: " + this.rule.getMatchedGroupId());
        if (continueParsing) {
            this.bAction.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RuleDetailsPanel.action.continueParsing"));
            this.rbContinueParsing.setSelected(true);
        } else if (silent) {
            this.bAction.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RuleDetailsPanel.action.silent"));
            this.rbSilent.setSelected(true);
        } else if (this.rule.getMatchedGroupId() != null) {
            System.out.println("heheheh");
            this.group = this.model.getGroup(this.rule.getMatchedGroupId());
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RuleJumpTo.none"));
            sb.append(" <strong>");
            if (this.group != null) {
                sb.append(this.group.getName());
            } else {
                sb.append("Group not found!");
            }
            sb.append("</strong></html>");
            this.bAction.setText(sb.toString());
            this.rbJumpToGroup.setSelected(true);
        } else {
            this.bAction.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RuleJumpTo.stopParsing"));
            this.rbStopParsing.setSelected(true);
            this.rbContinueParsing.setSelected(false);
            this.rbSilent.setSelected(false);
            this.rbJumpToGroup.setSelected(false);
        }
    }

    private void initComponents() {
        this.pmAction = new JPopupMenu();
        this.rbStopParsing = new JRadioButtonMenuItem();
        this.rbSilent = new JRadioButtonMenuItem();
        this.rbContinueParsing = new JRadioButtonMenuItem();
        this.rbJumpToGroup = new JRadioButtonMenuItem();
        this.jLabel1 = new JLabel();
        this.bAction = new JButton();
        this.bBuildRegexp = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.taRegexp = new JTextArea();
        this.jTabbedPane1 = new JTabbedPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jScrollPane4 = new JScrollPane();
        this.pMetaRules = new JPanel();
        this.bAddMetaRule = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.jScrollPane5 = new JScrollPane();
        this.pAssignments = new JPanel();
        this.bAddAssignment = new JButton();
        this.rbStopParsing.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbStopParsing, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.rbStopParsing.text"));
        this.pmAction.add(this.rbStopParsing);
        this.rbSilent.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSilent, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.rbSilent.text"));
        this.pmAction.add(this.rbSilent);
        this.rbContinueParsing.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbContinueParsing, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.rbContinueParsing.text"));
        this.pmAction.add(this.rbContinueParsing);
        this.rbJumpToGroup.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbJumpToGroup, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.rbJumpToGroup.text"));
        this.pmAction.add(this.rbJumpToGroup);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jLabel1.text"));
        this.bAction.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bAction, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.bAction.text"));
        this.bAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleDetailsPanel.this.bActionActionPerformed(evt);
            }
        });
        this.bBuildRegexp.setIcon(new ImageIcon(this.getClass().getResource("/wrench.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bBuildRegexp, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.bBuildRegexp.text"));
        this.bBuildRegexp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleDetailsPanel.this.bBuildRegexpActionPerformed(evt);
            }
        });
        this.taRegexp.setColumns(20);
        this.taRegexp.setLineWrap(true);
        this.taRegexp.setRows(3);
        this.jScrollPane3.setViewportView(this.taRegexp);
        this.jTabbedPane1.setFont(new Font("Dialog", 0, 12));
        this.jSplitPane2.setResizeWeight(0.5);
        this.jLabel4.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jLabel4.text"));
        this.pMetaRules.setLayout(new BoxLayout(this.pMetaRules, 1));
        this.jScrollPane4.setViewportView(this.pMetaRules);
        this.bAddMetaRule.setFont(new Font("Dialog", 0, 12));
        this.bAddMetaRule.setIcon(new ImageIcon(this.getClass().getResource("/add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bAddMetaRule, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.bAddMetaRule.text"));
        this.bAddMetaRule.setMargin(new Insets(0, 0, 0, 0));
        this.bAddMetaRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleDetailsPanel.this.bAddMetaRuleActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane4).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addComponent(this.jLabel4, -1, 403, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bAddMetaRule)).addComponent(this.jSeparator2, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bAddMetaRule).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 230, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setLeftComponent(this.jPanel3);
        this.jLabel5.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jLabel5.text"));
        this.pAssignments.setLayout(new BoxLayout(this.pAssignments, 1));
        this.jScrollPane5.setViewportView(this.pAssignments);
        this.bAddAssignment.setFont(new Font("Dialog", 0, 12));
        this.bAddAssignment.setIcon(new ImageIcon(this.getClass().getResource("/add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bAddAssignment, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.bAddAssignment.text"));
        this.bAddAssignment.setMargin(new Insets(0, 0, 0, 0));
        this.bAddAssignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleDetailsPanel.this.bAddAssignmentActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane5).addGroup(GroupLayout.Alignment.LEADING, jPanel4Layout.createSequentialGroup().addComponent(this.jLabel5, -1, 415, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bAddAssignment)).addComponent(this.jSeparator4, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.bAddAssignment)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -1, 230, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setRightComponent(this.jPanel4);
        this.jTabbedPane1.addTab(NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jSplitPane2.TabConstraints.tabTitle"), this.jSplitPane2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3).addGap(18, 18, 18).addComponent(this.bBuildRegexp)).addComponent(this.bAction, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane3, -1, 71, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.bBuildRegexp, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bAction).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1).addContainerGap()));
    }

    private void bActionActionPerformed(ActionEvent evt) {
        if (this.model.isEditMode()) {
            this.pmAction.show(this.bAction, this.x, this.y);
        } else if (this.rule != null) {
            this.groupService.groupFocusChanged(this.rule.getMatchedGroupId());
        }
    }

    private void bBuildRegexpActionPerformed(ActionEvent evt) {
        final RegExpDebuggerPanel panel = new RegExpDebuggerPanel(this.rule);
        panel.setText("");
        panel.setRegExp(this.rule.getRegexp());
        DialogDescriptor d = new DialogDescriptor((Object)panel, NbBundle.getMessage(RuleDetailsPanel.class, (String)"regexp_debugger.title"), false, null);
        DialogDisplayer.getDefault().createDialog(d).setVisible(true);
        if (this.model.isEditMode()) {
            d.setValid(true);
        } else {
            d.setValid(false);
        }
        d.setButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int opt = (Integer)e.getSource();
                if (DialogDescriptor.OK_OPTION.equals(opt)) {
                    RuleDetailsPanel.this.taRegexp.setText(panel.getRegExp());
                }
            }
        });
    }

    private void bAddAssignmentActionPerformed(ActionEvent evt) {
        this.model.addAssignment(this.rule);
        this.updateDisplay(this.rule);
    }

    private void bAddMetaRuleActionPerformed(ActionEvent evt) {
        this.model.addMetaRule(this.rule);
        this.updateDisplay(this.rule);
    }

    public class MyAncestorListener
    implements AncestorListener {
        private final RuleDetailsPanel panel;

        public MyAncestorListener(RuleDetailsPanel panel) {
            this.panel = panel;
        }

        public AncestorListener getAncestorListener() {
            return this;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            RuleDetailsPanel.this.model.addPropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            RuleDetailsPanel.this.model.removePropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

