/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import rs.co.ast.aspen.gui.module.datamaps.DataMapKey;
import rs.co.ast.aspen.gui.module.datamaps.model.DataMapModel;
import rs.co.ast.aspen.gui.module.datamaps.model.DeletedDataMapsModel;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapNode;

public class DataMapKeyNode
extends AbstractNode
implements PropertyChangeListener,
NodeListener,
Comparable<DataMapKeyNode> {
    private static final long MS_IN_DAY = 86400000L;
    private static final long MS_IN_WEEK = 604800000L;
    private static final long MS_IN_MONTH = 2592000000L;
    private static final long MS_IN_THREEMONTHS = 7776000000L;
    private static final long MS_IN_SIXMONTHS = 15552000000L;
    private static final long MS_IN_YEAR = 31104000000L;
    private static final Logger LOGGER = Logger.getLogger(DataMapKeyNode.class.getName());
    private DataMapKey key;
    private DataMapModel model = (DataMapModel)Lookup.getDefault().lookup(DataMapModel.class);
    private DeletedDataMapsModel deletedDataMapsModel = (DeletedDataMapsModel)Lookup.getDefault().lookup(DeletedDataMapsModel.class);

    public DataMapKeyNode(DataMapKey key, boolean fullLoad, int size) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{key}));
        long lastUpdated;
        long curent;
        long diff;
        this.key = key;
        this.setDisplayName(key.getDmv().getKey());
        if (!fullLoad && key.getDmv().getKey().startsWith("~ Limit of")) {
            size += size;
            String description = String.format(NbBundle.getMessage(DataMapKeyNode.class, (String)"DataMapKeyNode.nextNode.description"), size);
            this.setShortDescription(description);
        }
        if ((diff = (curent = System.currentTimeMillis()) - (lastUpdated = key.getLastUpdated())) <= 604800000L) {
            this.setIconBaseWithExtension("textfield1.png");
        } else if (diff <= 2592000000L) {
            this.setIconBaseWithExtension("textfield2.png");
        } else if (diff <= 7776000000L) {
            this.setIconBaseWithExtension("textfield3.png");
        } else if (diff <= 15552000000L) {
            this.setIconBaseWithExtension("textfield4.png");
        } else if (diff <= 31104000000L) {
            this.setIconBaseWithExtension("textfield5.png");
        } else {
            this.setIconBaseWithExtension("textfield6.png");
        }
        this.addNodeListener(this);
        this.addPropertyChangeListener(this);
    }

    public boolean canDestroy() {
        return true;
    }

    public boolean canRename() {
        return true;
    }

    public void childrenAdded(NodeMemberEvent nme) {
    }

    public void childrenRemoved(NodeMemberEvent nme) {
    }

    public void childrenReordered(NodeReorderEvent nre) {
    }

    public void destroy() throws IOException {
        this.fireNodeDestroyed();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{(Action)Utilities.actionsForPath((String)"Actions/RightClickDataMapKey").get(0), (Action)Utilities.actionsForPath((String)"Actions/RightClickDataMapKey").get(1), (Action)Utilities.actionsForPath((String)"Actions/RightClickDataMap").get(6)};
    }

    public DataMapKey getDataMapKey() {
        return this.key;
    }

    public String getHtmlDisplayName() {
        Object name;
        String map = this.key.getDmv().getMap();
        if (this.deletedDataMapsModel.findKey(map, (String)(name = this.key.getDmv().getKey()))) {
            name = "<html><s><i>" + (String)name + "</i></s></html>";
        }
        return name;
    }

    public void nodeDestroyed(NodeEvent ne) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name") && evt.getNewValue() instanceof String) {
            String newValue = (String)evt.getNewValue();
            LOGGER.info(String.format("KEY CHANGED: %s", newValue));
            if (newValue != null) {
                this.model.renameDataMapKey(this.key.getDmv().getMap(), this.key.getDmv().getKey(), newValue);
                this.updateParentNode();
            }
        }
    }

    private void updateParentNode() {
        LOGGER.info("UPDATE PARENT NODE");
        Node parentNode = this.getParentNode();
        if (parentNode instanceof DataMapNode) {
            DataMapNode node = (DataMapNode)parentNode;
            node.updateChildren(this.key.getDmv().getMap(), "");
        }
    }

    @Override
    public int compareTo(DataMapKeyNode o) {
        return Long.compare(this.key.getLastUpdated(), o.getDataMapKey().getLastUpdated());
    }
}

