/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.nodes;

import java.util.List;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DataMapValue;
import rs.co.ast.aspen.gui.module.datamaps.DataMapKey;
import rs.co.ast.aspen.gui.module.datamaps.DatamapsDrawingHelper;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapKeyNode;

public class DataMapKeyChildFactory
extends ChildFactory<DataMapKey> {
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private final String mapName;
    private final String regex;
    private final DatamapsDrawingHelper dmdh = DatamapsDrawingHelper.getInstance();
    private int size = 0;
    private boolean fullLoad = false;

    public DataMapKeyChildFactory(String mapName, String regex) {
        this.mapName = mapName;
        this.regex = regex;
    }

    protected boolean createKeys(List toPopulate) {
        Integer numberForLoad = this.dmdh.getNumberForLoad(this.mapName);
        try {
            List dataMapKeys = this.apiService.getKeysWithLastUpdatedForDataMap(this.mapName, this.regex);
            if (numberForLoad == 1 && dataMapKeys.size() <= 1000) {
                this.fullLoad = true;
            }
            dataMapKeys.sort((o1, o2) -> {
                String o1Key = o1.getKey() == null ? "-" : o1.getKey();
                String o2Key = o2.getKey() == null ? "-" : o2.getKey();
                return String.CASE_INSENSITIVE_ORDER.compare(o1Key, o2Key);
            });
            if (this.fullLoad) {
                dataMapKeys.stream().map(s -> new DataMapKey(this.mapName, (DataMapValue)s)).forEach(k -> toPopulate.add(k));
            } else {
                this.size = 1000 * numberForLoad > dataMapKeys.size() ? dataMapKeys.size() : 1000 * numberForLoad;
                for (int i = 0; i < this.size; ++i) {
                    DataMapKey dmk = new DataMapKey(this.mapName, (DataMapValue)dataMapKeys.get(i));
                    toPopulate.add(dmk);
                }
                if (this.size == 1000 * numberForLoad) {
                    DataMapValue dmvNext = new DataMapValue();
                    String keyName = String.format(NbBundle.getMessage(DataMapKeyChildFactory.class, (String)"DataMapKeyChildFactory.nextNode.keyName"), this.size);
                    dmvNext.setKey(keyName);
                    dmvNext.setLastUpdated(System.currentTimeMillis() + 86400L);
                    dmvNext.setMap(this.mapName);
                    DataMapKey dmkNext = new DataMapKey(this.mapName, dmvNext);
                    toPopulate.add(dmkNext);
                }
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    protected Node createNodeForKey(DataMapKey key) {
        return new DataMapKeyNode(key, this.fullLoad, this.size);
    }
}

