/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.audio.AudioData;
import com.jme3.audio.AudioRenderer;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObject;
import java.nio.ByteBuffer;

public class AudioBuffer
extends AudioData {
    protected ByteBuffer audioData;

    public AudioBuffer() {
    }

    protected AudioBuffer(int id) {
        super(id);
    }

    @Override
    public AudioData.DataType getDataType() {
        return AudioData.DataType.Buffer;
    }

    @Override
    public float getDuration() {
        int bytesPerSec = this.bitsPerSample / 8 * this.channels * this.sampleRate;
        if (this.audioData != null) {
            return (float)this.audioData.limit() / (float)bytesPerSec;
        }
        return Float.NaN;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", ch=" + this.channels + ", bits=" + this.bitsPerSample + ", rate=" + this.sampleRate + ", duration=" + this.getDuration() + "]";
    }

    public void updateData(ByteBuffer data) {
        this.audioData = data;
        this.updateNeeded = true;
    }

    public ByteBuffer getData() {
        return this.audioData;
    }

    @Override
    public void resetObject() {
        this.id = -1;
        this.setUpdateNeeded();
    }

    @Override
    protected void deleteNativeBuffers() {
        if (this.audioData != null) {
            BufferUtils.destroyDirectBuffer(this.audioData);
        }
    }

    @Override
    public void deleteObject(Object rendererObject) {
        ((AudioRenderer)rendererObject).deleteAudioData(this);
    }

    @Override
    public NativeObject createDestructableClone() {
        return new AudioBuffer(this.id);
    }

    @Override
    public long getUniqueId() {
        return 0x600000000L | (long)this.id;
    }
}

