/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class ThreadingManager {
    protected final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new LoadingThreadFactory());
    protected final AssetManager owner;
    protected int nextThreadId = 0;

    public ThreadingManager(AssetManager owner) {
        this.owner = owner;
    }

    public <T> Future<T> loadAsset(AssetKey<T> assetKey) {
        return this.executor.submit(new LoadingTask<T>(assetKey));
    }

    public static boolean isLoadingThread() {
        return Thread.currentThread().getName().startsWith("jME3-threadpool");
    }

    protected class LoadingTask<T>
    implements Callable<T> {
        private final AssetKey<T> assetKey;

        public LoadingTask(AssetKey<T> assetKey) {
            this.assetKey = assetKey;
        }

        @Override
        public T call() throws Exception {
            return ThreadingManager.this.owner.loadAsset(this.assetKey);
        }
    }

    protected class LoadingThreadFactory
    implements ThreadFactory {
        protected LoadingThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "jME3-threadpool-" + ThreadingManager.this.nextThreadId++);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }
}

