/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.misc;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FbxGlobalSettings {
    private static final Logger logger = Logger.getLogger(FbxGlobalSettings.class.getName());
    private static final Map<Integer, Float> timeModeToFps = new HashMap<Integer, Float>();
    public float unitScaleFactor = 1.0f;
    public ColorRGBA ambientColor = ColorRGBA.Black;
    public float frameRate = 25.0f;

    public Transform getGlobalTransform() {
        float scale = this.unitScaleFactor / 100.0f;
        return new Transform(Vector3f.ZERO, Quaternion.IDENTITY, new Vector3f(scale, scale, scale));
    }

    public void fromElement(FbxElement element) {
        int timeMode = -1;
        float customFrameRate = 30.0f;
        for (FbxElement e2 : element.getFbxProperties()) {
            Integer frontAxisSign;
            String propName = (String)e2.properties.get(0);
            if (propName.equals("UnitScaleFactor")) {
                this.unitScaleFactor = ((Double)e2.properties.get(4)).floatValue();
                if (this.unitScaleFactor == 100.0f) continue;
                logger.log(Level.WARNING, "FBX model isn't using meters for world units. Scale could be incorrect.");
                continue;
            }
            if (propName.equals("TimeMode")) {
                timeMode = (Integer)e2.properties.get(4);
                continue;
            }
            if (propName.equals("CustomFrameRate")) {
                float framerate = ((Double)e2.properties.get(4)).floatValue();
                if (framerate == -1.0f) continue;
                customFrameRate = framerate;
                continue;
            }
            if (propName.equals("UpAxis")) {
                Integer upAxis = (Integer)e2.properties.get(4);
                if (upAxis == 1) continue;
                logger.log(Level.WARNING, "FBX model isn't using Y as up axis. Orientation could be incorrect");
                continue;
            }
            if (propName.equals("UpAxisSign")) {
                Integer upAxisSign = (Integer)e2.properties.get(4);
                if (upAxisSign == 1) continue;
                logger.log(Level.WARNING, "FBX model isn't using correct up axis sign. Orientation could be incorrect");
                continue;
            }
            if (propName.equals("FrontAxis")) {
                Integer frontAxis = (Integer)e2.properties.get(4);
                if (frontAxis == 2) continue;
                logger.log(Level.WARNING, "FBX model isn't using Z as forward axis. Orientation could be incorrect");
                continue;
            }
            if (!propName.equals("FrontAxisSign") || (frontAxisSign = (Integer)e2.properties.get(4)) == -1) continue;
            logger.log(Level.WARNING, "FBX model isn't using correct forward axis sign. Orientation could be incorrect");
        }
        Float fps = timeModeToFps.get(timeMode);
        if (fps != null) {
            this.frameRate = fps.floatValue() == -1.0f ? customFrameRate : fps.floatValue();
        }
    }

    static {
        timeModeToFps.put(1, Float.valueOf(120.0f));
        timeModeToFps.put(2, Float.valueOf(100.0f));
        timeModeToFps.put(3, Float.valueOf(60.0f));
        timeModeToFps.put(4, Float.valueOf(50.0f));
        timeModeToFps.put(5, Float.valueOf(48.0f));
        timeModeToFps.put(6, Float.valueOf(30.0f));
        timeModeToFps.put(9, Float.valueOf(29.970028f));
        timeModeToFps.put(10, Float.valueOf(25.0f));
        timeModeToFps.put(11, Float.valueOf(24.0f));
        timeModeToFps.put(13, Float.valueOf(23.976023f));
        timeModeToFps.put(14, Float.valueOf(-1.0f));
        timeModeToFps.put(15, Float.valueOf(96.0f));
        timeModeToFps.put(16, Float.valueOf(72.0f));
        timeModeToFps.put(17, Float.valueOf(59.940056f));
    }
}

