/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.HostStatsAgg;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableModelV2;

public class ComplementTableModelV2
extends DefaultTableModel {
    private final List<String> columns = Stream.of(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.host"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.domains"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.fqdns"), NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"SumOfCountsPerHostnameTableModel.columnName.tags"), NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"SumOfCountsPerHostnameTableModel.columnName.ips"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.numberOfEvents"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.firstActive"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.lastActive")).collect(Collectors.toList());
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());
    private List<HostStatsAgg> reversedDateComplementHostsList = new ArrayList<HostStatsAgg>();
    private List<HostStatsAgg> complementHostsList = new ArrayList<HostStatsAgg>();
    private List<HostStatsAgg> secondHostsList = new ArrayList<HostStatsAgg>();
    private List<HostStatsAgg> mainHostsList = new ArrayList<HostStatsAgg>();
    private boolean showComplement = true;

    @Override
    public Object getValueAt(int row, int column) {
        HostStatsAgg element = null;
        element = this.showComplement ? this.complementHostsList.get(row) : this.reversedDateComplementHostsList.get(row);
        switch (column) {
            case 0: {
                return element.getHost();
            }
            case 1: {
                return element.getDomains().stream().collect(Collectors.joining(";"));
            }
            case 2: {
                return element.getFqdns().stream().collect(Collectors.joining(";"));
            }
            case 3: {
                return element.getTags().stream().collect(Collectors.joining(";"));
            }
            case 4: {
                return element.getIps().stream().collect(Collectors.joining(";"));
            }
            case 5: {
                return element.getSum();
            }
            case 6: {
                return element.getHumanFirstActive();
            }
            case 7: {
                return element.getHumanLastActive();
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"TableModel.columnName.unknown"));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        if (this.showComplement) {
            return this.complementHostsList == null ? 0 : this.complementHostsList.size();
        }
        return this.reversedDateComplementHostsList == null ? 0 : this.reversedDateComplementHostsList.size();
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return Long.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"TableModel.columnName.unknown"));
    }

    public void showComplement(boolean showInactive) {
        this.showComplement = showInactive;
        this.fireTableDataChanged();
    }

    public void update(List<HostStatsAgg> mainDateHosts, List<HostStatsAgg> secondDateHosts, boolean order) {
        boolean isExists;
        this.mainHostsList = mainDateHosts;
        this.secondHostsList = secondDateHosts;
        this.reversedDateComplementHostsList.clear();
        this.complementHostsList.clear();
        for (HostStatsAgg hMain : this.mainHostsList) {
            isExists = false;
            for (HostStatsAgg hSecond : this.secondHostsList) {
                if (!hMain.getHost().equals(hSecond.getHost())) continue;
                isExists = true;
                break;
            }
            if (isExists) continue;
            this.complementHostsList.add(hMain);
        }
        for (HostStatsAgg hSecond : this.secondHostsList) {
            isExists = false;
            for (HostStatsAgg hMain : this.mainHostsList) {
                if (!hSecond.getHost().equals(hMain.getHost())) continue;
                isExists = true;
                break;
            }
            if (isExists) continue;
            this.reversedDateComplementHostsList.add(hSecond);
        }
        this.fireTableDataChanged();
    }
}

