/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.HostStatsAggObject;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableModel;

public class ComplementTableModel
extends DefaultTableModel {
    private final List<String> columns = Stream.of(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.host"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.domains"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.fqdns"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.numberOfEvents"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.firstActive"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.lastActive")).collect(Collectors.toList());
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());
    private List<HostStatsAggObject> reversedDateComplementHostsList = new ArrayList<HostStatsAggObject>();
    private List<HostStatsAggObject> complementHostsList = new ArrayList<HostStatsAggObject>();
    private List<HostStatsAggObject> secondHostsList = new ArrayList<HostStatsAggObject>();
    private List<HostStatsAggObject> mainHostsList = new ArrayList<HostStatsAggObject>();
    private boolean showComplement = true;

    @Override
    public Object getValueAt(int row, int column) {
        HostStatsAggObject element = null;
        element = this.showComplement ? this.complementHostsList.get(row) : this.reversedDateComplementHostsList.get(row);
        switch (column) {
            case 0: {
                return element.getHost();
            }
            case 1: {
                return element.getDomains().stream().collect(Collectors.joining(";"));
            }
            case 2: {
                return element.getFqdns().stream().collect(Collectors.joining(";"));
            }
            case 3: {
                return element.getSum();
            }
            case 4: {
                return element.getHumanFirstActive();
            }
            case 5: {
                return element.getHumanLastActive();
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"TableModel.columnName.unknown"));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        if (this.showComplement) {
            return this.complementHostsList == null ? 0 : this.complementHostsList.size();
        }
        return this.reversedDateComplementHostsList == null ? 0 : this.reversedDateComplementHostsList.size();
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"TableModel.columnName.unknown"));
    }

    public void showComplement(boolean showInactive) {
        this.showComplement = showInactive;
        this.fireTableDataChanged();
    }

    public void update(List<HostStatsAggObject> mainDateHosts, List<HostStatsAggObject> secondDateHosts, boolean order) {
        boolean isExists;
        this.mainHostsList = mainDateHosts;
        this.secondHostsList = secondDateHosts;
        this.reversedDateComplementHostsList.clear();
        this.complementHostsList.clear();
        for (HostStatsAggObject hMain : this.mainHostsList) {
            isExists = false;
            for (HostStatsAggObject hSecond : this.secondHostsList) {
                if (!hMain.getHost().equals(hSecond.getHost())) continue;
                isExists = true;
                break;
            }
            if (isExists) continue;
            this.complementHostsList.add(hMain);
        }
        for (HostStatsAggObject hSecond : this.secondHostsList) {
            isExists = false;
            for (HostStatsAggObject hMain : this.mainHostsList) {
                if (!hSecond.getHost().equals(hMain.getHost())) continue;
                isExists = true;
                break;
            }
            if (isExists) continue;
            this.reversedDateComplementHostsList.add(hSecond);
        }
        this.fireTableDataChanged();
    }
}

