/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import rs.co.ast.aspen.gui.module.datamaps.DataMapName;
import rs.co.ast.aspen.gui.module.datamaps.DataMapsTopComponent;
import rs.co.ast.aspen.gui.module.datamaps.model.DataMapModel;
import rs.co.ast.aspen.gui.module.datamaps.model.DeletedDataMapsModel;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapNode;
import rs.co.ast.aspen.gui.module.datamaps.nodes.RootNode;

public final class DeleteMultipleDataMapNameAction
implements ActionListener {
    private final List<DataMapName> dataMaps;
    private DataMapModel model = (DataMapModel)Lookup.getDefault().lookup(DataMapModel.class);
    private DeletedDataMapsModel deletedDataMapsModel = (DeletedDataMapsModel)Lookup.getDefault().lookup(DeletedDataMapsModel.class);

    public DeleteMultipleDataMapNameAction(List<DataMapName> dataMaps) {
        this.dataMaps = dataMaps;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DeleteDataMapConfirmation.message"), NbBundle.getMessage(DataMapsTopComponent.class, (String)"DeleteDataMapConfirmation.title"), 0);
        this.deletedDataMapsModel.addDeletedMaps(this.dataMaps);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
            for (DataMapName dataMap : this.dataMaps) {
                Node parentNode;
                this.model.deleteDataMap(dataMap.getName());
                DataMapNode dataMapNode = (DataMapNode)Utilities.actionsGlobalContext().lookup(DataMapNode.class);
                if (dataMapNode == null || !((parentNode = dataMapNode.getParentNode()) instanceof RootNode)) continue;
                RootNode node = (RootNode)parentNode;
                node.updateChildren("");
            }
        }
    }
}

