/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.curves;

import com.jme3.material.RenderState;
import com.jme3.math.FastMath;
import com.jme3.math.Spline;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.curves.BezierCurve;
import com.jme3.scene.plugins.blender.curves.CurvesHelper;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.Edge;
import com.jme3.scene.plugins.blender.meshes.Face;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.shape.Curve;
import com.jme3.scene.shape.Surface;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class CurvesTemporalMesh
extends TemporalMesh {
    private static final Logger LOGGER = Logger.getLogger(CurvesTemporalMesh.class.getName());
    private static final int TYPE_BEZIER = 1;
    private static final int TYPE_NURBS = 4;
    private static final int FLAG_3D = 1;
    private static final int FLAG_FRONT = 2;
    private static final int FLAG_BACK = 4;
    private static final int FLAG_FILL_CAPS = 16384;
    private static final int FLAG_SMOOTH = 1;
    protected CurvesHelper curvesHelper;
    protected boolean is2D;
    protected boolean isFront;
    protected boolean isBack;
    protected boolean fillCaps;
    protected float bevelStart;
    protected float bevelEnd;
    protected List<BezierLine> beziers = new ArrayList<BezierLine>();
    protected CurvesTemporalMesh bevelObject;
    protected CurvesTemporalMesh taperObject;
    protected Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

    protected CurvesTemporalMesh(BlenderContext blenderContext) throws BlenderFileException {
        super(null, blenderContext, false);
    }

    public CurvesTemporalMesh(Structure curveStructure, BlenderContext blenderContext) throws BlenderFileException {
        this(curveStructure, new Vector3f(1.0f, 1.0f, 1.0f), true, blenderContext);
    }

    private CurvesTemporalMesh(Structure curveStructure, Vector3f scale, boolean loadBevelAndTaper, BlenderContext blenderContext) throws BlenderFileException {
        super(curveStructure, blenderContext, false);
        this.name = curveStructure.getName();
        this.curvesHelper = (CurvesHelper)blenderContext.getHelper(CurvesHelper.class);
        this.scale = scale;
        int flag = ((Number)curveStructure.getFieldValue("flag")).intValue();
        boolean bl = this.is2D = (flag & 1) == 0;
        if (this.is2D) {
            LOGGER.warning("2D flag not yet supported for curves!");
        }
        this.isFront = (flag & 2) != 0;
        this.isBack = (flag & 4) != 0;
        this.fillCaps = (flag & 0x4000) != 0;
        this.bevelStart = ((Number)curveStructure.getFieldValue("bevfac1", 0)).floatValue();
        this.bevelEnd = ((Number)curveStructure.getFieldValue("bevfac2", 1)).floatValue();
        if (this.bevelStart > this.bevelEnd) {
            float temp = this.bevelStart;
            this.bevelStart = this.bevelEnd;
            this.bevelEnd = temp;
        }
        LOGGER.fine("Reading nurbs (and sorting them by material).");
        HashMap<Number, ArrayList<Structure>> nurbs = new HashMap<Number, ArrayList<Structure>>();
        List<Structure> nurbStructures = ((Structure)curveStructure.getFieldValue("nurb")).evaluateListBase();
        for (Structure structure : nurbStructures) {
            Number matNumber = (Number)structure.getFieldValue("mat_nr");
            ArrayList<Structure> nurbList = (ArrayList<Structure>)nurbs.get(matNumber);
            if (nurbList == null) {
                nurbList = new ArrayList<Structure>();
                nurbs.put(matNumber, nurbList);
            }
            nurbList.add(structure);
        }
        LOGGER.fine("Getting materials.");
        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
        this.materials = materialHelper.getMaterials(curveStructure, blenderContext);
        if (this.materials != null) {
            for (MaterialContext materialContext : this.materials) {
                materialContext.setFaceCullMode(RenderState.FaceCullMode.Off);
            }
        }
        LOGGER.fine("Getting or creating bevel object.");
        this.bevelObject = loadBevelAndTaper ? this.loadBevelObject(curveStructure) : null;
        LOGGER.fine("Getting taper object.");
        Pointer pointer = (Pointer)curveStructure.getFieldValue("taperobj");
        if (this.bevelObject != null && pointer.isNotNull()) {
            Structure taperObjectStructure = pointer.fetchData().get(0);
            DynamicArray scaleArray = (DynamicArray)taperObjectStructure.getFieldValue("size");
            scale = blenderContext.getBlenderKey().isFixUpAxis() ? new Vector3f(((Number)scaleArray.get(0)).floatValue(), ((Number)scaleArray.get(1)).floatValue(), ((Number)scaleArray.get(2)).floatValue()) : new Vector3f(((Number)scaleArray.get(0)).floatValue(), ((Number)scaleArray.get(2)).floatValue(), ((Number)scaleArray.get(1)).floatValue());
            Pointer pTaperStructure = (Pointer)taperObjectStructure.getFieldValue("data");
            Structure taperStructure = pTaperStructure.fetchData().get(0);
            this.taperObject = new CurvesTemporalMesh(taperStructure, blenderContext);
        }
        LOGGER.fine("Creating the result curves.");
        for (Map.Entry nurbEntry : nurbs.entrySet()) {
            for (Structure nurb : (List)nurbEntry.getValue()) {
                int type = ((Number)nurb.getFieldValue("type")).intValue();
                if ((type & 1) != 0) {
                    this.loadBezierCurve(nurb, ((Number)nurbEntry.getKey()).intValue());
                    continue;
                }
                if ((type & 4) != 0) {
                    this.loadNurbSurface(nurb, ((Number)nurbEntry.getKey()).intValue());
                    continue;
                }
                throw new BlenderFileException("Unknown curve type: " + type);
            }
        }
        if (this.bevelObject != null && this.beziers.size() > 0) {
            this.append(this.applyBevelAndTaper(this, this.bevelObject, this.taperObject, blenderContext));
        } else {
            for (BezierLine bezierLine : this.beziers) {
                int originalVerticesAmount = this.vertices.size();
                this.vertices.add(bezierLine.vertices[0]);
                Vector3f v = bezierLine.vertices[1].subtract(bezierLine.vertices[0]).normalizeLocal();
                float temp = v.x;
                v.x = -v.y;
                v.y = temp;
                v.z = 0.0f;
                this.normals.add(v);
                for (int i = 1; i < bezierLine.vertices.length; ++i) {
                    this.vertices.add(bezierLine.vertices[i]);
                    this.edges.add(new Edge(originalVerticesAmount + i - 1, originalVerticesAmount + i, 0.0f, false, this));
                    v = bezierLine.vertices[i].subtract(bezierLine.vertices[i - 1]).normalizeLocal();
                    temp = v.x;
                    v.x = -v.y;
                    v.y = temp;
                    v.z = 0.0f;
                    ((Vector3f)this.normals.get(i - 1)).addLocal(v).multLocal(0.5f).normalizeLocal();
                    this.normals.add(v);
                }
            }
        }
    }

    private Vector3f getValueAlongCurve(float alongRatio) {
        alongRatio = FastMath.clamp((float)alongRatio, (float)0.0f, (float)1.0f);
        Vector3f result = new Vector3f();
        float probeLength = this.getLength() * alongRatio;
        float length = 0.0f;
        for (BezierLine bezier : this.beziers) {
            float edgeLength = bezier.getLength();
            if (length + edgeLength >= probeLength) {
                float ratioAlongEdge = (probeLength - length) / edgeLength;
                return bezier.getValueAlongCurve(ratioAlongEdge);
            }
            length += edgeLength;
        }
        return result;
    }

    private float getLength() {
        float result = 0.0f;
        for (BezierLine bezier : this.beziers) {
            result += bezier.getLength();
        }
        return result;
    }

    private void loadBezierCurve(Structure nurbStructure, int materialIndex) throws BlenderFileException {
        Pointer pBezierTriple = (Pointer)nurbStructure.getFieldValue("bezt");
        if (pBezierTriple.isNotNull()) {
            int resolution = ((Number)nurbStructure.getFieldValue("resolu")).intValue();
            boolean cyclic = (((Number)nurbStructure.getFieldValue("flagu")).intValue() & 1) != 0;
            boolean smooth = (((Number)nurbStructure.getFieldValue("flag")).intValue() & 1) != 0;
            BezierCurve bezierCurve = new BezierCurve(0, pBezierTriple.fetchData(), 3, this.blenderContext.getBlenderKey().isFixUpAxis());
            List<Vector3f> controlPoints = bezierCurve.getControlPoints();
            if (cyclic) {
                for (int i = 0; i < 3; ++i) {
                    controlPoints.add(controlPoints.get(i));
                }
            }
            controlPoints.remove(0);
            controlPoints.remove(controlPoints.size() - 1);
            Curve curve = new Curve(new Spline(Spline.SplineType.Bezier, controlPoints, 0.0f, false), resolution);
            FloatBuffer vertsBuffer = (FloatBuffer)curve.getBuffer(VertexBuffer.Type.Position).getData();
            this.beziers.add(new BezierLine(BufferUtils.getVector3Array((FloatBuffer)vertsBuffer), materialIndex, smooth, cyclic));
        }
    }

    private void loadNurbSurface(Structure nurb, int materialIndex) throws BlenderFileException {
        List[] knots = new List[2];
        Pointer[] pKnots = new Pointer[]{(Pointer)nurb.getFieldValue("knotsu"), (Pointer)nurb.getFieldValue("knotsv")};
        for (int i = 0; i < knots.length; ++i) {
            if (!pKnots[i].isNotNull()) continue;
            FileBlockHeader fileBlockHeader = this.blenderContext.getFileBlock(pKnots[i].getOldMemoryAddress());
            BlenderInputStream blenderInputStream = this.blenderContext.getInputStream();
            blenderInputStream.setPosition(fileBlockHeader.getBlockPosition());
            int knotsAmount = fileBlockHeader.getCount() * fileBlockHeader.getSize() / 4;
            knots[i] = new ArrayList(knotsAmount);
            for (int j = 0; j < knotsAmount; ++j) {
                knots[i].add(Float.valueOf(blenderInputStream.readFloat()));
            }
        }
        int flag = ((Number)nurb.getFieldValue("flag")).intValue();
        boolean smooth = (flag & 1) != 0;
        int flagU = ((Number)nurb.getFieldValue("flagu")).intValue();
        int flagV = ((Number)nurb.getFieldValue("flagv")).intValue();
        int orderU = ((Number)nurb.getFieldValue("orderu")).intValue();
        int orderV = ((Number)nurb.getFieldValue("orderv")).intValue();
        int pntsU = ((Number)nurb.getFieldValue("pntsu")).intValue();
        int pntsV = ((Number)nurb.getFieldValue("pntsv")).intValue();
        List<Structure> bPoints = ((Pointer)nurb.getFieldValue("bp")).fetchData();
        ArrayList controlPoints = new ArrayList(pntsV);
        for (int i = 0; i < pntsV; ++i) {
            ArrayList<Object> uControlPoints = new ArrayList<Object>(pntsU);
            for (int j = 0; j < pntsU; ++j) {
                DynamicArray vec = (DynamicArray)bPoints.get(j + i * pntsU).getFieldValue("vec");
                if (this.blenderContext.getBlenderKey().isFixUpAxis()) {
                    uControlPoints.add(new Vector4f(((Float)vec.get(0)).floatValue(), ((Float)vec.get(2)).floatValue(), -((Float)vec.get(1)).floatValue(), ((Float)vec.get(3)).floatValue()));
                    continue;
                }
                uControlPoints.add(new Vector4f(((Float)vec.get(0)).floatValue(), ((Float)vec.get(1)).floatValue(), ((Float)vec.get(2)).floatValue(), ((Float)vec.get(3)).floatValue()));
            }
            if ((flagU & 1) != 0) {
                for (int k = 0; k < orderU - 1; ++k) {
                    uControlPoints.add(uControlPoints.get(k));
                }
            }
            controlPoints.add(uControlPoints);
        }
        if ((flagV & 1) != 0) {
            for (int k = 0; k < orderV - 1; ++k) {
                controlPoints.add(controlPoints.get(k));
            }
        }
        int originalVerticesAmount = this.vertices.size();
        int resolu = ((Number)nurb.getFieldValue("resolu")).intValue();
        if (knots[1] == null) {
            Curve curve = new Curve(new Spline((List)controlPoints.get(0), knots[0]), resolu);
            FloatBuffer vertsBuffer = (FloatBuffer)curve.getBuffer(VertexBuffer.Type.Position).getData();
            this.beziers.add(new BezierLine(BufferUtils.getVector3Array((FloatBuffer)vertsBuffer), materialIndex, smooth, false));
        } else {
            int resolv = ((Number)nurb.getFieldValue("resolv")).intValue();
            int uSegments = resolu * ((List)controlPoints.get(0)).size() - 1;
            int vSegments = resolv * controlPoints.size() - 1;
            Surface nurbSurface = Surface.createNurbsSurface(controlPoints, (List[])knots, (int)uSegments, (int)vSegments, (int)orderU, (int)orderV, (boolean)smooth);
            FloatBuffer vertsBuffer = (FloatBuffer)nurbSurface.getBuffer(VertexBuffer.Type.Position).getData();
            this.vertices.addAll(Arrays.asList(BufferUtils.getVector3Array((FloatBuffer)vertsBuffer)));
            FloatBuffer normalsBuffer = (FloatBuffer)nurbSurface.getBuffer(VertexBuffer.Type.Normal).getData();
            this.normals.addAll(Arrays.asList(BufferUtils.getVector3Array((FloatBuffer)normalsBuffer)));
            IndexBuffer indexBuffer = nurbSurface.getIndexBuffer();
            for (int i = 0; i < indexBuffer.size(); i += 3) {
                int index1 = indexBuffer.get(i) + originalVerticesAmount;
                int index2 = indexBuffer.get(i + 1) + originalVerticesAmount;
                int index3 = indexBuffer.get(i + 2) + originalVerticesAmount;
                this.faces.add(new Face(new Integer[]{index1, index2, index3}, smooth, materialIndex, null, null, this));
            }
        }
    }

    private CurvesTemporalMesh loadBevelObject(Structure curveStructure) throws BlenderFileException {
        CurvesTemporalMesh bevelObject = null;
        Pointer pBevelObject = (Pointer)curveStructure.getFieldValue("bevobj");
        boolean cyclic = false;
        if (pBevelObject.isNotNull()) {
            Structure bevelObjectStructure = pBevelObject.fetchData().get(0);
            DynamicArray scaleArray = (DynamicArray)bevelObjectStructure.getFieldValue("size");
            Vector3f scale = this.blenderContext.getBlenderKey().isFixUpAxis() ? new Vector3f(((Number)scaleArray.get(0)).floatValue(), ((Number)scaleArray.get(1)).floatValue(), ((Number)scaleArray.get(2)).floatValue()) : new Vector3f(((Number)scaleArray.get(0)).floatValue(), ((Number)scaleArray.get(2)).floatValue(), ((Number)scaleArray.get(1)).floatValue());
            Pointer pBevelStructure = (Pointer)bevelObjectStructure.getFieldValue("data");
            Structure bevelStructure = pBevelStructure.fetchData().get(0);
            bevelObject = new CurvesTemporalMesh(bevelStructure, scale, false, this.blenderContext);
            for (BezierLine bl : bevelObject.beziers) {
                for (Vector3f v : bl.vertices) {
                    v.y = -v.z;
                    v.z = v.x;
                    v.x = 0.0f;
                }
                if (!bl.isCyclic()) continue;
                bl.removeLastVertex();
            }
        } else {
            this.fillCaps = false;
            int bevResol = ((Number)curveStructure.getFieldValue("bevresol")).intValue();
            float extrude = ((Number)curveStructure.getFieldValue("ext1")).floatValue();
            float bevelDepth = ((Number)curveStructure.getFieldValue("ext2")).floatValue();
            float offset = ((Number)curveStructure.getFieldValue("offset", 0)).floatValue();
            if (offset != 0.0f) {
                LOGGER.warning("Offset parameter not yet supported.");
            }
            Curve bevelCurve = null;
            if (bevelDepth > 0.0f) {
                float handlerLength = bevelDepth / 2.0f;
                cyclic = !this.isFront && !this.isBack;
                ArrayList<Vector3f> conrtolPoints = new ArrayList<Vector3f>();
                if (cyclic || this.blenderContext.getBlenderVersion() < 253) {
                    conrtolPoints.add(new Vector3f(0.0f, -extrude - bevelDepth, 0.0f));
                    conrtolPoints.add(new Vector3f(0.0f, -extrude - bevelDepth, -handlerLength));
                    conrtolPoints.add(new Vector3f(0.0f, -extrude - handlerLength, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, -extrude, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, -extrude + handlerLength, -bevelDepth));
                    if (extrude > 0.0f) {
                        conrtolPoints.add(new Vector3f(0.0f, extrude - handlerLength, -bevelDepth));
                        conrtolPoints.add(new Vector3f(0.0f, extrude, -bevelDepth));
                        conrtolPoints.add(new Vector3f(0.0f, extrude + handlerLength, -bevelDepth));
                    }
                    conrtolPoints.add(new Vector3f(0.0f, extrude + bevelDepth, -handlerLength));
                    conrtolPoints.add(new Vector3f(0.0f, extrude + bevelDepth, 0.0f));
                    if (cyclic) {
                        conrtolPoints.add(new Vector3f(0.0f, extrude + bevelDepth, handlerLength));
                        conrtolPoints.add(new Vector3f(0.0f, extrude + handlerLength, bevelDepth));
                        conrtolPoints.add(new Vector3f(0.0f, extrude, bevelDepth));
                        conrtolPoints.add(new Vector3f(0.0f, extrude - handlerLength, bevelDepth));
                        if (extrude > 0.0f) {
                            conrtolPoints.add(new Vector3f(0.0f, -extrude + handlerLength, bevelDepth));
                            conrtolPoints.add(new Vector3f(0.0f, -extrude, bevelDepth));
                            conrtolPoints.add(new Vector3f(0.0f, -extrude - handlerLength, bevelDepth));
                        }
                        conrtolPoints.add(new Vector3f(0.0f, -extrude - bevelDepth, handlerLength));
                        conrtolPoints.add(new Vector3f(0.0f, -extrude - bevelDepth, 0.0f));
                    }
                } else if (extrude > 0.0f) {
                    if (this.isBack) {
                        conrtolPoints.add(new Vector3f(0.0f, -extrude - bevelDepth, 0.0f));
                        conrtolPoints.add(new Vector3f(0.0f, -extrude - bevelDepth, -handlerLength));
                        conrtolPoints.add(new Vector3f(0.0f, -extrude - handlerLength, -bevelDepth));
                    }
                    conrtolPoints.add(new Vector3f(0.0f, -extrude, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, -extrude + handlerLength, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, extrude - handlerLength, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, extrude, -bevelDepth));
                    if (this.isFront) {
                        conrtolPoints.add(new Vector3f(0.0f, extrude + handlerLength, -bevelDepth));
                        conrtolPoints.add(new Vector3f(0.0f, extrude + bevelDepth, -handlerLength));
                        conrtolPoints.add(new Vector3f(0.0f, extrude + bevelDepth, 0.0f));
                    }
                } else if (this.isFront && this.isBack) {
                    conrtolPoints.add(new Vector3f(0.0f, -bevelDepth, 0.0f));
                    conrtolPoints.add(new Vector3f(0.0f, -bevelDepth, -handlerLength));
                    conrtolPoints.add(new Vector3f(0.0f, -handlerLength, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, 0.0f, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, handlerLength, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, bevelDepth, -handlerLength));
                    conrtolPoints.add(new Vector3f(0.0f, bevelDepth, 0.0f));
                } else if (this.isBack) {
                    conrtolPoints.add(new Vector3f(0.0f, -bevelDepth, 0.0f));
                    conrtolPoints.add(new Vector3f(0.0f, -bevelDepth, -handlerLength));
                    conrtolPoints.add(new Vector3f(0.0f, -handlerLength, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, 0.0f, -bevelDepth));
                } else {
                    conrtolPoints.add(new Vector3f(0.0f, 0.0f, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, handlerLength, -bevelDepth));
                    conrtolPoints.add(new Vector3f(0.0f, bevelDepth, -handlerLength));
                    conrtolPoints.add(new Vector3f(0.0f, bevelDepth, 0.0f));
                }
                bevelCurve = new Curve(new Spline(Spline.SplineType.Bezier, conrtolPoints, 0.0f, false), bevResol);
            } else if (extrude > 0.0f) {
                Spline bevelSpline = new Spline(Spline.SplineType.Linear, new Vector3f[]{new Vector3f(0.0f, extrude, 0.0f), new Vector3f(0.0f, -extrude, 0.0f)}, 1.0f, false);
                bevelCurve = new Curve(bevelSpline, bevResol);
            }
            if (bevelCurve != null) {
                bevelObject = new CurvesTemporalMesh(this.blenderContext);
                FloatBuffer vertsBuffer = (FloatBuffer)bevelCurve.getBuffer(VertexBuffer.Type.Position).getData();
                Vector3f[] verts = BufferUtils.getVector3Array((FloatBuffer)vertsBuffer);
                if (cyclic) {
                    verts = Arrays.copyOf(verts, verts.length - 1);
                }
                bevelObject.beziers.add(new BezierLine(verts, 0, false, cyclic));
            }
        }
        return bevelObject;
    }

    private List<BezierLine> getScaledBeziers() {
        if (this.scale.equals((Object)Vector3f.UNIT_XYZ)) {
            return this.beziers;
        }
        ArrayList<BezierLine> result = new ArrayList<BezierLine>();
        for (BezierLine bezierLine : this.beziers) {
            result.add(bezierLine.scale(this.scale));
        }
        return result;
    }

    private CurvesTemporalMesh applyBevelAndTaper(CurvesTemporalMesh curve, CurvesTemporalMesh bevelObject, CurvesTemporalMesh taperObject, BlenderContext blenderContext) throws BlenderFileException {
        List<BezierLine> bevelBezierLines = bevelObject.getScaledBeziers();
        List<BezierLine> curveLines = curve.beziers;
        if (bevelBezierLines.size() == 0 || curveLines.size() == 0) {
            return null;
        }
        CurvesTemporalMesh result = new CurvesTemporalMesh(blenderContext);
        for (BezierLine curveLine : curveLines) {
            Vector3f[] curveLineVertices = curveLine.getVertices(this.bevelStart, this.bevelEnd);
            for (BezierLine bevelBezierLine : bevelBezierLines) {
                CurvesTemporalMesh partResult = new CurvesTemporalMesh(blenderContext);
                Vector3f[] bevelLineVertices = bevelBezierLine.getVertices();
                ArrayList<Vector3f[]> bevels = new ArrayList<Vector3f[]>();
                Vector3f[] bevelPoints = this.curvesHelper.transformToFirstLineOfBevelPoints(bevelLineVertices, curveLineVertices[0], curveLineVertices[1]);
                bevels.add(bevelPoints);
                for (int i = 1; i < curveLineVertices.length - 1; ++i) {
                    bevelPoints = this.curvesHelper.transformBevel(bevelPoints, curveLineVertices[i - 1], curveLineVertices[i], curveLineVertices[i + 1]);
                    bevels.add(bevelPoints);
                }
                bevelPoints = this.curvesHelper.transformBevel(bevelPoints, curveLineVertices[curveLineVertices.length - 2], curveLineVertices[curveLineVertices.length - 1], null);
                bevels.add(bevelPoints);
                Vector3f subtractResult = new Vector3f();
                if (bevels.size() > 2) {
                    int[][] pointIndexes;
                    for (int[] indexes : pointIndexes = new int[][]{{0, 1}, {curveLineVertices.length - 1, curveLineVertices.length - 2}}) {
                        float distance = curveLineVertices[indexes[1]].subtract(curveLineVertices[indexes[0]], subtractResult).length();
                        Vector3f[] bevel = (Vector3f[])bevels.get(indexes[0]);
                        Vector3f[] nextBevel = (Vector3f[])bevels.get(indexes[1]);
                        for (int i = 0; i < bevel.length; ++i) {
                            float d = bevel[i].subtract(nextBevel[i], subtractResult).length();
                            subtractResult.normalizeLocal().multLocal(distance - d);
                            bevel[i].addLocal(subtractResult);
                        }
                    }
                }
                if (taperObject != null) {
                    float curveLength = curveLine.getLength();
                    float lengthAlongCurve = this.bevelStart;
                    for (int i = 0; i < curveLineVertices.length; ++i) {
                        float taperScale;
                        if (i > 0) {
                            lengthAlongCurve += curveLineVertices[i].subtract(curveLineVertices[i - 1], subtractResult).length();
                        }
                        if ((taperScale = -taperObject.getValueAlongCurve((float)(lengthAlongCurve / curveLength)).z * taperObject.scale.z) == 1.0f) continue;
                        this.applyScale((Vector3f[])bevels.get(i), curveLineVertices[i], taperScale);
                    }
                }
                Iterator curveLength = bevels.iterator();
                while (curveLength.hasNext()) {
                    Vector3f[] bevel;
                    for (Vector3f d : bevel = (Vector3f[])curveLength.next()) {
                        partResult.getVertices().add(d);
                    }
                }
                int bevelVertCount = bevelPoints.length;
                for (int i = 0; i < bevels.size() - 1; ++i) {
                    int j;
                    for (j = 0; j < bevelVertCount - 1; ++j) {
                        Integer[] indexes = new Integer[]{i * bevelVertCount + j + 1, (i + 1) * bevelVertCount + j + 1, (i + 1) * bevelVertCount + j, i * bevelVertCount + j};
                        partResult.getFaces().add(new Face(indexes, curveLine.isSmooth(), curveLine.getMaterialNumber(), null, null, partResult));
                        partResult.getEdges().add(new Edge(indexes[0], indexes[1], 0.0f, true, partResult));
                        partResult.getEdges().add(new Edge(indexes[1], indexes[2], 0.0f, true, partResult));
                        partResult.getEdges().add(new Edge(indexes[2], indexes[3], 0.0f, true, partResult));
                        partResult.getEdges().add(new Edge(indexes[3], indexes[0], 0.0f, true, partResult));
                    }
                    if (!bevelBezierLine.isCyclic()) continue;
                    j = bevelVertCount - 1;
                    Integer[] indexes = new Integer[]{i * bevelVertCount, (i + 1) * bevelVertCount, (i + 1) * bevelVertCount + j, i * bevelVertCount + j};
                    partResult.getFaces().add(new Face(indexes, curveLine.isSmooth(), curveLine.getMaterialNumber(), null, null, partResult));
                    partResult.getEdges().add(new Edge(indexes[0], indexes[1], 0.0f, true, partResult));
                    partResult.getEdges().add(new Edge(indexes[1], indexes[2], 0.0f, true, partResult));
                    partResult.getEdges().add(new Edge(indexes[2], indexes[3], 0.0f, true, partResult));
                    partResult.getEdges().add(new Edge(indexes[3], indexes[0], 0.0f, true, partResult));
                }
                partResult.generateNormals();
                if (this.fillCaps) {
                    int i;
                    Vector3f[] cap = (Vector3f[])bevels.get(0);
                    ArrayList<Integer> capIndexes = new ArrayList<Integer>(cap.length);
                    Vector3f capNormal = curveLineVertices[0].subtract(curveLineVertices[1]).normalizeLocal();
                    for (i = 0; i < cap.length; ++i) {
                        capIndexes.add(partResult.getVertices().size());
                        partResult.getVertices().add(cap[i]);
                        partResult.getNormals().add(capNormal);
                    }
                    Collections.reverse(capIndexes);
                    partResult.getFaces().add(new Face(capIndexes.toArray(new Integer[capIndexes.size()]), false, curveLine.getMaterialNumber(), null, null, partResult));
                    for (i = 1; i < capIndexes.size(); ++i) {
                        partResult.getEdges().add(new Edge((Integer)capIndexes.get(i - 1), (Integer)capIndexes.get(i), 0.0f, true, partResult));
                    }
                    cap = (Vector3f[])bevels.get(bevels.size() - 1);
                    capIndexes.clear();
                    capNormal = curveLineVertices[curveLineVertices.length - 1].subtract(curveLineVertices[curveLineVertices.length - 2]).normalizeLocal();
                    for (i = 0; i < cap.length; ++i) {
                        capIndexes.add(partResult.getVertices().size());
                        partResult.getVertices().add(cap[i]);
                        partResult.getNormals().add(capNormal);
                    }
                    partResult.getFaces().add(new Face(capIndexes.toArray(new Integer[capIndexes.size()]), false, curveLine.getMaterialNumber(), null, null, partResult));
                    for (i = 1; i < capIndexes.size(); ++i) {
                        partResult.getEdges().add(new Edge((Integer)capIndexes.get(i - 1), (Integer)capIndexes.get(i), 0.0f, true, partResult));
                    }
                }
                result.append(partResult);
            }
        }
        return result;
    }

    private void generateNormals() {
        TreeMap<Integer, Vector3f> normalMap = new TreeMap<Integer, Vector3f>();
        for (Face face : this.faces) {
            int index1 = face.getIndexes().get(0);
            int index2 = face.getIndexes().get(1);
            int index3 = face.getIndexes().get(2);
            Vector3f n = FastMath.computeNormal((Vector3f)((Vector3f)this.vertices.get(index1)), (Vector3f)((Vector3f)this.vertices.get(index2)), (Vector3f)((Vector3f)this.vertices.get(index3)));
            for (int index : face.getIndexes()) {
                Vector3f normal = (Vector3f)normalMap.get(index);
                if (normal == null) {
                    normalMap.put(index, n.clone());
                    continue;
                }
                normal.addLocal(n).normalizeLocal();
            }
        }
        this.normals.clear();
        Collections.addAll(this.normals, new Vector3f[normalMap.size()]);
        for (Map.Entry entry : normalMap.entrySet()) {
            this.normals.set((Integer)entry.getKey(), entry.getValue());
        }
    }

    private void applyScale(Vector3f[] points, Vector3f centerPoint, float scale) {
        Vector3f taperScaleVector = new Vector3f();
        for (Vector3f p : points) {
            taperScaleVector.set(centerPoint).subtractLocal(p).multLocal(1.0f - scale);
            p.addLocal(taperScaleVector);
        }
    }

    public static class BezierLine {
        private Vector3f[] vertices;
        private int materialNumber;
        private boolean smooth;
        private float length;
        private boolean cyclic;

        public BezierLine(Vector3f[] vertices, int materialNumber, boolean smooth, boolean cyclik) {
            this.vertices = vertices;
            this.materialNumber = materialNumber;
            this.smooth = smooth;
            this.cyclic = cyclik;
            this.recomputeLength();
        }

        public BezierLine scale(Vector3f scale) {
            BezierLine result = new BezierLine(this.vertices, this.materialNumber, this.smooth, this.cyclic);
            result.vertices = new Vector3f[this.vertices.length];
            for (int i = 0; i < this.vertices.length; ++i) {
                result.vertices[i] = this.vertices[i].mult(scale);
            }
            result.recomputeLength();
            return result;
        }

        public void removeLastVertex() {
            Vector3f[] newVertices = new Vector3f[this.vertices.length - 1];
            for (int i = 0; i < this.vertices.length - 1; ++i) {
                newVertices[i] = this.vertices[i];
            }
            this.vertices = newVertices;
            this.recomputeLength();
        }

        private void recomputeLength() {
            this.length = 0.0f;
            for (int i = 1; i < this.vertices.length; ++i) {
                this.length += this.vertices[i - 1].distance(this.vertices[i]);
            }
            if (this.cyclic) {
                this.length += this.vertices[this.vertices.length - 1].distance(this.vertices[0]);
            }
        }

        public Vector3f[] getVertices() {
            return this.getVertices(0.0f, 1.0f);
        }

        public Vector3f[] getVertices(float startSlice, float endSlice) {
            Vector3f v2;
            Vector3f v1;
            if (startSlice == 0.0f && endSlice == 1.0f) {
                return this.vertices;
            }
            ArrayList<Vector3f> result = new ArrayList<Vector3f>();
            float length = this.getLength();
            float temp = 0.0f;
            float startSliceLength = length * startSlice;
            float endSliceLength = length * endSlice;
            int index = 1;
            if (startSlice > 0.0f) {
                while (temp < startSliceLength) {
                    float edgeLength;
                    v1 = this.vertices[index - 1];
                    if ((temp += (edgeLength = v1.distance(v2 = this.vertices[index++]))) == startSliceLength) {
                        result.add(v2);
                        continue;
                    }
                    if (!(temp > startSliceLength)) continue;
                    result.add(v1.subtract(v2).normalizeLocal().multLocal(temp - startSliceLength).addLocal(v2));
                }
            }
            if (endSlice < 1.0f) {
                if (index == this.vertices.length) {
                    v1 = this.vertices[this.vertices.length - 2];
                    v2 = this.vertices[this.vertices.length - 1];
                    result.add(v1.subtract(v2).normalizeLocal().multLocal(length - endSliceLength).addLocal(v2));
                } else {
                    for (int i = index; i < this.vertices.length && temp < endSliceLength; ++i) {
                        Vector3f v22;
                        Vector3f v12 = this.vertices[index - 1];
                        if ((temp += v12.distance(v22 = this.vertices[index++])) == endSliceLength) {
                            result.add(v22);
                            continue;
                        }
                        if (!(temp > endSliceLength)) continue;
                        result.add(v12.subtract(v22).normalizeLocal().multLocal(temp - startSliceLength).addLocal(v22));
                    }
                }
            } else {
                result.addAll(Arrays.asList(Arrays.copyOfRange(this.vertices, index, this.vertices.length)));
            }
            return result.toArray(new Vector3f[result.size()]);
        }

        public Vector3f getValueAlongCurve(float alongRatio) {
            alongRatio = FastMath.clamp((float)alongRatio, (float)0.0f, (float)1.0f);
            Vector3f result = new Vector3f();
            float probeLength = this.getLength() * alongRatio;
            float length = 0.0f;
            for (int i = 1; i < this.vertices.length; ++i) {
                float edgeLength = this.vertices[i].distance(this.vertices[i - 1]);
                if (length + edgeLength > probeLength) {
                    float ratioAlongEdge = (probeLength - length) / edgeLength;
                    return FastMath.interpolateLinear((float)ratioAlongEdge, (Vector3f)this.vertices[i - 1], (Vector3f)this.vertices[i]);
                }
                if (length + edgeLength == probeLength) {
                    return this.vertices[i];
                }
                length += edgeLength;
            }
            return result;
        }

        public int getMaterialNumber() {
            return this.materialNumber;
        }

        public boolean isSmooth() {
            return this.smooth;
        }

        public float getLength() {
            return this.length;
        }

        public boolean isCyclic() {
            return this.cyclic;
        }
    }
}

