/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.AnimationHelper;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.BoneConstraint;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.SimulationNode;
import com.jme3.scene.plugins.blender.constraints.SkeletonConstraint;
import com.jme3.scene.plugins.blender.constraints.SpatialConstraint;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.util.TempVars;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ConstraintHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ConstraintHelper.class.getName());

    public ConstraintHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public void loadConstraints(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        List<Structure> constraints;
        ArrayList<Constraint> constraintsList;
        Pointer pPose;
        LOGGER.fine("Loading constraints.");
        AnimationHelper animationHelper = (AnimationHelper)blenderContext.getHelper(AnimationHelper.class);
        HashMap constraintsIpos = new HashMap();
        Pointer pActions = (Pointer)objectStructure.getFieldValue("action");
        if (pActions.isNotNull()) {
            List<Structure> actions = pActions.fetchData();
            for (Structure structure : actions) {
                Structure chanbase = (Structure)structure.getFieldValue("chanbase");
                List<Structure> actionChannels = chanbase.evaluateListBase();
                for (Structure actionChannel : actionChannels) {
                    HashMap<String, Ipo> ipos = new HashMap<String, Ipo>();
                    Structure constChannels = (Structure)actionChannel.getFieldValue("constraintChannels");
                    List<Structure> constraintChannels = constChannels.evaluateListBase();
                    for (Structure constraintChannel : constraintChannels) {
                        Pointer pIpo = (Pointer)constraintChannel.getFieldValue("ipo");
                        if (!pIpo.isNotNull()) continue;
                        String constraintName = constraintChannel.getFieldValue("name").toString();
                        Ipo ipo = animationHelper.fromIpoStructure(pIpo.fetchData().get(0), blenderContext);
                        ipos.put(constraintName, ipo);
                    }
                    String actionName = actionChannel.getFieldValue("name").toString();
                    constraintsIpos.put(actionName, ipos);
                }
            }
        }
        if ((pPose = (Pointer)objectStructure.getFieldValue("pose")).isNotNull()) {
            List<Structure> poseChannels = ((Structure)pPose.fetchData().get(0).getFieldValue("chanbase")).evaluateListBase();
            for (Structure poseChannel : poseChannels) {
                constraintsList = new ArrayList<Constraint>();
                Long boneOMA = ((Pointer)poseChannel.getFieldValue("bone")).getOldMemoryAddress();
                String name = blenderContext.getFileBlock(boneOMA).getStructure(blenderContext).getFieldValue("name").toString();
                List<Structure> constraints2 = ((Structure)poseChannel.getFieldValue("constraints")).evaluateListBase();
                for (Structure constraint : constraints2) {
                    Ipo ipo;
                    String constraintName = constraint.getFieldValue("name").toString();
                    Map ipoMap = (Map)constraintsIpos.get(name);
                    Ipo ipo2 = ipo = ipoMap == null ? null : (Ipo)ipoMap.get(constraintName);
                    if (ipo == null) {
                        float enforce = ((Number)constraint.getFieldValue("enforce")).floatValue();
                        ipo = animationHelper.fromValue(enforce);
                    }
                    constraintsList.add(new BoneConstraint(constraint, boneOMA, ipo, blenderContext));
                }
                blenderContext.addConstraints(boneOMA, constraintsList);
            }
        }
        if ((constraints = ((Structure)objectStructure.getFieldValue("constraints")).evaluateListBase()) != null && constraints.size() > 0) {
            Pointer pointer = (Pointer)objectStructure.getFieldValue("data");
            String dataType = pointer.isNotNull() ? pointer.fetchData().get(0).getType() : null;
            constraintsList = new ArrayList(constraints.size());
            for (Structure constraint : constraints) {
                Ipo ipo;
                String constraintName = constraint.getFieldValue("name").toString();
                String objectName = objectStructure.getName();
                Map objectConstraintsIpos = (Map)constraintsIpos.get(objectName);
                Ipo ipo3 = ipo = objectConstraintsIpos != null ? (Ipo)objectConstraintsIpos.get(constraintName) : null;
                if (ipo == null) {
                    float enforce = ((Number)constraint.getFieldValue("enforce")).floatValue();
                    ipo = animationHelper.fromValue(enforce);
                }
                constraintsList.add(this.createConstraint(dataType, constraint, objectStructure.getOldMemoryAddress(), ipo, blenderContext));
            }
            blenderContext.addConstraints(objectStructure.getOldMemoryAddress(), constraintsList);
        }
    }

    private Constraint createConstraint(String dataType, Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        if (dataType == null || "Mesh".equalsIgnoreCase(dataType) || "Camera".equalsIgnoreCase(dataType) || "Lamp".equalsIgnoreCase(dataType)) {
            return new SpatialConstraint(constraintStructure, ownerOMA, influenceIpo, blenderContext);
        }
        if ("Armature".equalsIgnoreCase(dataType)) {
            return new SkeletonConstraint(constraintStructure, ownerOMA, influenceIpo, blenderContext);
        }
        throw new IllegalArgumentException("Unsupported data type for applying constraints: " + dataType);
    }

    public void bakeConstraints(BlenderContext blenderContext) {
        HashSet<Long> owners = new HashSet<Long>();
        for (Constraint constraint : blenderContext.getAllConstraints()) {
            if (constraint instanceof BoneConstraint) {
                BoneContext boneContext = blenderContext.getBoneContext(constraint.ownerOMA);
                owners.add(boneContext.getArmatureObjectOMA());
                continue;
            }
            Spatial spatial = (Spatial)blenderContext.getLoadedFeature(constraint.ownerOMA, BlenderContext.LoadedDataType.FEATURE);
            while (spatial.getParent() != null) {
                spatial = spatial.getParent();
            }
            owners.add((Long)blenderContext.getMarkerValue("oma", spatial));
        }
        ArrayList<SimulationNode> simulationRootNodes = new ArrayList<SimulationNode>(owners.size());
        for (Long ownerOMA : owners) {
            simulationRootNodes.add(new SimulationNode(ownerOMA, blenderContext));
        }
        for (SimulationNode node : simulationRootNodes) {
            node.simulate();
        }
    }

    public Transform getTransform(Long oma, String subtargetName, Space space) {
        boolean isArmature;
        Spatial feature = (Spatial)this.blenderContext.getLoadedFeature(oma, BlenderContext.LoadedDataType.FEATURE);
        boolean bl = isArmature = this.blenderContext.getMarkerValue("armature-node", feature) != null;
        if (isArmature) {
            Transform result;
            this.blenderContext.getSkeleton(oma).updateWorldVectors();
            BoneContext targetBoneContext = this.blenderContext.getBoneByName(oma, subtargetName);
            Bone bone = targetBoneContext.getBone();
            if (bone.getParent() == null && (space == Space.CONSTRAINT_SPACE_LOCAL || space == Space.CONSTRAINT_SPACE_PARLOCAL)) {
                space = Space.CONSTRAINT_SPACE_POSE;
            }
            TempVars tempVars = TempVars.get();
            switch (space) {
                case CONSTRAINT_SPACE_WORLD: {
                    Spatial model = (Spatial)this.blenderContext.getLoadedFeature(targetBoneContext.getSkeletonOwnerOma(), BlenderContext.LoadedDataType.FEATURE);
                    Matrix4f boneModelMatrix = this.toMatrix(bone.getModelSpacePosition(), bone.getModelSpaceRotation(), bone.getModelSpaceScale(), tempVars.tempMat4);
                    Matrix4f modelWorldMatrix = this.toMatrix(model.getWorldTransform(), tempVars.tempMat42);
                    Matrix4f boneMatrixInWorldSpace = modelWorldMatrix.multLocal(boneModelMatrix);
                    result = new Transform(boneMatrixInWorldSpace.toTranslationVector(), boneMatrixInWorldSpace.toRotationQuat(), boneMatrixInWorldSpace.toScaleVector());
                    break;
                }
                case CONSTRAINT_SPACE_LOCAL: {
                    assert (bone.getParent() != null) : "CONSTRAINT_SPACE_LOCAL should be evaluated as CONSTRAINT_SPACE_POSE if the bone has no parent!";
                    result = new Transform(bone.getLocalPosition(), bone.getLocalRotation(), bone.getLocalScale());
                    break;
                }
                case CONSTRAINT_SPACE_POSE: {
                    Matrix4f boneWorldMatrix = this.toMatrix(this.getTransform(oma, subtargetName, Space.CONSTRAINT_SPACE_WORLD), tempVars.tempMat4);
                    Matrix4f armatureInvertedWorldMatrix = this.toMatrix(feature.getWorldTransform(), tempVars.tempMat42).invertLocal();
                    Matrix4f bonePoseMatrix = armatureInvertedWorldMatrix.multLocal(boneWorldMatrix);
                    result = new Transform(bonePoseMatrix.toTranslationVector(), bonePoseMatrix.toRotationQuat(), bonePoseMatrix.toScaleVector());
                    break;
                }
                case CONSTRAINT_SPACE_PARLOCAL: {
                    Matrix4f boneWorldMatrix = this.toMatrix(this.getTransform(oma, subtargetName, Space.CONSTRAINT_SPACE_WORLD), tempVars.tempMat4);
                    Matrix4f armatureInvertedWorldMatrix = this.toMatrix(feature.getWorldTransform(), tempVars.tempMat42).invertLocal();
                    Matrix4f bonePoseMatrix = armatureInvertedWorldMatrix.multLocal(boneWorldMatrix);
                    result = new Transform(bonePoseMatrix.toTranslationVector(), bonePoseMatrix.toRotationQuat(), bonePoseMatrix.toScaleVector());
                    Bone parent = bone.getParent();
                    if (parent == null) break;
                    BoneContext parentContext = this.blenderContext.getBoneContext(parent);
                    Vector3f head = parent.getModelSpacePosition();
                    Vector3f tail = head.add(bone.getModelSpaceRotation().mult(Vector3f.UNIT_Y.mult(parentContext.getLength())));
                    result.getTranslation().subtractLocal(tail);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown space type: " + (Object)((Object)space));
                }
            }
            tempVars.release();
            return result;
        }
        switch (space) {
            case CONSTRAINT_SPACE_LOCAL: {
                return feature.getLocalTransform();
            }
            case CONSTRAINT_SPACE_WORLD: {
                return feature.getWorldTransform();
            }
            case CONSTRAINT_SPACE_POSE: 
            case CONSTRAINT_SPACE_PARLOCAL: {
                throw new IllegalStateException("Nodes can have only Local and World spaces applied!");
            }
        }
        throw new IllegalStateException("Unknown space type: " + (Object)((Object)space));
    }

    public void applyTransform(Long oma, String subtargetName, Space space, Transform transform) {
        boolean isArmature;
        Spatial feature = (Spatial)this.blenderContext.getLoadedFeature(oma, BlenderContext.LoadedDataType.FEATURE);
        boolean bl = isArmature = this.blenderContext.getMarkerValue("armature-node", feature) != null;
        if (isArmature) {
            Skeleton skeleton = this.blenderContext.getSkeleton(oma);
            BoneContext targetBoneContext = this.blenderContext.getBoneByName(oma, subtargetName);
            Bone bone = targetBoneContext.getBone();
            if (bone.getParent() == null && (space == Space.CONSTRAINT_SPACE_LOCAL || space == Space.CONSTRAINT_SPACE_PARLOCAL)) {
                space = Space.CONSTRAINT_SPACE_POSE;
            }
            TempVars tempVars = TempVars.get();
            switch (space) {
                case CONSTRAINT_SPACE_LOCAL: {
                    assert (bone.getParent() != null) : "CONSTRAINT_SPACE_LOCAL should be evaluated as CONSTRAINT_SPACE_POSE if the bone has no parent!";
                    bone.setBindTransforms(transform.getTranslation(), transform.getRotation(), transform.getScale());
                    break;
                }
                case CONSTRAINT_SPACE_WORLD: {
                    Matrix4f boneMatrixInWorldSpace = this.toMatrix(transform, tempVars.tempMat4);
                    Matrix4f modelWorldMatrix = this.toMatrix(this.getTransform(targetBoneContext.getSkeletonOwnerOma(), null, Space.CONSTRAINT_SPACE_WORLD), tempVars.tempMat42);
                    Matrix4f boneMatrixInModelSpace = modelWorldMatrix.invertLocal().multLocal(boneMatrixInWorldSpace);
                    Bone parent = bone.getParent();
                    if (parent != null) {
                        Matrix4f parentMatrixInModelSpace = this.toMatrix(parent.getModelSpacePosition(), parent.getModelSpaceRotation(), parent.getModelSpaceScale(), tempVars.tempMat4);
                        boneMatrixInModelSpace = parentMatrixInModelSpace.invertLocal().multLocal(boneMatrixInModelSpace);
                    }
                    bone.setBindTransforms(boneMatrixInModelSpace.toTranslationVector(), boneMatrixInModelSpace.toRotationQuat(), boneMatrixInModelSpace.toScaleVector());
                    break;
                }
                case CONSTRAINT_SPACE_POSE: {
                    Matrix4f armatureWorldMatrix = this.toMatrix(feature.getWorldTransform(), tempVars.tempMat4);
                    Matrix4f boneMatrixInWorldSpace = armatureWorldMatrix.multLocal(this.toMatrix(transform, tempVars.tempMat42));
                    Matrix4f invertedModelMatrix = this.toMatrix(this.getTransform(targetBoneContext.getSkeletonOwnerOma(), null, Space.CONSTRAINT_SPACE_WORLD), tempVars.tempMat42).invertLocal();
                    Matrix4f boneMatrixInModelSpace = invertedModelMatrix.multLocal(boneMatrixInWorldSpace);
                    Bone parent = bone.getParent();
                    if (parent != null) {
                        Matrix4f parentMatrixInModelSpace = this.toMatrix(parent.getModelSpacePosition(), parent.getModelSpaceRotation(), parent.getModelSpaceScale(), tempVars.tempMat4);
                        boneMatrixInModelSpace = parentMatrixInModelSpace.invertLocal().multLocal(boneMatrixInModelSpace);
                    }
                    bone.setBindTransforms(boneMatrixInModelSpace.toTranslationVector(), boneMatrixInModelSpace.toRotationQuat(), boneMatrixInModelSpace.toScaleVector());
                    break;
                }
                case CONSTRAINT_SPACE_PARLOCAL: {
                    Matrix4f armatureWorldMatrix = this.toMatrix(feature.getWorldTransform(), tempVars.tempMat4);
                    Matrix4f boneMatrixInWorldSpace = armatureWorldMatrix.multLocal(this.toMatrix(transform, tempVars.tempMat42));
                    Matrix4f invertedModelMatrix = this.toMatrix(this.getTransform(targetBoneContext.getSkeletonOwnerOma(), null, Space.CONSTRAINT_SPACE_WORLD), tempVars.tempMat42).invertLocal();
                    Matrix4f boneMatrixInModelSpace = invertedModelMatrix.multLocal(boneMatrixInWorldSpace);
                    Bone parent = bone.getParent();
                    if (parent != null) {
                        BoneContext parentContext = this.blenderContext.getBoneContext(parent);
                        Matrix4f initialParentMatrixInModelSpace = parentContext.getBoneMatrixInModelSpace();
                        Matrix4f currentParentMatrixInModelSpace = this.toMatrix(parent.getModelSpacePosition(), parent.getModelSpaceRotation(), parent.getModelSpaceScale(), tempVars.tempMat4);
                        boneMatrixInModelSpace = initialParentMatrixInModelSpace.mult(boneMatrixInModelSpace);
                        Matrix4f diffMatrix = initialParentMatrixInModelSpace.mult(currentParentMatrixInModelSpace.invert());
                        boneMatrixInModelSpace.multLocal(diffMatrix);
                    }
                    bone.setBindTransforms(boneMatrixInModelSpace.toTranslationVector(), boneMatrixInModelSpace.toRotationQuat(), boneMatrixInModelSpace.toScaleVector());
                    break;
                }
                default: {
                    tempVars.release();
                    throw new IllegalStateException("Invalid space type for target object: " + space.toString());
                }
            }
            tempVars.release();
            skeleton.updateWorldVectors();
        } else {
            switch (space) {
                case CONSTRAINT_SPACE_LOCAL: {
                    feature.getLocalTransform().set(transform);
                    break;
                }
                case CONSTRAINT_SPACE_WORLD: {
                    if (feature.getParent() == null) {
                        feature.setLocalTransform(transform);
                        break;
                    }
                    Transform parentWorldTransform = feature.getParent().getWorldTransform();
                    TempVars tempVars = TempVars.get();
                    Matrix4f parentInverseMatrix = this.toMatrix(parentWorldTransform, tempVars.tempMat4).invertLocal();
                    Matrix4f m = this.toMatrix(transform, tempVars.tempMat42);
                    m = m.multLocal(parentInverseMatrix);
                    tempVars.release();
                    transform.setTranslation(m.toTranslationVector());
                    transform.setRotation(m.toRotationQuat());
                    transform.setScale(m.toScaleVector());
                    feature.setLocalTransform(transform);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid space type for spatial object: " + space.toString());
                }
            }
        }
    }

    public Matrix4f toMatrix(Transform transform, Matrix4f store) {
        if (transform != null) {
            return this.toMatrix(transform.getTranslation(), transform.getRotation(), transform.getScale(), store);
        }
        store.loadIdentity();
        return store;
    }

    private Matrix4f toMatrix(Vector3f position, Quaternion rotation, Vector3f scale, Matrix4f store) {
        store.loadIdentity();
        store.setTranslation(position);
        store.setRotationQuaternion(rotation);
        store.setScale(scale);
        return store;
    }

    public static enum Space {
        CONSTRAINT_SPACE_WORLD,
        CONSTRAINT_SPACE_LOCAL,
        CONSTRAINT_SPACE_POSE,
        CONSTRAINT_SPACE_PARLOCAL;


        public static Space valueOf(byte c) {
            switch (c) {
                case 0: {
                    return CONSTRAINT_SPACE_WORLD;
                }
                case 1: {
                    return CONSTRAINT_SPACE_LOCAL;
                }
                case 2: {
                    return CONSTRAINT_SPACE_POSE;
                }
                case 3: {
                    return CONSTRAINT_SPACE_PARLOCAL;
                }
            }
            throw new IllegalArgumentException("Value: " + c + " cannot be converted to Space enum instance!");
        }
    }
}

