/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.JRBaseDataRange;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.type.MeterShapeEnum;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseMeterPlot
extends JRBaseChartPlot
implements JRMeterPlot {
    private static final long serialVersionUID = 10200L;
    protected JRDataRange dataRange;
    protected JRValueDisplay valueDisplay;
    protected MeterShapeEnum shapeValue;
    protected List<JRMeterInterval> intervals = new ArrayList<JRMeterInterval>();
    protected Integer meterAngleInteger;
    protected String units;
    protected Double tickIntervalDouble;
    protected Color meterBackgroundColor;
    protected Color needleColor;
    protected Color tickColor;
    protected Integer tickCount;
    protected JRFont tickLabelFont;
    private int PSEUDO_SERIAL_VERSION_UID = 61100;
    private byte shape = MeterShapeEnum.PIE.getValue();
    private int meterAngle = 180;
    private double tickInterval = 10.0;
    private Byte shapeByte;

    public JRBaseMeterPlot(JRChartPlot plot, JRChart chart) {
        super(plot, chart);
        JRMeterPlot meterPlot;
        JRMeterPlot jRMeterPlot = meterPlot = plot instanceof JRMeterPlot ? (JRMeterPlot)plot : null;
        if (meterPlot == null) {
            this.valueDisplay = new JRBaseValueDisplay(null, chart);
        } else {
            this.valueDisplay = new JRBaseValueDisplay(meterPlot.getValueDisplay(), chart);
            this.tickLabelFont = meterPlot.getTickLabelFont();
        }
    }

    public JRBaseMeterPlot(JRMeterPlot meterPlot, JRBaseObjectFactory factory) {
        super((JRChartPlot)meterPlot, factory);
        this.dataRange = new JRBaseDataRange(meterPlot.getDataRange(), factory);
        this.valueDisplay = new JRBaseValueDisplay(meterPlot.getValueDisplay(), factory);
        this.shapeValue = meterPlot.getShapeValue();
        List<JRMeterInterval> origIntervals = meterPlot.getIntervals();
        this.intervals.clear();
        if (origIntervals != null) {
            for (JRMeterInterval interval : origIntervals) {
                this.intervals.add(new JRMeterInterval(interval, factory));
            }
        }
        this.meterAngleInteger = meterPlot.getMeterAngleInteger();
        this.units = meterPlot.getUnits();
        this.tickIntervalDouble = meterPlot.getTickIntervalDouble();
        this.tickCount = meterPlot.getTickCount();
        this.meterBackgroundColor = meterPlot.getMeterBackgroundColor();
        this.needleColor = meterPlot.getNeedleColor();
        this.tickColor = meterPlot.getTickColor();
        this.tickLabelFont = factory.getFont(this.getChart(), meterPlot.getTickLabelFont());
    }

    @Override
    public JRDataRange getDataRange() {
        return this.dataRange;
    }

    @Override
    public JRValueDisplay getValueDisplay() {
        return this.valueDisplay;
    }

    @Override
    public MeterShapeEnum getShapeValue() {
        return this.shapeValue;
    }

    @Override
    public List<JRMeterInterval> getIntervals() {
        return this.intervals;
    }

    @Override
    public Integer getMeterAngleInteger() {
        return this.meterAngleInteger;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public Double getTickIntervalDouble() {
        return this.tickIntervalDouble;
    }

    @Override
    public Color getMeterBackgroundColor() {
        return this.meterBackgroundColor;
    }

    @Override
    public Color getNeedleColor() {
        return this.needleColor;
    }

    @Override
    public Color getTickColor() {
        return this.tickColor;
    }

    @Override
    public Integer getTickCount() {
        return this.tickCount;
    }

    @Override
    public JRFont getTickLabelFont() {
        return this.tickLabelFont;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public Object clone(JRChart parentChart) {
        JRBaseMeterPlot clone = (JRBaseMeterPlot)super.clone(parentChart);
        clone.dataRange = JRCloneUtils.nullSafeClone(this.dataRange);
        clone.valueDisplay = this.valueDisplay == null ? null : this.valueDisplay.clone(parentChart);
        clone.intervals = JRCloneUtils.cloneList(this.intervals);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            if (this.PSEUDO_SERIAL_VERSION_UID < 30103) {
                this.shapeValue = MeterShapeEnum.getByValue(this.shape);
                this.meterAngleInteger = this.meterAngle;
                this.tickIntervalDouble = this.tickInterval;
            } else {
                this.shapeValue = MeterShapeEnum.getByValue(this.shapeByte);
                this.shapeByte = null;
            }
        }
    }
}

