/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultFormatter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.gui.module.securityevents.simplecorrelator.ActionProperty;
import rs.co.ast.aspen.gui.module.securityevents.simplecorrelator.ActionTreeCellRenderer;
import rs.co.ast.aspen.gui.module.securityevents.simplecorrelator.SimpleCorrelatorPanel;
import rs.co.ast.aspen.gui.module.securityevents.simplecorrelator.SimpleCorrelatorScriptEditorPanel;

public class SimpleHistoricalCorrelationPanel
extends JPanel {
    private String scriptTemplate = null;
    private String scriptText = null;
    private String scriptName = null;
    private String scriptCron = null;
    private SimpleCorrelatorScriptEditorPanel scriptEditorPanel = new SimpleCorrelatorScriptEditorPanel();
    private final RSyntaxTextArea taScriptText = this.scriptEditorPanel.getTaScriptText();
    private final DefaultTreeModel actionTreeModel;
    private final DefaultMutableTreeNode actionRoot;
    private static final String GENERATE_SECURITY_EVENT = "generateSecurityEvent";
    private DefaultTableModel tableModel;
    private List<String> fields = new ArrayList<String>();
    private static final String NOTIFICATION_SEND = "sendNotifications";
    private JButton bGenerateSE;
    private JButton bSendNotification;
    private JCheckBox cbDebug;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable jtFields;
    private JTree jtrAction;
    private JMenuItem mEditA;
    private JMenuItem mRemoveA;
    private JPanel pActions;
    private JPanel pConditions;
    private JPanel pScriptEditor;
    private JPopupMenu pmTreeA;
    private JSpinner sDebugArrayLength;
    private JSpinner sMaxEvents;
    private JSpinner sTopN;
    private JSpinner sTriggerTrashold;
    private JLabel tDebugArrayLength;
    private JTabbedPane tabbedPanel;
    private JTextField tfCron;
    private JTextField tfQuery;
    private JTextField tfScriptName;

    public SimpleHistoricalCorrelationPanel(String query, Map<String, String> fields) {
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn("Fields");
        this.tableModel.addColumn("Values");
        fields.forEach((k, v) -> {
            Object[] rowData = new String[]{k, v};
            this.fields.add((String)k);
            this.tableModel.addRow(rowData);
        });
        this.initComponents();
        this.actionTreeModel = (DefaultTreeModel)this.jtrAction.getModel();
        this.actionRoot = (DefaultMutableTreeNode)this.actionTreeModel.getRoot();
        this.pScriptEditor.add(this.scriptEditorPanel);
        this.tfQuery.setText(query);
        this.setScriptText();
        this.tfScriptName.getDocument().addDocumentListener(new TextFieldDocumentLisener(this.tfScriptName));
        this.tfCron.getDocument().addDocumentListener(new TextFieldDocumentLisener(this.tfCron));
        this.addLisenersToFields(this.pConditions);
        this.setToolTipTextToJSpinersInJPanel(this.pConditions);
        this.jtrAction.setCellRenderer(new ActionTreeCellRenderer());
        this.jtrAction.setRowHeight(20);
        this.jtFields.setEnabled(false);
        this.actionTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                this.extandAndSetText(e);
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                this.extandAndSetText(e);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                this.extandAndSetText(e);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                this.extandAndSetText(e);
            }

            private void extandAndSetText(TreeModelEvent e) {
                SimpleHistoricalCorrelationPanel.this.jtrAction.expandPath(e.getTreePath());
                SimpleHistoricalCorrelationPanel.this.setScriptText();
            }
        });
    }

    private void setToolTipTextToJSpinersInJPanel(JPanel panel) {
        Component[] pConditionComponents = panel.getComponents();
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            if (!(pConditionComponents[i] instanceof JSpinner)) continue;
            JSpinner spiner = (JSpinner)pConditionComponents[i];
            SpinnerNumberModel model = (SpinnerNumberModel)spiner.getModel();
            spiner.setToolTipText("Min " + model.getMinimum() + " Max " + model.getMaximum());
        }
    }

    private void addLisenersToFields(JPanel panel) {
        Component[] pConditionComponents = panel.getComponents();
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            if (pConditionComponents[i] instanceof JTextField) {
                JTextField field = (JTextField)pConditionComponents[i];
                field.getDocument().addDocumentListener(new TextFieldDocumentLisener(field));
                continue;
            }
            if (!(pConditionComponents[i] instanceof JSpinner)) continue;
            JSpinner spiner = (JSpinner)pConditionComponents[i];
            JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spiner.getEditor();
            JFormattedTextField jtf = editor.getTextField();
            DefaultFormatter formatter = (DefaultFormatter)jtf.getFormatter();
            formatter.setCommitsOnValidEdit(true);
            spiner.addChangeListener(e -> this.setScriptText());
        }
    }

    private void deleteTreeNode() {
        DefaultMutableTreeNode lastSelectedPath = (DefaultMutableTreeNode)this.jtrAction.getLastSelectedPathComponent();
        DefaultTreeModel treeModel = (DefaultTreeModel)this.jtrAction.getModel();
        if (lastSelectedPath != null && lastSelectedPath.getParent() != null && lastSelectedPath.getChildCount() > 0) {
            treeModel.removeNodeFromParent(lastSelectedPath);
        }
    }

    private void editTreeNode(DefaultMutableTreeNode selectedNode) {
        String newValue;
        Object userObject = selectedNode.getUserObject();
        if (userObject instanceof ActionProperty && ((ActionProperty)userObject).isEditable() && (newValue = JOptionPane.showInputDialog(this.jtrAction, "Enter value for " + ((ActionProperty)userObject).getProperty().replace("=", ""), ((ActionProperty)userObject).getText())) != null && !newValue.startsWith(" ") && !newValue.isEmpty()) {
            ((ActionProperty)userObject).setText(newValue);
            this.actionTreeModel.nodeChanged(selectedNode);
        }
    }

    public String getScriptText() {
        this.setScriptText();
        return this.scriptText;
    }

    public String getScriptName() {
        return this.tfScriptName.getText().replaceAll(" ", "_");
    }

    public String getScriptCron() {
        return this.tfCron.getText();
    }

    private String loadScriptTamplate() {
        if (this.scriptTemplate == null) {
            InputStream is = this.getClass().getResourceAsStream("/scripts/historical_ correlation_script_template.txt");
            this.scriptTemplate = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
        }
        return this.scriptTemplate;
    }

    private void setScriptText() {
        String scrName = this.tfScriptName.getText();
        this.scriptText = String.format(this.loadScriptTamplate(), scrName, this.getHistoricalAggregationText());
        this.taScriptText.setText(this.scriptText);
    }

    private String getHistoricalAggregationText() {
        String lineSeparator = System.lineSeparator();
        String twoTabs = "\t\t";
        String histAggregation = "utils.historicalAggregationByFields(scriptName,\n\t\t\t %s, %s, %d, %d, %d);";
        StringBuilder sb = new StringBuilder();
        sb.append("var utils = new HistoricalCorrelationUtilityFunctions();").append(lineSeparator).append(twoTabs);
        if (this.cbDebug.isSelected()) {
            sb.append("utils.DEBUG = true;").append(lineSeparator).append(twoTabs);
            sb.append("utils.DEBUG_ARRAY_LENGTH = ").append(this.sDebugArrayLength.getValue()).append(lineSeparator).append(twoTabs);
        }
        String format = String.format(histAggregation, this.getQueryFields(), this.appendQuotes(this.tfQuery.getText()), this.sTopN.getValue(), this.sTriggerTrashold.getValue(), this.sMaxEvents.getValue());
        sb.append("var events = ").append(format).append(lineSeparator).append(twoTabs);
        StringBuilder actionBuilder = new StringBuilder();
        sb.append(this.actionText(this.actionRoot, actionBuilder)).append(lineSeparator).append(twoTabs);
        return sb.toString();
    }

    private String appendQuotes(String text) {
        return "'" + text + "'";
    }

    private String getQueryFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.fields.size(); ++i) {
            sb.append("'").append(this.fields.get(i)).append("'");
            if (i == this.fields.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private String actionText(DefaultMutableTreeNode node, StringBuilder sb) {
        int childCount = node.getChildCount();
        if (!node.isRoot()) {
            sb.append("utils.").append(node);
        }
        for (int i = 0; i < childCount; ++i) {
            Object userObject;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (childNode.getChildCount() > 0) {
                this.actionText(childNode, sb);
                continue;
            }
            if (i == 0) {
                sb.append("(");
            }
            if ((userObject = childNode.getUserObject()) instanceof ActionProperty) {
                this.appendQuotes(sb, (ActionProperty)userObject);
            }
            if (i != childCount - 1) {
                sb.append(",");
            }
            if (i != childCount - 1) continue;
            sb.append(");").append(System.lineSeparator()).append("\t\t\t");
        }
        return sb.toString();
    }

    private void appendQuotes(StringBuilder sb, ActionProperty ac) {
        String s = ac.getText();
        try {
            Integer number = Integer.valueOf(s);
            sb.append(" ").append(number.toString()).append(" ");
        }
        catch (NumberFormatException ex) {
            if (!ac.isEditable() || ac.getText() != null && ac.getText().startsWith("event.") || ac.getText() != null && ac.getText().equals("scriptName")) {
                sb.append(" ").append(s).append(" ");
            }
            sb.append(" '").append(s).append("' ");
        }
    }

    public boolean isScriptValid() {
        return this.scriptEditorPanel.isScriptValid();
    }

    private void initComponents() {
        this.pmTreeA = new JPopupMenu();
        this.mRemoveA = new JMenuItem();
        this.mEditA = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.pScriptEditor = new JPanel();
        this.jPanel1 = new JPanel();
        this.tfCron = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.tfScriptName = new JTextField();
        this.tabbedPanel = new JTabbedPane();
        this.pConditions = new JPanel();
        this.jLabel1 = new JLabel();
        this.tfQuery = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.cbDebug = new JCheckBox();
        this.tDebugArrayLength = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jtFields = new JTable();
        this.sTriggerTrashold = new JSpinner();
        this.sMaxEvents = new JSpinner();
        this.sTopN = new JSpinner();
        this.sDebugArrayLength = new JSpinner();
        this.pActions = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jtrAction = new JTree();
        this.bGenerateSE = new JButton();
        this.bSendNotification = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.mRemoveA, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.mRemoveA.text"));
        this.mRemoveA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleHistoricalCorrelationPanel.this.mRemoveAActionPerformed(evt);
            }
        });
        this.pmTreeA.add(this.mRemoveA);
        Mnemonics.setLocalizedText((AbstractButton)this.mEditA, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.mEditA.text"));
        this.mEditA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleHistoricalCorrelationPanel.this.mEditAActionPerformed(evt);
            }
        });
        this.pmTreeA.add(this.mEditA);
        this.jSplitPane1.setDividerLocation(375);
        this.pScriptEditor.setLayout(new BorderLayout());
        this.jSplitPane1.setRightComponent(this.pScriptEditor);
        this.tfCron.setText(NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.tfCron.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.jLabel7.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.jLabel6.text"));
        this.jLabel6.setToolTipText(NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.jLabel6.toolTipText"));
        this.tfScriptName.setText(NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.tfScriptName.text"));
        this.tfScriptName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SimpleHistoricalCorrelationPanel.this.tfScriptNameKeyTyped(evt);
            }
        });
        this.tabbedPanel.setName("");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.jLabel1.text"));
        this.tfQuery.setText(NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.tfQuery.text"));
        this.tfQuery.setDisabledTextColor(new Color(51, 51, 51));
        this.tfQuery.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDebug, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.cbDebug.text"));
        this.cbDebug.setToolTipText(NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.cbDebug.toolTipText"));
        this.cbDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleHistoricalCorrelationPanel.this.cbDebugActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.tDebugArrayLength, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.tDebugArrayLength.text"));
        this.tDebugArrayLength.setEnabled(false);
        this.jtFields.setModel(this.tableModel);
        this.jScrollPane2.setViewportView(this.jtFields);
        this.sTriggerTrashold.setModel(new SpinnerNumberModel(15, 10, 1000, 1));
        this.sTriggerTrashold.setName("");
        this.sMaxEvents.setModel(new SpinnerNumberModel(100, 10, 1000, 1));
        this.sTopN.setModel(new SpinnerNumberModel(10, 1, 50, 1));
        this.sDebugArrayLength.setModel(new SpinnerNumberModel(10, 1, 100, 1));
        this.sDebugArrayLength.setEnabled(false);
        GroupLayout pConditionsLayout = new GroupLayout(this.pConditions);
        this.pConditions.setLayout(pConditionsLayout);
        pConditionsLayout.setHorizontalGroup(pConditionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(pConditionsLayout.createSequentialGroup().addContainerGap().addGroup(pConditionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pConditionsLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfQuery)).addGroup(pConditionsLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.sTopN, -2, 55, -2)).addGroup(pConditionsLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 126, Short.MAX_VALUE).addComponent(this.sTriggerTrashold, -2, 55, -2)).addGroup(pConditionsLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.sMaxEvents, -2, 55, -2)).addGroup(pConditionsLayout.createSequentialGroup().addComponent(this.cbDebug).addGap(0, 0, Short.MAX_VALUE)).addGroup(pConditionsLayout.createSequentialGroup().addComponent(this.tDebugArrayLength).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.sDebugArrayLength, -2, 55, -2))).addContainerGap()));
        pConditionsLayout.setVerticalGroup(pConditionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pConditionsLayout.createSequentialGroup().addContainerGap().addGroup(pConditionsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pConditionsLayout.createSequentialGroup().addGroup(pConditionsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pConditionsLayout.createSequentialGroup().addGroup(pConditionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfQuery, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 163, -2).addGap(18, 18, 18).addComponent(this.sTopN, -2, -1, -2)).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sTriggerTrashold, -2, -1, -2)).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pConditionsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.sMaxEvents, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pConditionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tDebugArrayLength).addComponent(this.sDebugArrayLength, -2, -1, -2)).addContainerGap(314, Short.MAX_VALUE)));
        this.tabbedPanel.addTab(NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.pConditions.TabConstraints.tabTitle"), this.pConditions);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Actions");
        this.jtrAction.setModel(new DefaultTreeModel(treeNode1));
        this.jtrAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimpleHistoricalCorrelationPanel.this.jtrActionMouseClicked(evt);
            }
        });
        this.jtrAction.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimpleHistoricalCorrelationPanel.this.jtrActionKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jtrAction);
        Mnemonics.setLocalizedText((AbstractButton)this.bGenerateSE, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.bGenerateSE.text"));
        this.bGenerateSE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleHistoricalCorrelationPanel.this.bGenerateSEActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bSendNotification, (String)NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.bSendNotification.text"));
        this.bSendNotification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleHistoricalCorrelationPanel.this.bSendNotificationActionPerformed(evt);
            }
        });
        GroupLayout pActionsLayout = new GroupLayout(this.pActions);
        this.pActions.setLayout(pActionsLayout);
        pActionsLayout.setHorizontalGroup(pActionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(pActionsLayout.createSequentialGroup().addContainerGap().addGroup(pActionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bGenerateSE).addComponent(this.bSendNotification)).addContainerGap(151, Short.MAX_VALUE)));
        pActionsLayout.setVerticalGroup(pActionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pActionsLayout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 235, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bGenerateSE).addGap(18, 18, 18).addComponent(this.bSendNotification).addGap(0, 348, Short.MAX_VALUE)));
        this.tabbedPanel.addTab(NbBundle.getMessage(SimpleHistoricalCorrelationPanel.class, (String)"SimpleHistoricalCorrelationPanel.pActions.TabConstraints.tabTitle"), this.pActions);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfScriptName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfCron, -2, 62, -2).addContainerGap()).addComponent(this.tabbedPanel));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.tfScriptName, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.tfCron, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPanel)));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 1140, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
    }

    private void tfScriptNameKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (!Character.isAlphabetic(c) && Character.getType(c) != 23 && !Character.isDigit(c)) {
            evt.consume();
        }
    }

    private void cbDebugActionPerformed(ActionEvent evt) {
        this.tDebugArrayLength.setEnabled(this.cbDebug.isSelected());
        this.sDebugArrayLength.setEnabled(this.cbDebug.isSelected());
        this.setScriptText();
    }

    private void bGenerateSEActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(GENERATE_SECURITY_EVENT);
        ActionProperty textProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.text"), "scriptName", false);
        node.add(new DefaultMutableTreeNode(textProp, false));
        ActionProperty priorityProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.priority"), NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.priority.example"), true);
        node.add(new DefaultMutableTreeNode(priorityProp, false));
        if (this.actionRoot != null) {
            this.actionTreeModel.insertNodeInto(node, this.actionRoot, this.actionRoot.getChildCount());
        }
    }

    private void bSendNotificationActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(NOTIFICATION_SEND);
        ActionProperty destinationProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.destination"), NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.destination.example"), true);
        node.add(new DefaultMutableTreeNode(destinationProp, false));
        ActionProperty severityProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.severity"), NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.severity.example"), true);
        node.add(new DefaultMutableTreeNode(severityProp, false));
        ActionProperty subjectProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.subject"), "scriptName", true);
        node.add(new DefaultMutableTreeNode(subjectProp, false));
        if (this.actionRoot != null) {
            this.actionTreeModel.insertNodeInto(node, this.actionRoot, this.actionRoot.getChildCount());
        }
    }

    private void jtrActionMouseClicked(MouseEvent evt) {
        DefaultMutableTreeNode lastPathComponent;
        TreePath pathForLocation;
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && (pathForLocation = this.jtrAction.getPathForLocation(evt.getX(), evt.getY())) != null) {
            lastPathComponent = (DefaultMutableTreeNode)pathForLocation.getLastPathComponent();
            this.editTreeNode(lastPathComponent);
        }
        if (evt.getButton() == 3 && (pathForLocation = this.jtrAction.getPathForLocation(evt.getX(), evt.getY())) != null) {
            this.jtrAction.setSelectionPath(pathForLocation);
            lastPathComponent = (DefaultMutableTreeNode)pathForLocation.getLastPathComponent();
            if (lastPathComponent.getLevel() == 1) {
                this.mEditA.setEnabled(false);
                this.mRemoveA.setEnabled(true);
            } else {
                this.mEditA.setEnabled(false);
                this.mRemoveA.setEnabled(false);
            }
            if (lastPathComponent.getUserObject() instanceof ActionProperty) {
                ActionProperty userObject = (ActionProperty)lastPathComponent.getUserObject();
                if (userObject.isEditable()) {
                    this.mEditA.setEnabled(true);
                } else {
                    this.mEditA.setEnabled(false);
                }
            }
            this.pmTreeA.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jtrActionKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.deleteTreeNode();
        }
        if (evt.getKeyCode() == 113) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.jtrAction.getLastSelectedPathComponent();
            this.editTreeNode(selectedNode);
        }
    }

    private void mRemoveAActionPerformed(ActionEvent evt) {
        this.deleteTreeNode();
    }

    private void mEditAActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode selectionPath = (DefaultMutableTreeNode)this.jtrAction.getLastSelectedPathComponent();
        this.editTreeNode(selectionPath);
    }

    private class TextFieldDocumentLisener
    implements DocumentListener {
        private JTextField textField;

        public TextFieldDocumentLisener(JTextField textField) {
            this.textField = textField;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validateConditionText();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validateConditionText();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validateConditionText();
        }

        private void validateConditionText() {
            if (!this.textField.getText().isEmpty()) {
                this.textField.setBorder(UIManager.getBorder("TextField.border"));
            } else {
                this.textField.setBorder(new LineBorder(Color.red, 1));
            }
            SimpleHistoricalCorrelationPanel.this.setScriptText();
        }
    }
}

