/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.pus;

import java.util.ArrayList;
import java.util.List;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;
import rs.co.ast.aspen.api.service.PusReport;
import rs.co.ast.aspen.api.service.Status;
import rs.co.ast.aspen.gui.module.pus.Constants;
import rs.co.ast.aspen.gui.module.pus.HasId;
import rs.co.ast.aspen.gui.module.pus.ProcessChildFactory;
import rs.co.ast.aspen.gui.module.pus.PusNodeWrapper;
import rs.co.ast.aspen.gui.module.pus.PusProcessWrapper;

public class NodeNode
extends AbstractNode
implements HasId {
    private PusNodeWrapper node;

    public NodeNode(PusNodeWrapper node) {
        super(Children.create((ChildFactory)new ProcessChildFactory(node.getProcesses()), (boolean)true), Lookups.singleton((Object)node));
        this.setDisplayName(node.getName());
        this.setIcon(node);
        this.node = node;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    @Override
    public String getId() {
        return this.node.getName();
    }

    public PusNodeWrapper getPusNode() {
        return this.node;
    }

    private void setIcon(PusNodeWrapper node) {
        ArrayList<ProcessStatus> statuses = new ArrayList<ProcessStatus>();
        for (PusProcessWrapper p : node.getProcesses()) {
            List<PusReport> reports = p.getReports();
            PusReport r = reports.get(reports.size() - 1);
            if (r.getStatus() != Status.ACTIVE) continue;
            long time = System.currentTimeMillis();
            if (time - r.getFinish() >= (long)(Constants.CYCLE * Constants.THIRD_CYCLE)) {
                statuses.add(ProcessStatus.RED);
                continue;
            }
            if (time - r.getFinish() >= (long)(Constants.CYCLE * Constants.FIRST_CYCLE)) {
                statuses.add(ProcessStatus.YELLOW);
                continue;
            }
            statuses.add(ProcessStatus.GREEN);
        }
        String icon = Constants.ICON_ACTIVE_GREEN;
        for (ProcessStatus s : statuses) {
            if (s == ProcessStatus.RED) {
                icon = Constants.ICON_ACTIVE_RED;
                break;
            }
            if (s != ProcessStatus.YELLOW) continue;
            icon = Constants.ICON_ACTIVE_YELLOW;
        }
        this.setIconBaseWithExtension(icon);
    }

    private static enum ProcessStatus {
        GREEN,
        YELLOW,
        RED;

    }
}

