/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;
import org.jdesktop.swingx.painter.BusyPainter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.HostStatsAggObject;
import rs.co.ast.aspen.api.service.HostStatsCsvReport;
import rs.co.ast.aspen.api.service.HostStatsGuiReport;
import rs.co.ast.aspen.gui.module.datamaps.TableTransferHandler;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.HostnamesActivityTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.HostnamesActivityTableRenderer;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.HostsPerDomainTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.HostsPerDomainTableRenderer;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.OverviewTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableRenderer;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableTooltipHeader;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.TableTransferHandlerColumnOne;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.TableTransferHandlerColumnThree;

@TopComponent.Description(preferredID="SourceStatisticsTopComponent", iconBase="assetts-statistic.png", persistenceType=0)
public final class SourceStatisticsTopComponent
extends TopComponent {
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private final SumOfCountsPerHostnameTableModel sumOfCountsPerHostnameTableModel = new SumOfCountsPerHostnameTableModel();
    private final HostsPerDomainTableModel hostsPerDomainTablemodel = new HostsPerDomainTableModel();
    private final HostnamesActivityTableModel hostnamesActivityTableModel = new HostnamesActivityTableModel();
    private final OverviewTableModel overviewTableModel = new OverviewTableModel();
    private final DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
    private final long MS_IN_DAY = 86400000L;
    private final KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                SourceStatisticsTopComponent.this.startSearch();
            }
        }
    };
    private JButton bExport;
    private JButton bRefresh;
    private JComboBox<String> cbLastNDays;
    private JXDatePicker dtpTimeFinish;
    private JXDatePicker dtpTimeFinishPastPeriod;
    private JXDatePicker dtpTimeStart;
    private JXDatePicker dtpTimeStartPastPeriod;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JLabel lDelimeter;
    private JLabel lFinish;
    private JLabel lFinish1;
    private JLabel lFinish2;
    private JXBusyLabel lLoading;
    private JLabel lQueryDomain;
    private JLabel lQueryHostname;
    private JLabel lStart;
    private JLabel lStart1;
    private JRadioButton rbCustomDate;
    private JRadioButton rbLastNDays;
    private JTable tCountOfHostNamesPerDomain;
    private JTable tHostnamesActivity;
    private JTable tOverview;
    private JTable tSumOfCountsPerHostname;
    private JToggleButton tbHostnameActivity;
    private JTabbedPane tbPanel;
    private JTextField tfDelimeter;
    private JTextField tfQueryDomain;
    private JTextField tfQueryHostname;

    public SourceStatisticsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"CTL_SourceStatisticsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"HINT_SourceStatisticsTopComponent"));
        this.dtpTimeStart.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeStart.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeFinish.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeFinish.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeStart.setTimeZone(TimeZone.getDefault());
        this.dtpTimeFinish.setTimeZone(TimeZone.getDefault());
        long now = System.currentTimeMillis();
        this.dtpTimeStart.setDate(new DateTime(now - 604800000L).withTimeAtStartOfDay().toDate());
        this.dtpTimeFinish.setDate(new DateTime(now).withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).withMillisOfSecond(0).toDate());
        this.dtpTimeStartPastPeriod.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeStartPastPeriod.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeStartPastPeriod.setTimeZone(TimeZone.getDefault());
        this.dtpTimeStartPastPeriod.setDate(new DateTime(this.getStartTime() - (long)(Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) + 1) * 86400000L).toDate());
        this.dtpTimeFinishPastPeriod.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeFinishPastPeriod.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeFinishPastPeriod.setTimeZone(TimeZone.getDefault());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.dtpTimeFinish.getDate());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.dtpTimeFinishPastPeriod.setDate(new DateTime(cal.getTimeInMillis() - (long)(Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) + 1) * 86400000L).toDate());
        this.tSumOfCountsPerHostname.setModel(this.sumOfCountsPerHostnameTableModel);
        this.tSumOfCountsPerHostname.setDefaultRenderer(Long.class, new SumOfCountsPerHostnameTableRenderer());
        this.tSumOfCountsPerHostname.setTransferHandler(new TableTransferHandlerColumnThree());
        this.tSumOfCountsPerHostname.setAutoCreateRowSorter(true);
        SumOfCountsPerHostnameTableTooltipHeader sumOfCountsPerHostnameToolTipHeader = new SumOfCountsPerHostnameTableTooltipHeader(this.tSumOfCountsPerHostname.getColumnModel());
        this.tSumOfCountsPerHostname.setTableHeader(sumOfCountsPerHostnameToolTipHeader);
        this.tCountOfHostNamesPerDomain.setModel(this.hostsPerDomainTablemodel);
        this.tCountOfHostNamesPerDomain.setDefaultRenderer(Long.class, new HostsPerDomainTableRenderer());
        this.tCountOfHostNamesPerDomain.setTransferHandler(new TableTransferHandlerColumnOne());
        this.tCountOfHostNamesPerDomain.setAutoCreateRowSorter(true);
        this.tOverview.setModel(this.overviewTableModel);
        this.tOverview.setTransferHandler(new TableTransferHandler());
        this.tOverview.setAutoCreateRowSorter(true);
        this.tHostnamesActivity.setModel(this.hostnamesActivityTableModel);
        this.tHostnamesActivity.setDefaultRenderer(Long.class, new HostnamesActivityTableRenderer());
        this.tHostnamesActivity.setTransferHandler(new TableTransferHandlerColumnThree());
        this.tHostnamesActivity.setAutoCreateRowSorter(true);
        this.tfQueryDomain.addKeyListener(this.keyAdapter);
        this.tfQueryHostname.addKeyListener(this.keyAdapter);
        this.tbPanel.setForegroundAt(1, new Color(51, 153, 255));
        this.tbPanel.setForegroundAt(2, new Color(173, 51, 255));
        this.tbPanel.setForegroundAt(3, new Color(255, 0, 0));
        if (this.tbHostnameActivity.isSelected()) {
            this.tbHostnameActivity.setForeground(Color.green);
        } else {
            this.tbHostnameActivity.setForeground(Color.red);
        }
        this.tbHostnameActivity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SourceStatisticsTopComponent.this.tbHostnameActivity.isSelected()) {
                    SourceStatisticsTopComponent.this.tbHostnameActivity.setText("Inactive");
                    SourceStatisticsTopComponent.this.tbHostnameActivity.setForeground(Color.red);
                    SourceStatisticsTopComponent.this.hostnamesActivityTableModel.setShowInactive(true);
                } else {
                    SourceStatisticsTopComponent.this.tbHostnameActivity.setText("New Active");
                    SourceStatisticsTopComponent.this.tbHostnameActivity.setForeground(new Color(0, 153, 0));
                    SourceStatisticsTopComponent.this.hostnamesActivityTableModel.setShowInactive(false);
                }
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbCustomDate);
        bg.add(this.rbLastNDays);
        this.rbLastNDays.setSelected(true);
        this.dtpTimeFinishPastPeriod.setEnabled(false);
        this.dtpTimeStartPastPeriod.setEnabled(false);
        this.rbLastNDays.addActionListener(e -> {
            this.cbLastNDays.setEnabled(true);
            this.dtpTimeFinishPastPeriod.setDate(new DateTime(this.getStartTime() - (long)Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) * 86400000L).toDate());
            this.dtpTimeStartPastPeriod.setDate(new DateTime(this.getFinishPastPeriodTime() - (this.getFinishTime() - this.getStartTime())).toDate());
            this.dtpTimeFinishPastPeriod.setEnabled(false);
            this.dtpTimeStartPastPeriod.setEnabled(false);
        });
        this.rbCustomDate.addActionListener(e -> {
            this.cbLastNDays.setEnabled(false);
            this.dtpTimeFinishPastPeriod.setEnabled(true);
            this.dtpTimeStartPastPeriod.setEnabled(true);
        });
        this.cbLastNDays.addActionListener(e -> {
            this.dtpTimeFinishPastPeriod.setDate(new DateTime(this.getStartTime() - (long)Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) * 86400000L).toDate());
            this.dtpTimeStartPastPeriod.setDate(new DateTime(this.getFinishPastPeriodTime() - (this.getFinishTime() - this.getStartTime())).toDate());
        });
        this.dtpTimeStart.addActionListener(e -> {
            if (this.rbLastNDays.isSelected()) {
                this.dtpTimeFinishPastPeriod.setDate(new DateTime(this.getStartTime() - (long)Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) * 86400000L).toDate());
                this.dtpTimeStartPastPeriod.setDate(new DateTime(this.getFinishPastPeriodTime() - (this.getFinishTime() - this.getStartTime())).toDate());
            }
        });
        this.dtpTimeFinish.addActionListener(e -> {
            if (this.rbLastNDays.isSelected()) {
                this.dtpTimeFinishPastPeriod.setDate(new DateTime(this.getStartTime() - (long)Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) * 86400000L).toDate());
                this.dtpTimeStartPastPeriod.setDate(new DateTime(this.getFinishPastPeriodTime() - (this.getFinishTime() - this.getStartTime())).toDate());
            }
        });
    }

    public long getStartTime() {
        return this.dtpTimeStart.getDate().getTime();
    }

    public long getFinishTime() {
        return this.dtpTimeFinish.getDate().getTime();
    }

    public long getStartPastPeriodTime() {
        return this.dtpTimeStartPastPeriod.getDate().getTime();
    }

    public long getFinishPastPeriodTime() {
        return this.dtpTimeFinishPastPeriod.getDate().getTime();
    }

    public String getQueryDomain() {
        return this.tfQueryDomain.getText();
    }

    public String getQueryHostname() {
        return this.tfQueryHostname.getText();
    }

    public String getDelimeter() {
        return this.tfDelimeter.getText();
    }

    private void toggleLoading() {
        this.lLoading.setBusy(!this.lLoading.isBusy());
    }

    private String genFileName() {
        DateTime now = new DateTime();
        String ext = "csv";
        return String.format("%s_%s.%s", "SourceStatistics", now.toString(this.dtf), ext);
    }

    private void initComponents() {
        this.tbPanel = new JTabbedPane();
        this.jScrollPane3 = new JScrollPane();
        this.tOverview = new JTable();
        this.jScrollPane1 = new JScrollPane();
        this.tCountOfHostNamesPerDomain = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.tSumOfCountsPerHostname = new JTable();
        this.jScrollPane4 = new JScrollPane();
        this.tHostnamesActivity = new JTable();
        this.jSeparator1 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.lQueryDomain = new JLabel();
        this.lLoading = new JXBusyLabel();
        this.tfQueryDomain = new JTextField();
        this.bRefresh = new JButton();
        this.lQueryHostname = new JLabel();
        this.tfQueryHostname = new JTextField();
        this.lStart = new JLabel();
        this.dtpTimeStart = new JXDatePicker();
        this.lFinish = new JLabel();
        this.dtpTimeFinish = new JXDatePicker();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.rbCustomDate = new JRadioButton();
        this.lStart1 = new JLabel();
        this.dtpTimeStartPastPeriod = new JXDatePicker();
        this.lFinish1 = new JLabel();
        this.dtpTimeFinishPastPeriod = new JXDatePicker();
        this.jPanel2 = new JPanel();
        this.rbLastNDays = new JRadioButton();
        this.lFinish2 = new JLabel();
        this.cbLastNDays = new JComboBox();
        this.jLabel1 = new JLabel();
        this.tbHostnameActivity = new JToggleButton();
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.lDelimeter = new JLabel();
        this.tfDelimeter = new JTextField();
        this.bExport = new JButton();
        this.jSeparator3 = new JSeparator();
        this.tOverview.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tOverview.setCellSelectionEnabled(true);
        this.jScrollPane3.setViewportView(this.tOverview);
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jScrollPane3.TabConstraints.tabTitle"), this.jScrollPane3);
        this.tCountOfHostNamesPerDomain.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tCountOfHostNamesPerDomain.setColumnSelectionAllowed(true);
        this.jScrollPane1.setViewportView(this.tCountOfHostNamesPerDomain);
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jScrollPane1.TabConstraints.tabTitle"), this.jScrollPane1);
        this.tSumOfCountsPerHostname.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tSumOfCountsPerHostname.setColumnSelectionAllowed(true);
        this.jScrollPane2.setViewportView(this.tSumOfCountsPerHostname);
        this.tSumOfCountsPerHostname.getColumnModel().getSelectionModel().setSelectionMode(1);
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jScrollPane2.TabConstraints.tabTitle"), this.jScrollPane2);
        this.tHostnamesActivity.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.tHostnamesActivity.setCellSelectionEnabled(true);
        this.jScrollPane4.setViewportView(this.tHostnamesActivity);
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jScrollPane4.TabConstraints.tabTitle"), this.jScrollPane4);
        this.jSeparator1.setOrientation(1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.lQueryDomain, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lQueryDomain.text"));
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lLoading.text"));
        this.lLoading.setDirection(BusyPainter.Direction.RIGHT);
        this.tfQueryDomain.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryDomain.text"));
        this.tfQueryDomain.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryDomain.toolTipText"));
        this.bRefresh.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bRefresh.text"));
        this.bRefresh.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bRefresh.toolTipText"));
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatisticsTopComponent.this.bRefreshActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lQueryHostname, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lQueryHostname.text"));
        this.tfQueryHostname.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryHostname.text"));
        this.tfQueryHostname.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryHostname.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.lStart, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lStart.text"));
        Mnemonics.setLocalizedText((JLabel)this.lFinish, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lFinish.text"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 190, Short.MAX_VALUE).addComponent(this.bRefresh, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lLoading, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lQueryHostname).addComponent(this.lQueryDomain)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfQueryHostname).addComponent(this.tfQueryDomain)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.lStart)).addComponent(this.lFinish)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dtpTimeStart, -2, -1, -2).addComponent((Component)this.dtpTimeFinish, -2, -1, -2)))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, 27, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.lLoading, GroupLayout.Alignment.TRAILING, -2, 27, -2).addComponent(this.bRefresh, GroupLayout.Alignment.TRAILING, -2, 27, -2))).addGap(51, 51, 51).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lStart).addComponent((Component)this.dtpTimeStart, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dtpTimeFinish, -2, -1, -2).addComponent(this.lFinish))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfQueryHostname, -2, -1, -2).addComponent(this.lQueryHostname)).addGap(7, 7, 7).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfQueryDomain, -2, -1, -2).addComponent(this.lQueryDomain)))).addContainerGap(8, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel2.text"));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        Mnemonics.setLocalizedText((AbstractButton)this.rbCustomDate, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.rbCustomDate.text"));
        Mnemonics.setLocalizedText((JLabel)this.lStart1, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lStart1.text"));
        Mnemonics.setLocalizedText((JLabel)this.lFinish1, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lFinish1.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbCustomDate).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.lStart1)).addComponent(this.lFinish1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.dtpTimeStartPastPeriod, -2, 1, Short.MAX_VALUE).addComponent((Component)this.dtpTimeFinishPastPeriod, -2, 165, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.rbCustomDate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lStart1).addComponent((Component)this.dtpTimeStartPastPeriod, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dtpTimeFinishPastPeriod, -2, -1, -2).addComponent(this.lFinish1)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setPreferredSize(new Dimension(228, 87));
        Mnemonics.setLocalizedText((AbstractButton)this.rbLastNDays, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.rbLastNDays.text"));
        Mnemonics.setLocalizedText((JLabel)this.lFinish2, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lFinish2.text"));
        this.cbLastNDays.setModel(new DefaultComboBoxModel<String>(new String[]{"7", "14", "21", "30", "60"}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel1.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.lFinish2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbLastNDays, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1)).addComponent(this.rbLastNDays)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.rbLastNDays).addGap(22, 22, 22).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lFinish2).addComponent(this.cbLastNDays, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((AbstractButton)this.tbHostnameActivity, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tbHostnameActivity.text"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.tbHostnameActivity).addGap(0, 111, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, 185, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tbHostnameActivity)).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, 97, Short.MAX_VALUE)).addContainerGap()));
        this.jPanel5.setPreferredSize(new Dimension(113, 148));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.lDelimeter, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lDelimeter.text"));
        this.tfDelimeter.setHorizontalAlignment(0);
        this.tfDelimeter.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfDelimeter.text"));
        this.tfDelimeter.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfDelimeter.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatisticsTopComponent.this.bExportActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.lDelimeter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfDelimeter, -2, 1, Short.MAX_VALUE)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.bExport, -1, 101, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 65, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lDelimeter).addComponent(this.tfDelimeter, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bExport).addContainerGap()));
        this.jSeparator3.setOrientation(1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 3, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, 3, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addGap(1, 1, 1)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tbPanel)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jSeparator3, -2, 140, -2)).addComponent(this.jPanel4, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1)).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jPanel5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbPanel, -1, 603, Short.MAX_VALUE).addContainerGap()));
    }

    private void bExportActionPerformed(ActionEvent evt) {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsPanel.export_progress.title"));
        SwingWorker<HostStatsCsvReport, Void> worker = new SwingWorker<HostStatsCsvReport, Void>(){

            @Override
            protected HostStatsCsvReport doInBackground() throws Exception {
                SourceStatisticsTopComponent.this.toggleLoading();
                try {
                    ph.start();
                    return SourceStatisticsTopComponent.this.apiService.hostCsvReport(SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getStartTime(), SourceStatisticsTopComponent.this.getFinishTime(), SourceStatisticsTopComponent.this.getDelimeter());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsTopComponent.this.toggleLoading();
                    ph.finish();
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                block18: {
                    try {
                        HostStatsCsvReport hostCsvReport = (HostStatsCsvReport)this.get();
                        String fileName = SourceStatisticsTopComponent.this.genFileName();
                        JFileChooser saveDialog = new JFileChooser();
                        saveDialog.setDialogTitle(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.saveDialog.title"));
                        saveDialog.setDialogType(1);
                        saveDialog.setSelectedFile(new File(fileName));
                        int actionDialog = saveDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
                        if (actionDialog == 0) {
                            File dfile = new File(saveDialog.getCurrentDirectory(), saveDialog.getSelectedFile().getName());
                            dfile.createNewFile();
                            try (FileOutputStream stream = new FileOutputStream(dfile);){
                                stream.write(hostCsvReport.getDataHandler());
                                break block18;
                            }
                        }
                        ph.finish();
                    }
                    catch (IOException | InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        SourceStatisticsTopComponent.this.toggleLoading();
                        ph.finish();
                    }
                }
            }
        };
        worker.execute();
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void startSearch() {
        final SwingWorker<HostStatsGuiReport, Void> worker1 = new SwingWorker<HostStatsGuiReport, Void>(){

            @Override
            protected HostStatsGuiReport doInBackground() throws Exception {
                try {
                    return SourceStatisticsTopComponent.this.apiService.hostGuiReport(SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getQueryDomain(), SourceStatisticsTopComponent.this.getStartPastPeriodTime(), SourceStatisticsTopComponent.this.getFinishPastPeriodTime());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    HostStatsGuiReport hostGuiReport = (HostStatsGuiReport)this.get();
                    List sumOfCountsPerHostname = hostGuiReport.getSumOfCountsPerHostname();
                    SourceStatisticsTopComponent.this.hostnamesActivityTableModel.update(sumOfCountsPerHostname, SourceStatisticsTopComponent.this.sumOfCountsPerHostnameTableModel.getData(), !SourceStatisticsTopComponent.this.tbHostnameActivity.isSelected());
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsTopComponent.this.toggleLoading();
                }
                finally {
                    SourceStatisticsTopComponent.this.toggleLoading();
                }
            }
        };
        SwingWorker<HostStatsGuiReport, Void> worker = new SwingWorker<HostStatsGuiReport, Void>(){

            @Override
            protected HostStatsGuiReport doInBackground() throws Exception {
                SourceStatisticsTopComponent.this.toggleLoading();
                try {
                    return SourceStatisticsTopComponent.this.apiService.hostGuiReport(SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getQueryDomain(), SourceStatisticsTopComponent.this.getStartTime(), SourceStatisticsTopComponent.this.getFinishTime());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsTopComponent.this.toggleLoading();
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    HostStatsGuiReport hostGuiReport = (HostStatsGuiReport)this.get();
                    SourceStatisticsTopComponent.this.overviewTableModel.update(hostGuiReport.getOverview());
                    List hostsPerDomain = hostGuiReport.getHostsPerDomain();
                    SourceStatisticsTopComponent.this.hostsPerDomainTablemodel.update(hostsPerDomain);
                    List sumOfCountsPerHostname = hostGuiReport.getSumOfCountsPerHostname();
                    SourceStatisticsTopComponent.this.sumOfCountsPerHostnameTableModel.update(sumOfCountsPerHostname);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    worker1.execute();
                }
            }
        };
        worker.execute();
    }

    public void componentOpened() {
        this.startSearch();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private class HostnamesActivity {
        List<HostStatsAggObject> inactiveHostnames;
        List<HostStatsAggObject> newActiveHostsList;

        public HostnamesActivity(List<HostStatsAggObject> inactiveHostnames, List<HostStatsAggObject> newActiveHostsList) {
            this.inactiveHostnames = inactiveHostnames;
            this.newActiveHostsList = newActiveHostsList;
        }

        public List<HostStatsAggObject> getInactiveHostnames() {
            return this.inactiveHostnames;
        }

        public List<HostStatsAggObject> getNewActiveHostsList() {
            return this.newActiveHostsList;
        }
    }
}

