/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.HostStatsAggObject;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableModel;

public class HostnamesActivityTableModel
extends DefaultTableModel {
    private final List<String> columns = Stream.of(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.host"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.domains"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.fqdns"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.numberOfEvents"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.firstActive"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.lastActive")).collect(Collectors.toList());
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());
    private List<HostStatsAggObject> newActiveHostsList = new ArrayList<HostStatsAggObject>();
    private List<HostStatsAggObject> inactiveHostsList = new ArrayList<HostStatsAggObject>();
    private List<HostStatsAggObject> newHostsList = new ArrayList<HostStatsAggObject>();
    private List<HostStatsAggObject> oldHostsList = new ArrayList<HostStatsAggObject>();
    private boolean showInactive = true;

    @Override
    public Object getValueAt(int row, int column) {
        HostStatsAggObject element = null;
        element = this.showInactive ? this.inactiveHostsList.get(row) : this.newActiveHostsList.get(row);
        switch (column) {
            case 0: {
                return element.getHost();
            }
            case 1: {
                return element.getDomains().stream().collect(Collectors.joining(";"));
            }
            case 2: {
                return element.getFqdns().stream().collect(Collectors.joining(";"));
            }
            case 3: {
                return element.getSum();
            }
            case 4: {
                return element.getHumanFirstActive();
            }
            case 5: {
                return element.getHumanLastActive();
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"TableModel.columnName.unknown"));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        if (this.showInactive) {
            return this.inactiveHostsList == null ? 0 : this.inactiveHostsList.size();
        }
        return this.newActiveHostsList == null ? 0 : this.newActiveHostsList.size();
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"TableModel.columnName.unknown"));
    }

    public void setShowInactive(boolean showInactive) {
        this.showInactive = showInactive;
        this.fireTableDataChanged();
    }

    public void update(List<HostStatsAggObject> oldHosts, List<HostStatsAggObject> newHosts, boolean showInactive) {
        boolean isExists;
        this.oldHostsList = oldHosts;
        this.newHostsList = newHosts;
        this.newActiveHostsList.clear();
        this.inactiveHostsList.clear();
        for (HostStatsAggObject hOld : this.oldHostsList) {
            isExists = false;
            for (HostStatsAggObject hNew : this.newHostsList) {
                if (!hOld.getHost().equals(hNew.getHost())) continue;
                isExists = true;
                break;
            }
            if (isExists) continue;
            this.inactiveHostsList.add(hOld);
        }
        for (HostStatsAggObject hNew : this.newHostsList) {
            isExists = false;
            for (HostStatsAggObject hOld : this.oldHostsList) {
                if (!hNew.getHost().equals(hOld.getHost())) continue;
                isExists = true;
                break;
            }
            if (isExists) continue;
            this.newActiveHostsList.add(hNew);
        }
        this.fireTableDataChanged();
    }
}

