/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import rs.co.ast.aspen.gui.module.datamaps.DataMapDataSource;
import rs.co.ast.aspen.gui.module.datamaps.DataMapName;
import rs.co.ast.aspen.gui.module.datamaps.ExportHelper;
import rs.co.ast.aspen.gui.module.datamaps.UniqueFildsPreferences;

public class ExportEnterFieldsPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(ExportEnterFieldsPanel.class.getName());
    private final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ExportEnterFieldsPanel.class, (String)"unique.fields.progress.title"));
    private final RequestProcessor req = new RequestProcessor("get_fields_thread", 1, true);
    private final UniqueFildsPreferences ufp = new UniqueFildsPreferences();
    private final DataMapName dataMapName;
    private JButton bGetFields;
    private JCheckBox cbMultipleWorksheets;
    private JLabel jLabel1;
    private JLabel lCSVSeparator;
    private JTextField tfCSVSeparator;
    private JTextField tfFields;

    public ExportEnterFieldsPanel(DataMapName dataMapName, boolean multipleRowsEnabled) {
        this.initComponents();
        this.dataMapName = dataMapName;
        this.cbMultipleWorksheets.setEnabled(multipleRowsEnabled);
        this.tfFields.setText(this.ufp.readUniqueFields());
        this.tfCSVSeparator.setEnabled(!multipleRowsEnabled);
        this.lCSVSeparator.setEnabled(!multipleRowsEnabled);
    }

    public List<String> getFields() {
        ArrayList<String> fields = new ArrayList<String>();
        if (!this.tfFields.getText().isEmpty()) {
            Pattern pattern = Pattern.compile("\\w+", 2);
            Matcher matcher = pattern.matcher(this.tfFields.getText());
            while (matcher.find()) {
                fields.add(matcher.group());
            }
        }
        return fields;
    }

    public boolean useMultipleWorkSheets() {
        return this.cbMultipleWorksheets.isSelected();
    }

    public boolean areThereAnyFields() {
        return this.getFields().isEmpty();
    }

    public String getSeparator() {
        return this.tfCSVSeparator.getText().isEmpty() ? ";" : this.tfCSVSeparator.getText();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.tfFields = new JTextField();
        this.bGetFields = new JButton();
        this.cbMultipleWorksheets = new JCheckBox();
        this.lCSVSeparator = new JLabel();
        this.tfCSVSeparator = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ExportEnterFieldsPanel.class, (String)"ExportEnterFieldsPanel.jLabel1.text"));
        this.tfFields.setColumns(1);
        this.tfFields.setText(NbBundle.getMessage(ExportEnterFieldsPanel.class, (String)"ExportEnterFieldsPanel.tfFields.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bGetFields, (String)NbBundle.getMessage(ExportEnterFieldsPanel.class, (String)"ExportEnterFieldsPanel.bGetFields.text"));
        this.bGetFields.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportEnterFieldsPanel.this.bGetFieldsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbMultipleWorksheets, (String)NbBundle.getMessage(ExportEnterFieldsPanel.class, (String)"ExportEnterFieldsPanel.cbMultipleWorksheets.text"));
        Mnemonics.setLocalizedText((JLabel)this.lCSVSeparator, (String)NbBundle.getMessage(ExportEnterFieldsPanel.class, (String)"ExportEnterFieldsPanel.lCSVSeparator.text"));
        this.tfCSVSeparator.setText(NbBundle.getMessage(ExportEnterFieldsPanel.class, (String)"ExportEnterFieldsPanel.tfCSVSeparator.text"));
        this.tfCSVSeparator.setToolTipText(NbBundle.getMessage(ExportEnterFieldsPanel.class, (String)"ExportEnterFieldsPanel.tfCSVSeparator.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfFields).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bGetFields).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.cbMultipleWorksheets, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lCSVSeparator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfCSVSeparator, -2, 50, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.bGetFields)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfFields, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbMultipleWorksheets).addComponent(this.lCSVSeparator).addComponent(this.tfCSVSeparator, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void bGetFieldsActionPerformed(ActionEvent evt) {
        this.req.execute(new Runnable(){

            @Override
            public void run() {
                ExportEnterFieldsPanel.this.bGetFields.setEnabled(false);
                ExportEnterFieldsPanel.this.ph.start();
                ExportEnterFieldsPanel.this.ph.switchToIndeterminate();
                DataMapDataSource ds = new DataMapDataSource(ExportEnterFieldsPanel.this.dataMapName, null);
                List<String> uniqueFields = ExportHelper.getAllUniqueFields(ds.getDataMapKeys());
                if (uniqueFields != null) {
                    ExportEnterFieldsPanel.this.tfFields.setText(ExportEnterFieldsPanel.this.ufp.uniqueFieldsAsString(uniqueFields));
                }
                ExportEnterFieldsPanel.this.ph.finish();
                ExportEnterFieldsPanel.this.bGetFields.setEnabled(true);
            }
        });
    }
}

