/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ChangeType;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptEditorTableModel;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdate;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdatedEvent;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdatedEventListener;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdatedListenerSupport;

public class DiffPanel
extends JPanel {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final ScriptUpdatedListenerSupport scriptUpdatedSupport = new ScriptUpdatedListenerSupport();
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private ScriptUpdate script;
    private List<ScriptUpdate> scripts;
    private JButton bDelete;
    private JButton bUpdate;
    private JButton bUpdateAll;
    private JPanel pContainer;

    public DiffPanel() {
        this.initComponents();
        this.pContainer.setLayout(new BorderLayout());
    }

    public void addComponent(Component component) {
        this.pContainer.add(component, "Center");
        this.pContainer.invalidate();
        this.pContainer.revalidate();
        this.pContainer.repaint();
    }

    public void removeAllComponents() {
        this.pContainer.removeAll();
        this.pContainer.invalidate();
        this.pContainer.revalidate();
        this.pContainer.repaint();
    }

    public void setScript(ScriptUpdate script) {
        this.script = script;
        if (script.getChangeType() == ChangeType.RED) {
            this.bUpdate.setEnabled(false);
            this.bUpdateAll.setEnabled(false);
        } else {
            this.bUpdate.setEnabled(true);
            this.bUpdateAll.setEnabled(true);
        }
        if (script.getChangeType() == ChangeType.GREEN) {
            this.bDelete.setEnabled(false);
        } else {
            this.bDelete.setEnabled(true);
        }
    }

    public void setScripts(List<ScriptUpdate> scripts) {
        this.scripts = scripts;
    }

    private Script scriptUpdateToScript(ScriptUpdate su) {
        Script s = new Script();
        s.setId(su.getId());
        s.setDescription(su.getDescription());
        s.setEnabled(su.isEnabled());
        s.setHash(su.getHash());
        s.setLanguage(su.getLanguage());
        s.setName(su.getName());
        if (su.getChangeType() == ChangeType.GREEN) {
            s.setOrder(-1L);
        } else {
            s.setOrder(su.getOrder());
        }
        s.setPrevScript(su.getPrevScript());
        s.setScript(su.getScript());
        s.setType(su.getType());
        s.setVersion(su.getVersion());
        return s;
    }

    private void initComponents() {
        this.pContainer = new JPanel();
        this.bUpdate = new JButton();
        this.bUpdateAll = new JButton();
        this.bDelete = new JButton();
        GroupLayout pContainerLayout = new GroupLayout(this.pContainer);
        this.pContainer.setLayout(pContainerLayout);
        pContainerLayout.setHorizontalGroup(pContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pContainerLayout.setVerticalGroup(pContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 251, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.bUpdate, (String)NbBundle.getMessage(DiffPanel.class, (String)"DiffPanel.bUpdate.text"));
        this.bUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffPanel.this.bUpdateActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bUpdateAll, (String)NbBundle.getMessage(DiffPanel.class, (String)"DiffPanel.bUpdateAll.text"));
        this.bUpdateAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffPanel.this.bUpdateAllActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bDelete, (String)NbBundle.getMessage(DiffPanel.class, (String)"DiffPanel.bDelete.text"));
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffPanel.this.bDeleteActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pContainer, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.bUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bUpdateAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bDelete).addContainerGap(99, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pContainer, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bUpdate).addComponent(this.bUpdateAll).addComponent(this.bDelete)).addContainerGap()));
    }

    private void bUpdateActionPerformed(ActionEvent evt) {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Script s = DiffPanel.this.scriptUpdateToScript(DiffPanel.this.script);
                if (s.getOrder() != -1L) {
                    DiffPanel.this.apiService.updateScript(s);
                } else {
                    DiffPanel.this.apiService.createScriptWithText(s.getName(), s.getScript(), s.getLanguage(), s.getDescription(), s.getType());
                }
                return null;
            }

            @Override
            protected void done() {
                DiffPanel.this.scriptUpdatedSupport.fireScriptUpdatedEventListener(new ScriptUpdatedEvent(this));
            }
        };
        worker.execute();
    }

    private void bUpdateAllActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ScriptEditorTableModel.class, (String)"UpdateAllScriptsConfirmation.message"), NbBundle.getMessage(ScriptEditorTableModel.class, (String)"UpdateAllScriptsConfirmation.title"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
            this.scriptUpdatedSupport.fireRecoverBeforeScriptUpdatedEventListener(new ScriptUpdatedEvent(this));
            this.bUpdate.setEnabled(false);
            this.bUpdateAll.setEnabled(false);
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    if (DiffPanel.this.scripts != null) {
                        ArrayList<Script> forUpdate = new ArrayList<Script>();
                        for (ScriptUpdate su : DiffPanel.this.scripts) {
                            Script s = DiffPanel.this.scriptUpdateToScript(su);
                            if (s.getOrder() != -1L) {
                                forUpdate.add(s);
                                continue;
                            }
                            DiffPanel.this.apiService.createScriptWithText(s.getName(), s.getScript(), s.getLanguage(), s.getDescription(), s.getType());
                        }
                        DiffPanel.this.apiService.updateScripts(forUpdate);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    DiffPanel.this.scriptUpdatedSupport.fireScriptUpdatedEventListener(new ScriptUpdatedEvent(this));
                    DiffPanel.this.bUpdate.setEnabled(true);
                    DiffPanel.this.bUpdateAll.setEnabled(true);
                }
            };
            worker.execute();
        }
    }

    private void bDeleteActionPerformed(ActionEvent evt) {
        if (this.script != null && this.script.getChangeType() != ChangeType.GREEN) {
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.message"), NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.title"), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                try {
                    if (this.script.getType() == ScriptType.SCHEDULED) {
                        this.apiService.deleteTask(this.script.getId());
                    }
                    this.apiService.deleteScript(this.script.getId());
                    this.scriptUpdatedSupport.fireScriptUpdatedEventListener(new ScriptUpdatedEvent(this));
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public void addScriptUpdatedEventListener(ScriptUpdatedEventListener listener) {
        this.scriptUpdatedSupport.addScriptUpdatedEventListener(listener);
    }

    public void removeScriptUpdatedEventListener(ScriptUpdatedEventListener listener) {
        this.scriptUpdatedSupport.removeScriptUpdatedEventListener(listener);
    }

    public void fireScriptUpdatedEventListener(ScriptUpdatedEvent event) {
        this.scriptUpdatedSupport.fireScriptUpdatedEventListener(event);
    }
}

