/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.shader.ShaderNodeDefinition;
import com.jme3.shader.VariableMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ShaderNode
implements Savable,
Cloneable {
    private String name;
    private ShaderNodeDefinition definition;
    private String condition;
    private List<VariableMapping> inputMapping = new ArrayList<VariableMapping>();
    private List<VariableMapping> outputMapping = new ArrayList<VariableMapping>();

    public ShaderNode(String name, ShaderNodeDefinition definition, String condition) {
        this.name = name;
        this.definition = definition;
        this.condition = condition;
    }

    public ShaderNode() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ShaderNodeDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(ShaderNodeDefinition definition) {
        this.definition = definition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public List<VariableMapping> getInputMapping() {
        return this.inputMapping;
    }

    public void setInputMapping(List<VariableMapping> inputMapping) {
        this.inputMapping = inputMapping;
    }

    public List<VariableMapping> getOutputMapping() {
        return this.outputMapping;
    }

    public void setOutputMapping(List<VariableMapping> outputMapping) {
        this.outputMapping = outputMapping;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", "");
        oc.write(this.definition, "definition", null);
        oc.write(this.condition, "condition", null);
        oc.writeSavableArrayList((ArrayList)this.inputMapping, "inputMapping", new ArrayList());
        oc.writeSavableArrayList((ArrayList)this.outputMapping, "outputMapping", new ArrayList());
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", "");
        this.definition = (ShaderNodeDefinition)ic.readSavable("definition", null);
        this.condition = ic.readString("condition", null);
        this.inputMapping = ic.readSavableArrayList("inputMapping", new ArrayList());
        this.outputMapping = ic.readSavableArrayList("outputMapping", new ArrayList());
    }

    public String toString() {
        return "\nShaderNode{\nname=" + this.name + ", \ndefinition=" + this.definition.getName() + ", \ncondition=" + this.condition + ", \ninputMapping=" + this.inputMapping + ", \noutputMapping=" + this.outputMapping + '}';
    }

    public ShaderNode clone() throws CloneNotSupportedException {
        ShaderNode clone = (ShaderNode)super.clone();
        clone.definition = this.definition;
        clone.inputMapping = new ArrayList<VariableMapping>();
        for (VariableMapping variableMapping : this.inputMapping) {
            clone.inputMapping.add(variableMapping.clone());
        }
        clone.outputMapping = new ArrayList<VariableMapping>();
        for (VariableMapping variableMapping : this.outputMapping) {
            clone.outputMapping.add(variableMapping.clone());
        }
        return clone;
    }
}

