/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.TextureKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import java.io.IOException;

public class MatParam
implements Savable,
Cloneable {
    protected VarType type;
    protected String name;
    protected String prefixedName;
    protected Object value;

    public MatParam(VarType type, String name, Object value) {
        this.type = type;
        this.name = name;
        this.prefixedName = "m_" + name;
        this.value = value;
    }

    public MatParam() {
    }

    public VarType getVarType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefixedName() {
        return this.prefixedName;
    }

    void setName(String name) {
        this.name = name;
        this.prefixedName = "m_" + name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getValueAsString() {
        switch (this.type) {
            case Boolean: 
            case Float: 
            case Int: {
                return this.value.toString();
            }
            case Vector2: {
                Vector2f v2 = (Vector2f)this.value;
                return v2.getX() + " " + v2.getY();
            }
            case Vector3: {
                Vector3f v3 = (Vector3f)this.value;
                return v3.getX() + " " + v3.getY() + " " + v3.getZ();
            }
            case Vector4: {
                if (this.value instanceof Vector4f) {
                    Vector4f v4 = (Vector4f)this.value;
                    return v4.getX() + " " + v4.getY() + " " + v4.getZ() + " " + v4.getW();
                }
                if (this.value instanceof ColorRGBA) {
                    ColorRGBA color = (ColorRGBA)this.value;
                    return color.getRed() + " " + color.getGreen() + " " + color.getBlue() + " " + color.getAlpha();
                }
                if (this.value instanceof Quaternion) {
                    Quaternion quat = (Quaternion)this.value;
                    return quat.getX() + " " + quat.getY() + " " + quat.getZ() + " " + quat.getW();
                }
                throw new UnsupportedOperationException("Unexpected Vector4 type: " + this.value);
            }
            case Texture2D: 
            case Texture3D: 
            case TextureArray: 
            case TextureBuffer: 
            case TextureCubeMap: {
                Texture texVal = (Texture)this.value;
                TextureKey texKey = (TextureKey)texVal.getKey();
                if (texKey == null) {
                    return texVal + ":returned null key";
                }
                String ret = "";
                if (texKey.isFlipY()) {
                    ret = ret + "Flip ";
                }
                ret = ret + this.getWrapMode(texVal, Texture.WrapAxis.S);
                ret = ret + this.getWrapMode(texVal, Texture.WrapAxis.T);
                ret = ret + this.getWrapMode(texVal, Texture.WrapAxis.R);
                Texture.MinFilter def = Texture.MinFilter.BilinearNoMipMaps;
                if (texVal.getImage().hasMipmaps() || texKey.isGenerateMips()) {
                    def = Texture.MinFilter.Trilinear;
                }
                if (texVal.getMinFilter() != def) {
                    ret = ret + "Min" + texVal.getMinFilter().name() + " ";
                }
                if (texVal.getMagFilter() != Texture.MagFilter.Bilinear) {
                    ret = ret + "Mag" + texVal.getMagFilter().name() + " ";
                }
                return ret + "\"" + texKey.getName() + "\"";
            }
        }
        return null;
    }

    private String getWrapMode(Texture texVal, Texture.WrapAxis axis) {
        Texture.WrapMode mode = Texture.WrapMode.EdgeClamp;
        try {
            mode = texVal.getWrap(axis);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        if (mode != Texture.WrapMode.EdgeClamp) {
            return "Wrap" + mode.name() + "_" + axis.name() + " ";
        }
        return "";
    }

    public MatParam clone() {
        try {
            MatParam param = (MatParam)super.clone();
            return param;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.type, "varType", null);
        oc.write(this.name, "name", null);
        if (this.value == null) {
            return;
        }
        if (this.value instanceof Savable) {
            oc.write((Savable)this.value, "value_savable", null);
        } else if (this.value instanceof Float) {
            oc.write(((Float)this.value).floatValue(), "value_float", 0.0f);
        } else if (this.value instanceof Integer) {
            oc.write((Integer)this.value, "value_int", 0);
        } else if (this.value instanceof Boolean) {
            oc.write((Boolean)this.value, "value_bool", false);
        } else if (this.value.getClass().isArray() && this.value instanceof Savable[]) {
            oc.write((Savable[])this.value, "value_savable_array", null);
        }
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.type = ic.readEnum("varType", VarType.class, null);
        this.name = ic.readString("name", null);
        this.prefixedName = "m_" + this.name;
        switch (this.getVarType()) {
            case Boolean: {
                this.value = ic.readBoolean("value_bool", false);
                break;
            }
            case Float: {
                this.value = Float.valueOf(ic.readFloat("value_float", 0.0f));
                break;
            }
            case Int: {
                this.value = ic.readInt("value_int", 0);
                break;
            }
            case Vector2Array: {
                Savable[] savableArray = ic.readSavableArray("value_savable_array", null);
                if (savableArray == null) break;
                this.value = new Vector2f[savableArray.length];
                System.arraycopy(savableArray, 0, this.value, 0, savableArray.length);
                break;
            }
            case Vector3Array: {
                Savable[] savableArray = ic.readSavableArray("value_savable_array", null);
                if (savableArray == null) break;
                this.value = new Vector3f[savableArray.length];
                System.arraycopy(savableArray, 0, this.value, 0, savableArray.length);
                break;
            }
            case Vector4Array: {
                Savable[] savableArray = ic.readSavableArray("value_savable_array", null);
                if (savableArray == null) break;
                this.value = new Vector4f[savableArray.length];
                System.arraycopy(savableArray, 0, this.value, 0, savableArray.length);
                break;
            }
            case Matrix3Array: {
                Savable[] savableArray = ic.readSavableArray("value_savable_array", null);
                if (savableArray == null) break;
                this.value = new Matrix3f[savableArray.length];
                System.arraycopy(savableArray, 0, this.value, 0, savableArray.length);
                break;
            }
            case Matrix4Array: {
                Savable[] savableArray = ic.readSavableArray("value_savable_array", null);
                if (savableArray == null) break;
                this.value = new Matrix4f[savableArray.length];
                System.arraycopy(savableArray, 0, this.value, 0, savableArray.length);
                break;
            }
            default: {
                this.value = ic.readSavable("value_savable", null);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatParam other = (MatParam)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.value == other.value || this.value != null && this.value.equals(other.value);
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 59 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    public String toString() {
        if (this.value != null) {
            return this.type.name() + " " + this.name + " : " + this.getValueAsString();
        }
        return this.type.name() + " " + this.name;
    }
}

