/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingSphere;
import com.jme3.light.Light;
import com.jme3.light.LightFilter;
import com.jme3.light.LightList;
import com.jme3.light.LightProbe;
import com.jme3.light.PoiLightProbeLightFilter;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Spatial;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.TempVars;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LightProbeBlendingProcessor
implements SceneProcessor {
    private ViewPort viewPort;
    private LightFilter prevFilter;
    private RenderManager renderManager;
    private LightProbe probe = new LightProbe();
    private Spatial poi;
    private AppProfiler prof;

    public LightProbeBlendingProcessor(Spatial poi) {
        this.poi = poi;
    }

    @Override
    public void initialize(RenderManager rm, ViewPort vp) {
        this.viewPort = vp;
        this.renderManager = rm;
        this.prevFilter = rm.getLightFilter();
        rm.setLightFilter(new PoiLightProbeLightFilter(this));
    }

    @Override
    public void reshape(ViewPort vp, int w, int h) {
    }

    @Override
    public boolean isInitialized() {
        return this.viewPort != null;
    }

    @Override
    public void preFrame(float tpf) {
    }

    @Override
    public void postQueue(RenderQueue rq) {
        ArrayList<BlendFactor> blendFactors = new ArrayList<BlendFactor>();
        float sumBlendFactors = this.computeBlendFactors(blendFactors);
        Collections.sort(blendFactors);
        float normalizer = 1.0f / sumBlendFactors;
        for (BlendFactor blendFactor : blendFactors) {
            blendFactor.ndf *= normalizer;
        }
        this.probe = !blendFactors.isEmpty() ? ((BlendFactor)blendFactors.get((int)0)).lightProbe : null;
    }

    private float computeBlendFactors(List<BlendFactor> blendFactors) {
        float sumBlendFactors = 0.0f;
        for (Spatial scene : this.viewPort.getScenes()) {
            for (Light light : scene.getWorldLightList()) {
                if (light.getType() != Light.Type.Probe) continue;
                LightProbe p = (LightProbe)light;
                TempVars vars = TempVars.get();
                boolean intersect = p.intersectsFrustum(this.viewPort.getCamera(), vars);
                vars.release();
                if (!intersect || !this.poi.getWorldBound().intersects(p.getBounds())) continue;
                float outerRadius = ((BoundingSphere)p.getBounds()).getRadius();
                float innerRadius = outerRadius * 0.5f;
                float distance = p.getBounds().getCenter().distance(this.poi.getWorldTranslation());
                if (distance < innerRadius) {
                    blendFactors.clear();
                    blendFactors.add(new BlendFactor(p, 1.0f));
                    return 1.0f;
                }
                float ndf = (distance - innerRadius) / (outerRadius - innerRadius);
                sumBlendFactors += ndf;
                blendFactors.add(new BlendFactor(p, ndf));
            }
        }
        return sumBlendFactors;
    }

    @Override
    public void postFrame(FrameBuffer out) {
    }

    @Override
    public void cleanup() {
        this.viewPort = null;
        this.renderManager.setLightFilter(this.prevFilter);
    }

    public void populateProbe(LightList lightList) {
        if (this.probe != null && this.probe.isReady()) {
            lightList.add(this.probe);
        }
    }

    public Spatial getPoi() {
        return this.poi;
    }

    public void setPoi(Spatial poi) {
        this.poi = poi;
    }

    @Override
    public void setProfiler(AppProfiler profiler) {
        this.prof = profiler;
    }

    private class BlendFactor
    implements Comparable<BlendFactor> {
        LightProbe lightProbe;
        float ndf;

        public BlendFactor(LightProbe lightProbe, float ndf) {
            this.lightProbe = lightProbe;
            this.ndf = ndf;
        }

        public String toString() {
            return "BlendFactor{lightProbe=" + this.lightProbe + ", ndf=" + this.ndf + '}';
        }

        @Override
        public int compareTo(BlendFactor o) {
            if (o.ndf > this.ndf) {
                return -1;
            }
            if (o.ndf < this.ndf) {
                return 1;
            }
            return 0;
        }
    }
}

