/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.animation.Animation;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.ModelKey;
import com.jme3.asset.StreamAssetInfo;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.post.filters.FogFilter;
import com.jme3.renderer.Camera;
import com.jme3.scene.CameraNode;
import com.jme3.scene.LightNode;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.AnimationHelper;
import com.jme3.scene.plugins.blender.cameras.CameraHelper;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.curves.CurvesHelper;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.landscape.LandscapeHelper;
import com.jme3.scene.plugins.blender.lights.LightHelper;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.modifiers.ModifierHelper;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import com.jme3.scene.plugins.blender.particles.ParticlesHelper;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Texture;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlenderLoader
implements AssetLoader {
    private static final Logger LOGGER = Logger.getLogger(BlenderLoader.class.getName());

    public Spatial load(AssetInfo assetInfo) throws IOException {
        try {
            BlenderContext blenderContext = this.setup(assetInfo);
            AnimationHelper animationHelper = (AnimationHelper)blenderContext.getHelper(AnimationHelper.class);
            animationHelper.loadAnimations();
            BlenderKey blenderKey = blenderContext.getBlenderKey();
            LoadedFeatures loadedFeatures = new LoadedFeatures();
            block16: for (FileBlockHeader fileBlockHeader : blenderContext.getBlocks()) {
                switch (fileBlockHeader.getCode()) {
                    case BLOCK_OB00: {
                        ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
                        Node object = (Node)objectHelper.toObject(fileBlockHeader.getStructure(blenderContext), blenderContext);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "{0}: {1}--> {2}", new Object[]{object.getName(), object.getLocalTranslation().toString(), object.getParent() == null ? "null" : object.getParent().getName()});
                        }
                        if (object.getParent() == null) {
                            loadedFeatures.objects.add(object);
                        }
                        if (object instanceof LightNode && ((LightNode)object).getLight() != null) {
                            loadedFeatures.lights.add(((LightNode)object).getLight());
                            break;
                        }
                        if (!(object instanceof CameraNode) || ((CameraNode)object).getCamera() == null) continue block16;
                        loadedFeatures.cameras.add(((CameraNode)object).getCamera());
                        break;
                    }
                    case BLOCK_SC00: {
                        loadedFeatures.sceneBlocks.add(fileBlockHeader);
                        break;
                    }
                    case BLOCK_MA00: {
                        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
                        MaterialContext materialContext = materialHelper.toMaterialContext(fileBlockHeader.getStructure(blenderContext), blenderContext);
                        loadedFeatures.materials.add(materialContext);
                        break;
                    }
                    case BLOCK_ME00: {
                        MeshHelper meshHelper = (MeshHelper)blenderContext.getHelper(MeshHelper.class);
                        TemporalMesh temporalMesh = meshHelper.toTemporalMesh(fileBlockHeader.getStructure(blenderContext), blenderContext);
                        loadedFeatures.meshes.add(temporalMesh);
                        break;
                    }
                    case BLOCK_IM00: {
                        TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
                        Texture image = textureHelper.loadImageAsTexture(fileBlockHeader.getStructure(blenderContext), 0, blenderContext);
                        if (image == null || image.getImage() == null) continue block16;
                        loadedFeatures.images.add(image);
                        break;
                    }
                    case BLOCK_TE00: {
                        Structure textureStructure = fileBlockHeader.getStructure(blenderContext);
                        int type = ((Number)textureStructure.getFieldValue("type")).intValue();
                        if (type == 8) {
                            TextureHelper texHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
                            Texture texture = texHelper.getTexture(textureStructure, null, blenderContext);
                            if (texture == null) continue block16;
                            loadedFeatures.textures.add(texture);
                            break;
                        }
                        LOGGER.fine("Only image textures can be loaded as unlinked assets. Generated textures will be applied to an existing object.");
                        break;
                    }
                    case BLOCK_WO00: {
                        LandscapeHelper landscapeHelper = (LandscapeHelper)blenderContext.getHelper(LandscapeHelper.class);
                        Structure worldStructure = fileBlockHeader.getStructure(blenderContext);
                        String worldName = worldStructure.getName();
                        if (blenderKey.getUsedWorld() != null && !blenderKey.getUsedWorld().equals(worldName)) continue block16;
                        Light ambientLight = landscapeHelper.toAmbientLight(worldStructure);
                        if (ambientLight != null) {
                            loadedFeatures.objects.add(new LightNode(null, ambientLight));
                            loadedFeatures.lights.add(ambientLight);
                        }
                        loadedFeatures.sky = landscapeHelper.toSky(worldStructure);
                        loadedFeatures.backgroundColor = landscapeHelper.toBackgroundColor(worldStructure);
                        FogFilter fogFilter = landscapeHelper.toFog(worldStructure);
                        if (fogFilter == null) continue block16;
                        loadedFeatures.filters.add(landscapeHelper.toFog(worldStructure));
                        break;
                    }
                    case BLOCK_AC00: {
                        LOGGER.fine("Loading unlinked animations is not yet supported!");
                        break;
                    }
                    default: {
                        LOGGER.log(Level.FINEST, "Ommiting the block: {0}.", (Object)fileBlockHeader.getCode());
                    }
                }
            }
            LOGGER.fine("Baking constraints after every feature is loaded.");
            ConstraintHelper constraintHelper = (ConstraintHelper)blenderContext.getHelper(ConstraintHelper.class);
            constraintHelper.bakeConstraints(blenderContext);
            LOGGER.fine("Loading scenes and attaching them to the root object.");
            for (Object sceneBlock : loadedFeatures.sceneBlocks) {
                loadedFeatures.scenes.add(this.toScene(((FileBlockHeader)sceneBlock).getStructure(blenderContext), blenderContext));
            }
            LOGGER.fine("Creating the root node of the model and applying loaded nodes of the scene and loaded features to it.");
            Node node = new Node(blenderKey.getName());
            for (Node scene : loadedFeatures.scenes) {
                node.attachChild((Spatial)scene);
            }
            if (blenderKey.isLoadUnlinkedAssets()) {
                LOGGER.fine("Setting loaded content as user data in resulting sptaial.");
                HashMap<String, Map<Object, Object>> linkedData = new HashMap<String, Map<Object, Object>>();
                HashMap thisFileData = new HashMap();
                thisFileData.put("scenes", loadedFeatures.scenes == null ? new ArrayList() : loadedFeatures.scenes);
                thisFileData.put("objects", loadedFeatures.objects == null ? new ArrayList() : loadedFeatures.objects);
                thisFileData.put("meshes", loadedFeatures.meshes == null ? new ArrayList() : loadedFeatures.meshes);
                thisFileData.put("materials", loadedFeatures.materials == null ? new ArrayList() : loadedFeatures.materials);
                thisFileData.put("textures", loadedFeatures.textures == null ? new ArrayList() : loadedFeatures.textures);
                thisFileData.put("images", loadedFeatures.images == null ? new ArrayList() : loadedFeatures.images);
                thisFileData.put("animations", loadedFeatures.animations == null ? new ArrayList() : loadedFeatures.animations);
                thisFileData.put("cameras", loadedFeatures.cameras == null ? new ArrayList() : loadedFeatures.cameras);
                thisFileData.put("lights", loadedFeatures.lights == null ? new ArrayList() : loadedFeatures.lights);
                thisFileData.put("filters", loadedFeatures.filters == null ? new ArrayList() : loadedFeatures.filters);
                thisFileData.put("backgroundColor", loadedFeatures.backgroundColor);
                thisFileData.put("sky", loadedFeatures.sky);
                linkedData.put("this", thisFileData);
                linkedData.putAll(blenderContext.getLinkedFeatures());
                node.setUserData("linkedData", linkedData);
            }
            Node node2 = node;
            return node2;
        }
        catch (BlenderFileException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            throw new IOException("Unexpected importer exception occured: " + e.getLocalizedMessage(), e);
        }
        finally {
            this.clear(assetInfo);
        }
    }

    private Node toScene(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
        Node result = new Node(structure.getName());
        List<Structure> base = ((Structure)structure.getFieldValue("base")).evaluateListBase();
        for (Structure b : base) {
            Pointer pObject = (Pointer)b.getFieldValue("object");
            if (!pObject.isNotNull()) continue;
            Structure objectStructure = pObject.fetchData().get(0);
            Object object = objectHelper.toObject(objectStructure, blenderContext);
            if (object instanceof LightNode) {
                result.addLight(((LightNode)object).getLight());
                result.attachChild((Spatial)((LightNode)object));
                continue;
            }
            if (!(object instanceof Node)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "{0}: {1}--> {2}", new Object[]{((Node)object).getName(), ((Node)object).getLocalTranslation().toString(), ((Node)object).getParent() == null ? "null" : ((Node)object).getParent().getName()});
            }
            if (((Node)object).getParent() != null) continue;
            result.attachChild((Spatial)object);
        }
        return result;
    }

    protected BlenderContext setup(AssetInfo assetInfo) throws BlenderFileException {
        FileBlockHeader fileBlock;
        ModelKey modelKey = (ModelKey)assetInfo.getKey();
        BlenderKey blenderKey = modelKey instanceof BlenderKey ? (BlenderKey)modelKey : new BlenderKey(modelKey.getName());
        BlenderInputStream inputStream = new BlenderInputStream(assetInfo.openStream());
        ArrayList<FileBlockHeader> blocks = new ArrayList<FileBlockHeader>();
        BlenderContext blenderContext = new BlenderContext();
        blenderContext.setBlenderVersion(inputStream.getVersionNumber());
        blenderContext.setAssetManager(assetInfo.getManager());
        blenderContext.setInputStream(inputStream);
        blenderContext.setBlenderKey(blenderKey);
        blenderContext.putHelper(AnimationHelper.class, new AnimationHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(TextureHelper.class, new TextureHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(MeshHelper.class, new MeshHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(ObjectHelper.class, new ObjectHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(CurvesHelper.class, new CurvesHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(LightHelper.class, new LightHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(CameraHelper.class, new CameraHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(ModifierHelper.class, new ModifierHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(MaterialHelper.class, new MaterialHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(ConstraintHelper.class, new ConstraintHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(ParticlesHelper.class, new ParticlesHelper(inputStream.getVersionNumber(), blenderContext));
        blenderContext.putHelper(LandscapeHelper.class, new LandscapeHelper(inputStream.getVersionNumber(), blenderContext));
        FileBlockHeader sceneFileBlock = null;
        do {
            if ((fileBlock = new FileBlockHeader(inputStream, blenderContext)).isDnaBlock()) continue;
            blocks.add(fileBlock);
            if (fileBlock.getCode() != FileBlockHeader.BlockCode.BLOCK_SC00) continue;
            sceneFileBlock = fileBlock;
        } while (!fileBlock.isLastBlock());
        if (sceneFileBlock != null) {
            blenderContext.setSceneStructure(sceneFileBlock.getStructure(blenderContext));
        }
        assetInfo.getManager().registerLocator(assetInfo.getKey().getName(), LinkedContentLocator.class);
        return blenderContext;
    }

    protected void clear(AssetInfo assetInfo) {
        assetInfo.getManager().unregisterLocator(assetInfo.getKey().getName(), LinkedContentLocator.class);
    }

    public static class LinkedContentLocator
    implements AssetLocator {
        private File rootFolder;

        public void setRootPath(String rootPath) {
            this.rootFolder = new File(rootPath);
            if (this.rootFolder.isFile()) {
                this.rootFolder = this.rootFolder.getParentFile();
            }
        }

        public AssetInfo locate(AssetManager manager, AssetKey key) {
            if (key instanceof BlenderKey) {
                File linkedAbsoluteFile = new File(key.getName());
                if (linkedAbsoluteFile.exists() && linkedAbsoluteFile.isFile()) {
                    try {
                        return new StreamAssetInfo(manager, key, (InputStream)new FileInputStream(linkedAbsoluteFile));
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
                File linkedFileInCurrentAssetFolder = new File(this.rootFolder, linkedAbsoluteFile.getName());
                if (linkedFileInCurrentAssetFolder.exists() && linkedFileInCurrentAssetFolder.isFile()) {
                    try {
                        return new StreamAssetInfo(manager, key, (InputStream)new FileInputStream(linkedFileInCurrentAssetFolder));
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
                File linkedFileInCurrentFolder = new File(".", linkedAbsoluteFile.getName());
                if (linkedFileInCurrentFolder.exists() && linkedFileInCurrentFolder.isFile()) {
                    try {
                        return new StreamAssetInfo(manager, key, (InputStream)new FileInputStream(linkedFileInCurrentFolder));
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
            }
            return null;
        }
    }

    private static class LoadedFeatures {
        private List<FileBlockHeader> sceneBlocks = new ArrayList<FileBlockHeader>();
        private List<Node> scenes = new ArrayList<Node>();
        private List<Node> objects = new ArrayList<Node>();
        private List<TemporalMesh> meshes = new ArrayList<TemporalMesh>();
        private List<MaterialContext> materials = new ArrayList<MaterialContext>();
        private List<Texture> textures = new ArrayList<Texture>();
        private List<Texture> images = new ArrayList<Texture>();
        private List<Animation> animations = new ArrayList<Animation>();
        private List<Camera> cameras = new ArrayList<Camera>();
        private List<Light> lights = new ArrayList<Light>();
        private Spatial sky;
        private List<Filter> filters = new ArrayList<Filter>();
        private ColorRGBA backgroundColor = ColorRGBA.Gray;

        private LoadedFeatures() {
        }
    }
}

