/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import rs.co.ast.aspen.core.module.visengine.graph.Attributed;
import rs.co.ast.aspen.core.module.visengine.graph.Edge;
import rs.co.ast.aspen.core.module.visengine.graph.NodeId;

public class Node
extends Attributed {
    public final Object edgesLock = new Object();
    public String id;
    private final List<Edge> edges = new CopyOnWriteArrayList<Edge>();

    public Node(Map<String, String> attributes) {
        super(attributes);
        this.id = new NodeId(this.keyAttributes).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Edge> commonEdges(Node n) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        Object object = this.edgesLock;
        synchronized (object) {
            this.edges.stream().forEach(e -> {
                Node other = e.other(this);
                if (other != null && other.id.equals(n.id)) {
                    ret.add((Edge)e);
                }
            });
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Node other, Map<String, String> edgeAttributes) {
        Edge existing;
        Edge edge = new Edge(this, other, edgeAttributes);
        Object object = this.edgesLock;
        synchronized (object) {
            if (!this.edges.contains(edge)) {
                this.edges.add(edge);
            } else {
                existing = this.edges.get(this.edges.indexOf(edge));
                existing.updateOthers(edge.otherAttributes);
            }
        }
        object = other.edgesLock;
        synchronized (object) {
            if (!other.edges.contains(edge)) {
                other.edges.add(edge);
            } else {
                existing = other.edges.get(other.edges.indexOf(edge));
                existing.updateOthers(edge.otherAttributes);
            }
        }
    }

    public Iterator<Edge> edges() {
        return this.edges.iterator();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.keyAttributes.entrySet().stream().forEach(e -> sb.append((String)e.getKey()).append(":").append((String)e.getValue()).append("\n"));
        return sb.toString();
    }
}

