/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.prsmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ParsingRuleAssignment;
import rs.co.ast.aspen.api.service.ParsingRuleDTO;
import rs.co.ast.aspen.api.service.ParsingRuleMetaRule;
import rs.co.ast.aspen.api.service.ParsingRuleSetDTO;
import rs.co.ast.aspen.api.service.ParsingRulesGroupDTO;
import rs.co.ast.aspen.api.service.ParsingUpdateObjectDTO;
import rs.co.ast.aspen.api.service.RuleSetBackupContainerDTO;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleSetDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;

public class RuleSetModel {
    private static final Logger LOGGER = Logger.getLogger(RuleSetModel.class.getName());
    public static final String PROP_EDITMODE_CHANGED = "editModeChanged";
    public static final String PROP_GROUP_ADDED = "groupAdded";
    public static final String PROP_GROUP_CHANGED = "groupChanged";
    public static final String PROP_GROUP_REMOVED = "groupRemoved";
    public static final String PROP_RULESET_ADD = "ruleSetAdded";
    public static final String PROP_RULESET_COPY = "ruleSetCopy";
    public static final String PROP_RULESET_CHANGED = "ruleSetChanged";
    public static final String PROP_RULESET_REMOVED = "ruleSetRemoved";
    public static final String PROP_RULE_ADDED = "ruleAdded";
    public static final String PROP_RULE_CHANGED = "ruleChanged";
    public static final String PROP_RULE_REMOVED = "ruleRemoved";
    public static final String PROP_RULE_RULE_REMOVED = "ruleRuleRemoved";
    private final Map<String, ParsingRuleSetDTOWrapper> cacheRuleSets = new HashMap<String, ParsingRuleSetDTOWrapper>();
    private final Map<String, ParsingRulesGroupDTOWrapper> cacheGroups = new HashMap<String, ParsingRulesGroupDTOWrapper>();
    private final Map<String, ParsingRuleDTOWrapper> cacheRules = new HashMap<String, ParsingRuleDTOWrapper>();
    private final Map<String, List<ParsingRulesGroupDTOWrapper>> cacheGroupsForParent = new HashMap<String, List<ParsingRulesGroupDTOWrapper>>();
    private final Map<String, List<ParsingRuleDTOWrapper>> cacheRulesForGroup = new HashMap<String, List<ParsingRuleDTOWrapper>>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private boolean editMode = false;

    public void commitChanges() {
        ParsingUpdateObjectDTO puo = new ParsingUpdateObjectDTO();
        List dirtyRules = this.cacheRules.values().stream().filter(rule -> rule.isDirty()).map(rule -> rule.getRule()).collect(Collectors.toList());
        puo.getDirtyRules().addAll(dirtyRules);
        List deleteRules = this.cacheRules.values().stream().filter(rule -> rule.isForDelete()).map(rule -> rule.getRule()).collect(Collectors.toList());
        puo.getDeleteRules().addAll(deleteRules);
        List dirtyGroups = this.cacheGroups.values().stream().filter(group -> group.isDirty()).map(group -> group.getGroup()).collect(Collectors.toList());
        puo.getDirtyGroups().addAll(dirtyGroups);
        List deleteGroups = this.cacheGroups.values().stream().filter(group -> group.isForDelete()).map(group -> group.getGroup()).collect(Collectors.toList());
        puo.getDeleteGroups().addAll(deleteGroups);
        List dirtyRuleSets = this.cacheRuleSets.values().stream().filter(ruleSet -> ruleSet.isDirty()).map(ruleSet -> ruleSet.getRuleset()).collect(Collectors.toList());
        puo.getDirtyRuleSets().addAll(dirtyRuleSets);
        List deleteRuleSets = this.cacheRuleSets.values().stream().filter(ruleSet -> ruleSet.isForDelete()).map(ruleSet -> ruleSet.getRuleset()).collect(Collectors.toList());
        puo.getDeleteRuleSets().addAll(deleteRuleSets);
        try {
            LOGGER.info(String.format("RULESETS NEW: %s", puo.getDirtyRuleSets()));
            LOGGER.info(String.format("RULESETS DELETE: %s", puo.getDeleteRuleSets()));
            LOGGER.info(String.format("GROUPS NEW: %s", puo.getDirtyGroups()));
            LOGGER.info(String.format("GROUPS DELETE: %s", puo.getDeleteGroups()));
            LOGGER.info(String.format("RULES NEW: %s", puo.getDirtyRules()));
            LOGGER.info(String.format("RULES DELETE: %s", puo.getDeleteRules()));
            this.apiService.saveChanges(puo);
            this.clearCache();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public List<ParsingRuleSetDTOWrapper> getOriginalRuleSets() {
        try {
            List originalRuleSets = this.apiService.getParsingRuleSets();
            List<ParsingRuleSetDTOWrapper> ruleSets = originalRuleSets.stream().map(rs -> new ParsingRuleSetDTOWrapper((ParsingRuleSetDTO)rs)).collect(Collectors.toList());
            return ruleSets;
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    public List<ParsingRuleSetDTOWrapper> getCachedRuleSets() {
        try {
            if (this.cacheRuleSets.isEmpty()) {
                List originalRuleSets = this.apiService.getParsingRuleSets();
                Map<String, ParsingRuleSetDTOWrapper> ruleSets = originalRuleSets.stream().map(rs -> new ParsingRuleSetDTOWrapper((ParsingRuleSetDTO)rs)).collect(Collectors.toMap(ParsingRuleSetDTOWrapper::getId, rs -> rs));
                this.cacheRuleSets.putAll(ruleSets);
            }
            return new ArrayList<ParsingRuleSetDTOWrapper>(this.cacheRuleSets.values());
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    public void addRuleSet() {
        ParsingRuleSetDTO ruleSet = new ParsingRuleSetDTO();
        ParsingRuleSetDTOWrapper ruleSetWrap = new ParsingRuleSetDTOWrapper(ruleSet);
        this.markRuleSetAsDirty(ruleSetWrap);
        ruleSet.setId(UUID.randomUUID().toString());
        ruleSet.setName(NbBundle.getMessage(RuleSetModel.class, (String)"NewItemName.title"));
        ruleSet.setDescription("");
        this.cacheRuleSets.put(ruleSet.getId(), ruleSetWrap);
        this.pcs.firePropertyChange(PROP_RULESET_ADD, null, ruleSetWrap);
    }

    public void addRuleSet(ParsingRuleSetDTOWrapper ruleSet) {
        this.markRuleSetAsDirty(ruleSet);
        this.cacheRuleSets.put(ruleSet.getId(), ruleSet);
        this.pcs.firePropertyChange(PROP_RULESET_ADD, null, ruleSet);
    }

    private ParsingRuleSetDTOWrapper duplicateRuleSet(ParsingRuleSetDTOWrapper ruleSet, Map<String, String> groupIdToNewGroupId) throws ApiServiceException_Exception {
        ParsingRuleSetDTO copyRuleSet = new ParsingRuleSetDTO();
        copyRuleSet.setId(UUID.randomUUID().toString());
        copyRuleSet.setDescription(ruleSet.getDescription());
        copyRuleSet.setName(ruleSet.getName());
        copyRuleSet.setVersion(ruleSet.getVersion());
        ParsingRuleSetDTOWrapper copyRuleSetWrapper = new ParsingRuleSetDTOWrapper(copyRuleSet);
        this.markRuleSetAsDirty(copyRuleSetWrapper);
        this.cacheRuleSets.put(copyRuleSetWrapper.getId(), copyRuleSetWrapper);
        List<ParsingRulesGroupDTOWrapper> ogroups = this.getGroupWrappersForParent(ruleSet.getId(), false);
        ogroups.stream().forEachOrdered(g -> this.duplicateGroup((ParsingRulesGroupDTOWrapper)g, copyRuleSet.getId(), groupIdToNewGroupId));
        this.pcs.firePropertyChange(PROP_RULESET_COPY, null, copyRuleSetWrapper);
        return copyRuleSetWrapper;
    }

    public void duplicateRuleSet(ParsingRuleSetDTOWrapper ruleSet) throws ApiServiceException_Exception {
        HashMap<String, String> groupIdToNewGroupId = new HashMap<String, String>();
        this.duplicateRuleSet(ruleSet, groupIdToNewGroupId);
    }

    public RuleSetBackupContainerDTO exportRuleSets() throws ApiServiceException_Exception {
        List parsingRuleSets = this.apiService.getParsingRuleSets();
        this.cacheRuleSets.putAll(parsingRuleSets.stream().map(rs -> new ParsingRuleSetDTOWrapper((ParsingRuleSetDTO)rs)).collect(Collectors.toMap(ParsingRuleSetDTOWrapper::getId, rsw -> rsw)));
        List parsingRulesGroups = this.apiService.getAllParsingRulesGroups();
        this.cacheGroups.putAll(parsingRulesGroups.stream().map(group -> new ParsingRulesGroupDTOWrapper((ParsingRulesGroupDTO)group)).collect(Collectors.toMap(ParsingRulesGroupDTOWrapper::getId, gw -> gw)));
        List parsingRules = this.apiService.getAllParsingRules();
        this.cacheRules.putAll(parsingRules.stream().map(rule -> new ParsingRuleDTOWrapper((ParsingRuleDTO)rule)).collect(Collectors.toMap(ParsingRuleDTOWrapper::getId, rw -> rw)));
        RuleSetBackupContainerDTO rsbc = new RuleSetBackupContainerDTO();
        rsbc.getRulesets().addAll(parsingRuleSets);
        rsbc.getRulesets().forEach(rs -> this.populateRecusivly(rsbc, rs.getGroupIds()));
        return rsbc;
    }

    private void populateRecusivly(RuleSetBackupContainerDTO rsbc, List<String> groupIds) {
        if (groupIds == null) {
            return;
        }
        groupIds.forEach(gid -> {
            ParsingRulesGroupDTOWrapper groupWrapper = this.getGroup((String)gid);
            rsbc.getGroups().add(groupWrapper.getGroup());
            groupWrapper.getRuleIds().forEach(rId -> {
                ParsingRuleDTOWrapper ruleWrapper = this.getRule((String)rId);
                rsbc.getRules().add(ruleWrapper.getRule());
            });
            this.populateRecusivly(rsbc, groupWrapper.getGroupIds());
        });
    }

    public void importRuleSets(RuleSetBackupContainerDTO rsbc) throws ApiServiceException_Exception {
        this.apiService.importRuleSets(rsbc);
        this.clearCache();
    }

    public Set<String> removeRuleSet(String ruleSetId) {
        ParsingRuleSetDTOWrapper oldRuleSet = this.cacheRuleSets.get(ruleSetId);
        this.markRuleSetForDelete(oldRuleSet);
        HashSet<String> affectedrules = new HashSet<String>();
        if (this.cacheGroupsForParent.containsKey(ruleSetId)) {
            HashSet<String> groupsToBeDeleted = new HashSet<String>();
            this.deleteRecursion(ruleSetId, groupsToBeDeleted, affectedrules);
        }
        this.pcs.firePropertyChange(PROP_RULESET_REMOVED, oldRuleSet, null);
        return affectedrules;
    }

    public void setRuleSetName(ParsingRuleSetDTOWrapper ruleSet, String newName) {
        ruleSet.setName(newName);
        ruleSet.setDirty(true);
        this.pcs.firePropertyChange(PROP_RULESET_CHANGED, null, ruleSet);
    }

    private void markRuleSetAsDirty(ParsingRuleSetDTOWrapper ruleSet) {
        if (!ruleSet.isForDelete()) {
            ruleSet.setDirty(true);
        } else {
            LOGGER.info("RuleSet is marked for delete therefore can not be marked as dirty too!");
        }
    }

    private void markRuleSetForDelete(ParsingRuleSetDTOWrapper ruleSet) {
        ruleSet.setForDelete(true);
        ruleSet.setDirty(false);
    }

    public List<ParsingRulesGroupDTOWrapper> getOriginalGroups() {
        try {
            List originalGroups = this.apiService.getAllParsingRulesGroups();
            List<ParsingRulesGroupDTOWrapper> groups = originalGroups.stream().map(g -> new ParsingRulesGroupDTOWrapper((ParsingRulesGroupDTO)g)).collect(Collectors.toList());
            return groups;
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    public List<ParsingRulesGroupDTOWrapper> getCachedGroups() {
        try {
            if (this.cacheGroups.isEmpty()) {
                List originalGroups = this.apiService.getAllParsingRulesGroups();
                Map<String, ParsingRulesGroupDTOWrapper> groups = originalGroups.stream().map(g -> new ParsingRulesGroupDTOWrapper((ParsingRulesGroupDTO)g)).collect(Collectors.toMap(ParsingRulesGroupDTOWrapper::getId, g -> g));
                this.cacheGroups.putAll(groups);
            }
            return new ArrayList<ParsingRulesGroupDTOWrapper>(this.cacheGroups.values());
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    public List<ParsingRulesGroupDTOWrapper> getGroupWrappersForParent(String parentId, boolean force) {
        try {
            List<ParsingRulesGroupDTOWrapper> groupsForParent = this.cacheGroupsForParent.get(parentId);
            if (groupsForParent == null || groupsForParent.isEmpty() || force) {
                List originalGroupsForParent = this.apiService.getParsingRulesGroupsForParent(parentId);
                if (originalGroupsForParent != null) {
                    LOGGER.info(String.format("getGroupWrappersForParent Got %d groups for parent id %s", originalGroupsForParent.size(), parentId));
                    groupsForParent = originalGroupsForParent.stream().map(g -> new ParsingRulesGroupDTOWrapper((ParsingRulesGroupDTO)g)).collect(Collectors.toList());
                    groupsForParent.forEach(group -> this.cacheGroups.put(group.getId(), (ParsingRulesGroupDTOWrapper)group));
                    this.cacheGroupsForParent.put(parentId, groupsForParent);
                } else {
                    LOGGER.warning(String.format("No groups for parent id '%s'", parentId));
                }
            }
            return groupsForParent;
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new ArrayList<ParsingRulesGroupDTOWrapper>();
        }
    }

    public void duplicateGroup(ParsingRulesGroupDTOWrapper group, String parentId) throws ApiServiceException_Exception {
        HashMap<String, String> groupIdToNewGroupId = new HashMap<String, String>();
        this.duplicateGroup(group, parentId, groupIdToNewGroupId);
    }

    private ParsingRulesGroupDTOWrapper duplicateGroup(ParsingRulesGroupDTOWrapper group, String parentId, Map<String, String> groupIdToNewGroupId) {
        ParsingRulesGroupDTOWrapper copyGroup = new ParsingRulesGroupDTOWrapper(UUID.randomUUID().toString(), group.getDescription(), group.getName(), parentId);
        this.markGroupAsDirty(copyGroup);
        this.addGroupIdToParent(parentId, copyGroup.getId());
        this.cacheGroups.put(copyGroup.getId(), copyGroup);
        this.addToCachedGroupsForParent(parentId, copyGroup);
        groupIdToNewGroupId.put(group.getId(), copyGroup.getId());
        List<ParsingRulesGroupDTOWrapper> groupsForParent = this.getGroupWrappersForParent(group.getId(), false);
        groupsForParent.stream().forEachOrdered(subGroup -> this.duplicateGroupAndUpdateCachesAndGUI((ParsingRulesGroupDTOWrapper)subGroup, copyGroup, groupIdToNewGroupId));
        List<ParsingRuleDTOWrapper> rulesForGroup = this.getRulesForGroup(group.getId(), false);
        rulesForGroup.stream().forEachOrdered(rule -> this.duplicateRuleAndUpdateCachesAndGUI((ParsingRuleDTOWrapper)rule, copyGroup, groupIdToNewGroupId));
        this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, copyGroup);
        return copyGroup;
    }

    private void duplicateRuleAndUpdateCachesAndGUI(ParsingRuleDTOWrapper rule, ParsingRulesGroupDTOWrapper copyGroup, Map<String, String> groupIdToNewGroupId) {
        ParsingRuleDTOWrapper copyRule = this.duplicateRule(rule);
        this.markRuleAsDirty(copyRule);
        copyRule.setParentGroupId(copyGroup.getId());
        if (!copyGroup.getRuleIds().contains(rule.getId())) {
            copyGroup.getRuleIds().add(rule.getId());
        }
        this.updateMatchedGroupIdForDuplicatedRule(groupIdToNewGroupId, rule, copyRule);
        this.cacheRules.put(copyRule.getId(), copyRule);
        this.addToCacheRulesForGroup(copyGroup.getId(), copyRule);
        this.pcs.firePropertyChange(PROP_RULE_ADDED, null, copyRule);
    }

    private void updateMatchedGroupIdForDuplicatedRule(Map<String, String> groupIdToNewGroupId, ParsingRuleDTOWrapper rule, ParsingRuleDTOWrapper copyRule) {
        LOGGER.info(String.format("groupIdToNewGroupId: %s", groupIdToNewGroupId));
        LOGGER.info(String.format("matchedGroupId '%s'", rule.getMatchedGroupId()));
        if (groupIdToNewGroupId.containsKey(rule.getMatchedGroupId())) {
            copyRule.setMatchedGroupId(groupIdToNewGroupId.get(rule.getMatchedGroupId()));
            LOGGER.info(String.format("Changing matchedGroupId to '%s'", groupIdToNewGroupId.get(rule.getMatchedGroupId())));
        }
    }

    private void duplicateGroupAndUpdateCachesAndGUI(ParsingRulesGroupDTOWrapper subGroup, ParsingRulesGroupDTOWrapper copyGroup, Map<String, String> groupIdToNewGroupId) {
        ParsingRulesGroupDTOWrapper copySubGroup = this.duplicateGroup(subGroup, copyGroup.getId(), groupIdToNewGroupId);
        this.markGroupAsDirty(copySubGroup);
        if (!copyGroup.getGroupIds().contains(copySubGroup.getId())) {
            copyGroup.getGroupIds().add(copySubGroup.getId());
        }
        this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, copySubGroup);
    }

    private void addToCacheRulesForGroup(String groupId, ParsingRuleDTOWrapper copyRule) {
        List rulesForGroup = this.cacheRulesForGroup.getOrDefault(groupId, new ArrayList());
        rulesForGroup.add(copyRule);
        this.cacheRulesForGroup.put(groupId, rulesForGroup);
    }

    private void addToCachedGroupsForParent(String parentId, ParsingRulesGroupDTOWrapper group) {
        List groupsForParent = this.cacheGroupsForParent.getOrDefault(parentId, new ArrayList());
        groupsForParent.add(group);
        this.cacheGroupsForParent.put(parentId, groupsForParent);
    }

    private void addGroupIdToParent(String parentId, String groupId) {
        LOGGER.info(String.format("Adding group '%s' from parent '%s'", groupId, parentId));
        ParsingRulesGroupDTOWrapper parentGroup = this.cacheGroups.get(parentId);
        if (parentGroup != null) {
            if (parentGroup.getGroupIds() == null) {
                parentGroup.setGroupIds(new ArrayList<String>());
            }
            if (!parentGroup.getGroupIds().contains(groupId)) {
                parentGroup.getGroupIds().add(groupId);
                this.markGroupAsDirty(parentGroup);
                this.pcs.firePropertyChange(PROP_GROUP_CHANGED, null, parentGroup);
                LOGGER.info(String.format("Added group '%s' to parent group '%s'", groupId, parentId));
            }
        } else {
            ParsingRuleSetDTOWrapper parentRuleSet = this.cacheRuleSets.get(parentId);
            if (parentRuleSet != null) {
                if (parentRuleSet.getGroupIds() == null) {
                    parentRuleSet.setGroupIds(new ArrayList<String>());
                }
                if (!parentRuleSet.getGroupIds().contains(groupId)) {
                    parentRuleSet.getGroupIds().add(groupId);
                    this.markRuleSetAsDirty(parentRuleSet);
                    this.pcs.firePropertyChange(PROP_RULESET_CHANGED, null, parentRuleSet);
                    LOGGER.info(String.format("Added group '%s' to parent ruleset '%s'", groupId, parentId));
                }
            }
        }
    }

    private void removeGroupIdFromParent(String parentId, String groupId) {
        LOGGER.info(String.format("Removing group '%s' from parent '%s'", groupId, parentId));
        ParsingRulesGroupDTOWrapper parentGroup = this.cacheGroups.get(parentId);
        if (parentGroup != null) {
            if (parentGroup.getGroupIds() == null) {
                parentGroup.setGroupIds(new ArrayList<String>());
            }
            if (parentGroup.getGroupIds().contains(groupId)) {
                parentGroup.getGroupIds().remove(groupId);
                this.markGroupAsDirty(parentGroup);
                this.pcs.firePropertyChange(PROP_GROUP_CHANGED, null, parentGroup);
                LOGGER.info(String.format("Removed group '%s' from parent group '%s'", groupId, parentId));
            }
        } else {
            ParsingRuleSetDTOWrapper parentRuleSet = this.cacheRuleSets.get(parentId);
            if (parentRuleSet != null) {
                if (parentRuleSet.getGroupIds() == null) {
                    parentRuleSet.setGroupIds(new ArrayList<String>());
                }
                if (parentRuleSet.getGroupIds().contains(groupId)) {
                    parentRuleSet.getGroupIds().remove(groupId);
                    this.markRuleSetAsDirty(parentRuleSet);
                    this.pcs.firePropertyChange(PROP_RULESET_CHANGED, null, parentRuleSet);
                    LOGGER.info(String.format("Removed group '%s' from parent ruleset '%s'", groupId, parentId));
                }
            }
        }
    }

    public String getParentIdForGroupId(String groupId) {
        ParsingRulesGroupDTOWrapper group = this.getGroup(groupId);
        return group != null ? group.getParentId() : null;
    }

    public ParsingRulesGroupDTOWrapper getGroup(String groupId) {
        return this.cacheGroups.get(groupId);
    }

    public String addEmptyGroup(String parentId) {
        return this.addGroup(parentId, NbBundle.getMessage(RuleSetModel.class, (String)"NewItemName.title"), "");
    }

    public String addGroup(String parentId, String name, String description) {
        ParsingRulesGroupDTO group = new ParsingRulesGroupDTO();
        ParsingRulesGroupDTOWrapper wrapperGroup = new ParsingRulesGroupDTOWrapper(group);
        group.setId(UUID.randomUUID().toString());
        group.setName(name);
        group.setDescription(description);
        if (parentId != null) {
            group.setParentId(parentId);
        } else {
            LOGGER.info(String.format("Group: %s [%s], ParentId: null", group.getName(), group.getId()));
        }
        this.markGroupAsDirty(wrapperGroup);
        this.cacheGroups.put(group.getId(), wrapperGroup);
        List<ParsingRulesGroupDTOWrapper> groupsForParent = this.cacheGroupsForParent.get(parentId);
        if (groupsForParent == null) {
            groupsForParent = new ArrayList<ParsingRulesGroupDTOWrapper>();
        }
        groupsForParent.add(wrapperGroup);
        if (!groupsForParent.isEmpty()) {
            this.cacheGroupsForParent.put(parentId, groupsForParent);
        }
        LOGGER.info(String.format("Trying to find parent with id '%s'", parentId));
        this.addGroupIdToParent(parentId, group.getId());
        this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, wrapperGroup);
        return group.getId();
    }

    public Set<String> removeGroup(String groupId) {
        LOGGER.info(String.format("Remove group '%s'", groupId));
        String parentId = this.getParentIdForGroupId(groupId);
        ParsingRulesGroupDTOWrapper oldGroup = this.cacheGroups.get(groupId);
        HashSet<String> groupsToBeDeleted = new HashSet<String>();
        HashSet<String> affectedRules = new HashSet<String>();
        this.deleteRecursion(oldGroup.getId(), groupsToBeDeleted, affectedRules);
        this.removeGroupIdFromParent(parentId, groupId);
        this.fixRuleJumpToIfGroupIsDeleted(new ArrayList<ParsingRuleDTOWrapper>(this.cacheRules.values()), groupsToBeDeleted, affectedRules);
        this.pcs.firePropertyChange(PROP_GROUP_REMOVED, oldGroup, null);
        return affectedRules;
    }

    public void refreshGroup(ParsingRulesGroupDTOWrapper group) throws ApiServiceException_Exception {
        this.cacheGroupsForParent.remove(group.getId());
        this.cacheGroups.remove(group.getId());
        group.getGroupIds().forEach(this.cacheGroups::remove);
        this.cacheRulesForGroup.remove(group.getId());
        group.getRuleIds().forEach(this.cacheRules::remove);
        this.getGroupWrappersForParent(group.getId(), true);
    }

    public void setGroupName(ParsingRulesGroupDTOWrapper group, String newName) {
        group.setName(newName);
        group.setDirty(true);
        this.pcs.firePropertyChange(PROP_GROUP_CHANGED, null, group);
    }

    public void setRulesForGroup(String groupId, List<ParsingRuleDTOWrapper> rules) {
        this.cacheRulesForGroup.get(groupId).clear();
        this.cacheRulesForGroup.get(groupId).addAll(rules);
        ParsingRulesGroupDTOWrapper group = this.cacheGroups.get(groupId);
        if (group != null) {
            if (group.getRuleIds() != null) {
                group.getRuleIds().clear();
            } else {
                group.setRuleIds(new ArrayList<String>());
            }
            List ruleIds = rules.stream().map(ParsingRuleDTOWrapper::getId).collect(Collectors.toList());
            group.getRuleIds().addAll(ruleIds);
            this.markGroupAsDirty(group);
            this.pcs.firePropertyChange(PROP_GROUP_CHANGED, null, group);
        } else {
            LOGGER.warning(String.format("Group %s is null!", groupId));
        }
    }

    private void markGroupAsDirty(ParsingRulesGroupDTOWrapper group) {
        if (!group.isForDelete()) {
            group.setDirty(true);
        } else {
            LOGGER.info("Group is marked for delete therefore can not be marked as dirty too!");
        }
    }

    private void markGroupForDelete(ParsingRulesGroupDTOWrapper group) {
        group.setForDelete(true);
        group.setDirty(false);
    }

    public List<ParsingRuleDTOWrapper> getOriginalRules() {
        try {
            List originalRules = this.apiService.getAllParsingRules();
            List<ParsingRuleDTOWrapper> rules = originalRules.stream().map(r -> new ParsingRuleDTOWrapper((ParsingRuleDTO)r)).collect(Collectors.toList());
            return rules;
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new ArrayList<ParsingRuleDTOWrapper>();
        }
    }

    public List<ParsingRuleDTOWrapper> getCachedRules() {
        try {
            if (this.cacheRules.isEmpty()) {
                List originalRules = this.apiService.getAllParsingRules();
                Map<String, ParsingRuleDTOWrapper> rules = originalRules.stream().map(r -> new ParsingRuleDTOWrapper((ParsingRuleDTO)r)).collect(Collectors.toMap(ParsingRuleDTOWrapper::getId, r -> r));
                this.cacheRules.putAll(rules);
            }
            return new ArrayList<ParsingRuleDTOWrapper>(this.cacheRules.values());
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new ArrayList<ParsingRuleDTOWrapper>();
        }
    }

    public List<ParsingRuleDTOWrapper> getRulesForGroup(String groupId, boolean force) {
        try {
            List<ParsingRuleDTOWrapper> rulesForGroup = this.cacheRulesForGroup.get(groupId);
            if (rulesForGroup == null || rulesForGroup.isEmpty() || force) {
                List originalRulesForGroup = this.apiService.getParsingRulesForGroup(groupId);
                Map<String, ParsingRuleDTOWrapper> rulesForGroupMap = originalRulesForGroup.stream().map(r -> new ParsingRuleDTOWrapper((ParsingRuleDTO)r)).collect(Collectors.toMap(ParsingRuleDTOWrapper::getId, r -> r));
                ParsingRulesGroupDTOWrapper parentGroup = this.getGroup(groupId);
                rulesForGroup = parentGroup.getRuleIds().stream().map(id -> (ParsingRuleDTOWrapper)rulesForGroupMap.get(id)).collect(Collectors.toList());
                LOGGER.info(String.format("Group rule ids: %s", parentGroup.getRuleIds()));
                LOGGER.info(String.format("rulesForGroup: %s", rulesForGroup.stream().map(ParsingRuleDTOWrapper::getId).collect(Collectors.toList())));
                LOGGER.info(String.format("rulesForGroup: %s", rulesForGroup));
                this.cacheRules.putAll(rulesForGroupMap);
                this.cacheRulesForGroup.put(groupId, rulesForGroup);
            }
            return rulesForGroup;
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new ArrayList<ParsingRuleDTOWrapper>();
        }
    }

    public void copyRule(ParsingRulesGroupDTOWrapper group, ParsingRuleDTOWrapper ruleToCopy) {
        if (group != null && ruleToCopy != null) {
            ParsingRuleDTOWrapper copyRule = this.duplicateRule(ruleToCopy);
            this.markRuleAsDirty(copyRule);
            this.cacheRules.put(copyRule.getId(), copyRule);
            List<ParsingRuleDTOWrapper> get = this.cacheRulesForGroup.get(group.getId());
            if (get == null) {
                get = new ArrayList<ParsingRuleDTOWrapper>();
            }
            get.add(copyRule);
            this.cacheRulesForGroup.put(group.getId(), get);
            group.getRuleIds().add(copyRule.getId());
            this.markGroupAsDirty(group);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", copyRule);
            this.pcs.firePropertyChange(PROP_GROUP_CHANGED, "", group);
        }
    }

    public void addRules(List<ParsingRuleDTOWrapper> rules) {
        rules.forEach(rule -> this.addRule((ParsingRuleDTOWrapper)rule));
    }

    public void addRule(String groupId) {
        this.addRule(groupId, null);
    }

    public void addRule(String groupId, String regexp) {
        if (this.cacheRules != null) {
            ParsingRuleDTO rule = new ParsingRuleDTO();
            rule.setId(UUID.randomUUID().toString());
            rule.setDescription(NbBundle.getMessage(RuleSetModel.class, (String)"NewItemName.title"));
            if (regexp != null) {
                rule.setRegexp(regexp);
            }
            ParsingRuleDTOWrapper wrule = new ParsingRuleDTOWrapper(rule);
            rule.setParentGroupId(groupId);
            this.markRuleAsDirty(wrule);
            this.cacheRules.put(rule.getId(), wrule);
            List<ParsingRuleDTOWrapper> get = this.cacheRulesForGroup.get(groupId);
            if (get == null) {
                get = new ArrayList<ParsingRuleDTOWrapper>();
            }
            get.add(wrule);
            this.cacheRulesForGroup.put(groupId, get);
            ParsingRulesGroupDTOWrapper parentGroup = this.cacheGroups.get(rule.getParentGroupId());
            if (!parentGroup.getRuleIds().contains(rule.getId())) {
                parentGroup.getRuleIds().add(rule.getId());
                this.pcs.firePropertyChange(PROP_GROUP_CHANGED, null, parentGroup);
            }
            this.pcs.firePropertyChange(PROP_RULE_ADDED, "", rule);
        }
    }

    public void addRule(ParsingRuleDTOWrapper rule) {
        this.markRuleAsDirty(rule);
        this.cacheRules.put(rule.getId(), rule);
        List<ParsingRuleDTOWrapper> get = this.cacheRulesForGroup.get(rule.getParentGroupId());
        if (get == null) {
            get = new ArrayList<ParsingRuleDTOWrapper>();
        }
        get.add(rule);
        this.cacheRulesForGroup.put(rule.getParentGroupId(), get);
        ParsingRulesGroupDTOWrapper parentGroup = this.cacheGroups.get(rule.getParentGroupId());
        if (parentGroup != null) {
            if (!parentGroup.getRuleIds().contains(rule.getId())) {
                parentGroup.getRuleIds().add(rule.getId());
                this.pcs.firePropertyChange(PROP_GROUP_CHANGED, null, parentGroup);
            }
            this.pcs.firePropertyChange(PROP_RULE_ADDED, "", rule);
        }
    }

    public void moveDownRule(ParsingRulesGroupDTOWrapper group, ParsingRuleDTOWrapper rule) {
        List<ParsingRuleDTOWrapper> list = this.cacheRulesForGroup.get(group.getId());
        ArrayList<ParsingRuleDTOWrapper> cList = new ArrayList<ParsingRuleDTOWrapper>(list);
        int i = cList.indexOf(rule);
        int ii = i + 1;
        if (ii < cList.size()) {
            ParsingRuleDTOWrapper belowRule = (ParsingRuleDTOWrapper)cList.get(ii);
            cList.set(i, belowRule);
            cList.set(ii, rule);
            LOGGER.info(String.format("MoveDown: %s", cList));
            this.setRulesForGroup(group.getId(), cList);
        }
    }

    public void moveUpRule(ParsingRulesGroupDTOWrapper group, ParsingRuleDTOWrapper rule) {
        List<ParsingRuleDTOWrapper> list = this.cacheRulesForGroup.get(group.getId());
        ArrayList<ParsingRuleDTOWrapper> cList = new ArrayList<ParsingRuleDTOWrapper>(list);
        int i = cList.indexOf(rule);
        int ii = i - 1;
        if (ii >= 0) {
            ParsingRuleDTOWrapper aboveRule = (ParsingRuleDTOWrapper)cList.get(ii);
            cList.set(i, aboveRule);
            cList.set(ii, rule);
            LOGGER.info(String.format("MoveUp: %s", cList));
            this.setRulesForGroup(group.getId(), cList);
        }
    }

    public void setRuleContinueParsing(ParsingRuleDTOWrapper rule, boolean continueParsing) {
        rule.setContinueParsing(continueParsing);
        rule.setSilent(false);
        rule.setMatchedGroupId(null);
        this.markRuleAsDirty(rule);
        this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
    }

    public void setRuleDescription(ParsingRuleDTOWrapper rule, String desc) {
        if (!rule.getDescription().equals(desc)) {
            rule.setDescription(desc);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setRuleRegexp(ParsingRuleDTOWrapper rule, String regexp) {
        if (rule.getRegexp() == null) {
            rule.setRegexp("");
        }
        if (!rule.getRegexp().equals(regexp)) {
            rule.setRegexp(regexp);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setRuleJumpTo(ParsingRuleDTOWrapper rule, String jumpToGroupId) {
        rule.setMatchedGroupId(jumpToGroupId);
        rule.setContinueParsing(false);
        rule.setSilent(false);
        this.markRuleAsDirty(rule);
        this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
    }

    public void setRuleSilent(ParsingRuleDTOWrapper rule, boolean silent) {
        rule.setSilent(silent);
        rule.setContinueParsing(false);
        rule.setMatchedGroupId(null);
        this.markRuleAsDirty(rule);
        this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
    }

    public void markRuleAsDirty(ParsingRuleDTOWrapper rule) {
        if (!rule.isForDelete()) {
            rule.setDirty(true);
        } else {
            LOGGER.info("Rule is marked for delete therefore can not be marked as dirty too!");
        }
    }

    private void markRuleForDelete(ParsingRuleDTOWrapper rule) {
        rule.setForDelete(true);
        rule.setDirty(false);
    }

    private ParsingRuleDTOWrapper duplicateRule(ParsingRuleDTOWrapper rule) {
        ParsingRuleDTO copyRule = new ParsingRuleDTO();
        copyRule.setContinueParsing(rule.isContinueParsing());
        copyRule.setDescription(rule.getDescription());
        copyRule.setId(UUID.randomUUID().toString());
        copyRule.setMatchedGroupId(rule.getMatchedGroupId());
        copyRule.setRegexp(rule.getRegexp());
        copyRule.setSilent(rule.isSilent());
        copyRule.setParentGroupId(rule.getParentGroupId());
        List assignments = rule.getAssignments().stream().map(a -> {
            ParsingRuleAssignment copyAssignment = new ParsingRuleAssignment();
            copyAssignment.setCategory(a.getCategory());
            copyAssignment.setId(UUID.randomUUID().toString());
            copyAssignment.setKey(a.getKey());
            copyAssignment.setMatchGroupNumber(a.getMatchGroupNumber());
            copyAssignment.setValue(a.getValue());
            return copyAssignment;
        }).collect(Collectors.toList());
        copyRule.getAssignments().addAll(assignments);
        List metaRules = rule.getMetaRules().stream().map(m -> {
            ParsingRuleMetaRule copyMetaRule = new ParsingRuleMetaRule();
            copyMetaRule.setActive(m.isActive());
            copyMetaRule.setId(UUID.randomUUID().toString());
            copyMetaRule.setRuleEL(m.getRuleEL());
            return copyMetaRule;
        }).collect(Collectors.toList());
        copyRule.getMetaRules().addAll(metaRules);
        ParsingRuleDTOWrapper copyRuleWrapper = new ParsingRuleDTOWrapper(copyRule);
        return copyRuleWrapper;
    }

    public void addAssignment(ParsingRuleDTOWrapper rule) {
        if (rule != null) {
            ParsingRuleAssignment assignment = new ParsingRuleAssignment();
            assignment.setId(UUID.randomUUID().toString());
            assignment.setCategory(NbBundle.getMessage(RuleSetModel.class, (String)"Assignment.category.text"));
            assignment.setKey(NbBundle.getMessage(RuleSetModel.class, (String)"Assignment.key.text"));
            assignment.setValue(NbBundle.getMessage(RuleSetModel.class, (String)"Assignment.value.text"));
            rule.addAssignment(assignment);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void removeAssignment(ParsingRuleDTOWrapper rule, ParsingRuleAssignment assignment) {
        if (rule != null && assignment != null) {
            rule.removeAssignment(assignment);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_RULE_REMOVED, "", rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setAssignmentCategory(ParsingRuleDTOWrapper rule, ParsingRuleAssignment assignment, String category) {
        if (rule != null && assignment != null && !assignment.getCategory().equals(category)) {
            assignment.setCategory(category);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setAssignmentKey(ParsingRuleDTOWrapper rule, ParsingRuleAssignment assignment, String key) {
        if (rule != null && assignment != null && !(assignment.getKey() != null ? assignment.getKey() : "").equals(key)) {
            assignment.setKey(key);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setAssignmentValue(ParsingRuleDTOWrapper rule, ParsingRuleAssignment assignment, String value) {
        if (rule != null && assignment != null && !(assignment.getValue() != null ? assignment.getValue() : "").equals(value)) {
            assignment.setValue(value);
            assignment.setMatchGroupNumber(null);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void addMetaRule(ParsingRuleDTOWrapper rule) {
        if (rule != null) {
            ParsingRuleMetaRule metaRule = new ParsingRuleMetaRule();
            metaRule.setId(UUID.randomUUID().toString());
            metaRule.setActive(Boolean.valueOf(false));
            metaRule.setRuleEL(NbBundle.getMessage(RuleSetModel.class, (String)"MetaRuleExpression.text"));
            rule.addMetaRule(metaRule);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void removeMetaRule(ParsingRuleDTOWrapper rule, ParsingRuleMetaRule metaRule) {
        if (rule != null && metaRule != null) {
            rule.removeMetaRule(metaRule);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_RULE_REMOVED, "", rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setMetaRuleActive(ParsingRuleDTOWrapper rule, ParsingRuleMetaRule metaRule, boolean active) {
        if (rule != null && metaRule != null) {
            metaRule.setActive(Boolean.valueOf(active));
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setMetaRuleExpression(ParsingRuleDTOWrapper rule, ParsingRuleMetaRule metaRule, String expression) {
        if (rule != null && metaRule != null && !metaRule.getRuleEL().equals(expression)) {
            metaRule.setRuleEL(expression);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void removeRule(ParsingRulesGroupDTOWrapper group, ParsingRuleDTOWrapper rule) {
        if (group != null && rule != null) {
            this.markRuleForDelete(rule);
            group.getRuleIds().remove(rule.getId());
            this.markGroupAsDirty(group);
            this.pcs.firePropertyChange(PROP_RULE_REMOVED, rule, null);
            this.pcs.firePropertyChange(PROP_GROUP_CHANGED, "", group);
        }
    }

    public ParsingRuleDTOWrapper getRule(String ruleId) {
        return this.cacheRules.get(ruleId);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void toggleEditMode() {
        this.editMode = !this.editMode;
        this.pcs.firePropertyChange(PROP_EDITMODE_CHANGED, "", (Object)this.editMode);
    }

    public void setEditMode(boolean mode) {
        this.editMode = mode;
        this.pcs.firePropertyChange(PROP_EDITMODE_CHANGED, "", (Object)this.editMode);
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    private void deleteRecursion(String parentId, Set<String> groupsToBeDeleted, Set<String> affectedRules) {
        LOGGER.info(String.format("Delete groups for parentId '%s'", parentId));
        ParsingRulesGroupDTOWrapper oldGroup = this.cacheGroups.get(parentId);
        this.markGroupForDelete(oldGroup);
        groupsToBeDeleted.add(oldGroup.getId());
        List rulesForParent = this.cacheRulesForGroup.getOrDefault(parentId, new ArrayList());
        rulesForParent.forEach(rule -> this.markRuleForDelete((ParsingRuleDTOWrapper)rule));
        List groupsForParent = this.cacheGroupsForParent.getOrDefault(parentId, new ArrayList());
        groupsForParent.forEach(group -> {
            LOGGER.info(String.format("Delete group '%s'", group.getId()));
            this.markGroupForDelete((ParsingRulesGroupDTOWrapper)group);
            groupsToBeDeleted.add(group.getId());
            List rulesForGroup = this.cacheRulesForGroup.getOrDefault(group.getId(), new ArrayList());
            rulesForGroup.forEach(rule -> this.markRuleForDelete((ParsingRuleDTOWrapper)rule));
            this.deleteRecursion(group.getId(), groupsToBeDeleted, affectedRules);
            this.removeGroupIdFromParent(parentId, group.getId());
        });
    }

    private void fixRuleJumpToIfGroupIsDeleted(List<ParsingRuleDTOWrapper> rules, Set<String> groupsToBeDeleted, Set<String> affectedRules) {
        rules.stream().filter(rule -> !rule.isForDelete()).filter(rule -> groupsToBeDeleted.contains(rule.getMatchedGroupId())).map(rule -> {
            affectedRules.add(rule.getDescription());
            return rule;
        }).forEach(rule -> {
            rule.setSilent(false);
            rule.setMatchedGroupId(null);
            rule.setContinueParsing(true);
            this.markRuleAsDirty((ParsingRuleDTOWrapper)rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, null, rule);
            ParsingRulesGroupDTOWrapper group = this.getGroup(rule.getParentGroupId());
            this.markGroupAsDirty(group);
            this.pcs.firePropertyChange(PROP_GROUP_CHANGED, null, group);
        });
    }

    public void reset() {
        this.clearCache();
    }

    public void clearCache() {
        this.cacheRuleSets.clear();
        this.cacheGroups.clear();
        this.cacheGroupsForParent.clear();
        this.cacheRules.clear();
        this.cacheRulesForGroup.clear();
    }

    public List<String> getMappingsForCategory(String category) {
        try {
            return this.apiService.getMappingsForCategory(category);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }
}

