/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AbstractDocument;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.fife.ui.rsyntaxtextarea.folding.JsonFoldParser;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.painter.BusyPainter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.ScheduledTask;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptModelChanged;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.scripteditor.AddNewScriptPanel;
import rs.co.ast.aspen.gui.module.scripteditor.JavaScripFileFilter;
import rs.co.ast.aspen.gui.module.scripteditor.RSyntaxAreaDocumentFilter;
import rs.co.ast.aspen.gui.module.scripteditor.RecoverScriptsEvent;
import rs.co.ast.aspen.gui.module.scripteditor.RecoverScriptsEventListener;
import rs.co.ast.aspen.gui.module.scripteditor.RenameScriptPanel;
import rs.co.ast.aspen.gui.module.scripteditor.ScheduledTaskModel;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptEditorTableModel;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptEditorTableRenderer;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptTypeComboBoxModel;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdateTopComponent;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptsZipUtils;
import rs.co.ast.aspen.gui.module.scripteditor.SearchResualtsTopComponent;
import rs.co.ast.aspen.gui.module.scripteditor.UpdateTableInScriptUpdateTopComponent;
import rs.co.ast.aspen.gui.module.scripteditor.VisualizationTokenMaker;
import rs.co.ast.aspen.gui.module.scripteditor.eval.ClusteringServiceTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.CorrelationContextTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.CounterManagerTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.CountryTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.DataMapManagerTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.DataMapperTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.NotificationManagerTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.RawLogTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.ScriptUtilsTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.SecurityEventTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.SecurityEventsTest;
import rs.co.ast.aspen.gui.module.scripteditor.eval.VirusTotalTest;

@TopComponent.Description(preferredID="ScriptEditorTopComponent", iconBase="script.png", persistenceType=1)
public final class ScriptEditorTopComponent
extends TopComponent {
    private static final Logger logger = Logger.getLogger(ScriptEditorTopComponent.class.getName());
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private ScriptEditorTableModel tableModel = new ScriptEditorTableModel();
    private final ScriptEngineManager sem = new ScriptEngineManager();
    private InstanceContent ic = new InstanceContent();
    private Collection<Script> allScripts;
    private Map<String, Script> changedScripts = this.tableModel.getChangedScripts();
    private Map<String, String> changedScriptsBackUp = new HashMap<String, String>();
    private Map<String, String> changedDescriptionsBackUp = new HashMap<String, String>();
    private RSyntaxTextArea taScriptText;
    private int selectedRow = 0;
    private int caretPosition = 0;
    private boolean onSave = false;
    private ScriptTypeComboBoxModel scriptTypeModel = new ScriptTypeComboBoxModel();
    private ScriptEditorTopComponent thiz = this;
    private Dialog dialog;
    private ScheduledExecutorService scriptsUpdater = Executors.newSingleThreadScheduledExecutor();
    private Map<ScriptType, List<Script>> recoveryScripts = new HashMap<ScriptType, List<Script>>();
    private RSyntaxAreaDocumentFilter taFilter = new RSyntaxAreaDocumentFilter();
    private JButton bToggleCollapsible = new JButton();
    private boolean toogleCollapsibleBool = false;
    private ScheduledTask currentTask = null;
    private final CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX);
    private final CronParser parser = new CronParser(this.cronDefinition);
    private final Pattern pat = Pattern.compile("[a-zA-Z0-9-,\\/ ?#*]");
    private boolean isCRONValid = false;
    private ScheduledTaskModel taskModel = new ScheduledTaskModel();
    private Map<String, ScheduledTask> changedTasks = new HashMap<String, ScheduledTask>();
    private Map<String, String> changedTasksBackup = new HashMap<String, String>();
    private final Format dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private JButton bBeautify;
    private JButton bEvaluate;
    private JButton bExport;
    private JButton bExportAll;
    private JButton bImport;
    private JButton bRefresh;
    private JButton bReset;
    private JButton bSave;
    private JButton bSearchAllScripts;
    private JButton bUpdate;
    private JComboBox cbScriptType;
    private JPanel cp;
    private JXCollapsiblePane cpCron;
    private JXCollapsiblePane cpDescription;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JXBusyLabel lLoading;
    private JLabel lType;
    private JMenu mAllScriptsActivationControl;
    private JMenu mScriptsActivationControl;
    private JMenuItem miDelete;
    private JMenuItem miDisable;
    private JMenuItem miDisableAllScripts;
    private JMenuItem miDown;
    private JMenuItem miEnable;
    private JMenuItem miEnableAllScripts;
    private JMenuItem miNew;
    private JMenuItem miRecover;
    private JMenuItem miRename;
    private JMenuItem miRestorePreviousScriptVersion;
    private JMenuItem miUp;
    private JPanel pButtons;
    private JPanel pCron;
    private JPanel pDescription;
    private JPanel pTaDescription;
    private JPopupMenu pmOperations;
    private JTable tScripts;
    private JTextArea taScriptDescription;
    private JToggleButton tbDescription;
    private JTextField tfCronExpression;
    private JTextField tfLastExecuted;
    private JTextField tfNextExecution;
    private JTextField tfSearch;

    public ScriptEditorTopComponent() {
        logger.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.SCRIPTEDITOR), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.SCRIPTEDITOR)));
        this.initComponents();
        this.setName(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"CTL_ScriptEditorTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"HINT_ScriptEditorTopComponent"));
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.ic));
        this.taScriptText = new RSyntaxTextArea(20, 60);
        FoldParserManager.get().addFoldParserMapping("text/visscript", (FoldParser)new JsonFoldParser());
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        atmf.putMapping("text/visscript", VisualizationTokenMaker.class.getName(), ((Object)((Object)this)).getClass().getClassLoader());
        this.taScriptText.setTabSize(4);
        this.taScriptText.setCodeFoldingEnabled(true);
        ((AbstractDocument)this.taScriptText.getDocument()).setDocumentFilter(this.taFilter);
        SyntaxScheme scheme = this.taScriptText.getSyntaxScheme();
        scheme.getStyle((int)10).foreground = new Color(153, 0, 0);
        scheme.getStyle((int)6).foreground = new Color(68, 85, 136);
        scheme.getStyle((int)7).foreground = new Color(0, 128, 128);
        scheme.getStyle((int)17).foreground = new Color(153, 0, 115);
        scheme.getStyle((int)1).foreground = new Color(0, 128, 0);
        scheme.getStyle((int)22).foreground = Color.DARK_GRAY;
        this.taScriptText.setSyntaxEditingStyle("text/javascript");
        Font font = this.taScriptText.getFontForTokenType(22);
        scheme.getStyle((int)22).font = font = font.deriveFont(1);
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.taScriptText);
        this.cp.add((Component)sp);
        this.jPanel2.add((Component)this.pDescription, "North");
        this.jPanel2.add((Component)this.cp, "Center");
        this.jPanel2.add((Component)this.pButtons, "South");
        this.cpCron.setLayout((LayoutManager)new BorderLayout());
        this.cpCron.add((Component)this.pCron, (Object)"Center");
        this.cpDescription.setLayout((LayoutManager)new BorderLayout());
        this.cpDescription.add((Component)this.pTaDescription, (Object)"Center");
        this.bToggleCollapsible.addActionListener(this.cpCron.getActionMap().get("toggle"));
        this.tbDescription.addActionListener(this.cpDescription.getActionMap().get("toggle"));
        this.tbDescription.setCursor(Cursor.getPredefinedCursor(12));
        this.disableButtons();
        this.miRecover.setEnabled(false);
        this.taScriptText.getCaret().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ScriptEditorTopComponent.this.onSave) {
                    ScriptEditorTopComponent.this.caretPosition = ScriptEditorTopComponent.this.taScriptText.getCaret().getDot();
                }
            }
        });
        this.taScriptText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ScriptEditorTopComponent.this.setOffsetsInFilter(ScriptEditorTopComponent.this.tableModel.getScriptByRow(ScriptEditorTopComponent.this.selectedRow));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ScriptEditorTopComponent.this.setOffsetsInFilter(ScriptEditorTopComponent.this.tableModel.getScriptByRow(ScriptEditorTopComponent.this.selectedRow));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ScriptEditorTopComponent.this.setOffsetsInFilter(ScriptEditorTopComponent.this.tableModel.getScriptByRow(ScriptEditorTopComponent.this.selectedRow));
            }
        });
        this.tfCronExpression.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doChecks();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doChecks();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doChecks();
            }

            private void doChecks() {
                ScriptEditorTopComponent.this.checkCRON();
                if (ScriptEditorTopComponent.this.currentTask != null) {
                    if (!ScriptEditorTopComponent.this.tfCronExpression.getText().isEmpty() && !ScriptEditorTopComponent.this.tfCronExpression.getText().equals(ScriptEditorTopComponent.this.currentTask.getCronSpec())) {
                        if (!ScriptEditorTopComponent.this.changedTasksBackup.containsKey(ScriptEditorTopComponent.this.currentTask.getScriptName())) {
                            ScriptEditorTopComponent.this.changedTasksBackup.put(ScriptEditorTopComponent.this.currentTask.getScriptName(), ScriptEditorTopComponent.this.currentTask.getCronSpec());
                        }
                        ScriptEditorTopComponent.this.currentTask.setCronSpec(ScriptEditorTopComponent.this.tfCronExpression.getText());
                        ScriptEditorTopComponent.this.changedTasks.put(ScriptEditorTopComponent.this.currentTask.getScriptName(), ScriptEditorTopComponent.this.currentTask);
                        ScriptEditorTopComponent.this.bSave.setEnabled(true);
                        ScriptEditorTopComponent.this.bReset.setEnabled(true);
                    }
                } else if (!ScriptEditorTopComponent.this.tfCronExpression.getText().isEmpty()) {
                    ScriptEditorTopComponent.this.bSave.setEnabled(true);
                    ScriptEditorTopComponent.this.bReset.setEnabled(true);
                }
            }
        });
        this.tfCronExpression.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                this.check(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            private void check(KeyEvent e) {
                char c = e.getKeyChar();
                Matcher m = ScriptEditorTopComponent.this.pat.matcher(String.valueOf(c));
                if (!m.matches()) {
                    e.consume();
                }
            }
        });
        this.tScripts.setDefaultRenderer(Script.class, new ScriptEditorTableRenderer());
        this.tScripts.setSelectionMode(2);
        this.tScripts.setRowSelectionAllowed(true);
        this.tScripts.setFillsViewportHeight(true);
        this.tScripts.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && ScriptEditorTopComponent.this.tScripts.getSelectedRow() > -1) {
                    ScriptEditorTopComponent.this.selectedRow = ScriptEditorTopComponent.this.tScripts.getSelectedRow();
                    Script script = (Script)ScriptEditorTopComponent.this.tableModel.getValueAt(ScriptEditorTopComponent.this.tScripts.getSelectedRow(), 0);
                    if (script != null) {
                        ScriptEditorTopComponent.this.setScriptText(script.getScript());
                        ScriptEditorTopComponent.this.setDescriptionText(script.getDescription());
                        ScriptEditorTopComponent.this.taScriptText.getCaret().setDot(ScriptEditorTopComponent.this.caretPosition);
                        ScriptEditorTopComponent.this.taScriptText.requestFocus();
                        ScriptEditorTopComponent.this.onSave = false;
                        ScriptEditorTopComponent.this.miDelete.setEnabled(true);
                        ScriptEditorTopComponent.this.miDown.setEnabled(true);
                        ScriptEditorTopComponent.this.miUp.setEnabled(true);
                        ScriptEditorTopComponent.this.bExport.setEnabled(true);
                        ScriptEditorTopComponent.this.bImport.setEnabled(true);
                        ScriptEditorTopComponent.this.bEvaluate.setEnabled(true);
                        ScriptEditorTopComponent.this.bBeautify.setEnabled(true);
                        ScriptEditorTopComponent.this.setOffsetsInFilter(script);
                        if (ScriptEditorTopComponent.this.changedScripts.containsKey(script.getId()) || script.getType() == ScriptType.SCHEDULED && ScriptEditorTopComponent.this.changedTasks.containsKey(script.getName())) {
                            Script tmpScript = (Script)ScriptEditorTopComponent.this.changedScripts.get(script.getId());
                            if (!script.getScript().equals(tmpScript.getScript())) {
                                ScriptEditorTopComponent.this.setScriptText(tmpScript.getScript());
                                ScriptEditorTopComponent.this.setDescriptionText(tmpScript.getDescription());
                            }
                            ScriptEditorTopComponent.this.bSave.setEnabled(true);
                            ScriptEditorTopComponent.this.bReset.setEnabled(true);
                        } else {
                            ScriptEditorTopComponent.this.bSave.setEnabled(false);
                            ScriptEditorTopComponent.this.bReset.setEnabled(false);
                        }
                        if (script.getType() == ScriptType.SCHEDULED) {
                            ScriptEditorTopComponent.this.setDataToCronPanel(script.getName());
                        } else {
                            ScriptEditorTopComponent.this.currentTask = null;
                        }
                        if (script.getDescription() == null || script.getDescription().isEmpty()) {
                            if (!ScriptEditorTopComponent.this.cpDescription.isCollapsed()) {
                                ScriptEditorTopComponent.this.tbDescription.doClick();
                            }
                        } else if (ScriptEditorTopComponent.this.cpDescription.isCollapsed()) {
                            ScriptEditorTopComponent.this.tbDescription.doClick();
                        }
                    }
                }
            }
        });
        this.tScripts.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = ScriptEditorTopComponent.this.tScripts.rowAtPoint(e.getPoint());
                    int column = ScriptEditorTopComponent.this.tScripts.columnAtPoint(e.getPoint());
                    if (!ScriptEditorTopComponent.this.tScripts.isRowSelected(row)) {
                        if (row > -1) {
                            ScriptEditorTopComponent.this.tScripts.setRowSelectionInterval(row, row);
                        }
                        ScriptEditorTopComponent.this.tScripts.changeSelection(row, column, false, false);
                    }
                    switch (ScriptEditorTopComponent.this.scriptTypeModel.getSelectedItem(ScriptEditorTopComponent.this.cbScriptType.getSelectedIndex())) {
                        case ROUTING: 
                        case SCHEDULED: 
                        case NOTIFICATION_PREPROCESSING: 
                        case UTILITY_FUNCTIONS: {
                            ScriptEditorTopComponent.this.miUp.setEnabled(false);
                            ScriptEditorTopComponent.this.miDown.setEnabled(false);
                            ScriptEditorTopComponent.this.mScriptsActivationControl.setEnabled(true);
                            break;
                        }
                        case VISUALISATION_RULESET: 
                        case VISUALISATION_CONFIGURATION: {
                            ScriptEditorTopComponent.this.miUp.setEnabled(false);
                            ScriptEditorTopComponent.this.miDown.setEnabled(false);
                            ScriptEditorTopComponent.this.mScriptsActivationControl.setEnabled(false);
                            break;
                        }
                        case CORRELATION: {
                            ScriptEditorTopComponent.this.miUp.setEnabled(true);
                            ScriptEditorTopComponent.this.miDown.setEnabled(true);
                            break;
                        }
                        default: {
                            logger.log(Level.WARNING, "ScriptType not supported. {0}", ScriptEditorTopComponent.this.cbScriptType.getSelectedItem());
                        }
                    }
                    ScriptEditorTopComponent.this.pmOperations.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.cbScriptType.setModel(this.scriptTypeModel);
        this.cbScriptType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ScriptEditorTopComponent.this.disableButtons();
            }
        });
        this.taScriptText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doChange();
            }

            private void doChange() {
                Script script = (Script)ScriptEditorTopComponent.this.tableModel.getValueAt(ScriptEditorTopComponent.this.tScripts.getSelectedRow(), 0);
                if (script != null && ScriptEditorTopComponent.this.taScriptText.getText() != null && !ScriptEditorTopComponent.this.taScriptText.getText().isEmpty() && !ScriptEditorTopComponent.this.taScriptText.getText().equals(script.getScript())) {
                    if (!ScriptEditorTopComponent.this.changedScriptsBackUp.containsKey(script.getId())) {
                        ScriptEditorTopComponent.this.changedScriptsBackUp.put(script.getId(), script.getScript());
                    }
                    script.setScript(ScriptEditorTopComponent.this.taScriptText.getText());
                    ScriptEditorTopComponent.this.changedScripts.put(script.getId(), script);
                    ScriptEditorTopComponent.this.bSave.setEnabled(true);
                    ScriptEditorTopComponent.this.bReset.setEnabled(true);
                }
            }
        });
        this.taScriptDescription.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doChange();
            }

            private void doChange() {
                Script script = (Script)ScriptEditorTopComponent.this.tableModel.getValueAt(ScriptEditorTopComponent.this.tScripts.getSelectedRow(), 0);
                if (script != null && ScriptEditorTopComponent.this.taScriptDescription.getText() != null && !ScriptEditorTopComponent.this.taScriptDescription.getText().isEmpty() && !ScriptEditorTopComponent.this.taScriptDescription.getText().equals(script.getDescription())) {
                    if (!ScriptEditorTopComponent.this.changedDescriptionsBackUp.containsKey(script.getId())) {
                        ScriptEditorTopComponent.this.changedDescriptionsBackUp.put(script.getId(), script.getDescription());
                    }
                    script.setDescription(ScriptEditorTopComponent.this.taScriptDescription.getText());
                    ScriptEditorTopComponent.this.changedScripts.put(script.getId(), script);
                    ScriptEditorTopComponent.this.bSave.setEnabled(true);
                    ScriptEditorTopComponent.this.bReset.setEnabled(true);
                }
            }
        });
        ActionListener findLisener = event -> {
            this.tfSearch.requestFocus();
            this.tfSearch.setCaretPosition(0);
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(70, 2, false);
        this.taScriptText.registerKeyboardAction(findLisener, "Find", stroke, 0);
        ActionListener findInAllFilesLisener = event -> this.searchInAllFiles();
        KeyStroke strokeFiles = KeyStroke.getKeyStroke(70, 8, false);
        this.registerKeyboardAction(findInAllFilesLisener, "FindInAll", strokeFiles, 1);
    }

    private void initComponents() {
        this.pmOperations = new JPopupMenu();
        this.miNew = new JMenuItem();
        this.miRename = new JMenuItem();
        this.miDelete = new JMenuItem();
        this.miUp = new JMenuItem();
        this.miDown = new JMenuItem();
        this.mScriptsActivationControl = new JMenu();
        this.miEnable = new JMenuItem();
        this.miDisable = new JMenuItem();
        this.mAllScriptsActivationControl = new JMenu();
        this.miEnableAllScripts = new JMenuItem();
        this.miDisableAllScripts = new JMenuItem();
        this.miRestorePreviousScriptVersion = new JMenuItem();
        this.miRecover = new JMenuItem();
        this.pCron = new JPanel();
        this.tfCronExpression = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.tfLastExecuted = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfNextExecution = new JTextField();
        this.pTaDescription = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.taScriptDescription = new JTextArea();
        this.pButtons = new JPanel();
        this.bExportAll = new JButton();
        this.bExport = new JButton();
        this.bImport = new JButton();
        this.bEvaluate = new JButton();
        this.bBeautify = new JButton();
        this.bSave = new JButton();
        this.bReset = new JButton();
        this.cp = new JPanel();
        this.pDescription = new JPanel();
        this.cpDescription = new JXCollapsiblePane();
        this.tbDescription = new JToggleButton();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.lType = new JLabel();
        this.cbScriptType = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tScripts = new JTable();
        this.bRefresh = new JButton();
        this.lLoading = new JXBusyLabel();
        this.bSearchAllScripts = new JButton();
        this.bUpdate = new JButton();
        this.jPanel4 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.tfSearch = new JTextField();
        this.jLabel4 = new JLabel();
        this.cpCron = new JXCollapsiblePane();
        Mnemonics.setLocalizedText((AbstractButton)this.miNew, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miNew.text"));
        this.miNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miNewActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miNew);
        Mnemonics.setLocalizedText((AbstractButton)this.miRename, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miRename.text"));
        this.miRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miRenameActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miRename);
        Mnemonics.setLocalizedText((AbstractButton)this.miDelete, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miDelete.text"));
        this.miDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miDeleteActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miDelete);
        Mnemonics.setLocalizedText((AbstractButton)this.miUp, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miUp.text"));
        this.miUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miUpActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miUp);
        Mnemonics.setLocalizedText((AbstractButton)this.miDown, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miDown.text"));
        this.miDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miDownActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miDown);
        Mnemonics.setLocalizedText((AbstractButton)this.mScriptsActivationControl, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.mScriptsActivationControl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.miEnable, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miEnable.text"));
        this.miEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miEnableActionPerformed(evt);
            }
        });
        this.mScriptsActivationControl.add(this.miEnable);
        Mnemonics.setLocalizedText((AbstractButton)this.miDisable, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miDisable.text"));
        this.miDisable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miDisableActionPerformed(evt);
            }
        });
        this.mScriptsActivationControl.add(this.miDisable);
        Mnemonics.setLocalizedText((AbstractButton)this.mAllScriptsActivationControl, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.mAllScriptsActivationControl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.miEnableAllScripts, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miEnableAllScripts.text"));
        this.miEnableAllScripts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miEnableAllScriptsActionPerformed(evt);
            }
        });
        this.mAllScriptsActivationControl.add(this.miEnableAllScripts);
        Mnemonics.setLocalizedText((AbstractButton)this.miDisableAllScripts, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miDisableAllScripts.text"));
        this.miDisableAllScripts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miDisableAllScriptsActionPerformed(evt);
            }
        });
        this.mAllScriptsActivationControl.add(this.miDisableAllScripts);
        this.mScriptsActivationControl.add(this.mAllScriptsActivationControl);
        this.pmOperations.add(this.mScriptsActivationControl);
        Mnemonics.setLocalizedText((AbstractButton)this.miRestorePreviousScriptVersion, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miRestorePreviousScriptVersion.text"));
        this.miRestorePreviousScriptVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miRestorePreviousScriptVersionActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miRestorePreviousScriptVersion);
        Mnemonics.setLocalizedText((AbstractButton)this.miRecover, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.miRecover.text"));
        this.miRecover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.miRecoverActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miRecover);
        this.tfCronExpression.setText(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.tfCronExpression.text"));
        this.tfCronExpression.setToolTipText(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.tfCronExpression.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.jLabel3.text"));
        this.tfLastExecuted.setText(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.tfLastExecuted.text"));
        this.tfLastExecuted.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.jLabel1.text"));
        this.tfNextExecution.setText(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.tfNextExecution.text"));
        this.tfNextExecution.setEnabled(false);
        GroupLayout pCronLayout = new GroupLayout(this.pCron);
        this.pCron.setLayout(pCronLayout);
        pCronLayout.setHorizontalGroup(pCronLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pCronLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfCronExpression, -1, 165, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfLastExecuted, -1, 165, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfNextExecution, -1, 165, Short.MAX_VALUE).addContainerGap()));
        pCronLayout.setVerticalGroup(pCronLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pCronLayout.createSequentialGroup().addGap(1, 1, 1).addGroup(pCronLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfCronExpression, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.tfLastExecuted, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.tfNextExecution, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.taScriptDescription.setColumns(20);
        this.taScriptDescription.setLineWrap(true);
        this.taScriptDescription.setRows(2);
        this.taScriptDescription.setTabSize(0);
        this.taScriptDescription.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.taScriptDescription);
        GroupLayout pTaDescriptionLayout = new GroupLayout(this.pTaDescription);
        this.pTaDescription.setLayout(pTaDescriptionLayout);
        pTaDescriptionLayout.setHorizontalGroup(pTaDescriptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 473, Short.MAX_VALUE));
        pTaDescriptionLayout.setVerticalGroup(pTaDescriptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 60, Short.MAX_VALUE));
        this.bExportAll.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bExportAll, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bExportAll.text"));
        this.bExportAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.bExportAllActionPerformed(evt);
            }
        });
        this.bExport.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.bExportActionPerformed(evt);
            }
        });
        this.bImport.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bImport, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bImport.text"));
        this.bImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.bImportActionPerformed(evt);
            }
        });
        this.bEvaluate.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bEvaluate, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bEvaluate.text"));
        this.bEvaluate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.bEvaluateActionPerformed(evt);
            }
        });
        this.bBeautify.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bBeautify, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bBeautify.text"));
        this.bBeautify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.bBeautifyActionPerformed(evt);
            }
        });
        this.bSave.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bSave, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bSave.text"));
        this.bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.bSaveActionPerformed(evt);
            }
        });
        this.bReset.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bReset, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bReset.text"));
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.bResetActionPerformed(evt);
            }
        });
        GroupLayout pButtonsLayout = new GroupLayout(this.pButtons);
        this.pButtons.setLayout(pButtonsLayout);
        pButtonsLayout.setHorizontalGroup(pButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pButtonsLayout.createSequentialGroup().addContainerGap().addComponent(this.bExportAll, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bExport, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bImport, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bEvaluate, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bBeautify, -1, -1, Short.MAX_VALUE).addGap(36, 36, 36).addComponent(this.bSave, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bReset, -1, -1, Short.MAX_VALUE).addContainerGap()));
        pButtonsLayout.setVerticalGroup(pButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pButtonsLayout.createSequentialGroup().addContainerGap().addGroup(pButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bExport).addComponent(this.bImport).addComponent(this.bEvaluate).addComponent(this.bBeautify).addComponent(this.bSave).addComponent(this.bReset).addComponent(this.bExportAll)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cp.setLayout(new BorderLayout());
        this.pDescription.setLayout(new BorderLayout());
        this.cpDescription.setCollapsed(true);
        this.cpDescription.setDirection(JXCollapsiblePane.Direction.DOWN);
        this.pDescription.add((Component)this.cpDescription, "Last");
        Mnemonics.setLocalizedText((AbstractButton)this.tbDescription, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.tbDescription.text"));
        this.tbDescription.setToolTipText(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.tbDescription.toolTipText"));
        this.tbDescription.setHorizontalTextPosition(2);
        this.tbDescription.setIconTextGap(12);
        this.pDescription.add((Component)this.tbDescription, "North");
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setResizeWeight(0.2);
        this.jSplitPane1.setMinimumSize(new Dimension(250, 0));
        this.jPanel1.setMinimumSize(new Dimension(270, 0));
        this.jPanel1.setPreferredSize(new Dimension(270, 501));
        this.lType.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lType, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.lType.text"));
        this.cbScriptType.setFont(new Font("Dialog", 0, 12));
        this.cbScriptType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.cbScriptTypeActionPerformed(evt);
            }
        });
        this.tScripts.setModel(this.tableModel);
        this.tScripts.setComponentPopupMenu(this.pmOperations);
        this.tScripts.setGridColor(new Color(217, 217, 217));
        this.tScripts.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tScripts);
        this.bRefresh.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bRefresh.text"));
        this.bRefresh.setToolTipText(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bRefresh.toolTipText"));
        this.bRefresh.setMaximumSize(new Dimension(50, 15));
        this.bRefresh.setMinimumSize(new Dimension(50, 15));
        this.bRefresh.setPreferredSize(new Dimension(50, 15));
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.bRefreshActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.lLoading.text"));
        this.lLoading.setDirection(BusyPainter.Direction.RIGHT);
        this.bSearchAllScripts.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/magnifier.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bSearchAllScripts, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bSearchAllScripts.text"));
        this.bSearchAllScripts.setToolTipText(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bSearchAllScripts.toolTipText"));
        this.bSearchAllScripts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.bSearchAllScriptsActionPerformed(evt);
            }
        });
        this.bUpdate.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/update.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bUpdate, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bUpdate.text"));
        this.bUpdate.setToolTipText(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.bUpdate.toolTipText"));
        this.bUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.bUpdateActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lType, -1, 141, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bUpdate, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSearchAllScripts, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lLoading, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bRefresh, -2, 32, -2)).addComponent(this.cbScriptType, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.lLoading, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.bSearchAllScripts, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.bRefresh, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.bUpdate, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lType, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbScriptType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 420, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel4.add((Component)this.jPanel2, "Center");
        this.jPanel5.setLayout(new BorderLayout());
        this.tfSearch.setText(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.tfSearch.text"));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditorTopComponent.this.tfSearchActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.jLabel4.text"));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch, -1, 903, Short.MAX_VALUE).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSearch, -2, -1, -2).addComponent(this.jLabel4)).addContainerGap()));
        this.jPanel5.add((Component)this.jPanel6, "Center");
        this.cpCron.setCollapsed(true);
        this.cpCron.setDirection(JXCollapsiblePane.Direction.DOWN);
        this.jPanel5.add((Component)this.cpCron, "Last");
        this.jPanel4.add((Component)this.jPanel5, "First");
        this.jSplitPane1.setRightComponent(this.jPanel4);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 1281, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel4);
    }

    private void cbScriptTypeActionPerformed(ActionEvent evt) {
        ScriptType scriptType = this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
        this.refreshTable(scriptType);
        this.resetScriptText();
        if (scriptType == ScriptType.SCHEDULED) {
            this.showCronPanel(true);
        } else {
            this.showCronPanel(false);
            this.isCRONValid = false;
            this.clearCronTextFieds();
        }
        switch (scriptType) {
            case ROUTING: 
            case SCHEDULED: 
            case NOTIFICATION_PREPROCESSING: 
            case UTILITY_FUNCTIONS: 
            case CORRELATION: {
                this.taScriptText.setSyntaxEditingStyle("text/javascript");
                break;
            }
            case VISUALISATION_RULESET: 
            case VISUALISATION_CONFIGURATION: {
                this.taScriptText.setSyntaxEditingStyle("text/visscript");
            }
        }
    }

    private void clearCronTextFieds() {
        this.tfCronExpression.setText("");
        this.tfNextExecution.setText("");
        this.tfLastExecuted.setText("");
    }

    public void setDataToCronPanel(String scriptName) {
        ScheduledTask task = this.taskModel.getTaskByScriptName(scriptName);
        if (this.changedTasks.containsKey(scriptName)) {
            task = this.changedTasks.get(scriptName);
        }
        if (task != null) {
            this.currentTask = task;
            this.tfCronExpression.setText(task.getCronSpec());
            this.checkCRON();
            if (task.getLastExecuted() == 0L) {
                this.tfLastExecuted.setText("NEVER");
            } else {
                this.tfLastExecuted.setText(this.dateFormat.format(task.getLastExecuted()));
            }
            if (task.isEnabled()) {
                if (this.isCRONValid) {
                    String nextTimeExecution = this.calculateNextTimeScheduledTaskExecution(task);
                    this.tfNextExecution.setText(nextTimeExecution);
                } else {
                    this.tfNextExecution.setText("NEVER");
                }
            } else {
                this.tfNextExecution.setText("NEVER");
            }
        } else {
            this.currentTask = null;
            this.tfCronExpression.setText("");
            this.tfLastExecuted.setText("NEVER");
            this.tfNextExecution.setText("NEVER");
        }
        this.checkCRON();
    }

    private String calculateNextTimeScheduledTaskExecution(ScheduledTask task) {
        Date date = new Date(task.getLastExecuted());
        if (task.getLastExecuted() == 0L) {
            date = new Date();
        }
        ZonedDateTime zonedDate = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        ExecutionTime executionTime = ExecutionTime.forCron(this.parser.parse(task.getCronSpec()));
        Optional<ZonedDateTime> nextExection = executionTime.nextExecution(zonedDate);
        if (nextExection.isPresent()) {
            ZonedDateTime get = nextExection.get();
            Date nextDate = Date.from(get.toInstant());
            return this.dateFormat.format(nextDate);
        }
        return "";
    }

    private String calculateNextTimeFromNowScheduledTaskExecution(String cronSpec) {
        Date date = new Date();
        ZonedDateTime zonedDate = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        ExecutionTime executionTime = ExecutionTime.forCron(this.parser.parse(cronSpec));
        Optional<ZonedDateTime> nextExection = executionTime.nextExecution(zonedDate);
        if (nextExection.isPresent()) {
            ZonedDateTime get = nextExection.get();
            Date nextDate = Date.from(get.toInstant());
            return this.dateFormat.format(nextDate);
        }
        return "";
    }

    public void showCronPanel(boolean show) {
        if (show) {
            if (!this.toogleCollapsibleBool) {
                this.bToggleCollapsible.doClick();
                this.toogleCollapsibleBool = true;
                this.jPanel2.invalidate();
                this.jPanel2.validate();
                this.jPanel2.updateUI();
            }
        } else if (this.toogleCollapsibleBool) {
            this.bToggleCollapsible.doClick();
            this.toogleCollapsibleBool = false;
            this.jPanel2.invalidate();
            this.jPanel2.validate();
            this.jPanel2.updateUI();
        }
    }

    public void checkCRON() {
        try {
            Cron cron = this.parser.parse(this.tfCronExpression.getText());
            cron.validate();
            this.tfCronExpression.setBorder(UIManager.getBorder("TextField.border"));
            this.tfCronExpression.repaint();
            this.isCRONValid = true;
        }
        catch (IllegalArgumentException ex) {
            this.tfCronExpression.setBorder(new LineBorder(Color.RED));
            this.tfCronExpression.repaint();
            this.isCRONValid = false;
        }
    }

    private void bResetActionPerformed(ActionEvent evt) {
        Script script = this.tableModel.getScriptByRow(this.tScripts.getSelectedRow());
        if (this.changedScripts.containsKey(script.getId())) {
            if (this.changedScriptsBackUp.get(script.getId()) != null) {
                this.taScriptText.setText(this.changedScriptsBackUp.get(script.getId()));
                this.changedScriptsBackUp.remove(script.getId());
            }
            if (this.changedDescriptionsBackUp.get(script.getId()) != null) {
                this.taScriptDescription.setText(this.changedDescriptionsBackUp.get(script.getId()));
                this.changedDescriptionsBackUp.remove(script.getId());
            }
            this.changedScripts.remove(script.getId());
        }
        if (script.getType() == ScriptType.SCHEDULED) {
            if (this.changedTasksBackup.containsKey(script.getName())) {
                ScheduledTask task = this.taskModel.getTaskByScriptName(script.getName());
                task.setCronSpec(this.changedTasksBackup.get(script.getName()));
                this.tfCronExpression.setText(task.getCronSpec());
                this.changedTasks.remove(script.getName());
                this.changedTasksBackup.remove(script.getName());
            } else {
                this.tfCronExpression.setText("");
            }
        }
        this.bSave.setEnabled(false);
        this.bReset.setEnabled(false);
        this.tScripts.repaint();
        this.tfCronExpression.repaint();
    }

    private void bExportActionPerformed(ActionEvent evt) {
        if (!this.taScriptText.getText().isEmpty()) {
            JFileChooser saveFileDialog = new JFileChooser();
            saveFileDialog.setFileFilter(new JavaScripFileFilter());
            saveFileDialog.setAcceptAllFileFilterUsed(false);
            Script script = (Script)this.tScripts.getValueAt(this.tScripts.getSelectedRow(), 0);
            saveFileDialog.setSelectedFile(new File(script.getName() + ".js"));
            int result = saveFileDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
            if (result == 0) {
                try (FileOutputStream st = new FileOutputStream(saveFileDialog.getSelectedFile());){
                    ((OutputStream)st).write(this.taScriptText.getText().getBytes());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void bImportActionPerformed(ActionEvent evt) {
        JFileChooser openFileDialog = new JFileChooser();
        openFileDialog.setFileFilter(new JavaScripFileFilter());
        openFileDialog.setAcceptAllFileFilterUsed(false);
        int result = openFileDialog.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (result == 0) {
            try (BufferedReader reader = new BufferedReader(new FileReader(openFileDialog.getSelectedFile()));){
                String text;
                StringBuilder sb = new StringBuilder();
                while ((text = reader.readLine()) != null) {
                    sb.append(text).append("\n");
                }
                String fileName = openFileDialog.getSelectedFile().getName().replace(".js", "");
                if (this.tableModel.scriptAlreadyExist(fileName, this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()))) {
                    String faildMsg = NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.importScript.save.failed");
                    String title = NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.importScript.save.failed,title");
                    int overwrite = JOptionPane.showConfirmDialog(openFileDialog, String.format(faildMsg, fileName), title, 0, 2);
                    int rowByScriptName = this.tableModel.getRowByScriptName(fileName);
                    if (overwrite == 0) {
                        Script script = this.tableModel.getScriptByRow(rowByScriptName);
                        script.setScript(sb.toString());
                        this.apiService.updateScript(script);
                        this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                        if (this.findScriptUpdateTopComponent() != null) {
                            this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
                        }
                    }
                } else {
                    Script createScript = this.apiService.createScript(fileName, "javascript", " ", this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()));
                    createScript.setScript(sb.toString());
                    this.apiService.updateScript(createScript);
                    this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                    if (this.findScriptUpdateTopComponent() != null) {
                        this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
                    }
                }
                Updater updater = new Updater();
                updater.setNewScript(true);
                updater.setNewScriptName(fileName);
                updater.execute();
            }
            catch (IOException | ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void bBeautifyActionPerformed(ActionEvent evt) {
        this.formatJS();
    }

    private void bEvaluateActionPerformed(ActionEvent evt) {
        switch (this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex())) {
            case VISUALISATION_RULESET: 
            case VISUALISATION_CONFIGURATION: {
                this.validateScriptSyntax();
                break;
            }
            case ROUTING: 
            case SCHEDULED: 
            case NOTIFICATION_PREPROCESSING: 
            case UTILITY_FUNCTIONS: 
            case CORRELATION: {
                this.validateScriptSyntax();
            }
        }
    }

    private void bSaveActionPerformed(ActionEvent evt) {
        this.onSave = true;
        Script script = this.tableModel.getScriptByRow(this.tScripts.getSelectedRow());
        if (script != null) {
            if (script.getType() == ScriptType.SCHEDULED) {
                if (this.isCRONValid) {
                    try {
                        boolean isTaskAdded;
                        if (this.currentTask != null) {
                            if (this.changedTasks.containsKey(this.currentTask.getScriptName())) {
                                this.apiService.updateTask(this.currentTask.getId(), this.currentTask.getScriptName(), this.currentTask.getCronSpec(), script.isEnabled());
                                this.changedTasks.remove(this.currentTask.getScriptName());
                            }
                        } else if (!this.tfCronExpression.getText().isEmpty() && !(isTaskAdded = this.apiService.addTask(script.getName(), this.tfCronExpression.getText(), script.isEnabled()))) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"SchedulerTask exists for this script", 1));
                        }
                    }
                    catch (ApiServiceException_Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"CRON expression is not valid. Please, make sure that CRON is valid.", 0));
                }
            }
            if (this.changedScripts.containsKey(script.getId())) {
                if ((script = this.changedScripts.get(script.getId())).getType() == ScriptType.SCHEDULED == this.isCRONValid) {
                    if (this.checkIfFunctionNameIsValid(script)) {
                        String errorMessage = this.validateScriptSyntax(script.getScript());
                        if (errorMessage.isEmpty()) {
                            try {
                                this.saveLocalBackup(script);
                                this.apiService.updateScript(script);
                                this.changedScripts.remove(script.getId());
                                new Updater().execute();
                                if (this.findScriptUpdateTopComponent() != null) {
                                    this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
                                }
                            }
                            catch (ApiServiceException_Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            this.bSave.setEnabled(false);
                            this.bReset.setEnabled(false);
                        } else {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errorMessage, 0));
                        }
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Script name and function name are not matched. Please correct function name to correspond to script name.", 0));
                    }
                }
            } else if (script.getType() == ScriptType.SCHEDULED == this.isCRONValid) {
                new Updater().execute();
                if (this.findScriptUpdateTopComponent() != null) {
                    this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
                }
                this.bSave.setEnabled(false);
                this.bReset.setEnabled(false);
            }
        }
    }

    private void miNewActionPerformed(ActionEvent evt) {
        final AddNewScriptPanel panel = new AddNewScriptPanel((String)this.scriptTypeModel.getSelectedItem());
        final JButton ok = new JButton("Ok");
        DialogDescriptor des = new DialogDescriptor((Object)panel, NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"AddNewScriptPanel.title"), false, new Object[]{ok, DialogDescriptor.CANCEL_OPTION}, (Object)ok, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(ok)) {
                    if (panel.IsNameValid()) {
                        if (panel.getScriptType() == ScriptType.SCHEDULED) {
                            if (ScriptEditorTopComponent.this.tableModel.scriptAlreadyExist(panel.getScriptName(), panel.getScriptType())) {
                                String faildMsg = NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.newScript.save.failed");
                                JOptionPane.showMessageDialog(panel, String.format(faildMsg, panel.getScriptName()));
                            } else if (panel.isCRONValid()) {
                                try {
                                    ScriptEditorTopComponent.this.apiService.createScript(panel.getScriptName(), "javascript", panel.getScriptDesc(), panel.getScriptType());
                                    ScriptEditorTopComponent.this.apiService.addTask(panel.getScriptName(), panel.getCronExpression(), false);
                                    ScriptEditorTopComponent.this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                                    Updater updater = new Updater();
                                    updater.setNewScript(true);
                                    updater.setNewScriptName(panel.getScriptName());
                                    updater.execute();
                                    if (ScriptEditorTopComponent.this.findScriptUpdateTopComponent() != null) {
                                        ScriptEditorTopComponent.this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
                                    }
                                }
                                catch (ApiServiceException_Exception ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                ScriptEditorTopComponent.this.dialog.setVisible(false);
                                ScriptEditorTopComponent.this.dialog.dispose();
                            } else {
                                String faildMsg = "CRON expression is not valid.";
                                JOptionPane.showMessageDialog(panel, String.format(faildMsg, panel.getScriptName()));
                            }
                        } else if (ScriptEditorTopComponent.this.tableModel.scriptAlreadyExist(panel.getScriptName(), panel.getScriptType())) {
                            String faildMsg = NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.newScript.save.failed");
                            JOptionPane.showMessageDialog(panel, String.format(faildMsg, panel.getScriptName()));
                        } else {
                            try {
                                ScriptEditorTopComponent.this.apiService.createScript(panel.getScriptName(), "javascript", panel.getScriptDesc(), panel.getScriptType());
                                ScriptEditorTopComponent.this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                                Updater updater = new Updater();
                                updater.setNewScript(true);
                                updater.setNewScriptName(panel.getScriptName());
                                updater.execute();
                                if (ScriptEditorTopComponent.this.findScriptUpdateTopComponent() != null) {
                                    ScriptEditorTopComponent.this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
                                }
                            }
                            catch (ApiServiceException_Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            ScriptEditorTopComponent.this.dialog.setVisible(false);
                            ScriptEditorTopComponent.this.dialog.dispose();
                        }
                    } else {
                        String faildMsg = "Name should not contain \".\" , \",\", space or special characters except \"_\".";
                        JOptionPane.showMessageDialog(panel, String.format(faildMsg, panel.getScriptName()));
                    }
                }
            }
        });
        this.dialog = DialogDisplayer.getDefault().createDialog(des);
        this.dialog.setVisible(true);
    }

    private void miDeleteActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            int[] selectedRows = this.tScripts.getSelectedRows();
            String bodyMessage = "";
            bodyMessage = selectedRows.length > 1 ? String.format(NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.message.multipleDeletions"), selectedRows.length) : NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.message");
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)bodyMessage, NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.title"), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                try {
                    if (selectedRows.length == 1) {
                        Script script = (Script)this.tableModel.getValueAt(selectedRows[0], 0);
                        if (!this.recoveryScripts.isEmpty()) {
                            List<Script> scriptForRecoveryList = this.recoveryScripts.get(script.getType());
                            Iterator<Script> it = scriptForRecoveryList.iterator();
                            while (it.hasNext()) {
                                Script itScript = it.next();
                                if (!script.getId().equals(itScript.getId())) continue;
                                it.remove();
                                break;
                            }
                            this.recoveryScripts.put(script.getType(), scriptForRecoveryList);
                        }
                        if (script.getType() == ScriptType.SCHEDULED && this.currentTask != null) {
                            this.apiService.deleteTask(this.currentTask.getId());
                            this.currentTask = null;
                        }
                        this.apiService.deleteScript(script.getId());
                    } else {
                        ArrayList<Script> scriptsForDelete = new ArrayList<Script>();
                        ArrayList<ScheduledTask> tasksForDelete = new ArrayList<ScheduledTask>();
                        int[] nArray = selectedRows;
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            ScheduledTask taskForDelete;
                            Integer index = nArray[i];
                            Script scriptTmp = (Script)this.tableModel.getValueAt(index, 0);
                            scriptsForDelete.add(scriptTmp);
                            if (scriptTmp.getType() != ScriptType.SCHEDULED || (taskForDelete = this.taskModel.getTaskByScriptName(scriptTmp.getName())) == null) continue;
                            tasksForDelete.add(taskForDelete);
                        }
                        if (((Script)scriptsForDelete.get(0)).getType() == ScriptType.SCHEDULED && !tasksForDelete.isEmpty()) {
                            this.apiService.deleteTasks(tasksForDelete);
                            this.currentTask = null;
                        }
                        this.recoveryScripts.put(((Script)scriptsForDelete.get(0)).getType(), scriptsForDelete);
                        this.miRecover.setEnabled(true);
                        this.apiService.deleteScripts(scriptsForDelete);
                    }
                    this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                    new Updater().execute();
                    if (this.findScriptUpdateTopComponent() != null) {
                        this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
                    }
                    this.selectedRow = this.selectedRow - 1 <= 0 ? 0 : this.selectedRow - 1;
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void miUpActionPerformed(ActionEvent evt) {
        this.moveUp();
    }

    private void miDownActionPerformed(ActionEvent evt) {
        this.moveDown();
    }

    private void bExportAllActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(NbBundle.getMessage(RenameScriptPanel.class, (String)"ExportDialog.title"));
            int userSelection = fileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
            File source = new File(ScriptsZipUtils.generateZipFileName());
            if (userSelection == 0) {
                ScriptsZipUtils.zip(this.tableModel.getScriptsOfType(), source.getAbsolutePath());
                File target = fileChooser.getSelectedFile();
                if (!target.getAbsolutePath().endsWith(".zip")) {
                    target = new File(Paths.get(target.getAbsolutePath() + ".zip", new String[0]).toString());
                }
                Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.deleteIfExists(source.toPath());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void miRenameActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            ScriptType scriptType = this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
            final RenameScriptPanel panel = new RenameScriptPanel(scriptType);
            final Script script = (Script)this.tableModel.getValueAt(this.tScripts.getSelectedRow(), 0);
            final String oldName = script.getName();
            final String oldScript = script.getScript();
            panel.setOldScriptName(oldName);
            final JButton ok = new JButton("OK");
            DialogDescriptor d = new DialogDescriptor((Object)panel, NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"RenameScriptPanel.title"), false, new Object[]{ok, DialogDescriptor.CANCEL_OPTION}, (Object)ok, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource().equals(ok)) {
                        if (panel.isNewNameValid()) {
                            try {
                                ScheduledTask task;
                                script.setName(panel.getNewScriptName());
                                String renamedScript = script.getScript().replaceAll(oldName, panel.getNewScriptName());
                                script.setScript(renamedScript);
                                ScriptEditorTopComponent.this.apiService.renameScript(script);
                                if (script.getType() == ScriptType.SCHEDULED && (task = ScriptEditorTopComponent.this.taskModel.getTaskByScriptName(oldName)) != null) {
                                    task.setScriptName(panel.getNewScriptName());
                                    ScriptEditorTopComponent.this.apiService.updateTask(task.getId(), task.getScriptName(), task.getCronSpec(), task.isEnabled());
                                }
                                ScriptEditorTopComponent.this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                                new Updater().execute();
                                if (ScriptEditorTopComponent.this.findScriptUpdateTopComponent() != null) {
                                    ScriptEditorTopComponent.this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
                                }
                            }
                            catch (ApiServiceException_Exception ex) {
                                logger.log(Level.INFO, "{0}", ex.getFaultInfo().getData());
                                JOptionPane.showMessageDialog(panel, String.format((String)ex.getFaultInfo().getData().get(0), NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"RenameScriptPanel.title")));
                                script.setName(oldName);
                                script.setScript(oldScript);
                            }
                            ScriptEditorTopComponent.this.dialog.setVisible(false);
                            ScriptEditorTopComponent.this.dialog.dispose();
                        } else {
                            String faildMsg = "Name should not contain \".\" , \",\", space or special characters except \"_\".";
                            JOptionPane.showMessageDialog(panel, String.format(faildMsg, new Object[0]));
                        }
                    }
                }
            });
            this.dialog = DialogDisplayer.getDefault().createDialog(d);
            this.dialog.setVisible(true);
        }
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        new Updater().execute();
        this.changedScripts.clear();
        this.changedTasks.clear();
    }

    private void miEnableActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            try {
                if (this.tScripts.getSelectedRows().length == 1) {
                    ScheduledTask task;
                    Script script = (Script)this.tableModel.getValueAt(this.tScripts.getSelectedRow(), 0);
                    if (script.getType() == ScriptType.SCHEDULED && (task = this.taskModel.getTaskByScriptName(script.getName())) != null) {
                        this.apiService.updateTask(task.getId(), task.getScriptName(), task.getCronSpec(), true);
                        String nextTimeExecution = this.calculateNextTimeFromNowScheduledTaskExecution(task.getCronSpec());
                        this.tfNextExecution.setText(nextTimeExecution);
                    }
                    script.setEnabled(true);
                    this.apiService.enableScript(script, true);
                } else {
                    String message = String.format(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"EnableScriptConfirmation.message"), this.tScripts.getSelectedRows().length);
                    NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)message, NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"EnableScriptConfirmation.title"), 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                        ArrayList<Script> scripts = new ArrayList<Script>();
                        int[] nArray = this.tScripts.getSelectedRows();
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            Integer i2 = nArray[i];
                            Script sc = this.tableModel.getScriptByRow(i2);
                            sc.setEnabled(true);
                            scripts.add(sc);
                        }
                        if (((Script)scripts.get(0)).getType() == ScriptType.SCHEDULED) {
                            scripts.forEach(s -> {
                                ScheduledTask task = this.taskModel.getTaskByScriptName(s.getName());
                                if (task != null) {
                                    try {
                                        this.apiService.updateTask(task.getId(), task.getScriptName(), task.getCronSpec(), true);
                                    }
                                    catch (ApiServiceException_Exception ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            });
                        }
                        this.apiService.enableScripts(scripts, true);
                    }
                }
                this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                new Updater().execute();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void miEnableAllScriptsActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"EnableAllScriptsConfirmation.message"), NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"EnableAllScriptsConfirmation.title"), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                Map<ScriptType, List<Script>> scriptsOfType = this.tableModel.getScriptsOfType();
                List<Script> scripts = scriptsOfType.get(this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()));
                if (this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()) == ScriptType.SCHEDULED) {
                    this.taskModel.getAllTasks().stream().forEach(t -> {
                        try {
                            this.apiService.updateTask(t.getId(), t.getScriptName(), t.getCronSpec(), true);
                        }
                        catch (ApiServiceException_Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    });
                }
                scripts.forEach(s -> s.setEnabled(true));
                try {
                    this.apiService.enableScripts(scripts, true);
                    this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                    new Updater().execute();
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void miDisableActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            try {
                if (this.tScripts.getSelectedRows().length == 1) {
                    ScheduledTask task;
                    Script script = (Script)this.tableModel.getValueAt(this.tScripts.getSelectedRow(), 0);
                    script.setEnabled(false);
                    if (script.getType() == ScriptType.SCHEDULED && (task = this.taskModel.getTaskByScriptName(script.getName())) != null) {
                        this.apiService.updateTask(task.getId(), task.getScriptName(), task.getCronSpec(), false);
                    }
                    this.apiService.enableScript(script, false);
                } else {
                    String message = String.format(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"DisableScriptConfirmation.message"), this.tScripts.getSelectedRows().length);
                    NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)message, NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"DisableScriptConfirmation.title"), 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                        ArrayList<Script> scripts = new ArrayList<Script>();
                        int[] nArray = this.tScripts.getSelectedRows();
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            Integer i2 = nArray[i];
                            Script sc = this.tableModel.getScriptByRow(i2);
                            sc.setEnabled(false);
                            scripts.add(sc);
                        }
                        if (((Script)scripts.get(0)).getType() == ScriptType.SCHEDULED) {
                            scripts.forEach(s -> {
                                ScheduledTask task = this.taskModel.getTaskByScriptName(s.getName());
                                if (task != null) {
                                    try {
                                        this.apiService.updateTask(task.getId(), task.getScriptName(), task.getCronSpec(), false);
                                    }
                                    catch (ApiServiceException_Exception ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            });
                        }
                        this.apiService.enableScripts(scripts, false);
                    }
                }
                this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                new Updater().execute();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void miDisableAllScriptsActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"DisableAllScriptsConfirmation.message"), NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"DisableAllScriptsConfirmation.title"), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                Map<ScriptType, List<Script>> scriptsOfType = this.tableModel.getScriptsOfType();
                List<Script> scripts = scriptsOfType.get(this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()));
                scripts.forEach(s -> s.setEnabled(false));
                if (this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()) == ScriptType.SCHEDULED) {
                    this.taskModel.getAllTasks().stream().forEach(t -> {
                        try {
                            this.apiService.updateTask(t.getId(), t.getScriptName(), t.getCronSpec(), false);
                        }
                        catch (ApiServiceException_Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    });
                }
                try {
                    this.apiService.enableScripts(scripts, false);
                    this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                    new Updater().execute();
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void miRestorePreviousScriptVersionActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            try {
                Script script = (Script)this.tableModel.getValueAt(this.tScripts.getSelectedRow(), 0);
                String prevScript = script.getPrevScript();
                if (prevScript != null) {
                    script.setScript(prevScript);
                    this.apiService.updateScript(script);
                }
                this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                new Updater().execute();
                if (this.findScriptUpdateTopComponent() != null) {
                    this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
                }
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void bSearchAllScriptsActionPerformed(ActionEvent evt) {
        this.searchInAllFiles();
    }

    private void bUpdateActionPerformed(ActionEvent evt) {
        ScriptUpdateTopComponent tc = this.findScriptUpdateTopComponent();
        if (tc == null) {
            tc = new ScriptUpdateTopComponent();
        }
        tc.addRecoverScriptsEventListener(new RecoverScriptsEventListener(){

            @Override
            public void recoverScriptsAction(RecoverScriptsEvent event) {
                ScriptEditorTopComponent.this.recoverScripts();
            }

            @Override
            public void updateTableAction(RecoverScriptsEvent event) {
                new Updater().execute();
            }
        });
        tc.open();
        tc.requestActive();
    }

    private void recoverScripts() {
        System.out.println("Recovering scripts...");
        this.recoveryScripts.clear();
        for (Map.Entry<ScriptType, List<Script>> entry : this.tableModel.getScriptsOfType().entrySet()) {
            List<Script> fromMap = entry.getValue();
            ArrayList<Script> forMap = new ArrayList<Script>();
            for (Script script : fromMap) {
                Script newScript = new Script();
                newScript.setDescription(script.getDescription());
                newScript.setEnabled(script.isEnabled());
                newScript.setHash(script.getHash());
                newScript.setId(script.getId());
                newScript.setLanguage(script.getLanguage());
                newScript.setOrder(script.getOrder());
                newScript.setPrevScript(script.getPrevScript());
                newScript.setScript(script.getScript());
                newScript.setType(script.getType());
                newScript.setVersion(script.getVersion());
                newScript.setName(script.getName());
                forMap.add(newScript);
            }
            this.recoveryScripts.put(entry.getKey(), forMap);
        }
        this.miRecover.setEnabled(true);
    }

    private void miRecoverActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ScriptEditorTableModel.class, (String)"RecoverScriptsConfirmation.message"), NbBundle.getMessage(ScriptEditorTableModel.class, (String)"RecoverScriptsConfirmation.title"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
            final ScriptType scriptType = this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
            if (!this.recoveryScripts.isEmpty()) {
                this.miRecover.setEnabled(false);
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        List scriptForRecoveryList = (List)ScriptEditorTopComponent.this.recoveryScripts.get(scriptType);
                        Map<ScriptType, List<Script>> currentScriptsByTypeMap = ScriptEditorTopComponent.this.tableModel.getScriptsOfType();
                        HashMap<String, Script> currentScriptsMap = new HashMap<String, Script>();
                        List<Script> currentScriptsList = currentScriptsByTypeMap.get(scriptType);
                        ArrayList<Script> scriptsToRecover = new ArrayList<Script>();
                        ArrayList<Script> scriptsToAdd = new ArrayList<Script>();
                        for (Script script : currentScriptsList) {
                            currentScriptsMap.put(script.getId(), script);
                        }
                        for (Script recoveryScript : scriptForRecoveryList) {
                            Script currScript = (Script)currentScriptsMap.get(recoveryScript.getId());
                            if (currScript != null) {
                                if (currScript.getHash().equals(recoveryScript.getHash())) continue;
                                scriptsToRecover.add(recoveryScript);
                                continue;
                            }
                            scriptsToAdd.add(recoveryScript);
                        }
                        if (!scriptsToRecover.isEmpty()) {
                            ScriptEditorTopComponent.this.apiService.updateScripts(scriptsToRecover);
                        }
                        if (!scriptsToAdd.isEmpty()) {
                            scriptsToAdd.forEach(s -> {
                                try {
                                    ScriptEditorTopComponent.this.apiService.createScriptWithText(s.getName(), s.getScript(), s.getLanguage(), s.getDescription(), s.getType());
                                }
                                catch (ApiServiceException_Exception ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            });
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        new Updater().execute();
                        if (ScriptEditorTopComponent.this.findScriptUpdateTopComponent() != null) {
                            ScriptEditorTopComponent.this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
                        }
                    }
                };
                worker.execute();
            }
        }
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        this.search();
    }

    private ScriptUpdateTopComponent findScriptUpdateTopComponent() {
        Set opened = WindowManager.getDefault().getRegistry().getOpened();
        for (TopComponent tc : opened) {
            if (!(tc instanceof ScriptUpdateTopComponent)) continue;
            return (ScriptUpdateTopComponent)tc;
        }
        return null;
    }

    public void selectAndSearchScript(String type, String scriptName, String search) {
        if (!this.scriptTypeModel.getSelectedItem().toString().equalsIgnoreCase(type)) {
            this.cbScriptType.setSelectedItem(type);
            this.cbScriptType.invalidate();
            this.cbScriptType.validate();
            this.cbScriptType.repaint();
            ScriptType scriptType = this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
            this.refreshTable(scriptType);
        }
        int row = this.tableModel.getRowByScriptName(scriptName);
        if (this.tScripts.getSelectedRow() != row) {
            this.tScripts.setRowSelectionInterval(row, row);
            this.scrollTable();
        }
        this.tfSearch.setText(search);
        this.search();
    }

    private void scrollTable() {
        JViewport viewport = (JViewport)this.tScripts.getParent();
        Rectangle rect = this.tScripts.getCellRect(this.tScripts.getSelectedRow(), 0, true);
        Rectangle r2 = viewport.getVisibleRect();
        this.tScripts.scrollRectToVisible(new Rectangle(rect.x, rect.y, (int)r2.getWidth(), (int)r2.getHeight()));
    }

    private void search() {
        if (this.tfSearch.getText().isEmpty()) {
            this.taScriptText.setCaretPosition(0);
        }
        SearchContext context = new SearchContext();
        context.setSearchFor(this.tfSearch.getText());
        context.setMatchCase(false);
        context.setRegularExpression(true);
        context.setSearchForward(true);
        context.setWholeWord(false);
        context.setMarkAll(true);
        SearchEngine.find((JTextArea)this.taScriptText, (SearchContext)context);
    }

    private void searchInAllFiles() {
        ImageIcon mag = new ImageIcon(((Object)((Object)this)).getClass().getResource("/magnifier.png"));
        String searchTitle = NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.searchTitle");
        String input = (String)JOptionPane.showInputDialog((Component)((Object)this), searchTitle, searchTitle, -1, mag, null, null);
        if (input != null && !input.isEmpty()) {
            ArrayList<Script> searchResualts = new ArrayList<Script>();
            this.allScripts.forEach(s -> {
                if (s.getScript().toLowerCase().contains(input.toLowerCase())) {
                    searchResualts.add((Script)s);
                }
            });
            Mode mode = WindowManager.getDefault().findMode("bottomSlidingSide");
            SearchResualtsTopComponent tc = new SearchResualtsTopComponent();
            tc.setSearchStringAndScripts(input, searchResualts);
            mode.dockInto((TopComponent)tc);
            tc.open();
            tc.requestActive();
            tc.setDisplayName(String.format(NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"SearchResaulstsTopComponent.title"), input));
        }
    }

    public void componentOpened() {
        new Updater().execute();
    }

    public void componentClosed() {
        this.scriptsUpdater.shutdownNow();
    }

    private void saveLocalBackup(Script script) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String name = script.getType() + "_" + script.getName().replaceAll("\\W+", "_") + ".js";
        try (FileOutputStream fos = new FileOutputStream(tmpDir + "/" + name);){
            fos.write(script.getScript().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void refreshTable(ScriptType type) {
        if (type == ScriptType.VISUALISATION_CONFIGURATION || type == ScriptType.VISUALISATION_RULESET) {
            this.tableModel.sortScriptsByName(type);
        } else {
            this.tableModel.sortScriptsByOrder(type);
        }
    }

    private void resetScriptText() {
        this.setScriptText("");
        this.setDescriptionText("");
    }

    private void moveUp() {
        int[] selectedRows;
        if (this.tScripts.getSelectedRow() != -1 && (selectedRows = this.tScripts.getSelectedRows())[0] > 0) {
            List<Script> list = null;
            list = this.tableModel.moveUp(selectedRows);
            if (!list.isEmpty()) {
                try {
                    this.apiService.updateScripts(list);
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (this.selectedRow > 0) {
                --this.selectedRow;
            }
            this.tScripts.setRowSelectionInterval(this.selectedRow, selectedRows[selectedRows.length - 1] > 0 ? selectedRows[selectedRows.length - 1] - 1 : this.selectedRow);
            if (this.findScriptUpdateTopComponent() != null) {
                this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
            }
        }
    }

    private void moveDown() {
        int[] selectedRows;
        if (this.tScripts.getSelectedRow() != -1 && (selectedRows = this.tScripts.getSelectedRows())[selectedRows.length - 1] < this.tableModel.getRowCount() - 1) {
            List<Script> list = null;
            list = this.tableModel.moveDown(selectedRows);
            if (!list.isEmpty()) {
                try {
                    this.apiService.updateScripts(list);
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (this.selectedRow < this.tScripts.getRowCount() - 1) {
                ++this.selectedRow;
            }
            this.tScripts.setRowSelectionInterval(this.selectedRow, selectedRows[selectedRows.length - 1] < this.tScripts.getRowCount() - 1 ? selectedRows[selectedRows.length - 1] + 1 : this.selectedRow);
            if (this.findScriptUpdateTopComponent() != null) {
                this.ic.set(Collections.singletonList(new UpdateTableInScriptUpdateTopComponent(true)), null);
            }
        }
    }

    private void formatJS() {
        ScriptEngine se = this.sem.getEngineByName("JavaScript");
        InputStreamReader r = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/jsbeautifier.js"));
        try {
            se.eval(r);
            Invocable in = (Invocable)((Object)se);
            String formatted = (String)in.invokeFunction("js_beautify", this.taScriptText.getText());
            this.setScriptText(formatted);
        }
        catch (NoSuchMethodException | ScriptException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private boolean validateJS() {
        ScriptEngine se = this.sem.getEngineByName("javascript");
        try {
            se.eval(this.taScriptText.getText());
            return true;
        }
        catch (ScriptException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateScriptSyntax() {
        boolean valid = false;
        String errorMessage = "";
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            engine.eval(String.format("var DataMapper = Java.type(\"%s\")", DataMapperTest.class.getName()));
            engine.eval(String.format("var RawLog = Java.type(\"%s\")", RawLogTest.class.getName()));
            engine.eval(String.format("var SecurityEvent = Java.type(\"%s\")", SecurityEventTest.class.getName()));
            engine.eval(String.format("var ScriptUtils = Java.type(\"%s\")", ScriptUtilsTest.class.getName()));
            engine.eval(String.format("var VirusTotal = Java.type(\"%s\")", VirusTotalTest.class.getName()));
            engine.eval(String.format("var API = Java.type(\"%s\")", VirusTotalTest.API.class.getName()));
            engine.eval("var System = Java.type(\"java.lang.System\");");
            engine.put("SLIDING", (Object)CorrelationContextTest.Mode.SLIDING_WINDOW);
            engine.put("FIXED", (Object)CorrelationContextTest.Mode.FIXED_WINDOW);
            engine.put("ASC", Boolean.TRUE);
            engine.put("DESC", Boolean.FALSE);
            engine.put("DataMap", new DataMapManagerTest());
            engine.put("log", Logger.getLogger(ScriptEditorTopComponent.class.getName()));
            engine.put("Notification", new NotificationManagerTest(new ClusteringServiceTest()));
            engine.put("Country", new CountryTest());
            engine.put("SecurityEvents", new SecurityEventsTest());
            engine.put("Counter", new CounterManagerTest());
            engine.eval(this.taScriptText.getText());
            valid = true;
        }
        catch (ScriptException ex) {
            valid = false;
            errorMessage = ex.getLocalizedMessage();
        }
        finally {
            if (valid) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ScriptEditorTopComponent.class, (String)"ScriptEditorTopComponent.scriptValidator.valid.message"), 1));
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errorMessage, 0));
            }
        }
    }

    private String validateScriptSyntax(String script) {
        boolean valid = false;
        String errorMessage = "";
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            engine.eval(String.format("var DataMapper = Java.type(\"%s\")", DataMapperTest.class.getName()));
            engine.eval(String.format("var RawLog = Java.type(\"%s\")", RawLogTest.class.getName()));
            engine.eval(String.format("var SecurityEvent = Java.type(\"%s\")", SecurityEventTest.class.getName()));
            engine.eval(String.format("var ScriptUtils = Java.type(\"%s\")", ScriptUtilsTest.class.getName()));
            engine.eval(String.format("var VirusTotal = Java.type(\"%s\")", VirusTotalTest.class.getName()));
            engine.eval(String.format("var API = Java.type(\"%s\")", VirusTotalTest.API.class.getName()));
            engine.eval("var System = Java.type(\"java.lang.System\");");
            engine.put("SLIDING", (Object)CorrelationContextTest.Mode.SLIDING_WINDOW);
            engine.put("FIXED", (Object)CorrelationContextTest.Mode.FIXED_WINDOW);
            engine.put("ASC", Boolean.TRUE);
            engine.put("DESC", Boolean.FALSE);
            engine.put("DataMap", new DataMapManagerTest());
            engine.put("log", Logger.getLogger(ScriptEditorTopComponent.class.getName()));
            engine.put("Notification", new NotificationManagerTest(new ClusteringServiceTest()));
            engine.put("Country", new CountryTest());
            engine.put("SecurityEvents", new SecurityEventsTest());
            engine.put("Counter", new CounterManagerTest());
            engine.eval(script);
            valid = true;
        }
        catch (ScriptException ex) {
            valid = false;
            errorMessage = ex.getLocalizedMessage();
        }
        return errorMessage;
    }

    private boolean testScript(String script, Object param) {
        if (ScriptType.CORRELATION.equals((Object)((ScriptType)this.cbScriptType.getSelectedItem()))) {
            this.correlate(script, param);
        } else if (ScriptType.ROUTING.equals((Object)((ScriptType)this.cbScriptType.getSelectedItem()))) {
            this.route(script, param);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void route(String script, Object param) {
        ScriptEngine se = this.sem.getEngineByName("javascript");
        ScriptEngineFactory fac = se.getFactory();
        String s = fac.getProgram(script);
        try {
            se.eval(s);
            if (!(se instanceof Invocable)) return;
            Invocable inv = (Invocable)((Object)se);
            try {
                Object dummy = inv.invokeFunction(this.genFuncName(), param);
                if (!(dummy instanceof String)) return;
                return;
            }
            catch (NoSuchMethodException | ScriptException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        }
        catch (ScriptException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void correlate(String script, Object param) {
        ScriptEngine se = this.sem.getEngineByName("javascript");
        se.put("SecurityEvent", new SecurityEvent());
        ScriptEngineFactory fac = se.getFactory();
        String s = fac.getProgram(script);
        try {
            se.eval(s);
            if (!(se instanceof Invocable)) return;
            Invocable inv = (Invocable)((Object)se);
            try {
                Object dummy = inv.invokeFunction(this.genFuncName(), param);
                if (dummy instanceof Array) return;
                if (dummy instanceof List) return;
                if (!(dummy instanceof Collection)) return;
                return;
            }
            catch (NoSuchMethodException | ScriptException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        }
        catch (ScriptException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String genFuncName() {
        Script script = (Script)this.tableModel.getValueAt(this.tScripts.getSelectedRow(), 0);
        if (this.scriptTypeModel.getSelectedItem() == ScriptType.CORRELATION.value()) {
            return script.getName() + "_correlate";
        }
        return script.getName() + "_route";
    }

    private void disableButtons() {
        this.miDelete.setEnabled(false);
        this.miDown.setEnabled(false);
        this.miUp.setEnabled(false);
        this.bExport.setEnabled(false);
        this.bEvaluate.setEnabled(false);
        this.bBeautify.setEnabled(false);
        this.bSave.setEnabled(false);
        this.bReset.setEnabled(false);
    }

    private void toggleLoading() {
        this.lLoading.setBusy(!this.lLoading.isBusy());
    }

    private void setOffsetsInFilter(Script script) {
        if (script != null) {
            if (!script.getType().equals((Object)ScriptType.VISUALISATION_CONFIGURATION) && !script.getType().equals((Object)ScriptType.VISUALISATION_RULESET)) {
                String fullFunctionName = "var " + script.getName() + " = new function";
                Pattern findWordPattern = Pattern.compile(fullFunctionName);
                Matcher matcher = findWordPattern.matcher(this.taScriptText.getText());
                int offsetStart = -1;
                int offsetEnd = -1;
                while (matcher.find()) {
                    offsetStart = matcher.start();
                    offsetEnd = matcher.end();
                }
                this.taFilter.setOffsets(offsetStart, offsetEnd);
            } else {
                this.taFilter.setOffsets(-1, -1);
            }
        }
    }

    private boolean checkIfFunctionNameIsValid(Script script) {
        if (script != null) {
            if (!(script.getType().equals((Object)ScriptType.VISUALISATION_CONFIGURATION) || script.getType().equals((Object)ScriptType.VISUALISATION_RULESET) || script.getType().equals((Object)ScriptType.UTILITY_FUNCTIONS))) {
                String fullFunctionName = "var " + script.getName() + " = new function";
                Pattern findWordPattern = Pattern.compile(fullFunctionName);
                Matcher matcher = findWordPattern.matcher(script.getScript());
                return matcher.find();
            }
            return true;
        }
        return false;
    }

    private void setScriptText(String text) {
        this.taScriptText.setText(text);
        this.taScriptText.setCaretPosition(0);
    }

    private void setDescriptionText(String text) {
        this.taScriptDescription.setText(text);
        this.taScriptDescription.setCaretPosition(0);
    }

    private class WorkerData {
        List<Script> scripts;
        List<ScheduledTask> tasks;

        public WorkerData(List<Script> scripts, List<ScheduledTask> tasks) {
            this.scripts = scripts;
            this.tasks = tasks;
        }

        public List<Script> getScripts() {
            return this.scripts;
        }

        public List<ScheduledTask> getTasks() {
            return this.tasks;
        }
    }

    public class Updater
    extends SwingWorker<WorkerData, Void> {
        private boolean newScript;
        private String newScriptName;

        @Override
        protected WorkerData doInBackground() throws Exception {
            ScriptEditorTopComponent.this.toggleLoading();
            try {
                List scripts = (List)ScriptEditorTopComponent.this.apiService.getAllScripts();
                List tasks = ScriptEditorTopComponent.this.apiService.getAllTasks();
                return new WorkerData(scripts, tasks);
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        @Override
        protected void done() {
            try {
                WorkerData response = (WorkerData)this.get();
                ScriptEditorTopComponent.this.allScripts = response.getScripts();
                ScriptEditorTopComponent.this.taskModel.setTasks(response.getTasks());
                if (ScriptEditorTopComponent.this.allScripts != null) {
                    ScriptEditorTopComponent.this.tableModel.setData(ScriptEditorTopComponent.this.allScripts);
                    ScriptEditorTopComponent.this.refreshTable(ScriptEditorTopComponent.this.scriptTypeModel.getSelectedItem(ScriptEditorTopComponent.this.scriptTypeModel.getSelectedIndex()));
                    ScriptEditorTopComponent.this.resetScriptText();
                    ScriptEditorTopComponent.this.disableButtons();
                    if (this.newScript) {
                        ScriptEditorTopComponent.this.selectedRow = ScriptEditorTopComponent.this.tableModel.getRowByScriptName(this.newScriptName);
                        ScriptEditorTopComponent.this.setOffsetsInFilter(ScriptEditorTopComponent.this.tableModel.getScriptByRow(ScriptEditorTopComponent.this.selectedRow));
                    }
                    if (ScriptEditorTopComponent.this.tableModel.getRowCount() > 0 && ScriptEditorTopComponent.this.selectedRow != -1 && ScriptEditorTopComponent.this.selectedRow <= ScriptEditorTopComponent.this.tableModel.getRowCount()) {
                        ScriptEditorTopComponent.this.tScripts.setRowSelectionInterval(ScriptEditorTopComponent.this.selectedRow, ScriptEditorTopComponent.this.selectedRow);
                    }
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ScriptEditorTopComponent.this.toggleLoading();
        }

        public void setNewScript(boolean newScript) {
            this.newScript = newScript;
        }

        public void setNewScriptName(String newScriptName) {
            this.newScriptName = newScriptName;
        }
    }
}

