/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;

public abstract class AbstractZip {
    protected Map<String, ExportZipEntry> exportZipEntries = new HashMap<String, ExportZipEntry>();

    public abstract ExportZipEntry createEntry(String var1);

    public void addEntry(ExportZipEntry entry) {
        this.exportZipEntries.put(entry.getName(), entry);
    }

    public void zipEntries(OutputStream os) throws IOException {
        ZipOutputStream zipos = new ZipOutputStream(os);
        zipos.setMethod(8);
        for (String name : this.exportZipEntries.keySet()) {
            ExportZipEntry exportZipEntry = this.exportZipEntries.get(name);
            ZipEntry zipEntry = new ZipEntry(exportZipEntry.getName());
            zipos.putNextEntry(zipEntry);
            exportZipEntry.writeData(zipos);
        }
        zipos.flush();
        zipos.finish();
    }

    public void dispose() {
        for (String name : this.exportZipEntries.keySet()) {
            ExportZipEntry exportZipEntry = this.exportZipEntries.get(name);
            exportZipEntry.dispose();
        }
    }
}

