/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.usermgmt;

import java.util.Arrays;
import java.util.List;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ComplexityViolation;
import rs.co.ast.aspen.api.service.ConsoleUser;
import rs.co.ast.aspen.gui.module.usermgmt.ConsoleUserChangedEvent;

public class ConsoleUserService
implements Lookup.Provider {
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private InstanceContent content = new InstanceContent();
    private Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.content);

    public void changePassword(String id, String password) throws ApiServiceException_Exception {
        this.apiService.setConsoleUserPassword(id, password);
        this.consoleUserChanged(id);
    }

    public List<ComplexityViolation> checkPasswordComplexity(String password) throws ApiServiceException_Exception {
        return this.apiService.checkPasswordComplexity(password);
    }

    public void createUser(String id) throws ApiServiceException_Exception {
        this.apiService.createConsoleUser(id);
        this.consoleUserChanged(id);
    }

    public void deleteUser(String id) throws ApiServiceException_Exception {
        this.apiService.deleteConsoleUser(id);
        this.consoleUserChanged(id);
    }

    public void enableUser(String id) throws ApiServiceException_Exception {
        this.apiService.enableConsoleUser(id);
        this.consoleUserChanged(id);
    }

    public void disableUser(String id) throws ApiServiceException_Exception {
        this.apiService.disableConsoleUser(id);
        this.consoleUserChanged(id);
    }

    public void unlockUser(String id) throws ApiServiceException_Exception {
        this.apiService.unlockConsoleUser(id);
        this.consoleUserChanged(id);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public List<ConsoleUser> getUsers() throws ApiServiceException_Exception {
        return this.apiService.getConsoleUsers();
    }

    public void updateData(ConsoleUser user) throws ApiServiceException_Exception {
        this.apiService.updateConsoleUser(user);
        this.consoleUserChanged(user.getId());
    }

    private void consoleUserChanged(String id) {
        ConsoleUserChangedEvent e = new ConsoleUserChangedEvent(id);
        this.content.set(Arrays.asList(e), null);
    }
}

