/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DataMapValue;
import rs.co.ast.aspen.gui.module.datamaps.DataMapName;
import rs.co.ast.aspen.gui.module.datamaps.ProgressValueChangedEvent;
import rs.co.ast.aspen.gui.module.datamaps.ReportDataMapKey;

public class DataMapDataSource
implements JRDataSource {
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private ProgressValueChangedEvent event = new ProgressValueChangedEvent();
    private List<ReportDataMapKey> dataMapKeys = new ArrayList<ReportDataMapKey>();
    private String mapName;
    private int position = 0;

    public DataMapDataSource(String mapName, ProgressValueChangedEvent.ProgressValueChangedListener listener) {
        this.mapName = mapName;
        this.event.addProgressValueChangeListener(listener);
        try {
            List keysForDataMap = this.apiService.getKeysForDataMap(mapName);
            for (String key : keysForDataMap) {
                DataMapValue value = this.apiService.getValueForDataMapKey(mapName, key);
                this.dataMapKeys.add(new ReportDataMapKey(key, value.getValue()));
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public DataMapDataSource(DataMapName dataMapName, ProgressValueChangedEvent.ProgressValueChangedListener listener) {
        this(dataMapName.getName(), listener);
    }

    public List<ReportDataMapKey> getDataMapKeys() {
        return this.dataMapKeys;
    }

    public String getMapName() {
        return this.mapName;
    }

    public boolean next() throws JRException {
        return this.position++ < this.dataMapKeys.size();
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        if (this.position - 1 < this.dataMapKeys.size()) {
            switch (jrField.getName()) {
                case "mapKey": {
                    return this.dataMapKeys.get(this.position - 1 < 0 ? 0 : this.position - 1).getKey();
                }
                case "keyValue": {
                    return this.dataMapKeys.get(this.position - 1 < 0 ? 0 : this.position - 1).getValue();
                }
            }
        }
        return String.format("%s %s", NbBundle.getMessage(DataMapDataSource.class, (String)"DataMapDataSource.UnknownField.text"), jrField.getName());
    }
}

