/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import rs.co.ast.aspen.api.service.ParsingRuleMetaRule;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;

public class MetaRulePanel
extends JPanel
implements PropertyChangeListener {
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private ParsingRuleMetaRule metaRule;
    private JButton bDeleteMetaRule;
    private JCheckBox cbActive;
    private JLabel jLabel1;
    private JTextField tfExpression;

    public MetaRulePanel(ParsingRuleMetaRule mr) {
        this.initComponents();
        this.addAncestorListener(new MyAncestorListener(this).getAncestorListener());
        this.updateEditMode();
        this.metaRule = mr;
        this.updateDisplay(this.metaRule);
        this.cbActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParsingRuleDTOWrapper rule = (ParsingRuleDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRuleDTOWrapper.class);
                MetaRulePanel.this.model.setMetaRuleActive(rule, MetaRulePanel.this.metaRule, MetaRulePanel.this.cbActive.isSelected());
            }
        });
        this.tfExpression.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                MetaRulePanel.this.updateValue();
            }
        });
    }

    private void updateValue() {
        String tmp;
        String text = this.tfExpression.getText();
        String value = this.metaRule.getRuleEL();
        if (value == null) {
            value = "";
        }
        if (!value.equals(text) && !(tmp = this.tfExpression.getText()).equals("")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParsingRuleDTOWrapper rule = (ParsingRuleDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRuleDTOWrapper.class);
                    MetaRulePanel.this.model.setMetaRuleExpression(rule, MetaRulePanel.this.metaRule, tmp);
                    MetaRulePanel.this.tfExpression.requestFocus();
                    MetaRulePanel.this.tfExpression.setCaretPosition(MetaRulePanel.this.tfExpression.getText().length());
                }
            });
        }
    }

    public final void updateDisplay(ParsingRuleMetaRule metaRule) {
        this.cbActive.setSelected(metaRule.isActive());
        this.tfExpression.setText(metaRule.getRuleEL());
    }

    public ParsingRuleMetaRule getMetaRule() {
        return this.metaRule;
    }

    private void updateEditMode() {
        this.cbActive.setEnabled(this.model.isEditMode());
        this.tfExpression.setEditable(this.model.isEditMode());
        this.bDeleteMetaRule.setEnabled(this.model.isEditMode());
    }

    private void initComponents() {
        this.cbActive = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.tfExpression = new JTextField();
        this.bDeleteMetaRule = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cbActive.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.cbActive, (String)NbBundle.getMessage(MetaRulePanel.class, (String)"MetaRulePanel.cbActive.text"));
        this.cbActive.setHorizontalTextPosition(2);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setLabelFor(this.tfExpression);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MetaRulePanel.class, (String)"MetaRulePanel.jLabel1.text"));
        this.tfExpression.setText(NbBundle.getMessage(MetaRulePanel.class, (String)"MetaRulePanel.tfExpression.text"));
        this.bDeleteMetaRule.setFont(new Font("Dialog", 0, 12));
        this.bDeleteMetaRule.setIcon(new ImageIcon(this.getClass().getResource("/delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bDeleteMetaRule, (String)NbBundle.getMessage(MetaRulePanel.class, (String)"MetaRulePanel.bDeleteMetaRule.text"));
        this.bDeleteMetaRule.setMargin(new Insets(0, 0, 0, 0));
        this.bDeleteMetaRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaRulePanel.this.bDeleteMetaRuleActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbActive).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfExpression, -1, 221, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDeleteMetaRule).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbActive).addComponent(this.jLabel1).addComponent(this.tfExpression, -2, -1, -2).addComponent(this.bDeleteMetaRule)));
    }

    private void bDeleteMetaRuleActionPerformed(ActionEvent evt) {
        ParsingRuleDTOWrapper rule = (ParsingRuleDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRuleDTOWrapper.class);
        this.model.removeMetaRule(rule, this.metaRule);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("editModeChanged")) {
            this.updateEditMode();
        }
    }

    public class MyAncestorListener
    implements AncestorListener {
        private final MetaRulePanel panel;

        public MyAncestorListener(MetaRulePanel panel) {
            this.panel = panel;
        }

        public AncestorListener getAncestorListener() {
            return this;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            MetaRulePanel.this.model.addPropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            MetaRulePanel.this.model.removePropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

