/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.ChartPanel;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ItemsPerTimePeriod;
import rs.co.ast.aspen.api.service.TermTimeHistogram;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventWrapper;
import rs.co.ast.aspen.gui.module.securityevents.widget.ButtonPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.LoadingPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.QueuePanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.ReloadPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.Widget;
import rs.co.ast.chart.ASTChart;
import rs.co.ast.chart.OverviewChart;
import rs.co.ast.chart.event.ASTMouseEvent;
import rs.co.ast.chart.event.ASTMouseListener;
import rs.co.ast.chart.event.ASTPlotChangeListener;

public class ByFieldPanel
extends JPanel
implements Widget {
    private static final Logger logger = Logger.getLogger(ByFieldPanel.class.getName());
    private Lookup.Result<SecurityEventWrapper> lr = Utilities.actionsGlobalContext().lookupResult(SecurityEventWrapper.class);
    private static final int NO_SOURCES = 20;
    private static final int GRAPH_HEIGHT = 150;
    private static final int MAX_SOURCE_TITLE_LEN = 190;
    private Map<String, Color> itemColors = new HashMap<String, Color>();
    private SecurityEventWrapper securityEventWrapper;
    private transient MouseListener listener;
    private FileSystem fs = FileUtil.createMemoryFileSystem();
    private FileObject root = this.fs.getRoot();
    private UpdateParams params;
    private OverviewChart chart;
    private ASTPlotChangeListener plotChangeListener;
    private ASTMouseListener mouseListener;
    private LoadingPanel loadingPanel;
    private QueuePanel queuePanel;
    private List<String> eventsListByField = new ArrayList<String>();
    private LinkedHashMap<String, Long> countedEventListByField = new LinkedHashMap();
    private JPopupMenu popUpMenu;
    private final List<String> listOfCharactersToEscape = Arrays.asList("\\", "+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":");
    private int nextCounter = 0;
    private JPanel buttonsPanel;
    private JPanel graphPanel;
    private JPanel pDataPanel;

    public ByFieldPanel() {
        this.initComponents();
        this.popUpMenu = new JPopupMenu();
        JMenuItem miCopy = new JMenuItem("Copy");
        miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringBuilder sb = new StringBuilder();
                Set entrySet = ByFieldPanel.this.countedEventListByField.entrySet();
                for (Map.Entry next : entrySet) {
                    sb.append(next.getKey());
                    sb.append("\t");
                    sb.append(next.getValue());
                    sb.append(System.lineSeparator());
                }
                StringSelection selection = new StringSelection(sb.toString());
                cb.setContents(selection, selection);
            }
        });
        this.popUpMenu.add(miCopy);
        this.graphPanel.setLayout(new BorderLayout());
        this.buttonsPanel.setOpaque(false);
        this.lr.allInstances();
        this.lr.addLookupListener(ev -> {
            Lookup.Result res = (Lookup.Result)ev.getSource();
            Collection instances = res.allInstances();
            for (Object o : instances) {
                if (!(o instanceof SecurityEventWrapper)) continue;
                this.securityEventWrapper = (SecurityEventWrapper)o;
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ByFieldPanel.this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ByFieldPanel.this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.listener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JButton btn = (JButton)e.getSource();
                if (ByFieldPanel.this.securityEventWrapper != null) {
                    String prevQuery = ByFieldPanel.this.securityEventWrapper.getQuery();
                    String query = null;
                    String field = ByFieldPanel.this.params.getField();
                    String text = String.format("\"%s\"", btn.getToolTipText());
                    text = this.escapeSpecialCharacters(text);
                    if (e.getButton() == 3) {
                        ByFieldPanel.this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                    if (ByFieldPanel.this.isCTRL_SHIFT_CLICK(e) && e.getButton() != 3) {
                        String string = query = !prevQuery.isEmpty() ? prevQuery + " " : prevQuery;
                        if (!query.isEmpty()) {
                            query = query + "OR ";
                        }
                        query = query + field + ":" + text + "";
                    } else if (e.isShiftDown() && e.getButton() != 3) {
                        query = !prevQuery.isEmpty() ? prevQuery + " " : prevQuery;
                        query = query + "NOT " + field + ":" + text + "";
                    } else if (e.isControlDown() && e.getButton() != 3) {
                        query = !prevQuery.isEmpty() ? prevQuery + " AND " : prevQuery;
                        query = query + field + ":" + text + "";
                    } else if (e.getButton() != 3) {
                        query = field + ":" + text + "";
                    }
                    if (query != null && !query.isEmpty()) {
                        try {
                            FileObject fileData;
                            FileObject testFolder;
                            if (ByFieldPanel.this.root.getFileObject("SecurityEventFolder") == null) {
                                testFolder = ByFieldPanel.this.root.createFolder("SecurityEventFolder");
                                fileData = testFolder.createData("SecurityEventID", "securityevent");
                            } else {
                                testFolder = ByFieldPanel.this.root.getFileObject("SecurityEventFolder");
                                fileData = testFolder.getFileObject("SecurityEventID", "securityevent");
                            }
                            fileData.setAttribute("query", (Object)query);
                            fileData.setAttribute("start", (Object)ByFieldPanel.this.securityEventWrapper.getOptions().getTimeStart());
                            fileData.setAttribute("finish", (Object)ByFieldPanel.this.securityEventWrapper.getOptions().getTimeFinish());
                            fileData.setAttribute("lastNHours", (Object)ByFieldPanel.this.securityEventWrapper.getOptions().isLastNHours());
                            fileData.setAttribute("lastNHoursSelectedIndex", (Object)ByFieldPanel.this.securityEventWrapper.getOptions().getLastNHoursSelectedIndex());
                            fileData.setAttribute("now", (Object)ByFieldPanel.this.securityEventWrapper.getOptions().isNow());
                            fileData.setAttribute("ASC", (Object)false);
                            DataObject sedo = DataObject.find((FileObject)fileData);
                            ((OpenCookie)sedo.getLookup().lookup(OpenCookie.class)).open();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }

            private String escapeSpecialCharacters(String text) {
                text = text.substring(1, text.length() - 1);
                for (String escape : ByFieldPanel.this.listOfCharactersToEscape) {
                    text = text.replace(escape, "\\" + escape);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("\"").append(text).append("\"");
                text = sb.toString();
                return text;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.plotChangeListener = event -> {
            this.params.getDisplayOptions().setTimeStart(event.getStartTime());
            this.params.getDisplayOptions().setTimeFinish(event.getFinishTime());
        };
        this.mouseListener = new ASTMouseListener(){

            public void mousePressed(ASTMouseEvent e) {
            }

            public void mouseReleased(ASTMouseEvent e) {
                double t = (e.getUpperBound() - e.getLowerBound()) / 30000.0 / 10.0;
                if (t < 9.0) {
                    ByFieldPanel.this.params.getDisplayOptions().setIntervalObj(ByFieldPanel.this.params.getDisplayOptions().getIntervals()[0]);
                }
            }
        };
    }

    private boolean isCTRL_SHIFT_CLICK(MouseEvent e) {
        int onmask = 1216;
        return (e.getModifiersEx() & onmask) == onmask;
    }

    @Override
    public void setLoadingPanel() {
        if (this.loadingPanel == null) {
            this.loadingPanel = new LoadingPanel();
        }
        this.removeAll();
        this.add(this.loadingPanel);
    }

    @Override
    public void setReloadPanel(ReloadPanel panel) {
        this.removeAll();
        this.add(panel);
    }

    @Override
    public void setQueuePanel() {
        if (this.queuePanel == null) {
            this.queuePanel = new QueuePanel();
        }
        this.removeAll();
        this.add(this.queuePanel);
    }

    @Override
    public void update(List<TermTimeHistogram> list, Class<?> clazz) {
        Map<String, Long> m = this.getTotalEventsByField(list);
        TreeMap<String, Long> sm = new TreeMap<String, Long>(new MyComparator(m, this.params.isSort()));
        this.buttonsPanel.removeAll();
        sm.putAll(m);
        this.eventsListByField.clear();
        this.countedEventListByField.clear();
        sm.keySet().stream().forEach(s -> this.eventsListByField.add((String)s));
        if (!this.params.isClickedNext()) {
            this.nextCounter = 0;
        }
        Iterator it = sm.keySet().iterator();
        for (int i = 0; i < this.params.getNoSources(); ++i) {
            ++this.nextCounter;
            String key = null;
            Long value = null;
            if (!it.hasNext()) continue;
            key = (String)it.next();
            value = m.get(key);
            this.countedEventListByField.put(key, value);
            this.itemColors.put(key, ASTChart.COLORS[i]);
            ButtonPanel button = new ButtonPanel(key, String.format("%d. \"%s\"", this.nextCounter, StringUtils.abbreviate((String)key, (int)190)), value != null ? String.format("%,d", value) : "", ASTChart.COLORS[i]);
            button.setOpaque(false);
            button.setListener(this.listener);
            this.buttonsPanel.add(button);
        }
        this.buttonsPanel.invalidate();
        this.buttonsPanel.validate();
        this.buttonsPanel.repaint();
        ChartPanel cpComponent = null;
        if (this.chart == null) {
            this.chart = new OverviewChart(this.createDataSet(list, sm, clazz));
            cpComponent = this.chart.getChartPanel();
        } else {
            this.chart.removeAllListeners();
            this.chart.updateChart(this.createDataSet(list, sm, clazz));
            cpComponent = this.chart.getChartPanel();
        }
        this.graphPanel.removeAll();
        if (cpComponent != null) {
            Dimension d = this.getParent().getParent().getParent().getSize();
            d.setSize(d.getWidth() - 35.0, 150.0);
            cpComponent.setPreferredSize(new Dimension(0, 150));
            cpComponent.setMaximumSize(d);
            this.graphPanel.add((Component)cpComponent);
        }
        this.graphPanel.invalidate();
        this.graphPanel.validate();
        this.graphPanel.repaint();
        this.removeAll();
        this.add(this.pDataPanel);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<TermTimeHistogram> getTimeHistogram(Object data) throws ApiServiceException_Exception {
        this.params = (UpdateParams)data;
        ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
        return apiService.getSETermTimeHistogram(this.params.getQuery(), this.params.getField(), this.params.getTimeStart(), this.params.getTimeFinish(), this.params.getNoSources(), this.params.getInterval(), this.params.isSort());
    }

    private TimeSeries[] createDataSet(List<TermTimeHistogram> items, SortedMap<String, Long> sortedData, Class clazz) {
        ArrayList<TimeSeries> list = new ArrayList<TimeSeries>();
        HashMap map = new HashMap();
        HashSet<Long> times = new HashSet<Long>();
        items.forEach(tth -> map.put(tth.getTerm(), tth));
        int i = 0;
        for (String item : sortedData.keySet()) {
            if (i >= 20) break;
            TermTimeHistogram tth2 = (TermTimeHistogram)map.get(item);
            TimeSeries ts = new TimeSeries((Comparable)((Object)tth2.getTerm()));
            times.clear();
            for (ItemsPerTimePeriod iptp : tth2.getHistogram()) {
                if (iptp.getTime() < this.params.getTimeStart() || iptp.getTime() > this.params.getTimeFinish() || times.contains(iptp.getTime())) continue;
                times.add(iptp.getTime());
                ts.addOrUpdate(RegularTimePeriod.createInstance((Class)clazz, (Date)new Date(iptp.getTime()), (TimeZone)TimeZone.getDefault()), (double)iptp.getCount());
            }
            if (ts.getItemCount() > 0) {
                list.add(ts);
            }
            ++i;
        }
        TimeSeries[] arr = new TimeSeries[list.size()];
        return list.toArray(arr);
    }

    private void initComponents() {
        this.pDataPanel = new JPanel();
        this.graphPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.pDataPanel.setBackground(new Color(255, 255, 255));
        this.graphPanel.setBackground(new Color(255, 255, 255));
        GroupLayout graphPanelLayout = new GroupLayout(this.graphPanel);
        this.graphPanel.setLayout(graphPanelLayout);
        graphPanelLayout.setHorizontalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 338, Short.MAX_VALUE));
        graphPanelLayout.setVerticalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 246, Short.MAX_VALUE));
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 1));
        GroupLayout pDataPanelLayout = new GroupLayout(this.pDataPanel);
        this.pDataPanel.setLayout(pDataPanelLayout);
        pDataPanelLayout.setHorizontalGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pDataPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buttonsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.graphPanel, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        pDataPanelLayout.setVerticalGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.graphPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridLayout(1, 1));
    }

    private Map<String, Long> getTotalEventsByField(List<TermTimeHistogram> data) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        data.forEach(tth -> {
            String t = tth.getTerm();
            tth.getHistogram().stream().map(iptp -> {
                Long i = (Long)map.get(t);
                if (i == null) {
                    i = 0L;
                }
                i = i + iptp.getCount();
                return i;
            }).forEachOrdered(i -> map.put(t, (Long)i));
        });
        return map;
    }

    public List<String> getEventsListByField() {
        return this.eventsListByField;
    }

    public LinkedHashMap<String, Long> getCountedEventListByField() {
        return this.countedEventListByField;
    }

    private static class MyComparator
    implements Comparator<String> {
        private Map<String, Long> map;
        private boolean sort;

        public MyComparator(Map<String, Long> map, boolean sort) {
            this.map = map;
            this.sort = sort;
        }

        @Override
        public int compare(String o1, String o2) {
            Long l1 = this.map.get(o1);
            Long l2 = this.map.get(o2);
            return this.sort ? (l1 <= l2 ? -1 : 1) : (l1 >= l2 ? -1 : 1);
        }
    }

    public static class UpdateParams {
        private String query;
        private long timeStart;
        private long timeFinish;
        private String interval;
        private DisplayOptions displayOptions;
        private String field;
        private boolean sort;
        private int noSources;
        private boolean isClickedNext = false;

        public UpdateParams(String query, long timeStart, long timeFinish, String interval) {
            this.query = query;
            this.timeStart = timeStart;
            this.timeFinish = timeFinish;
            this.interval = interval;
        }

        public UpdateParams(String query, DisplayOptions displayOptions) {
            this.query = query;
            this.timeStart = displayOptions.getTimeStart();
            this.timeFinish = displayOptions.getTimeFinish();
            this.interval = displayOptions.getIntervalObj().getValue();
            this.displayOptions = displayOptions;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public long getTimeStart() {
            return this.timeStart;
        }

        public void setTimeStart(long timeStart) {
            this.timeStart = timeStart;
        }

        public long getTimeFinish() {
            return this.timeFinish;
        }

        public void setTimeFinish(long timeFinish) {
            this.timeFinish = timeFinish;
        }

        public String getInterval() {
            return this.interval;
        }

        public void setInterval(String interval) {
            this.interval = interval;
        }

        public DisplayOptions getDisplayOptions() {
            return this.displayOptions;
        }

        public void setDisplayOptions(DisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
        }

        public String getField() {
            return this.field;
        }

        public UpdateParams setField(String field) {
            this.field = field;
            return this;
        }

        public boolean isSort() {
            return this.sort;
        }

        public UpdateParams setSort(boolean sort) {
            this.sort = sort;
            return this;
        }

        public int getNoSources() {
            return this.noSources;
        }

        public UpdateParams setNoSources(int noSources) {
            this.noSources = noSources;
            return this;
        }

        public boolean isClickedNext() {
            return this.isClickedNext;
        }

        public UpdateParams setIsClickedNext(boolean isClickedNext) {
            this.isClickedNext = isClickedNext;
            return this;
        }
    }
}

