/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.GroupLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventDetailsTable;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventDetailsTableModel;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventDetailsTableRenderer;
import rs.co.ast.aspen.gui.module.securityevents.query.QueryManager;

public class SecurityEventDetailsPanel
extends JPanel {
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private LinkedHashMap<String, List<String>> mapOfRegexpsAndLinks = new LinkedHashMap();
    private SecurityEventDetailsTableModel tableModel = new SecurityEventDetailsTableModel();
    private JPopupMenu popupMenu = new JPopupMenu();
    private final JMenuItem miCopy = new JMenuItem(NbBundle.getMessage(SecurityEventDetailsPanel.class, (String)"SecurityEventDetailsPanel.miCopy.text"));
    private JMenuItem miCheck = new JMenuItem("Check");
    private static final Logger logger = Logger.getLogger(SecurityEventDetailsPanel.class.getName());
    private JScrollPane jScrollPane2;
    private JTable tEventDetails;

    public SecurityEventDetailsPanel() {
        this.initComponents();
        this.loadRegexsAndUrlsFromUpdates();
        ActionListener copyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SecurityEventDetailsTableModel.Item item = (SecurityEventDetailsTableModel.Item)SecurityEventDetailsPanel.this.tEventDetails.getValueAt(SecurityEventDetailsPanel.this.tEventDetails.getSelectedRow(), 0);
                if (item != null) {
                    String query = QueryManager.copySEDetailsRow(item, SecurityEventDetailsPanel.this.tEventDetails.getSelectedColumn());
                    StringSelection selection = new StringSelection(query);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                }
            }
        };
        ActionListener checkListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SecurityEventDetailsTableModel.Item item = (SecurityEventDetailsTableModel.Item)SecurityEventDetailsPanel.this.tEventDetails.getValueAt(SecurityEventDetailsPanel.this.tEventDetails.getSelectedRow(), 0);
                if (item != null) {
                    Desktop desktop = Desktop.getDesktop();
                    for (Map.Entry entry : SecurityEventDetailsPanel.this.mapOfRegexpsAndLinks.entrySet()) {
                        Pattern pattern = Pattern.compile((String)entry.getKey());
                        Matcher matcher = pattern.matcher(item.getValue());
                        if (!matcher.find()) continue;
                        logger.log(Level.INFO, "Check action - regex matched: {0}", entry.getKey());
                        String value = matcher.group(1);
                        if (item.getValue().startsWith("\"") && item.getValue().endsWith("\"")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        for (String url : (List)entry.getValue()) {
                            StringBuilder sbUrl = new StringBuilder();
                            sbUrl.append(String.format(url, value));
                            try {
                                URI oURL = new URI(sbUrl.toString());
                                desktop.browse(oURL);
                            }
                            catch (IOException | URISyntaxException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(67, 2, false);
        this.tEventDetails.registerKeyboardAction(copyListener, "Copy", stroke, 0);
        this.tEventDetails.setDefaultRenderer(SecurityEventDetailsTableModel.Item.class, new SecurityEventDetailsTableRenderer());
        this.tEventDetails.setSelectionMode(0);
        this.tEventDetails.setCellSelectionEnabled(true);
        this.miCopy.addActionListener(copyListener);
        this.miCheck.addActionListener(checkListener);
        this.popupMenu.add(this.miCopy);
        this.tEventDetails.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int row = source.rowAtPoint(e.getPoint());
                int column = source.columnAtPoint(e.getPoint());
                if (!source.isRowSelected(row)) {
                    source.changeSelection(row, column, false, false);
                }
                if (e.getButton() == 3) {
                    if (row != -1) {
                        SecurityEventDetailsTableModel.Item item = (SecurityEventDetailsTableModel.Item)SecurityEventDetailsPanel.this.tEventDetails.getValueAt(row, 0);
                        SecurityEventDetailsPanel.this.popupMenu.remove(SecurityEventDetailsPanel.this.miCheck);
                        if (item.getValue() != null) {
                            for (Map.Entry entry : SecurityEventDetailsPanel.this.mapOfRegexpsAndLinks.entrySet()) {
                                Pattern pattern = Pattern.compile((String)entry.getKey());
                                Matcher matcher = pattern.matcher(item.getValue());
                                if (!matcher.find()) continue;
                                SecurityEventDetailsPanel.this.popupMenu.add(SecurityEventDetailsPanel.this.miCheck);
                                break;
                            }
                        }
                    }
                    SecurityEventDetailsPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public SecurityEventDetailsTableModel getTableModel() {
        return this.tableModel;
    }

    public JTable getTable() {
        return this.tEventDetails;
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.tEventDetails = new SecurityEventDetailsTable(this.tableModel);
        this.jScrollPane2.setViewportView(this.tEventDetails);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 360, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 450, Short.MAX_VALUE));
    }

    private void loadRegexsAndUrlsFromUpdates() {
        SwingWorker swLoadRegex = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    String line;
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    SSLContext sc = SSLContext.getInstance("SSL");
                    sc.init(null, trustAllCerts, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                    HostnameVerifier allHostsValid = new HostnameVerifier(){

                        @Override
                        public boolean verify(String string, SSLSession ssls) {
                            return true;
                        }
                    };
                    HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
                    URL url = new URL("https://updates.ast.co.rs/consolefiles/SecEventsDynamicActionsURLs.js");
                    BufferedReader read = new BufferedReader(new InputStreamReader(url.openStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((line = read.readLine()) != null) {
                        sb.append(line);
                        sb.append(System.lineSeparator());
                    }
                    String regexpsAndUrls = sb.toString();
                    if (regexpsAndUrls != null) {
                        ObjectMapper mapper = new ObjectMapper();
                        SecurityEventDetailsPanel.this.mapOfRegexpsAndLinks = (LinkedHashMap)mapper.readValue(regexpsAndUrls, LinkedHashMap.class);
                        SecurityEventDetailsPanel.this.tEventDetails.setDefaultRenderer(SecurityEventDetailsTableModel.Item.class, new SecurityEventDetailsTableRenderer(SecurityEventDetailsPanel.this.mapOfRegexpsAndLinks));
                    } else {
                        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)"The function \"Check\" will not appear in the pop-up menu in the SE details window because the file with regex-s and URLs is not loaded. Contact support about this problem.", 1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                    }
                }
                catch (IOException ex) {
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)"The function \"Check\" will not appear in the pop-up menu in the SE details window because the file with regex-s and URLs is not loaded. Contact support about this problem.", 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
                catch (KeyManagementException | NoSuchAlgorithmException ex) {
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)"The function \"Check\" will not appear in the pop-up menu in the SE details window because the file with regex-s and URLs is not loaded. Contact support about this problem.", 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
                return null;
            }
        };
        swLoadRegex.execute();
    }
}

