/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.phys;

import com.jme3.math.Vector3f;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsConstants;

public class PhysicsBody {
    public Charge charge;
    public float mass;
    public final Node node;
    public final Vector3f position;
    public float radius;
    public final Vector3f velocity = new Vector3f();

    public static Charge getCharge(Node node, PhysicsConstants c) {
        String m = node.get("%charge", c.DEFAULT_CHARGE.toString());
        return Charge.valueOf(m);
    }

    public static float getMass(Node node, PhysicsConstants c) {
        String m = node.get("%mass", String.valueOf(c.DEFAULT_MASS));
        return Float.parseFloat(m);
    }

    public static float getRadius(Node node, PhysicsConstants c) {
        String m = node.get("%radius", String.valueOf(c.DEFAULT_RADIUS));
        return Float.parseFloat(m);
    }

    public PhysicsBody(Node node, Vector3f pos, PhysicsConstants c) {
        this.node = node;
        this.position = pos.clone();
        this.mass = PhysicsBody.getMass(node, c);
        this.charge = PhysicsBody.getCharge(node, c);
        this.radius = PhysicsBody.getRadius(node, c);
    }

    public static enum Charge {
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        I,
        J,
        K,
        L,
        M,
        N,
        O,
        P,
        Q,
        R,
        S,
        T,
        U,
        V,
        W,
        X,
        Y,
        Z,
        _0;

    }
}

