/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood;

import com.jme3.audio.AudioNode;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.io.IOException;
import java.util.Objects;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.RendererProperties;

public class GlowControl
implements Control {
    private AudioNode audioNode;
    private float duration;
    private Geometry geometry;
    private ColorRGBA[] glowColor;
    private ColorRGBA prevColor;
    private RendererProperties props;
    private final float startAt;
    private final float stopAt;
    private int curGlowIndex;
    private int glowIndex;
    private final float glowStep;

    public GlowControl(RendererProperties props, float start, float duration, ColorRGBA currentColor, AudioNode audioNode) {
        this(props, start, duration, (ColorRGBA)null, currentColor, audioNode);
    }

    public GlowControl(RendererProperties props, float start, float duration, ColorRGBA glowColor, ColorRGBA currentColor, AudioNode audioNode) {
        ColorRGBA[] colorRGBAArray;
        if (glowColor != null) {
            ColorRGBA[] colorRGBAArray2 = new ColorRGBA[1];
            colorRGBAArray = colorRGBAArray2;
            colorRGBAArray2[0] = glowColor;
        } else {
            colorRGBAArray = null;
        }
        this(props, start, duration, colorRGBAArray, currentColor, audioNode);
    }

    public GlowControl(RendererProperties props, float start, float duration, ColorRGBA[] glowColor, ColorRGBA currentColor, AudioNode audioNode) {
        ColorRGBA[] colorRGBAArray;
        this.curGlowIndex = -1;
        this.glowIndex = 0;
        this.props = props;
        this.startAt = start;
        this.stopAt = start + duration;
        this.prevColor = currentColor;
        this.audioNode = audioNode;
        float f = this.glowStep = glowColor != null ? duration / (float)glowColor.length : duration;
        if (glowColor != null) {
            colorRGBAArray = glowColor;
        } else {
            ColorRGBA[] colorRGBAArray2 = new ColorRGBA[1];
            colorRGBAArray = colorRGBAArray2;
            colorRGBAArray2[0] = this.prevColor;
        }
        this.glowColor = colorRGBAArray;
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof Geometry) {
            this.geometry = (Geometry)spatial;
        }
    }

    public void read(JmeImporter im) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    public void update(float tpf) {
        if (this.geometry != null) {
            this.duration += tpf;
            if (this.curGlowIndex == this.glowIndex && this.duration > this.startAt + this.glowStep * (float)this.glowIndex + this.glowStep) {
                ++this.glowIndex;
            }
            if (this.duration >= this.stopAt) {
                this.stopGlow();
            } else if (this.glowIndex != this.curGlowIndex && this.duration > this.startAt + this.glowStep * (float)this.glowIndex) {
                this.setGlow(this.glowIndex);
                this.curGlowIndex = this.glowIndex;
            }
        }
    }

    private void setGlow(int glowIndex) {
        this.setColor(this.geometry.getMaterial(), this.glowColor[glowIndex]);
        this.geometry.getMaterial().setColor("GlowColor", this.glowColor[glowIndex]);
        if (this.audioNode != null) {
            this.audioNode.play();
        }
    }

    private void stopGlow() {
        Boolean autoStop;
        this.setColor(this.geometry.getMaterial(), this.prevColor);
        this.geometry.getMaterial().setColor("GlowColor", ColorRGBA.Black);
        this.geometry.removeControl((Control)this);
        this.geometry = null;
        if (this.audioNode != null && (autoStop = (Boolean)this.audioNode.getUserData("autoStop")) != null && Objects.equals(autoStop, Boolean.TRUE)) {
            this.audioNode.stop();
        }
    }

    public void write(JmeExporter ex) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void setColor(Material m, ColorRGBA color) {
        if (this.props.LIGHTING) {
            m.setBoolean("UseMaterialColors", true);
            m.setColor("Diffuse", color);
            m.setColor("Specular", color);
            m.setFloat("Shininess", 64.0f);
        } else {
            m.setColor("Color", color);
        }
    }
}

