/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.centralized.api.manager.script;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.fife.ui.rsyntaxtextarea.folding.JsonFoldParser;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.painter.BusyPainter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiErrorMessage;
import rs.co.ast.aspen.api.service.ApiResponse;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.CreateScriptDTO;
import rs.co.ast.aspen.api.service.ListScriptsResponse;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptModelChanged;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.ClusteringServiceTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.CorrelationContextTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.CounterManagerTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.CountryTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.DataMapManagerTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.DataMapperTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.NotificationManagerTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.RawLogTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.ScriptUtilsTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.SecurityEventTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.SecurityEventsTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.eval.VirusTotalTest;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.AddNewScriptPanel;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.JavaScriptFileFilter;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.RenameScriptPanel;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.ScriptEditorTableModel;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.ScriptEditorTableRenderer;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.ScriptTypeComboBoxModel;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.ScriptsZipUtils;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.SearchResultsTopComponent;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.VisualizationTokenMaker;

@TopComponent.Description(preferredID="CentralizedApiScriptManagerTopComponent", iconBase="script.png", persistenceType=2)
public final class CentralizedApiScriptManagerTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(CentralizedApiScriptManagerTopComponent.class.getName());
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private ScriptEditorTableModel tableModel = new ScriptEditorTableModel();
    private final ScriptEngineManager sem = new ScriptEngineManager();
    private final InstanceContent ic = new InstanceContent();
    private Collection<Script> allScripts;
    private Map<String, Script> changedScripts = this.tableModel.getChangedScripts();
    private Map<String, String> changedScriptsBackUp = new HashMap<String, String>();
    private Map<String, String> changedDescriptionsBackUp = new HashMap<String, String>();
    private RSyntaxTextArea taScriptText;
    private int selectedRow = 0;
    private int caretPosition = 0;
    private boolean onSave = false;
    private boolean sortByName = true;
    private ScriptTypeComboBoxModel scriptTypeModel = new ScriptTypeComboBoxModel();
    private Dialog dialog;
    private final ScheduledExecutorService scriptsUpdater = Executors.newSingleThreadScheduledExecutor();
    private JButton bBeautify;
    private JButton bEvaluate;
    private JButton bExport;
    private JButton bExportAll;
    private JButton bImport;
    private JButton bRefresh;
    private JButton bReset;
    private JButton bSave;
    private JButton bSearchAllScripts;
    private JComboBox cbScriptType;
    private JPanel cp;
    private JXCollapsiblePane cpDescription;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JXBusyLabel lLoading;
    private JLabel lType;
    private JMenuItem miDelete;
    private JMenuItem miNew;
    private JMenuItem miRename;
    private JMenuItem miRestorePreviousScriptVersion;
    private JMenuItem miSortByName;
    private JMenuItem miSortByOrder;
    private JPanel pButtons;
    private JPanel pDescription;
    private JPanel pTaDescription;
    private JPopupMenu pmOperations;
    private JTable tScripts;
    private JTextArea taScriptDescription;
    private JToggleButton tbDescription;
    private JTextField tfSearch;

    public CentralizedApiScriptManagerTopComponent() {
        LOGGER.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.APIMANAGER), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.APIMANAGER)));
        this.initComponents();
        this.setName(NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CTL_CentralizedApiManagerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"HINT_CentralizedApiManagerTopComponent"));
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.ic));
        this.taScriptText = new RSyntaxTextArea(20, 60);
        FoldParserManager.get().addFoldParserMapping("text/visscript", (FoldParser)new JsonFoldParser());
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        atmf.putMapping("text/visscript", VisualizationTokenMaker.class.getName(), ((Object)((Object)this)).getClass().getClassLoader());
        this.taScriptText.setTabSize(4);
        this.taScriptText.setCodeFoldingEnabled(true);
        SyntaxScheme scheme = this.taScriptText.getSyntaxScheme();
        scheme.getStyle((int)10).foreground = new Color(153, 0, 0);
        scheme.getStyle((int)6).foreground = new Color(68, 85, 136);
        scheme.getStyle((int)7).foreground = new Color(0, 128, 128);
        scheme.getStyle((int)17).foreground = new Color(153, 0, 115);
        scheme.getStyle((int)1).foreground = new Color(0, 128, 0);
        scheme.getStyle((int)22).foreground = Color.DARK_GRAY;
        this.taScriptText.setSyntaxEditingStyle("text/javascript");
        Font font = this.taScriptText.getFontForTokenType(22);
        scheme.getStyle((int)22).font = font = font.deriveFont(1);
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.taScriptText);
        this.cp.add((Component)sp);
        this.jPanel4.add((Component)this.pDescription, "North");
        this.jPanel4.add((Component)this.cp, "Center");
        this.jPanel4.add((Component)this.pButtons, "South");
        this.cpDescription.setLayout((LayoutManager)new BorderLayout());
        this.cpDescription.add((Component)this.pTaDescription, (Object)"Center");
        this.tbDescription.addActionListener(this.cpDescription.getActionMap().get("toggle"));
        this.tbDescription.setCursor(Cursor.getPredefinedCursor(12));
        this.disableButtons();
        this.taScriptText.getCaret().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CentralizedApiScriptManagerTopComponent.this.onSave) {
                    CentralizedApiScriptManagerTopComponent.this.caretPosition = CentralizedApiScriptManagerTopComponent.this.taScriptText.getCaret().getDot();
                }
            }
        });
        this.tScripts.setDefaultRenderer(Script.class, new ScriptEditorTableRenderer());
        this.tScripts.setSelectionMode(2);
        this.tScripts.setRowSelectionAllowed(true);
        this.tScripts.setFillsViewportHeight(true);
        this.tScripts.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CentralizedApiScriptManagerTopComponent.this.tScripts.getSelectedRow() > -1) {
                    CentralizedApiScriptManagerTopComponent.this.selectedRow = CentralizedApiScriptManagerTopComponent.this.tScripts.getSelectedRow();
                    Script script = (Script)CentralizedApiScriptManagerTopComponent.this.tableModel.getValueAt(CentralizedApiScriptManagerTopComponent.this.tScripts.getSelectedRow(), 0);
                    if (script != null) {
                        CentralizedApiScriptManagerTopComponent.this.setScriptText(script.getScript());
                        CentralizedApiScriptManagerTopComponent.this.taScriptText.getCaret().setDot(CentralizedApiScriptManagerTopComponent.this.caretPosition);
                        CentralizedApiScriptManagerTopComponent.this.taScriptText.requestFocus();
                        CentralizedApiScriptManagerTopComponent.this.setDescriptionText(script.getDescription());
                        CentralizedApiScriptManagerTopComponent.this.onSave = false;
                        CentralizedApiScriptManagerTopComponent.this.miDelete.setEnabled(true);
                        CentralizedApiScriptManagerTopComponent.this.bExport.setEnabled(true);
                        CentralizedApiScriptManagerTopComponent.this.bImport.setEnabled(true);
                        CentralizedApiScriptManagerTopComponent.this.bEvaluate.setEnabled(true);
                        CentralizedApiScriptManagerTopComponent.this.bBeautify.setEnabled(true);
                        if (CentralizedApiScriptManagerTopComponent.this.changedScripts.containsKey(script.getId())) {
                            CentralizedApiScriptManagerTopComponent.this.bSave.setEnabled(true);
                            CentralizedApiScriptManagerTopComponent.this.bReset.setEnabled(true);
                        } else {
                            CentralizedApiScriptManagerTopComponent.this.bSave.setEnabled(false);
                            CentralizedApiScriptManagerTopComponent.this.bReset.setEnabled(false);
                        }
                        if (script.getDescription() == null || script.getDescription().isEmpty()) {
                            if (!CentralizedApiScriptManagerTopComponent.this.cpDescription.isCollapsed()) {
                                CentralizedApiScriptManagerTopComponent.this.tbDescription.doClick();
                            }
                        } else if (CentralizedApiScriptManagerTopComponent.this.cpDescription.isCollapsed()) {
                            CentralizedApiScriptManagerTopComponent.this.tbDescription.doClick();
                        }
                    }
                }
            }
        });
        this.tScripts.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = CentralizedApiScriptManagerTopComponent.this.tScripts.rowAtPoint(e.getPoint());
                    int column = CentralizedApiScriptManagerTopComponent.this.tScripts.columnAtPoint(e.getPoint());
                    if (!CentralizedApiScriptManagerTopComponent.this.tScripts.isRowSelected(row)) {
                        if (row > -1) {
                            CentralizedApiScriptManagerTopComponent.this.tScripts.setRowSelectionInterval(row, row);
                        }
                        CentralizedApiScriptManagerTopComponent.this.tScripts.changeSelection(row, column, false, false);
                    }
                    CentralizedApiScriptManagerTopComponent.this.pmOperations.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.cbScriptType.setModel(this.scriptTypeModel);
        this.cbScriptType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CentralizedApiScriptManagerTopComponent.this.disableButtons();
            }
        });
        this.taScriptText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doChange();
            }

            private void doChange() {
                Script script = (Script)CentralizedApiScriptManagerTopComponent.this.tableModel.getValueAt(CentralizedApiScriptManagerTopComponent.this.tScripts.getSelectedRow(), 0);
                if (script != null && CentralizedApiScriptManagerTopComponent.this.taScriptText.getText() != null && !CentralizedApiScriptManagerTopComponent.this.taScriptText.getText().isEmpty() && !CentralizedApiScriptManagerTopComponent.this.taScriptText.getText().equals(script.getScript())) {
                    if (!CentralizedApiScriptManagerTopComponent.this.changedScriptsBackUp.containsKey(script.getId())) {
                        CentralizedApiScriptManagerTopComponent.this.changedScriptsBackUp.put(script.getId(), script.getScript());
                    }
                    script.setScript(CentralizedApiScriptManagerTopComponent.this.taScriptText.getText());
                    CentralizedApiScriptManagerTopComponent.this.changedScripts.put(script.getId(), script);
                    CentralizedApiScriptManagerTopComponent.this.bSave.setEnabled(true);
                    CentralizedApiScriptManagerTopComponent.this.bReset.setEnabled(true);
                }
            }
        });
        this.taScriptDescription.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doChange();
            }

            private void doChange() {
                Script script = (Script)CentralizedApiScriptManagerTopComponent.this.tableModel.getValueAt(CentralizedApiScriptManagerTopComponent.this.tScripts.getSelectedRow(), 0);
                if (script != null && CentralizedApiScriptManagerTopComponent.this.taScriptDescription.getText() != null && !CentralizedApiScriptManagerTopComponent.this.taScriptDescription.getText().isEmpty() && !CentralizedApiScriptManagerTopComponent.this.taScriptDescription.getText().equals(script.getDescription())) {
                    if (!CentralizedApiScriptManagerTopComponent.this.changedDescriptionsBackUp.containsKey(script.getId())) {
                        CentralizedApiScriptManagerTopComponent.this.changedDescriptionsBackUp.put(script.getId(), script.getDescription());
                    }
                    script.setDescription(CentralizedApiScriptManagerTopComponent.this.taScriptDescription.getText());
                    CentralizedApiScriptManagerTopComponent.this.changedScripts.put(script.getId(), script);
                    CentralizedApiScriptManagerTopComponent.this.bSave.setEnabled(true);
                    CentralizedApiScriptManagerTopComponent.this.bReset.setEnabled(true);
                }
            }
        });
        ActionListener findLisener = event -> {
            this.tfSearch.requestFocus();
            this.tfSearch.setCaretPosition(0);
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(70, 2, false);
        this.taScriptText.registerKeyboardAction(findLisener, "Find", stroke, 0);
        ActionListener findInAllFilesLisener = event -> this.searchInAllFiles();
        KeyStroke strokeFiles = KeyStroke.getKeyStroke(70, 8, false);
        this.registerKeyboardAction(findInAllFilesLisener, "FindInAll", strokeFiles, 1);
    }

    private void initComponents() {
        this.pmOperations = new JPopupMenu();
        this.miNew = new JMenuItem();
        this.miRename = new JMenuItem();
        this.miDelete = new JMenuItem();
        this.miRestorePreviousScriptVersion = new JMenuItem();
        this.miSortByName = new JMenuItem();
        this.miSortByOrder = new JMenuItem();
        this.pTaDescription = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.taScriptDescription = new JTextArea();
        this.pButtons = new JPanel();
        this.bExportAll = new JButton();
        this.bExport = new JButton();
        this.bImport = new JButton();
        this.bEvaluate = new JButton();
        this.bBeautify = new JButton();
        this.bSave = new JButton();
        this.bReset = new JButton();
        this.cp = new JPanel();
        this.pDescription = new JPanel();
        this.tbDescription = new JToggleButton();
        this.cpDescription = new JXCollapsiblePane();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.lType = new JLabel();
        this.cbScriptType = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tScripts = new JTable();
        this.bRefresh = new JButton();
        this.lLoading = new JXBusyLabel();
        this.bSearchAllScripts = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tfSearch = new JTextField();
        this.jPanel4 = new JPanel();
        Mnemonics.setLocalizedText((AbstractButton)this.miNew, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.miNew.text"));
        this.miNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.miNewActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miNew);
        Mnemonics.setLocalizedText((AbstractButton)this.miRename, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.miRename.text"));
        this.miRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.miRenameActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miRename);
        Mnemonics.setLocalizedText((AbstractButton)this.miDelete, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.miDelete.text"));
        this.miDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.miDeleteActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miDelete);
        Mnemonics.setLocalizedText((AbstractButton)this.miRestorePreviousScriptVersion, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.miRestorePreviousScriptVersion.text"));
        this.miRestorePreviousScriptVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.miRestorePreviousScriptVersionActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miRestorePreviousScriptVersion);
        Mnemonics.setLocalizedText((AbstractButton)this.miSortByName, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.miSortByName.text"));
        this.miSortByName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.miSortByNameActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miSortByName);
        Mnemonics.setLocalizedText((AbstractButton)this.miSortByOrder, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.miSortByOrder.text"));
        this.miSortByOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.miSortByOrderActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miSortByOrder);
        this.taScriptDescription.setColumns(20);
        this.taScriptDescription.setRows(5);
        this.jScrollPane2.setViewportView(this.taScriptDescription);
        GroupLayout pTaDescriptionLayout = new GroupLayout(this.pTaDescription);
        this.pTaDescription.setLayout(pTaDescriptionLayout);
        pTaDescriptionLayout.setHorizontalGroup(pTaDescriptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE).addGroup(pTaDescriptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pTaDescriptionLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0))));
        pTaDescriptionLayout.setVerticalGroup(pTaDescriptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE).addGroup(pTaDescriptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pTaDescriptionLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0))));
        this.bExportAll.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bExportAll, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.bExportAll.text"));
        this.bExportAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.bExportAllActionPerformed(evt);
            }
        });
        this.bExport.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.bExportActionPerformed(evt);
            }
        });
        this.bImport.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bImport, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.bImport.text"));
        this.bImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.bImportActionPerformed(evt);
            }
        });
        this.bEvaluate.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bEvaluate, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.bEvaluate.text"));
        this.bEvaluate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.bEvaluateActionPerformed(evt);
            }
        });
        this.bBeautify.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bBeautify, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.bBeautify.text"));
        this.bBeautify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.bBeautifyActionPerformed(evt);
            }
        });
        this.bSave.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bSave, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.bSave.text"));
        this.bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.bSaveActionPerformed(evt);
            }
        });
        this.bReset.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bReset, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.bReset.text"));
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.bResetActionPerformed(evt);
            }
        });
        GroupLayout pButtonsLayout = new GroupLayout(this.pButtons);
        this.pButtons.setLayout(pButtonsLayout);
        pButtonsLayout.setHorizontalGroup(pButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pButtonsLayout.createSequentialGroup().addContainerGap().addComponent(this.bExportAll, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bExport, -1, 100, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bImport, -1, 100, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bEvaluate, -1, 114, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bBeautify, -1, 110, Short.MAX_VALUE).addGap(36, 36, 36).addComponent(this.bSave, -1, 94, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bReset, -1, 96, Short.MAX_VALUE).addContainerGap()));
        pButtonsLayout.setVerticalGroup(pButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pButtonsLayout.createSequentialGroup().addContainerGap().addGroup(pButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bExport).addComponent(this.bImport).addComponent(this.bEvaluate).addComponent(this.bBeautify).addComponent(this.bSave).addComponent(this.bReset).addComponent(this.bExportAll)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cp.setLayout(new BorderLayout());
        this.pDescription.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.tbDescription, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.tbDescription.text"));
        this.pDescription.add((Component)this.tbDescription, "Center");
        this.cpDescription.setCollapsed(true);
        this.cpDescription.setDirection(JXCollapsiblePane.Direction.DOWN);
        this.pDescription.add((Component)this.cpDescription, "Last");
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setResizeWeight(0.2);
        this.jSplitPane1.setMinimumSize(new Dimension(250, 0));
        this.jPanel1.setMinimumSize(new Dimension(270, 0));
        this.jPanel1.setPreferredSize(new Dimension(270, 501));
        this.lType.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lType, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.lType.text"));
        this.cbScriptType.setFont(new Font("Dialog", 0, 12));
        this.cbScriptType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.cbScriptTypeActionPerformed(evt);
            }
        });
        this.tScripts.setModel(this.tableModel);
        this.tScripts.setComponentPopupMenu(this.pmOperations);
        this.tScripts.setGridColor(new Color(217, 217, 217));
        this.tScripts.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tScripts);
        this.bRefresh.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.bRefresh.text"));
        this.bRefresh.setMaximumSize(new Dimension(50, 15));
        this.bRefresh.setMinimumSize(new Dimension(50, 15));
        this.bRefresh.setPreferredSize(new Dimension(50, 15));
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.bRefreshActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.lLoading.text"));
        this.lLoading.setDirection(BusyPainter.Direction.RIGHT);
        this.bSearchAllScripts.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/magnifier.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bSearchAllScripts, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.bSearchAllScripts.text"));
        this.bSearchAllScripts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.bSearchAllScriptsActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lType, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSearchAllScripts, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lLoading, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bRefresh, -2, 32, -2)).addComponent(this.cbScriptType, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.lLoading, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.bSearchAllScripts, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.bRefresh, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lType, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbScriptType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 485, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.jLabel1.text_1"));
        this.tfSearch.setText(NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiScriptManagerTopComponent.tfSearch.text"));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiScriptManagerTopComponent.this.tfSearchActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfSearch, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.add((Component)this.jPanel3, "First");
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 1281, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void cbScriptTypeActionPerformed(ActionEvent evt) {
        ScriptType scriptType = this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
        this.refreshTable(scriptType);
        this.resetScriptText();
        this.resetDescriptionText();
        switch (scriptType) {
            case CORRELATION: 
            case ROUTING: 
            case NOTIFICATION_PREPROCESSING: 
            case SCHEDULED: 
            case UTILITY_FUNCTIONS: {
                this.taScriptText.setSyntaxEditingStyle("text/javascript");
                break;
            }
            case VISUALISATION_CONFIGURATION: 
            case VISUALISATION_RULESET: {
                this.taScriptText.setSyntaxEditingStyle("text/visscript");
            }
        }
    }

    private void bResetActionPerformed(ActionEvent evt) {
        Script script = this.tableModel.getScriptByRow(this.tScripts.getSelectedRow());
        if (this.changedScripts.containsKey(script.getId())) {
            if (this.changedScriptsBackUp.get(script.getId()) != null) {
                this.taScriptText.setText(this.changedScriptsBackUp.get(script.getId()));
                this.changedScriptsBackUp.remove(script.getId());
            }
            if (this.changedDescriptionsBackUp.get(script.getId()) != null) {
                this.taScriptDescription.setText(this.changedDescriptionsBackUp.get(script.getId()));
                this.changedDescriptionsBackUp.remove(script.getId());
            }
            this.changedScripts.remove(script.getId());
        }
        this.bSave.setEnabled(false);
        this.bReset.setEnabled(false);
        this.tScripts.repaint();
    }

    private void bExportActionPerformed(ActionEvent evt) {
        if (!this.taScriptText.getText().isEmpty()) {
            JFileChooser saveFileDialog = new JFileChooser();
            saveFileDialog.setFileFilter(new JavaScriptFileFilter());
            saveFileDialog.setAcceptAllFileFilterUsed(false);
            Script script = (Script)this.tScripts.getValueAt(this.tScripts.getSelectedRow(), 0);
            saveFileDialog.setSelectedFile(new File(script.getName() + ".js"));
            int result = saveFileDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
            if (result == 0) {
                try (FileOutputStream st = new FileOutputStream(saveFileDialog.getSelectedFile());){
                    ((OutputStream)st).write(this.taScriptText.getText().getBytes());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void bImportActionPerformed(ActionEvent evt) {
        JFileChooser openFileDialog = new JFileChooser();
        openFileDialog.setFileFilter(new JavaScriptFileFilter());
        openFileDialog.setAcceptAllFileFilterUsed(false);
        int result = openFileDialog.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (result == 0) {
            try (BufferedReader reader = new BufferedReader(new FileReader(openFileDialog.getSelectedFile()));){
                String text;
                StringBuilder sb = new StringBuilder();
                while ((text = reader.readLine()) != null) {
                    sb.append(text).append("\n");
                }
                String fileName = openFileDialog.getSelectedFile().getName().replace(".js", "");
                if (this.tableModel.scriptAlreadyExist(fileName, this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()))) {
                    String faildMsg = NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"ScriptEditorTopComponent.importScript.save.failed");
                    String title = NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"ScriptEditorTopComponent.importScript.save.failed,title");
                    int overwrite = JOptionPane.showConfirmDialog(openFileDialog, String.format(faildMsg, fileName), title, 0, 2);
                    int rowByScriptName = this.tableModel.getRowByScriptName(fileName);
                    if (overwrite == 0) {
                        Script script = this.tableModel.getScriptByRow(rowByScriptName);
                        script.setScript(sb.toString());
                        this.apiService.apiUpdateScript(script);
                        this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                    }
                } else {
                    CreateScriptDTO dto = new CreateScriptDTO();
                    dto.setDescription(" ");
                    dto.setLanguage("javascript");
                    dto.setName(fileName);
                    dto.setScriptText(sb.toString());
                    dto.setType(this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()));
                    ApiResponse response = this.apiService.apiCreateScript(dto);
                    if (response.isSuccess()) {
                        this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                        Updater updater = new Updater();
                        updater.setNewScript(true);
                        updater.setNewScriptName(fileName);
                        updater.execute();
                    } else {
                        ApiErrorMessage errorMessage = response.getErrorMessage();
                        LOGGER.log(Level.SEVERE, String.format("%s | %s", errorMessage.getErrorCode(), errorMessage.getMessage()));
                        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage.getMessage(), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                    }
                }
            }
            catch (IOException | ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void bBeautifyActionPerformed(ActionEvent evt) {
        this.formatJS();
    }

    private void bEvaluateActionPerformed(ActionEvent evt) {
        switch (this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex())) {
            case VISUALISATION_CONFIGURATION: 
            case VISUALISATION_RULESET: {
                this.validateScriptSyntax();
                break;
            }
            case CORRELATION: 
            case ROUTING: 
            case NOTIFICATION_PREPROCESSING: 
            case SCHEDULED: 
            case UTILITY_FUNCTIONS: {
                this.validateScriptSyntax();
            }
        }
    }

    private void bSaveActionPerformed(ActionEvent evt) {
        this.onSave = true;
        Script script = this.tableModel.getScriptByRow(this.tScripts.getSelectedRow());
        if (script != null && this.changedScripts.containsKey(script.getId())) {
            String errorMessage = this.validateScriptSyntax((script = this.changedScripts.get(script.getId())).getScript());
            if (errorMessage.isEmpty()) {
                try {
                    this.saveLocalBackup(script);
                    ApiResponse response = this.apiService.apiUpdateScript(script);
                    if (response.isSuccess()) {
                        this.changedScripts.remove(script.getId());
                        new Updater().execute();
                    } else {
                        ApiErrorMessage apiError = response.getErrorMessage();
                        LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                    }
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                this.bSave.setEnabled(false);
                this.bReset.setEnabled(false);
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errorMessage, 0));
            }
        }
    }

    private void miNewActionPerformed(ActionEvent evt) {
        final AddNewScriptPanel panel = new AddNewScriptPanel();
        panel.setSelectedScriptType((String)this.scriptTypeModel.getSelectedItem());
        final JButton ok = new JButton("Ok");
        DialogDescriptor des = new DialogDescriptor((Object)panel, NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"AddNewScriptPanel.title"), false, new Object[]{ok, DialogDescriptor.CANCEL_OPTION}, (Object)ok, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(ok)) {
                    if (CentralizedApiScriptManagerTopComponent.this.tableModel.scriptAlreadyExist(panel.getScriptName(), panel.getScriptType())) {
                        String faildMsg = NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiManagerTopComponent.newScript.save.failed");
                        JOptionPane.showMessageDialog(panel, String.format(faildMsg, panel.getScriptName()));
                    } else {
                        try {
                            CreateScriptDTO dto = new CreateScriptDTO();
                            dto.setDescription(panel.getScriptDesc());
                            dto.setLanguage("javascript");
                            dto.setName(panel.getScriptName());
                            dto.setScriptText("");
                            dto.setType(panel.getScriptType());
                            ApiResponse response = CentralizedApiScriptManagerTopComponent.this.apiService.apiCreateScript(dto);
                            if (response.isSuccess()) {
                                CentralizedApiScriptManagerTopComponent.this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                                Updater updater = new Updater();
                                updater.setNewScript(true);
                                updater.setNewScriptName(panel.getScriptName());
                                updater.execute();
                            } else {
                                ApiErrorMessage apiError = response.getErrorMessage();
                                LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                            }
                        }
                        catch (ApiServiceException_Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        CentralizedApiScriptManagerTopComponent.this.dialog.setVisible(false);
                        CentralizedApiScriptManagerTopComponent.this.dialog.dispose();
                    }
                }
            }
        });
        this.dialog = DialogDisplayer.getDefault().createDialog(des);
        this.dialog.setVisible(true);
    }

    private void miDeleteActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            int[] selectedRows = this.tScripts.getSelectedRows();
            String bodyMessage = "";
            bodyMessage = selectedRows.length > 1 ? String.format(NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.message.multipleDeletions"), selectedRows.length) : NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.message");
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)bodyMessage, NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.title"), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                try {
                    Script script = (Script)this.tableModel.getValueAt(this.tScripts.getSelectedRow(), 0);
                    ApiResponse response = this.apiService.apiDeleteScript(script.getId());
                    if (response.isSuccess()) {
                        this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                        new Updater().execute();
                        this.selectedRow = this.selectedRow - 1 <= 0 ? 0 : this.selectedRow - 1;
                    } else {
                        ApiErrorMessage apiError = response.getErrorMessage();
                        LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void bExportAllActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(NbBundle.getMessage(RenameScriptPanel.class, (String)"ExportDialog.title"));
            int userSelection = fileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
            File source = new File(ScriptsZipUtils.generateZipFileName());
            if (userSelection == 0) {
                ScriptsZipUtils.zip(this.tableModel.getScriptsOfType(), source.getAbsolutePath());
                File target = fileChooser.getSelectedFile();
                if (!target.getAbsolutePath().endsWith(".zip")) {
                    target = new File(Paths.get(target.getAbsolutePath() + ".zip", new String[0]).toString());
                }
                Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.deleteIfExists(source.toPath());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void miRenameActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            final RenameScriptPanel panel = new RenameScriptPanel();
            final Script script = (Script)this.tableModel.getValueAt(this.tScripts.getSelectedRow(), 0);
            final String oldName = script.getName();
            final String oldScript = script.getScript();
            panel.setOldScriptName(oldName);
            DialogDescriptor d = new DialogDescriptor((Object)panel, NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"RenameScriptPanel.title"), true, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == DialogDescriptor.OK_OPTION) {
                        try {
                            ApiResponse response = CentralizedApiScriptManagerTopComponent.this.apiService.apiRenameScript(script.getId(), panel.getNewScriptName());
                            if (response.isSuccess()) {
                                CentralizedApiScriptManagerTopComponent.this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                                new Updater().execute();
                            } else {
                                ApiErrorMessage apiError = response.getErrorMessage();
                                LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                            }
                        }
                        catch (ApiServiceException_Exception ex) {
                            LOGGER.log(Level.INFO, "{0}", ex.getFaultInfo().getData());
                            JOptionPane.showMessageDialog(panel, ex.getFaultInfo().getData().get(0), NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"RenameScriptPanel.title"), 2);
                            script.setName(oldName);
                            script.setScript(oldScript);
                        }
                    }
                }
            });
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        }
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        new Updater().execute();
        this.changedScripts.clear();
    }

    private void miRestorePreviousScriptVersionActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            try {
                Script script = (Script)this.tableModel.getValueAt(this.tScripts.getSelectedRow(), 0);
                String prevScript = script.getPrevScript();
                if (prevScript != null) {
                    script.setScript(prevScript);
                    ApiResponse response = this.apiService.apiUpdateScriptText(script.getId(), script.getScript());
                    if (response.isSuccess()) {
                        this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                        new Updater().execute();
                    } else {
                        ApiErrorMessage apiError = response.getErrorMessage();
                        LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                    }
                }
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void bSearchAllScriptsActionPerformed(ActionEvent evt) {
        this.searchInAllFiles();
    }

    private void miSortByNameActionPerformed(ActionEvent evt) {
        this.tableModel.sortScriptsByName(this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()));
        this.sortByName = true;
    }

    private void miSortByOrderActionPerformed(ActionEvent evt) {
        this.tableModel.sortScriptsByOrder(this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()));
        this.sortByName = false;
    }

    public void selectAndSearchScript(String type, String scriptName, String search) {
        if (!this.scriptTypeModel.getSelectedItem().toString().equalsIgnoreCase(type)) {
            this.scriptTypeModel.setSelectedItem(type);
            this.cbScriptType.invalidate();
            this.cbScriptType.revalidate();
            this.cbScriptType.repaint();
            ScriptType scriptType = this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
            this.refreshTable(scriptType);
        }
        int row = this.tableModel.getRowByScriptName(scriptName);
        if (this.tScripts.getSelectedRow() != row) {
            this.tScripts.setRowSelectionInterval(row, row);
            this.scrollTable();
        }
        this.tfSearch.setText(search);
        this.search();
    }

    private void search() {
        if (this.tfSearch.getText().isEmpty()) {
            this.taScriptText.setCaretPosition(0);
        }
        SearchContext context = new SearchContext();
        context.setSearchFor(this.tfSearch.getText());
        context.setMatchCase(false);
        context.setRegularExpression(true);
        context.setSearchForward(true);
        context.setWholeWord(false);
        context.setMarkAll(true);
        SearchEngine.find((JTextArea)this.taScriptText, (SearchContext)context);
    }

    private void searchInAllFiles() {
        ImageIcon mag = new ImageIcon(((Object)((Object)this)).getClass().getResource("/magnifier.png"));
        String searchTitle = NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiManagerTopComponent.searchTitle");
        String input = (String)JOptionPane.showInputDialog((Component)((Object)this), searchTitle, searchTitle, -1, mag, null, null);
        if (input != null && !input.isEmpty()) {
            ArrayList<Script> searchResults = new ArrayList<Script>();
            this.allScripts.forEach(s -> {
                if (s.getScript().toLowerCase().contains(input.toLowerCase())) {
                    searchResults.add((Script)s);
                }
            });
            Mode mode = WindowManager.getDefault().findMode("bottomSlidingSide");
            SearchResultsTopComponent tc = new SearchResultsTopComponent();
            tc.setSearchStringAndScripts(input, searchResults);
            mode.dockInto((TopComponent)tc);
            tc.open();
            tc.requestActive();
            tc.setDisplayName(String.format(NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"SearchResultsTopComponent.title"), input));
        }
    }

    public void componentOpened() {
        new Updater().execute();
    }

    public void componentClosed() {
        this.scriptsUpdater.shutdownNow();
    }

    private void saveLocalBackup(Script script) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String name = String.valueOf(script.getType()) + "_" + script.getName().replaceAll("\\W+", "_") + ".js";
        try (FileOutputStream fos = new FileOutputStream(String.valueOf(tmpDir) + "/" + name);){
            fos.write(script.getScript().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void refreshTable(ScriptType type) {
        if (type == ScriptType.VISUALISATION_CONFIGURATION || type == ScriptType.VISUALISATION_RULESET) {
            this.tableModel.sortScriptsByName(type);
        } else if (this.sortByName) {
            this.tableModel.sortScriptsByName(type);
        } else {
            this.tableModel.sortScriptsByOrder(type);
        }
    }

    private void resetScriptText() {
        this.setScriptText("");
    }

    private void resetDescriptionText() {
        if (!this.cpDescription.isCollapsed()) {
            this.tbDescription.doClick();
        }
        this.setDescriptionText("");
    }

    private void formatJS() {
        ScriptEngine se = this.sem.getEngineByName("JavaScript");
        InputStreamReader r = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/jsbeautifier.js"));
        try {
            se.eval(r);
            Invocable in = (Invocable)((Object)se);
            String formatted = (String)in.invokeFunction("js_beautify", this.taScriptText.getText());
            this.setScriptText(formatted);
        }
        catch (NoSuchMethodException | ScriptException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private boolean validateJS() {
        ScriptEngine se = this.sem.getEngineByName("javascript");
        try {
            se.eval(this.taScriptText.getText());
            return true;
        }
        catch (ScriptException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateScriptSyntax() {
        boolean valid = false;
        String errorMessage = "";
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            engine.eval(String.format("var DataMapper = Java.type(\"%s\")", DataMapperTest.class.getName()));
            engine.eval(String.format("var RawLog = Java.type(\"%s\")", RawLogTest.class.getName()));
            engine.eval(String.format("var SecurityEvent = Java.type(\"%s\")", SecurityEventTest.class.getName()));
            engine.eval(String.format("var ScriptUtils = Java.type(\"%s\")", ScriptUtilsTest.class.getName()));
            engine.eval(String.format("var VirusTotal = Java.type(\"%s\")", VirusTotalTest.class.getName()));
            engine.eval(String.format("var API = Java.type(\"%s\")", VirusTotalTest.API.class.getName()));
            engine.eval("var System = Java.type(\"java.lang.System\");");
            engine.put("SLIDING", (Object)CorrelationContextTest.Mode.SLIDING_WINDOW);
            engine.put("FIXED", (Object)CorrelationContextTest.Mode.FIXED_WINDOW);
            engine.put("ASC", Boolean.TRUE);
            engine.put("DESC", Boolean.FALSE);
            engine.put("DataMap", new DataMapManagerTest());
            engine.put("log", Logger.getLogger(CentralizedApiScriptManagerTopComponent.class.getName()));
            engine.put("Notification", new NotificationManagerTest(new ClusteringServiceTest()));
            engine.put("Country", new CountryTest());
            engine.put("SecurityEvents", new SecurityEventsTest());
            engine.put("Counter", new CounterManagerTest());
            engine.eval(this.taScriptText.getText());
            valid = true;
        }
        catch (ScriptException ex) {
            valid = false;
            errorMessage = ex.getLocalizedMessage();
        }
        finally {
            if (valid) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CentralizedApiScriptManagerTopComponent.class, (String)"CentralizedApiManagerTopComponent.scriptValidator.valid.message"), 1));
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errorMessage, 0));
            }
        }
    }

    private String validateScriptSyntax(String script) {
        boolean valid = false;
        String errorMessage = "";
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            engine.eval(String.format("var DataMapper = Java.type(\"%s\")", DataMapperTest.class.getName()));
            engine.eval(String.format("var RawLog = Java.type(\"%s\")", RawLogTest.class.getName()));
            engine.eval(String.format("var SecurityEvent = Java.type(\"%s\")", SecurityEventTest.class.getName()));
            engine.eval(String.format("var ScriptUtils = Java.type(\"%s\")", ScriptUtilsTest.class.getName()));
            engine.eval(String.format("var VirusTotal = Java.type(\"%s\")", VirusTotalTest.class.getName()));
            engine.eval(String.format("var API = Java.type(\"%s\")", VirusTotalTest.API.class.getName()));
            engine.eval("var System = Java.type(\"java.lang.System\");");
            engine.put("SLIDING", (Object)CorrelationContextTest.Mode.SLIDING_WINDOW);
            engine.put("FIXED", (Object)CorrelationContextTest.Mode.FIXED_WINDOW);
            engine.put("ASC", Boolean.TRUE);
            engine.put("DESC", Boolean.FALSE);
            engine.put("DataMap", new DataMapManagerTest());
            engine.put("log", Logger.getLogger(CentralizedApiScriptManagerTopComponent.class.getName()));
            engine.put("Notification", new NotificationManagerTest(new ClusteringServiceTest()));
            engine.put("Country", new CountryTest());
            engine.put("SecurityEvents", new SecurityEventsTest());
            engine.put("Counter", new CounterManagerTest());
            engine.eval(script);
            valid = true;
        }
        catch (ScriptException ex) {
            valid = false;
            errorMessage = ex.getLocalizedMessage();
        }
        return errorMessage;
    }

    private boolean testScript(String script, Object param) {
        if (ScriptType.CORRELATION.equals((Object)((ScriptType)this.cbScriptType.getSelectedItem()))) {
            this.correlate(script, param);
        } else if (ScriptType.ROUTING.equals((Object)((ScriptType)this.cbScriptType.getSelectedItem()))) {
            this.route(script, param);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void route(String script, Object param) {
        ScriptEngine se = this.sem.getEngineByName("javascript");
        ScriptEngineFactory fac = se.getFactory();
        String s = fac.getProgram(script);
        try {
            se.eval(s);
            if (!(se instanceof Invocable)) return;
            Invocable inv = (Invocable)((Object)se);
            try {
                Object dummy = inv.invokeFunction(this.genFuncName(), param);
                if (!(dummy instanceof String)) return;
                return;
            }
            catch (NoSuchMethodException | ScriptException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        }
        catch (ScriptException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void correlate(String script, Object param) {
        ScriptEngine se = this.sem.getEngineByName("javascript");
        se.put("SecurityEvent", new SecurityEvent());
        ScriptEngineFactory fac = se.getFactory();
        String s = fac.getProgram(script);
        try {
            se.eval(s);
            if (!(se instanceof Invocable)) return;
            Invocable inv = (Invocable)((Object)se);
            try {
                Object dummy = inv.invokeFunction(this.genFuncName(), param);
                if (dummy instanceof Array) return;
                if (dummy instanceof List) return;
                if (!(dummy instanceof Collection)) return;
                return;
            }
            catch (NoSuchMethodException | ScriptException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        }
        catch (ScriptException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String genFuncName() {
        Script script = (Script)this.tableModel.getValueAt(this.tScripts.getSelectedRow(), 0);
        if (this.scriptTypeModel.getSelectedItem() == ScriptType.CORRELATION.value()) {
            return script.getName() + "_correlate";
        }
        return script.getName() + "_route";
    }

    private void disableButtons() {
        this.miDelete.setEnabled(false);
        this.bExport.setEnabled(false);
        this.bEvaluate.setEnabled(false);
        this.bBeautify.setEnabled(false);
        this.bSave.setEnabled(false);
        this.bReset.setEnabled(false);
    }

    private void toggleLoading() {
        this.lLoading.setBusy(!this.lLoading.isBusy());
    }

    private void scrollTable() {
        JViewport viewport = (JViewport)this.tScripts.getParent();
        Rectangle rect = this.tScripts.getCellRect(this.tScripts.getSelectedRow(), 0, true);
        Rectangle r2 = viewport.getVisibleRect();
        this.tScripts.scrollRectToVisible(new Rectangle(rect.x, rect.y, (int)r2.getWidth(), (int)r2.getHeight()));
    }

    private void setScriptText(String text) {
        this.taScriptText.setText(text);
        this.taScriptText.setCaretPosition(0);
    }

    private void setDescriptionText(String text) {
        this.taScriptDescription.setText(text);
        this.taScriptDescription.setCaretPosition(0);
    }

    public class Updater
    extends SwingWorker<ListScriptsResponse, Void> {
        private boolean newScript;
        private String newScriptName;

        @Override
        protected ListScriptsResponse doInBackground() throws Exception {
            CentralizedApiScriptManagerTopComponent.this.toggleLoading();
            try {
                return CentralizedApiScriptManagerTopComponent.this.apiService.apiGetAllScripts();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                ListScriptsResponse response = (ListScriptsResponse)this.get();
                if (response.isSuccess()) {
                    CentralizedApiScriptManagerTopComponent.this.allScripts = response.getScripts();
                    CentralizedApiScriptManagerTopComponent.this.tableModel.setData(CentralizedApiScriptManagerTopComponent.this.allScripts);
                    CentralizedApiScriptManagerTopComponent.this.refreshTable(CentralizedApiScriptManagerTopComponent.this.scriptTypeModel.getSelectedItem(CentralizedApiScriptManagerTopComponent.this.scriptTypeModel.getSelectedIndex()));
                    CentralizedApiScriptManagerTopComponent.this.resetScriptText();
                    CentralizedApiScriptManagerTopComponent.this.disableButtons();
                    if (this.newScript) {
                        CentralizedApiScriptManagerTopComponent.this.selectedRow = CentralizedApiScriptManagerTopComponent.this.tableModel.getRowByScriptName(this.newScriptName);
                    }
                    if (CentralizedApiScriptManagerTopComponent.this.tableModel.getRowCount() > 0 && CentralizedApiScriptManagerTopComponent.this.selectedRow != -1 && CentralizedApiScriptManagerTopComponent.this.selectedRow <= CentralizedApiScriptManagerTopComponent.this.tableModel.getRowCount()) {
                        CentralizedApiScriptManagerTopComponent.this.tScripts.setRowSelectionInterval(CentralizedApiScriptManagerTopComponent.this.selectedRow, CentralizedApiScriptManagerTopComponent.this.selectedRow);
                    }
                } else {
                    ApiErrorMessage errorMessage = response.getErrorMessage();
                    LOGGER.log(Level.SEVERE, String.format("%s | %s", errorMessage.getErrorCode(), errorMessage.getMessage()));
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage.getMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                CentralizedApiScriptManagerTopComponent.this.toggleLoading();
            }
        }

        public void setNewScript(boolean newScript) {
            this.newScript = newScript;
        }

        public void setNewScriptName(String newScriptName) {
            this.newScriptName = newScriptName;
        }
    }
}

