/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.centralized.api.manager.account;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXDatePicker;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiAccount;
import rs.co.ast.aspen.api.service.ApiRole;
import rs.co.ast.aspen.gui.module.centralized.api.manager.account.RolesListModel;

public class NewAccountPanel
extends JPanel {
    private Pattern USERNAME_REGEX = Pattern.compile("^[a-zA-Z0-9_]{3,}$");
    public static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);
    private final RolesListModel listModelAvailable = new RolesListModel();
    private final RolesListModel listModelGranted = new RolesListModel();
    private final ApiAccount account = new ApiAccount();
    private boolean isNameValid = false;
    private boolean isEmailValid = true;
    private boolean isRoleValid = false;
    private JButton bGrantRole;
    private JButton bRevokeRole;
    private JXDatePicker dpApiKeyExpiration;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList<ApiRole> lAvailableRoles;
    private JList<ApiRole> lGrantedRoles;
    private JTextField tfEmail;
    private JTextField tfName;

    public NewAccountPanel() {
        this.initComponents();
        this.setFieldsBordersColorRed();
        this.listModelAvailable.setRoles(ApiRole.values());
        this.lAvailableRoles.setModel(this.listModelAvailable);
        this.lGrantedRoles.setModel(this.listModelGranted);
        Date date = new Date(0L);
        this.dpApiKeyExpiration.setDate(date);
        this.account.setApiKeyExpiry(date.getTime());
        this.tfName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkUsername();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkUsername();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkUsername();
            }

            private void checkUsername() {
                Matcher mat = NewAccountPanel.this.USERNAME_REGEX.matcher(NewAccountPanel.this.tfName.getText());
                NewAccountPanel.this.isNameValid = mat.matches();
                if (NewAccountPanel.this.isNameValid) {
                    NewAccountPanel.this.tfName.setBorder(UIManager.getBorder("TextField.border"));
                } else {
                    NewAccountPanel.this.tfName.setBorder(new LineBorder(Color.RED));
                }
                NewAccountPanel.this.tfName.repaint();
            }
        });
        this.tfEmail.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkEmail();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkEmail();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkEmail();
            }

            private void checkEmail() {
                Matcher mat = VALID_EMAIL_ADDRESS_REGEX.matcher(NewAccountPanel.this.tfEmail.getText());
                NewAccountPanel.this.isEmailValid = NewAccountPanel.this.tfEmail.getText().isEmpty() ? true : mat.matches();
                if (NewAccountPanel.this.isEmailValid) {
                    NewAccountPanel.this.tfEmail.setBorder(UIManager.getBorder("TextField.border"));
                } else {
                    NewAccountPanel.this.tfEmail.setBorder(new LineBorder(Color.RED));
                }
                NewAccountPanel.this.tfEmail.repaint();
            }
        });
    }

    public ApiAccount getAccount() {
        this.account.setName(this.tfName.getText());
        this.account.setEmail(this.tfEmail.getText());
        if (this.dpApiKeyExpiration.getDate() != null) {
            this.account.setApiKeyExpiry(this.dpApiKeyExpiration.getDate().getTime());
        } else {
            Date date = new Date(0L);
            this.account.setApiKeyExpiry(date.getTime());
        }
        this.account.setEnabled(true);
        return this.account;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.tfName = new JTextField();
        this.tfEmail = new JTextField();
        this.dpApiKeyExpiration = new JXDatePicker();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lAvailableRoles = new JList();
        this.bGrantRole = new JButton();
        this.bRevokeRole = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.lGrantedRoles = new JList();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NewAccountPanel.class, (String)"NewAccountPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NewAccountPanel.class, (String)"NewAccountPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(NewAccountPanel.class, (String)"NewAccountPanel.jLabel3.text"));
        this.tfName.setText(NbBundle.getMessage(NewAccountPanel.class, (String)"NewAccountPanel.tfName.text"));
        this.tfEmail.setText(NbBundle.getMessage(NewAccountPanel.class, (String)"NewAccountPanel.tfEmail.text"));
        this.lAvailableRoles.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lAvailableRoles);
        this.bGrantRole.setIcon(new ImageIcon(this.getClass().getResource("/arrow_right.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bGrantRole, (String)NbBundle.getMessage(NewAccountPanel.class, (String)"NewAccountPanel.bGrantRole.text"));
        this.bGrantRole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewAccountPanel.this.bGrantRoleActionPerformed(evt);
            }
        });
        this.bRevokeRole.setIcon(new ImageIcon(this.getClass().getResource("/arrow_left.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRevokeRole, (String)NbBundle.getMessage(NewAccountPanel.class, (String)"NewAccountPanel.bRevokeRole.text"));
        this.bRevokeRole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewAccountPanel.this.bRevokeRoleActionPerformed(evt);
            }
        });
        this.lGrantedRoles.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.lGrantedRoles);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bGrantRole).addComponent(this.bRevokeRole)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 166, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.bGrantRole).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bRevokeRole)).addComponent(this.jScrollPane1, -2, 161, -2).addComponent(this.jScrollPane2, -2, 161, -2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfName).addComponent(this.tfEmail).addComponent((Component)this.dpApiKeyExpiration, -1, 238, Short.MAX_VALUE))).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfName, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tfEmail, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.dpApiKeyExpiration, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void bGrantRoleActionPerformed(ActionEvent evt) {
        ApiRole selectedRole = this.lAvailableRoles.getSelectedValue();
        if (selectedRole != null) {
            this.listModelAvailable.removeRole(selectedRole);
            this.listModelGranted.addRole(selectedRole);
            this.account.getRoles().add(selectedRole);
            if (!this.account.getRoles().isEmpty()) {
                this.isRoleValid = true;
                this.lGrantedRoles.setBorder(UIManager.getBorder("TextField.border"));
            } else {
                this.isRoleValid = false;
                this.lGrantedRoles.setBorder(new LineBorder(Color.RED));
            }
            this.lGrantedRoles.repaint();
        }
    }

    private void bRevokeRoleActionPerformed(ActionEvent evt) {
        ApiRole selectedRole = this.lGrantedRoles.getSelectedValue();
        if (selectedRole != null) {
            this.listModelGranted.removeRole(selectedRole);
            this.listModelAvailable.addRole(selectedRole);
            this.account.getRoles().remove(selectedRole);
            if (this.account.getRoles().isEmpty()) {
                this.isRoleValid = false;
                this.lGrantedRoles.setBorder(new LineBorder(Color.RED));
            } else {
                this.isRoleValid = true;
                this.lGrantedRoles.setBorder(UIManager.getBorder("TextField.border"));
            }
            this.lGrantedRoles.repaint();
        }
    }

    public boolean isNameValid() {
        return this.isNameValid;
    }

    public boolean isEmailValid() {
        return this.isEmailValid;
    }

    public boolean isRoleValid() {
        return this.isRoleValid;
    }

    private void setFieldsBordersColorRed() {
        this.tfName.setBorder(new LineBorder(Color.RED));
        this.lGrantedRoles.setBorder(new LineBorder(Color.RED));
        this.tfName.repaint();
        this.lGrantedRoles.repaint();
    }
}

