/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public final class FreeRectangularAnchor
extends Anchor {
    private boolean includeBorders;

    public FreeRectangularAnchor(Widget widget, boolean includeBorders) {
        super(widget);
        this.includeBorders = includeBorders;
    }

    @Override
    public Anchor.Result compute(Anchor.Entry entry) {
        float ddy;
        ConnectionWidget fcw = entry.getAttachedConnectionWidget();
        assert (fcw != null);
        Point relatedLocation = this.getRelatedSceneLocation();
        Widget widget = this.getRelatedWidget();
        List<Point> fcwControlPoints = fcw.getControlPoints();
        Point oppositeLocation = fcwControlPoints.size() < 2 ? this.getOppositeSceneLocation(entry) : (entry.isAttachedToConnectionSource() ? fcwControlPoints.get(1) : fcwControlPoints.get(fcwControlPoints.size() - 2));
        Rectangle bounds = widget.getBounds();
        if (!this.includeBorders) {
            Insets insets = widget.getBorder().getInsets();
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
        }
        if ((bounds = widget.convertLocalToScene(bounds)).isEmpty() || relatedLocation.equals(oppositeLocation)) {
            return (Anchor)this.new Anchor.Result(relatedLocation, Anchor.DIRECTION_ANY);
        }
        float dx = oppositeLocation.x - relatedLocation.x;
        float dy = oppositeLocation.y - relatedLocation.y;
        float ddx = Math.abs(dx) / (float)bounds.width;
        Anchor.Direction direction = ddx >= (ddy = Math.abs(dy) / (float)bounds.height) ? (dx >= 0.0f ? Anchor.Direction.RIGHT : Anchor.Direction.LEFT) : (dy >= 0.0f ? Anchor.Direction.BOTTOM : Anchor.Direction.TOP);
        float scale = 0.5f / Math.max(ddx, ddy);
        Point point = new Point(Math.round((float)relatedLocation.x + scale * dx), Math.round((float)relatedLocation.y + scale * dy));
        return (Anchor)this.new Anchor.Result(point, direction);
    }
}

