/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import java.util.Comparator;

public class ListSort<T> {
    private static final int MIN_SIZE = 128;
    private T[] array;
    private T[] tmpArray;
    private Comparator<T> comparator;
    int iterA;
    int iterB;
    int dest;
    int lengthA;
    int lengthB;
    private int nbRuns = 0;
    private int[] runsIndices = null;
    private int[] runsLength = null;
    private int length = 0;
    private static final int MIN_GALLOP = 7;
    private int minGallop = 7;

    public final void allocateStack(int len) {
        int stackLen;
        this.length = len;
        int tmpLen = len >>> 1;
        if (this.tmpArray == null || tmpLen > this.tmpArray.length) {
            this.tmpArray = new Object[tmpLen];
        }
        int n = len < 1400 ? 5 : (len < 15730 ? 10 : (stackLen = len < 1196194 ? 19 : 40));
        if (this.runsIndices == null || stackLen > this.runsIndices.length) {
            this.runsIndices = new int[stackLen];
            this.runsLength = new int[stackLen];
        }
    }

    private void clean() {
        for (int i = 0; i < this.runsIndices.length; ++i) {
            this.runsIndices[i] = 0;
            this.runsLength[i] = 0;
        }
    }

    public void sort(T[] array, Comparator<T> comparator) {
        int runLength;
        int remaining;
        this.array = array;
        this.comparator = comparator;
        this.clean();
        int low = 0;
        int high = this.length;
        if (remaining < 128) {
            int runLength2 = this.getRunLength(array, low, high, comparator);
            this.binaryInsertionSort(array, low, high, low + runLength2, comparator);
            return;
        }
        int minLength = this.mergeComputeMinRun(remaining);
        for (remaining = high - low; remaining != 0; remaining -= runLength) {
            runLength = this.getRunLength(array, low, high, comparator);
            if (runLength < minLength) {
                int newLength = remaining <= minLength ? remaining : minLength;
                this.binaryInsertionSort(array, low, low + newLength, low + runLength, comparator);
                runLength = newLength;
            }
            this.runsIndices[this.nbRuns] = low;
            this.runsLength[this.nbRuns] = runLength;
            ++this.nbRuns;
            this.mergeCollapse();
            low += runLength;
        }
        this.mergeForceCollapse();
    }

    private int getRunLength(T[] array, int firstId, int lastId, Comparator<T> comparator) {
        int runEnd = firstId + 1;
        if (runEnd < lastId) {
            if (comparator.compare(array[runEnd++], array[firstId]) >= 0) {
                while (runEnd < lastId && comparator.compare(array[runEnd], array[runEnd - 1]) >= 0) {
                    ++runEnd;
                }
            } else {
                while (runEnd < lastId && comparator.compare(array[runEnd], array[runEnd - 1]) < 0) {
                    ++runEnd;
                }
                ListSort.reverseArray(array, firstId, runEnd);
            }
            return runEnd - firstId;
        }
        return 1;
    }

    private void binaryInsertionSort(T[] array, int firstId, int lastId, int start, Comparator<T> comparator) {
        if (firstId == start) {
            ++start;
        }
        while (start < lastId) {
            T pivot = array[start];
            int left = firstId;
            int right = start;
            while (left < right) {
                int middle = left + right >>> 1;
                if (comparator.compare(pivot, array[middle]) < 0) {
                    right = middle;
                    continue;
                }
                left = middle + 1;
            }
            int nbElems = start - left;
            switch (nbElems) {
                case 2: {
                    array[left + 2] = array[left + 1];
                }
                case 1: {
                    array[left + 1] = array[left];
                    break;
                }
                default: {
                    System.arraycopy(array, left, array, left + 1, nbElems);
                }
            }
            array[left] = pivot;
            ++start;
        }
    }

    private int mergeComputeMinRun(int n) {
        int r = 0;
        while (n >= 128) {
            r |= n & 1;
            n >>= 1;
        }
        return n + r;
    }

    private void mergeCollapse() {
        while (this.nbRuns > 1) {
            int n = this.nbRuns - 2;
            if (n > 0 && this.runsLength[n - 1] <= this.runsLength[n] + this.runsLength[n + 1]) {
                if (this.runsLength[n - 1] < this.runsLength[n + 1]) {
                    --n;
                }
                this.mergeRuns(n);
                continue;
            }
            if (this.runsLength[n] > this.runsLength[n + 1]) break;
            this.mergeRuns(n);
        }
    }

    private void mergeForceCollapse() {
        while (this.nbRuns > 1) {
            int n = this.nbRuns - 2;
            if (n > 0 && this.runsLength[n - 1] < this.runsLength[n + 1]) {
                --n;
            }
            this.mergeRuns(n);
        }
    }

    private void mergeRuns(int idx) {
        int indexA = this.runsIndices[idx];
        int lenA = this.runsLength[idx];
        int indexB = this.runsIndices[idx + 1];
        int lenB = this.runsLength[idx + 1];
        this.runsLength[idx] = lenA + lenB;
        if (idx == this.nbRuns - 3) {
            this.runsIndices[idx + 1] = this.runsIndices[idx + 2];
            this.runsLength[idx + 1] = this.runsLength[idx + 2];
        }
        --this.nbRuns;
        int k = this.gallopRight(this.array[indexB], this.array, indexA, lenA, 0, this.comparator);
        indexA += k;
        if ((lenA -= k) == 0) {
            return;
        }
        if ((lenB = this.gallopLeft(this.array[indexA + lenA - 1], this.array, indexB, lenB, lenB - 1, this.comparator)) == 0) {
            return;
        }
        if (lenA <= lenB) {
            this.mergeLow(indexA, lenA, indexB, lenB);
        } else {
            this.mergeHigh(indexA, lenA, indexB, lenB);
        }
    }

    private int gallopLeft(T key, T[] array, int idx, int length, int hint, Comparator<T> comparator) {
        int maxOffset;
        int lastOffset = 0;
        int offset = 1;
        if (comparator.compare(key, array[idx + hint]) > 0) {
            maxOffset = length - hint;
            while (offset < maxOffset && comparator.compare(key, array[idx + hint + offset]) > 0) {
                lastOffset = offset;
                if ((offset = (offset << 1) + 1) > 0) continue;
                offset = maxOffset;
            }
            if (offset > maxOffset) {
                offset = maxOffset;
            }
            lastOffset += hint;
            offset += hint;
        } else {
            maxOffset = hint + 1;
            while (offset < maxOffset && comparator.compare(key, array[idx + hint - offset]) <= 0) {
                lastOffset = offset;
                if ((offset = (offset << 1) + 1) > 0) continue;
                offset = maxOffset;
            }
            if (offset > maxOffset) {
                offset = maxOffset;
            }
            int k = lastOffset;
            lastOffset = hint - offset;
            offset = hint - k;
        }
        ++lastOffset;
        while (lastOffset < offset) {
            int m = lastOffset + (offset - lastOffset >>> 1);
            if (comparator.compare(key, array[idx + m]) > 0) {
                lastOffset = m + 1;
                continue;
            }
            offset = m;
        }
        return offset;
    }

    private int gallopRight(T key, T[] array, int idx, int length, int hint, Comparator<T> comparator) {
        int maxOffset;
        int offset = 1;
        int lastOffset = 0;
        if (comparator.compare(key, array[idx + hint]) < 0) {
            maxOffset = hint + 1;
            while (offset < maxOffset && comparator.compare(key, array[idx + hint - offset]) < 0) {
                lastOffset = offset;
                if ((offset = (offset << 1) + 1) > 0) continue;
                offset = maxOffset;
            }
            if (offset > maxOffset) {
                offset = maxOffset;
            }
            int k = lastOffset;
            lastOffset = hint - offset;
            offset = hint - k;
        } else {
            maxOffset = length - hint;
            while (offset < maxOffset && comparator.compare(key, array[idx + hint + offset]) >= 0) {
                lastOffset = offset;
                if ((offset = (offset << 1) + 1) > 0) continue;
                offset = maxOffset;
            }
            if (offset > maxOffset) {
                offset = maxOffset;
            }
            lastOffset += hint;
            offset += hint;
        }
        ++lastOffset;
        while (lastOffset < offset) {
            int m = lastOffset + (offset - lastOffset >>> 1);
            if (comparator.compare(key, array[idx + m]) < 0) {
                offset = m;
                continue;
            }
            lastOffset = m + 1;
        }
        return offset;
    }

    private void mergeLow(int idxA, int lenA, int idxB, int lenB) {
        this.lengthA = lenA;
        this.lengthB = lenB;
        this.iterA = 0;
        this.iterB = idxB;
        this.dest = idxA;
        Comparator<T> comp = this.comparator;
        T[] arr = this.array;
        T[] tempArray = this.tmpArray;
        System.arraycopy(arr, idxA, tempArray, 0, this.lengthA);
        arr[this.dest] = arr[this.iterB];
        ++this.dest;
        ++this.iterB;
        this.innerMergeLow(comp, arr, tempArray);
        int n = this.minGallop = this.minGallop < 1 ? 1 : this.minGallop;
        if (this.lengthA == 1) {
            System.arraycopy(arr, this.iterB, arr, this.dest, this.lengthB);
            arr[this.dest + this.lengthB] = tempArray[this.iterA];
        } else {
            if (this.lengthA == 0) {
                throw new UnsupportedOperationException("Compare function result changed! Make sure you do not modify the scene from another thread and that the comparisons are not based on NaN values.");
            }
            System.arraycopy(tempArray, this.iterA, arr, this.dest, this.lengthA);
        }
    }

    public void innerMergeLow(Comparator<T> comp, T[] arr, T[] tempArray) {
        --this.lengthB;
        if (this.lengthB == 0 || this.lengthA == 1) {
            return;
        }
        while (true) {
            int aWins = 0;
            int bWins = 0;
            do {
                if (comp.compare(arr[this.iterB], tempArray[this.iterA]) < 0) {
                    arr[this.dest] = arr[this.iterB];
                    ++this.dest;
                    ++this.iterB;
                    ++bWins;
                    aWins = 0;
                    --this.lengthB;
                    if (this.lengthB != 0) continue;
                    return;
                }
                arr[this.dest] = tempArray[this.iterA];
                ++this.dest;
                ++this.iterA;
                ++aWins;
                bWins = 0;
                --this.lengthA;
                if (this.lengthA != 1) continue;
                return;
            } while ((aWins | bWins) < this.minGallop);
            do {
                if ((aWins = this.gallopRight(arr[this.iterB], tempArray, this.iterA, this.lengthA, 0, comp)) != 0) {
                    System.arraycopy(tempArray, this.iterA, arr, this.dest, aWins);
                    this.dest += aWins;
                    this.iterA += aWins;
                    this.lengthA -= aWins;
                    if (this.lengthA <= 1) {
                        return;
                    }
                }
                arr[this.dest] = arr[this.iterB];
                ++this.dest;
                ++this.iterB;
                --this.lengthB;
                if (this.lengthB == 0) {
                    return;
                }
                bWins = this.gallopLeft(tempArray[this.iterA], arr, this.iterB, this.lengthB, 0, comp);
                if (bWins != 0) {
                    System.arraycopy(arr, this.iterB, arr, this.dest, bWins);
                    this.dest += bWins;
                    this.iterB += bWins;
                    this.lengthB -= bWins;
                    if (this.lengthB == 0) {
                        return;
                    }
                }
                arr[this.dest] = tempArray[this.iterA];
                ++this.dest;
                ++this.iterA;
                --this.lengthA;
                if (this.lengthA == 1) {
                    return;
                }
                --this.minGallop;
            } while (aWins >= 7 || bWins >= 7);
            if (this.minGallop < 0) {
                this.minGallop = 0;
            }
            this.minGallop += 2;
        }
    }

    private void mergeHigh(int idxA, int lenA, int idxB, int lenB) {
        this.lengthA = lenA;
        this.lengthB = lenB;
        this.iterA = idxA + this.lengthA - 1;
        this.iterB = this.lengthB - 1;
        this.dest = idxB + this.lengthB - 1;
        Comparator<T> comp = this.comparator;
        T[] arr = this.array;
        T[] tempArray = this.tmpArray;
        System.arraycopy(arr, idxB, tempArray, 0, this.lengthB);
        arr[this.dest] = arr[this.iterA];
        --this.dest;
        --this.iterA;
        this.innerMergeHigh(comp, tempArray, arr, idxA);
        int n = this.minGallop = this.minGallop < 1 ? 1 : this.minGallop;
        if (this.lengthB == 1) {
            this.dest -= this.lengthA;
            this.iterA -= this.lengthA;
            System.arraycopy(arr, this.iterA + 1, arr, this.dest + 1, this.lengthA);
            arr[this.dest] = tempArray[this.iterB];
        } else {
            if (this.lengthB == 0) {
                throw new UnsupportedOperationException("Compare function result changed! Make sure you do not modify the scene from another thread!");
            }
            System.arraycopy(tempArray, 0, arr, this.dest - (this.lengthB - 1), this.lengthB);
        }
    }

    public void innerMergeHigh(Comparator<T> comp, T[] tempArray, T[] arr, int idxA) {
        --this.lengthA;
        if (this.lengthA == 0 || this.lengthB == 1) {
            return;
        }
        if (this.lengthB == 1) {
            return;
        }
        while (true) {
            int aWins = 0;
            int bWins = 0;
            do {
                if (comp.compare(tempArray[this.iterB], arr[this.iterA]) < 0) {
                    arr[this.dest] = arr[this.iterA];
                    --this.dest;
                    --this.iterA;
                    ++aWins;
                    bWins = 0;
                    --this.lengthA;
                    if (this.lengthA != 0) continue;
                    return;
                }
                arr[this.dest] = tempArray[this.iterB];
                --this.dest;
                --this.iterB;
                ++bWins;
                aWins = 0;
                --this.lengthB;
                if (this.lengthB != 1) continue;
                return;
            } while ((aWins | bWins) < this.minGallop);
            do {
                if ((aWins = this.lengthA - this.gallopRight(tempArray[this.iterB], arr, idxA, this.lengthA, this.lengthA - 1, comp)) != 0) {
                    this.dest -= aWins;
                    this.iterA -= aWins;
                    this.lengthA -= aWins;
                    System.arraycopy(arr, this.iterA + 1, arr, this.dest + 1, aWins);
                    if (this.lengthA == 0) {
                        return;
                    }
                }
                arr[this.dest] = tempArray[this.iterB];
                --this.dest;
                --this.iterB;
                --this.lengthB;
                if (this.lengthB == 1) {
                    return;
                }
                bWins = this.lengthB - this.gallopLeft(arr[this.iterA], tempArray, 0, this.lengthB, this.lengthB - 1, comp);
                if (bWins != 0) {
                    this.dest -= bWins;
                    this.iterB -= bWins;
                    this.lengthB -= bWins;
                    System.arraycopy(tempArray, this.iterB + 1, arr, this.dest + 1, bWins);
                    if (this.lengthB <= 1) {
                        return;
                    }
                }
                arr[this.dest] = arr[this.iterA];
                --this.dest;
                --this.iterA;
                --this.lengthA;
                if (this.lengthA == 0) {
                    return;
                }
                --this.minGallop;
            } while (aWins >= 7 || bWins >= 7);
            if (this.minGallop < 0) {
                this.minGallop = 0;
            }
            this.minGallop += 2;
        }
    }

    private static void reverseArray(Object[] array, int firstId, int lastId) {
        --lastId;
        while (firstId < lastId) {
            Object o = array[firstId];
            array[firstId] = array[lastId];
            array[lastId] = o;
            ++firstId;
            --lastId;
        }
    }

    public int getLength() {
        return this.length;
    }

    public static void main(String[] argv) {
        Integer[] arr = new Integer[]{5, 6, 2, 9, 10, 11, 12, 8, 3, 12, 3, 7, 12, 32, 458, 12, 5, 3, 78, 45, 12, 32, 58, 45, 65, 45, 98, 45, 65, 2, 3, 47, 21, 35};
        ListSort<Integer> ls = new ListSort<Integer>();
        ls.allocateStack(34);
        ls.sort(arr, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int x = o1 - o2;
                return x == 0 ? 0 : (x > 0 ? 1 : -1);
            }
        });
        for (Integer integer : arr) {
            System.err.print(integer + ",");
        }
        System.err.println();
    }
}

