/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector4f;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.shadow.AbstractShadowRenderer;
import com.jme3.shadow.CompareMode;
import com.jme3.shadow.EdgeFilteringMode;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public abstract class AbstractShadowFilter<T extends AbstractShadowRenderer>
extends Filter
implements Cloneable,
JmeCloneable {
    protected T shadowRenderer;
    protected ViewPort viewPort;
    Vector4f tmpv = new Vector4f();

    protected AbstractShadowFilter() {
    }

    protected AbstractShadowFilter(AssetManager manager, int shadowMapSize, T shadowRenderer) {
        super("Post Shadow");
        this.material = new Material(manager, "Common/MatDefs/Shadow/PostShadowFilter.j3md");
        this.shadowRenderer = shadowRenderer;
        ((AbstractShadowRenderer)this.shadowRenderer).setPostShadowMaterial(this.material);
        ((AbstractShadowRenderer)this.shadowRenderer).setRenderBackFacesShadows(true);
    }

    @Override
    protected Material getMaterial() {
        return this.material;
    }

    @Override
    protected boolean isRequiresDepthTexture() {
        return true;
    }

    public Material getShadowMaterial() {
        return this.material;
    }

    @Override
    protected void preFrame(float tpf) {
        ((AbstractShadowRenderer)this.shadowRenderer).preFrame(tpf);
        this.material.setMatrix4("ViewProjectionMatrixInverse", this.viewPort.getCamera().getViewProjectionMatrix().invert());
        Matrix4f m = this.viewPort.getCamera().getViewProjectionMatrix();
        this.material.setVector4("ViewProjectionMatrixRow2", this.tmpv.set(m.m20, m.m21, m.m22, m.m23));
    }

    @Override
    protected void postQueue(RenderQueue queue) {
        ((AbstractShadowRenderer)this.shadowRenderer).postQueue(queue);
        if (((AbstractShadowRenderer)this.shadowRenderer).skipPostPass) {
            this.material.setTexture("ShadowMap0", null);
        }
    }

    @Override
    protected void postFrame(RenderManager renderManager, ViewPort viewPort, FrameBuffer prevFilterBuffer, FrameBuffer sceneBuffer) {
        if (!((AbstractShadowRenderer)this.shadowRenderer).skipPostPass) {
            ((AbstractShadowRenderer)this.shadowRenderer).setPostShadowParams();
        }
    }

    @Override
    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        ((AbstractShadowRenderer)this.shadowRenderer).needsfallBackMaterial = true;
        ((AbstractShadowRenderer)this.shadowRenderer).initialize(renderManager, vp);
        this.viewPort = vp;
    }

    public float getShadowZExtend() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getShadowZExtend();
    }

    public void setShadowZExtend(float zFar) {
        ((AbstractShadowRenderer)this.shadowRenderer).setShadowZExtend(zFar);
    }

    public void setShadowZFadeLength(float length) {
        ((AbstractShadowRenderer)this.shadowRenderer).setShadowZFadeLength(length);
    }

    public float getShadowZFadeLength() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getShadowZFadeLength();
    }

    public float getShadowIntensity() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getShadowIntensity();
    }

    public final void setShadowIntensity(float shadowIntensity) {
        ((AbstractShadowRenderer)this.shadowRenderer).setShadowIntensity(shadowIntensity);
    }

    public int getEdgesThickness() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getEdgesThickness();
    }

    public void setEdgesThickness(int edgesThickness) {
        ((AbstractShadowRenderer)this.shadowRenderer).setEdgesThickness(edgesThickness);
    }

    @Deprecated
    public boolean isFlushQueues() {
        return ((AbstractShadowRenderer)this.shadowRenderer).isFlushQueues();
    }

    @Deprecated
    public void setFlushQueues(boolean flushQueues) {
    }

    public final void setShadowCompareMode(CompareMode compareMode) {
        ((AbstractShadowRenderer)this.shadowRenderer).setShadowCompareMode(compareMode);
    }

    public CompareMode getShadowCompareMode() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getShadowCompareMode();
    }

    public final void setEdgeFilteringMode(EdgeFilteringMode filterMode) {
        ((AbstractShadowRenderer)this.shadowRenderer).setEdgeFilteringMode(filterMode);
    }

    public void setRenderBackFacesShadows(Boolean renderBackFacesShadows) {
        ((AbstractShadowRenderer)this.shadowRenderer).setRenderBackFacesShadows(renderBackFacesShadows);
    }

    public boolean isRenderBackFacesShadows() {
        return ((AbstractShadowRenderer)this.shadowRenderer).isRenderBackFacesShadows();
    }

    public RenderState getPreShadowForcedRenderState() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getPreShadowForcedRenderState();
    }

    public EdgeFilteringMode getEdgeFilteringMode() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getEdgeFilteringMode();
    }

    @Override
    public AbstractShadowFilter<T> jmeClone() {
        try {
            return (AbstractShadowFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.material = cloner.clone(this.material);
        this.shadowRenderer = (AbstractShadowRenderer)cloner.clone(this.shadowRenderer);
        ((AbstractShadowRenderer)this.shadowRenderer).setPostShadowMaterial(this.material);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
    }
}

