/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class Grid
extends Mesh {
    public Grid() {
    }

    public Grid(int xLines, int yLines, float lineDist) {
        int i;
        int lineCount = (xLines -= 2) + (yLines -= 2) + 4;
        FloatBuffer fpb = BufferUtils.createFloatBuffer(6 * lineCount);
        ShortBuffer sib = BufferUtils.createShortBuffer(2 * lineCount);
        float xLineLen = (float)(yLines + 1) * lineDist;
        float yLineLen = (float)(xLines + 1) * lineDist;
        int curIndex = 0;
        for (i = 0; i < xLines + 2; ++i) {
            float y = (float)i * lineDist;
            fpb.put(0.0f).put(0.0f).put(y);
            fpb.put(xLineLen).put(0.0f).put(y);
            sib.put((short)curIndex++);
            sib.put((short)curIndex++);
        }
        for (i = 0; i < yLines + 2; ++i) {
            float x = (float)i * lineDist;
            fpb.put(x).put(0.0f).put(0.0f);
            fpb.put(x).put(0.0f).put(yLineLen);
            sib.put((short)curIndex++);
            sib.put((short)curIndex++);
        }
        fpb.flip();
        sib.flip();
        this.setBuffer(VertexBuffer.Type.Position, 3, fpb);
        this.setBuffer(VertexBuffer.Type.Index, 2, sib);
        this.setMode(Mesh.Mode.Lines);
        this.updateBound();
        this.updateCounts();
        this.setStatic();
    }
}

