/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.CloneableSmartAsset;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.LightList;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamOverride;
import com.jme3.material.MatParamTexture;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.material.Technique;
import com.jme3.material.TechniqueDef;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.shader.Shader;
import com.jme3.shader.Uniform;
import com.jme3.shader.VarType;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.ListMap;
import com.jme3.util.SafeArrayList;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Material
implements CloneableSmartAsset,
Cloneable,
Savable {
    public static final int SAVABLE_VERSION = 2;
    private static final Logger logger = Logger.getLogger(Material.class.getName());
    private AssetKey key;
    private String name;
    private MaterialDef def;
    private ListMap<String, MatParam> paramValues = new ListMap();
    private Technique technique;
    private HashMap<String, Technique> techniques = new HashMap();
    private RenderState additionalState = null;
    private RenderState mergedRenderState = new RenderState();
    private boolean transparent = false;
    private boolean receivesShadows = false;
    private int sortingId = -1;

    public Material(MaterialDef def) {
        if (def == null) {
            throw new NullPointerException("Material definition cannot be null");
        }
        this.def = def;
        for (MatParam param : def.getMaterialParams()) {
            if (param.getValue() == null) continue;
            this.setParam(param.getName(), param.getVarType(), param.getValue());
        }
    }

    public Material(AssetManager contentMan, String defName) {
        this((MaterialDef)contentMan.loadAsset(new AssetKey(defName)));
    }

    public Material() {
    }

    public String getAssetName() {
        return this.key != null ? this.key.getName() : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setKey(AssetKey key) {
        this.key = key;
    }

    @Override
    public AssetKey getKey() {
        return this.key;
    }

    public int getSortId() {
        if (this.sortingId == -1 && this.technique != null) {
            this.sortingId = this.technique.getSortId() << 16;
            int texturesSortId = 17;
            for (int i = 0; i < this.paramValues.size(); ++i) {
                Image image;
                Texture texture;
                MatParam param = this.paramValues.getValue(i);
                if (!param.getVarType().isTextureType() || (texture = (Texture)param.getValue()) == null || (image = texture.getImage()) == null) continue;
                int textureId = image.getId();
                if (textureId == -1) {
                    textureId = 0;
                }
                texturesSortId = texturesSortId * 23 + textureId;
            }
            this.sortingId |= texturesSortId & 0xFFFF;
        }
        return this.sortingId;
    }

    @Override
    public Material clone() {
        try {
            Material mat = (Material)super.clone();
            if (this.additionalState != null) {
                mat.additionalState = this.additionalState.clone();
            }
            mat.technique = null;
            mat.techniques = new HashMap();
            mat.paramValues = new ListMap();
            for (int i = 0; i < this.paramValues.size(); ++i) {
                Map.Entry<String, MatParam> entry = this.paramValues.getEntry(i);
                mat.paramValues.put(entry.getKey(), entry.getValue().clone());
            }
            mat.sortingId = -1;
            return mat;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public boolean contentEquals(Object otherObj) {
        if (!(otherObj instanceof Material)) {
            return false;
        }
        Material other = (Material)otherObj;
        if (this == other) {
            return true;
        }
        if (this.getMaterialDef() != other.getMaterialDef()) {
            return false;
        }
        if (this.paramValues.size() != other.paramValues.size()) {
            return false;
        }
        if (this.technique != null || other.technique != null) {
            String otherDefName;
            String thisDefName = this.technique != null ? this.technique.getDef().getName() : "Default";
            String string = otherDefName = other.technique != null ? other.technique.getDef().getName() : "Default";
            if (!thisDefName.equals(otherDefName)) {
                return false;
            }
        }
        for (String paramKey : this.paramValues.keySet()) {
            MatParam thisParam = this.getParam(paramKey);
            MatParam otherParam = other.getParam(paramKey);
            if (otherParam == null) {
                return false;
            }
            if (otherParam.equals(thisParam)) continue;
            return false;
        }
        return !(this.additionalState == null ? other.additionalState != null : !this.additionalState.equals(other.additionalState));
    }

    public int contentHashCode() {
        int hash = 7;
        hash = 29 * hash + (this.def != null ? this.def.hashCode() : 0);
        hash = 29 * hash + (this.paramValues != null ? this.paramValues.hashCode() : 0);
        hash = 29 * hash + (this.technique != null ? this.technique.getDef().getName().hashCode() : 0);
        hash = 29 * hash + (this.additionalState != null ? this.additionalState.contentHashCode() : 0);
        return hash;
    }

    public Technique getActiveTechnique() {
        return this.technique;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public boolean isReceivesShadows() {
        return this.receivesShadows;
    }

    public void setReceivesShadows(boolean receivesShadows) {
        this.receivesShadows = receivesShadows;
    }

    public RenderState getAdditionalRenderState() {
        if (this.additionalState == null) {
            this.additionalState = RenderState.ADDITIONAL.clone();
        }
        return this.additionalState;
    }

    public MaterialDef getMaterialDef() {
        return this.def;
    }

    public MatParam getParam(String name) {
        return this.paramValues.get(name);
    }

    public MatParamTexture getTextureParam(String name) {
        MatParam param = this.paramValues.get(name);
        if (param instanceof MatParamTexture) {
            return (MatParamTexture)param;
        }
        return null;
    }

    public Collection<MatParam> getParams() {
        return this.paramValues.values();
    }

    public ListMap<String, MatParam> getParamsMap() {
        return this.paramValues;
    }

    private void checkSetParam(VarType type, String name) {
        MatParam paramDef = this.def.getMaterialParam(name);
        if (paramDef == null) {
            throw new IllegalArgumentException("Material parameter is not defined: " + name);
        }
        if (type != null && paramDef.getVarType() != type) {
            logger.log(Level.WARNING, "Material parameter being set: {0} with type {1} doesn''t match definition types {2}", new Object[]{name, type.name(), paramDef.getVarType()});
        }
    }

    public void setParam(String name, VarType type, Object value) {
        this.checkSetParam(type, name);
        if (type.isTextureType()) {
            this.setTextureParam(name, type, (Texture)value);
        } else {
            MatParam val = this.getParam(name);
            if (val == null) {
                MatParam paramDef = this.def.getMaterialParam(name);
                this.paramValues.put(name, new MatParam(type, name, value));
            } else {
                val.setValue(value);
            }
            if (this.technique != null) {
                this.technique.notifyParamChanged(name, type, value);
            }
        }
    }

    public void clearParam(String name) {
        this.checkSetParam(null, name);
        MatParam matParam = this.getParam(name);
        if (matParam == null) {
            return;
        }
        this.paramValues.remove(name);
        if (matParam instanceof MatParamTexture) {
            this.sortingId = -1;
        }
        if (this.technique != null) {
            this.technique.notifyParamChanged(name, null, null);
        }
    }

    public void setTextureParam(String name, VarType type, Texture value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.checkSetParam(type, name);
        MatParamTexture val = this.getTextureParam(name);
        if (val == null) {
            this.checkTextureParamColorSpace(name, value);
            this.paramValues.put(name, new MatParamTexture(type, name, value, null));
        } else {
            val.setTextureValue(value);
        }
        if (this.technique != null) {
            this.technique.notifyParamChanged(name, type, value);
        }
        this.sortingId = -1;
    }

    private void checkTextureParamColorSpace(String name, Texture value) {
        MatParamTexture paramDef = (MatParamTexture)this.def.getMaterialParam(name);
        if (paramDef.getColorSpace() != null && paramDef.getColorSpace() != value.getImage().getColorSpace()) {
            value.getImage().setColorSpace(paramDef.getColorSpace());
            logger.log(Level.FINE, "Material parameter {0} needs a {1} texture, texture {2} was switched to {3} color space.", new Object[]{name, paramDef.getColorSpace().toString(), value.getName(), value.getImage().getColorSpace().name()});
        } else if (paramDef.getColorSpace() == null && value.getName() != null && value.getImage().getColorSpace() == ColorSpace.Linear) {
            logger.log(Level.WARNING, "The texture {0} has linear color space, but the material parameter {2} specifies no color space requirement, this may lead to unexpected behavior.\nCheck if the image was not set to another material parameter with a linear color space, or that you did not set the ColorSpace to Linear using texture.getImage.setColorSpace().", new Object[]{value.getName(), value.getImage().getColorSpace().name(), name});
        }
    }

    public void setTexture(String name, Texture value) {
        if (value == null) {
            this.clearParam(name);
            return;
        }
        VarType paramType = null;
        switch (value.getType()) {
            case TwoDimensional: {
                paramType = VarType.Texture2D;
                break;
            }
            case TwoDimensionalArray: {
                paramType = VarType.TextureArray;
                break;
            }
            case ThreeDimensional: {
                paramType = VarType.Texture3D;
                break;
            }
            case CubeMap: {
                paramType = VarType.TextureCubeMap;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown texture type: " + (Object)((Object)value.getType()));
            }
        }
        this.setTextureParam(name, paramType, value);
    }

    public void setMatrix4(String name, Matrix4f value) {
        this.setParam(name, VarType.Matrix4, value);
    }

    public void setBoolean(String name, boolean value) {
        this.setParam(name, VarType.Boolean, value);
    }

    public void setFloat(String name, float value) {
        this.setParam(name, VarType.Float, Float.valueOf(value));
    }

    public void setFloat(String name, Float value) {
        this.setParam(name, VarType.Float, value);
    }

    public void setInt(String name, int value) {
        this.setParam(name, VarType.Int, value);
    }

    public void setColor(String name, ColorRGBA value) {
        this.setParam(name, VarType.Vector4, value);
    }

    public void setVector2(String name, Vector2f value) {
        this.setParam(name, VarType.Vector2, value);
    }

    public void setVector3(String name, Vector3f value) {
        this.setParam(name, VarType.Vector3, value);
    }

    public void setVector4(String name, Vector4f value) {
        this.setParam(name, VarType.Vector4, value);
    }

    public void selectTechnique(String name, RenderManager renderManager) {
        Technique tech = this.techniques.get(name);
        if (tech == null) {
            EnumSet<Caps> rendererCaps = renderManager.getRenderer().getCaps();
            List<TechniqueDef> techDefs = this.def.getTechniqueDefs(name);
            if (techDefs == null || techDefs.isEmpty()) {
                throw new IllegalArgumentException(String.format("The requested technique %s is not available on material %s", name, this.def.getName()));
            }
            TechniqueDef lastTech = null;
            float weight = 0.0f;
            for (TechniqueDef techDef : techDefs) {
                float techWeight;
                if (rendererCaps.containsAll(techDef.getRequiredCaps()) && (techWeight = techDef.getWeight() + (techDef.getLightMode() == renderManager.getPreferredLightMode() ? 10.0f : 0.0f)) > weight) {
                    tech = new Technique(this, techDef);
                    this.techniques.put(name, tech);
                    weight = techWeight;
                }
                lastTech = techDef;
            }
            if (tech == null) {
                throw new UnsupportedOperationException(String.format("No technique '%s' on material '%s' is supported by the video hardware. The capabilities %s are required.", name, this.def.getName(), lastTech.getRequiredCaps()));
            }
            logger.log(Level.FINE, this.getMaterialDef().getName() + " selected technique def " + tech.getDef());
        } else if (this.technique == tech) {
            return;
        }
        this.technique = tech;
        tech.notifyTechniqueSwitched();
        this.sortingId = -1;
    }

    private int applyOverrides(Renderer renderer, Shader shader, SafeArrayList<MatParamOverride> overrides, int unit) {
        for (MatParamOverride override : overrides.getArray()) {
            VarType type = override.getVarType();
            MatParam paramDef = this.def.getMaterialParam(override.getName());
            if (paramDef == null || paramDef.getVarType() != type || !override.isEnabled()) continue;
            Uniform uniform = shader.getUniform(override.getPrefixedName());
            if (override.getValue() != null) {
                if (type.isTextureType()) {
                    renderer.setTexture(unit, (Texture)override.getValue());
                    uniform.setValue(VarType.Int, unit);
                    ++unit;
                    continue;
                }
                uniform.setValue(type, override.getValue());
                continue;
            }
            uniform.clearValue();
        }
        return unit;
    }

    private int updateShaderMaterialParameters(Renderer renderer, Shader shader, SafeArrayList<MatParamOverride> worldOverrides, SafeArrayList<MatParamOverride> forcedOverrides) {
        int unit = 0;
        if (worldOverrides != null) {
            unit = this.applyOverrides(renderer, shader, worldOverrides, unit);
        }
        if (forcedOverrides != null) {
            unit = this.applyOverrides(renderer, shader, forcedOverrides, unit);
        }
        for (int i = 0; i < this.paramValues.size(); ++i) {
            MatParam param = this.paramValues.getValue(i);
            VarType type = param.getVarType();
            Uniform uniform = shader.getUniform(param.getPrefixedName());
            if (uniform.isSetByCurrentMaterial()) continue;
            if (type.isTextureType()) {
                renderer.setTexture(unit, (Texture)param.getValue());
                uniform.setValue(VarType.Int, unit);
                ++unit;
                continue;
            }
            uniform.setValue(type, param.getValue());
        }
        return unit;
    }

    private void updateRenderState(RenderManager renderManager, Renderer renderer, TechniqueDef techniqueDef) {
        if (renderManager.getForcedRenderState() != null) {
            renderer.applyRenderState(renderManager.getForcedRenderState());
        } else if (techniqueDef.getRenderState() != null) {
            renderer.applyRenderState(techniqueDef.getRenderState().copyMergedTo(this.additionalState, this.mergedRenderState));
        } else {
            renderer.applyRenderState(RenderState.DEFAULT.copyMergedTo(this.additionalState, this.mergedRenderState));
        }
    }

    public void preload(RenderManager renderManager) {
        if (this.technique == null) {
            this.selectTechnique("Default", renderManager);
        }
        TechniqueDef techniqueDef = this.technique.getDef();
        Renderer renderer = renderManager.getRenderer();
        EnumSet<Caps> rendererCaps = renderer.getCaps();
        if (techniqueDef.isNoRender()) {
            return;
        }
        Shader shader = this.technique.makeCurrent(renderManager, null, null, null, rendererCaps);
        this.updateShaderMaterialParameters(renderer, shader, null, null);
        renderManager.getRenderer().setShader(shader);
    }

    private void clearUniformsSetByCurrent(Shader shader) {
        ListMap<String, Uniform> uniforms = shader.getUniformMap();
        int size = uniforms.size();
        for (int i = 0; i < size; ++i) {
            Uniform u = uniforms.getValue(i);
            u.clearSetByCurrentMaterial();
        }
    }

    private void resetUniformsNotSetByCurrent(Shader shader) {
        ListMap<String, Uniform> uniforms = shader.getUniformMap();
        int size = uniforms.size();
        for (int i = 0; i < size; ++i) {
            Uniform u = uniforms.getValue(i);
            if (u.isSetByCurrentMaterial() || u.getName().charAt(0) == 'g') continue;
            u.clearValue();
        }
    }

    public void render(Geometry geometry, LightList lights, RenderManager renderManager) {
        if (this.technique == null) {
            this.selectTechnique("Default", renderManager);
        }
        TechniqueDef techniqueDef = this.technique.getDef();
        Renderer renderer = renderManager.getRenderer();
        EnumSet<Caps> rendererCaps = renderer.getCaps();
        if (techniqueDef.isNoRender()) {
            return;
        }
        this.updateRenderState(renderManager, renderer, techniqueDef);
        SafeArrayList<MatParamOverride> overrides = geometry.getWorldMatParamOverrides();
        Shader shader = this.technique.makeCurrent(renderManager, overrides, renderManager.getForcedMatParams(), lights, rendererCaps);
        this.clearUniformsSetByCurrent(shader);
        renderManager.updateUniformBindings(shader);
        int unit = this.updateShaderMaterialParameters(renderer, shader, overrides, renderManager.getForcedMatParams());
        this.resetUniformsNotSetByCurrent(shader);
        this.technique.render(renderManager, shader, geometry, lights, unit);
    }

    public void render(Geometry geom, RenderManager rm) {
        this.render(geom, geom.getWorldLightList(), rm);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.def.getAssetName(), "material_def", null);
        oc.write(this.additionalState, "render_state", null);
        oc.write(this.transparent, "is_transparent", false);
        oc.write(this.name, "name", null);
        oc.writeStringSavableMap(this.paramValues, "parameters", null);
    }

    public String toString() {
        return "Material[name=" + this.name + ", def=" + (this.def != null ? this.def.getName() : null) + ", tech=" + (this.technique != null && this.technique.getDef() != null ? this.technique.getDef().getName() : null) + "]";
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", null);
        this.additionalState = (RenderState)ic.readSavable("render_state", null);
        this.transparent = ic.readBoolean("is_transparent", false);
        String defName = ic.readString("material_def", null);
        HashMap params = (HashMap)ic.readStringSavableMap("parameters", null);
        boolean enableVcolor = false;
        boolean separateTexCoord = false;
        boolean applyDefaultValues = false;
        boolean guessRenderStateApply = false;
        int ver = ic.getSavableVersion(Material.class);
        if (ver < 1) {
            applyDefaultValues = true;
        }
        if (ver < 2) {
            guessRenderStateApply = true;
        }
        if (im.getFormatVersion() == 0) {
            MatParam value;
            if (defName.equalsIgnoreCase("Common/MatDefs/Misc/VertexColor.j3md")) {
                enableVcolor = true;
                defName = "Common/MatDefs/Misc/Unshaded.j3md";
            } else if (defName.equalsIgnoreCase("Common/MatDefs/Misc/SimpleTextured.j3md") || defName.equalsIgnoreCase("Common/MatDefs/Misc/SolidColor.j3md")) {
                defName = "Common/MatDefs/Misc/Unshaded.j3md";
            } else if (defName.equalsIgnoreCase("Common/MatDefs/Misc/WireColor.j3md")) {
                this.getAdditionalRenderState().setWireframe(true);
                defName = "Common/MatDefs/Misc/Unshaded.j3md";
            } else if (defName.equalsIgnoreCase("Common/MatDefs/Misc/Unshaded.j3md") && (value = (MatParam)params.get("SeperateTexCoord")) != null && ((Boolean)value.getValue()).booleanValue()) {
                params.remove("SeperateTexCoord");
                separateTexCoord = true;
            }
            assert (applyDefaultValues && guessRenderStateApply);
        }
        this.def = (MaterialDef)im.getAssetManager().loadAsset(new AssetKey(defName));
        this.paramValues = new ListMap();
        for (Map.Entry entry : params.entrySet()) {
            MatParam param = (MatParam)entry.getValue();
            if (param instanceof MatParamTexture) {
                MatParamTexture texVal = (MatParamTexture)param;
                if (texVal.getTextureValue() == null || texVal.getTextureValue().getImage() == null) continue;
                this.checkTextureParamColorSpace(texVal.getName(), texVal.getTextureValue());
            }
            if (im.getFormatVersion() == 0 && param.getName().startsWith("m_")) {
                param.setName(param.getName().substring(2));
            }
            if (this.def.getMaterialParam(param.getName()) == null) {
                logger.log(Level.WARNING, "The material parameter is not defined: {0}. Ignoring..", param.getName());
                continue;
            }
            this.checkSetParam(param.getVarType(), param.getName());
            this.paramValues.put(param.getName(), param);
        }
        if (applyDefaultValues) {
            for (MatParam param : this.def.getMaterialParams()) {
                if (param.getValue() == null || this.paramValues.get(param.getName()) != null) continue;
                this.setParam(param.getName(), param.getVarType(), param.getValue());
            }
        }
        if (guessRenderStateApply && this.additionalState != null) {
            this.additionalState.applyPolyOffset = this.additionalState.offsetEnabled;
            this.additionalState.applyBlendMode = this.additionalState.blendMode != RenderState.BlendMode.Off;
            this.additionalState.applyColorWrite = !this.additionalState.colorWrite;
            this.additionalState.applyCullMode = this.additionalState.cullMode != RenderState.FaceCullMode.Back;
            this.additionalState.applyDepthTest = !this.additionalState.depthTest;
            this.additionalState.applyDepthWrite = !this.additionalState.depthWrite;
            this.additionalState.applyStencilTest = this.additionalState.stencilTest;
            this.additionalState.applyWireFrame = this.additionalState.wireframe;
        }
        if (enableVcolor) {
            this.setBoolean("VertexColor", true);
        }
        if (separateTexCoord) {
            this.setBoolean("SeparateTexCoord", true);
        }
    }
}

