/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.environment.util.EnvMapUtils;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.Light;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.TextureCubeMap;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LightProbe
extends Light
implements Savable {
    private static final Logger logger = Logger.getLogger(LightProbe.class.getName());
    private Vector3f[] shCoeffs;
    private TextureCubeMap prefilteredEnvMap;
    private BoundingVolume bounds = new BoundingSphere(1.0f, Vector3f.ZERO);
    private boolean ready = false;
    private Vector3f position = new Vector3f();
    private Node debugNode;
    private int nbMipMaps;

    public TextureCubeMap getPrefilteredEnvMap() {
        return this.prefilteredEnvMap;
    }

    public void setPrefilteredMap(TextureCubeMap prefileteredEnvMap) {
        this.prefilteredEnvMap = prefileteredEnvMap;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.shCoeffs, "shCoeffs", null);
        oc.write(this.prefilteredEnvMap, "prefilteredEnvMap", null);
        oc.write(this.position, "position", null);
        oc.write(this.bounds, "bounds", new BoundingSphere(1.0f, Vector3f.ZERO));
        oc.write(this.ready, "ready", false);
        oc.write(this.nbMipMaps, "nbMipMaps", 0);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.prefilteredEnvMap = (TextureCubeMap)ic.readSavable("prefilteredEnvMap", null);
        this.position = (Vector3f)ic.readSavable("position", null);
        this.bounds = (BoundingVolume)ic.readSavable("bounds", new BoundingSphere(1.0f, Vector3f.ZERO));
        this.nbMipMaps = ic.readInt("nbMipMaps", 0);
        this.ready = ic.readBoolean("ready", false);
        Savable[] coeffs = ic.readSavableArray("shCoeffs", null);
        if (coeffs == null) {
            this.ready = false;
            logger.log(Level.WARNING, "LightProbe is missing parameters, it should be recomputed. Please use lightProbeFactory.updateProbe()");
        } else {
            this.shCoeffs = new Vector3f[coeffs.length];
            for (int i = 0; i < coeffs.length; ++i) {
                this.shCoeffs[i] = (Vector3f)coeffs[i];
            }
        }
    }

    public BoundingVolume getBounds() {
        return this.bounds;
    }

    public void setBounds(BoundingVolume bounds) {
        if (bounds.getType() != BoundingVolume.Type.Sphere) {
            throw new UnsupportedOperationException("For not only BoundingSphere are suported for LightProbe");
        }
        this.bounds = bounds;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public Node getDebugGui(AssetManager manager) {
        if (!this.ready) {
            throw new UnsupportedOperationException("This EnvProbe is not ready yet, try to test isReady()");
        }
        if (this.debugNode == null) {
            this.debugNode = new Node("debug gui probe");
            Node debugPfemCm = EnvMapUtils.getCubeMapCrossDebugViewWithMipMaps(this.getPrefilteredEnvMap(), manager);
            this.debugNode.attachChild(debugPfemCm);
            debugPfemCm.setLocalTranslation(520.0f, 0.0f, 0.0f);
        }
        return this.debugNode;
    }

    public Vector3f[] getShCoeffs() {
        return this.shCoeffs;
    }

    public void setShCoeffs(Vector3f[] shCoeffs) {
        this.shCoeffs = shCoeffs;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f position) {
        this.position.set(position);
        this.getBounds().setCenter(position);
    }

    public int getNbMipMaps() {
        return this.nbMipMaps;
    }

    public void setNbMipMaps(int nbMipMaps) {
        this.nbMipMaps = nbMipMaps;
    }

    @Override
    public boolean intersectsBox(BoundingBox box, TempVars vars) {
        return this.getBounds().intersectsBoundingBox(box);
    }

    @Override
    public boolean intersectsFrustum(Camera camera, TempVars vars) {
        return camera.contains(this.bounds) != Camera.FrustumIntersect.Outside;
    }

    @Override
    protected void computeLastDistance(Spatial owner) {
        if (owner.getWorldBound() != null) {
            BoundingVolume bv = owner.getWorldBound();
            this.lastDistance = bv.distanceSquaredTo(this.position);
        } else {
            this.lastDistance = owner.getWorldTranslation().distanceSquared(this.position);
        }
    }

    @Override
    public Light.Type getType() {
        return Light.Type.Probe;
    }

    public String toString() {
        return "Light Probe : " + this.name + " at " + this.position + " / " + this.bounds;
    }

    @Override
    public boolean intersectsSphere(BoundingSphere sphere, TempVars vars) {
        return this.getBounds().intersectsSphere(sphere);
    }
}

